/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target.schema;

import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.SchemaBuilder;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DefaultSchemaContext
implements SchemaContext {
    private final Map<TargetObjectSchema.SchemaName, TargetObjectSchema> schemas = new LinkedHashMap<TargetObjectSchema.SchemaName, TargetObjectSchema>();

    public DefaultSchemaContext() {
        for (EnumerableTargetObjectSchema schema : EnumerableTargetObjectSchema.values()) {
            this.schemas.put(schema.getName(), schema);
        }
    }

    public SchemaBuilder builder(TargetObjectSchema.SchemaName name) {
        return new SchemaBuilder(this, name);
    }

    public synchronized void putSchema(TargetObjectSchema schema) {
        if (this.schemas.containsKey(schema.getName())) {
            throw new IllegalArgumentException("Name already in context: " + schema.getName());
        }
        this.schemas.put(schema.getName(), schema);
    }

    public synchronized void replaceSchema(TargetObjectSchema schema) {
        this.schemas.put(schema.getName(), schema);
    }

    @Override
    public synchronized TargetObjectSchema getSchemaOrNull(TargetObjectSchema.SchemaName name) {
        return this.schemas.get(name);
    }

    @Override
    public synchronized TargetObjectSchema getSchema(TargetObjectSchema.SchemaName name) {
        return Objects.requireNonNull(this.schemas.get(name), "No such schema name: " + name);
    }

    @Override
    public synchronized Set<TargetObjectSchema> getAllSchemas() {
        return Collections.unmodifiableSet(new LinkedHashSet<TargetObjectSchema>(this.schemas.values()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TargetObjectSchema s : this.schemas.values()) {
            sb.append(s + "\n");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultSchemaContext) {
            DefaultSchemaContext that = (DefaultSchemaContext)obj;
            return Objects.equals(this.schemas, that.schemas);
        }
        if (obj instanceof SchemaContext) {
            SchemaContext that = (SchemaContext)obj;
            return this.schemas.values().equals(that.getAllSchemas());
        }
        return false;
    }

    public int hashCode() {
        return this.schemas.hashCode();
    }
}

