/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBModule;
import SWIG.SBTarget;
import SWIG.SBThread;
import agent.lldb.lldb.DebugModuleInfo;
import agent.lldb.model.iface2.LldbModelTargetModule;
import agent.lldb.model.iface2.LldbModelTargetModuleContainer;
import agent.lldb.model.impl.LldbModelImpl;
import agent.lldb.model.impl.LldbModelTargetModuleImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetSessionImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.lifecycle.Internal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ModuleContainer", elements={@TargetElementType(type=LldbModelTargetModuleImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class LldbModelTargetModuleContainerImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetModuleContainer {
    protected final LldbModelTargetSessionImpl targetSession;
    protected final SBTarget session;

    public LldbModelTargetModuleContainerImpl(LldbModelTargetSessionImpl session) {
        super(session.getModel(), (TargetObject)session, "Modules", "ModuleContainer");
        this.targetSession = session;
        this.session = session.getSession();
        this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Internal
    public void libraryLoaded(DebugModuleInfo info, int index) {
        LldbModelTargetModule targetModule;
        SBModule module = info.getModule(index);
        LldbModelTargetModuleContainerImpl lldbModelTargetModuleContainerImpl = this;
        synchronized (lldbModelTargetModuleContainerImpl) {
            targetModule = this.getTargetModule(module);
        }
        if (targetModule == null) {
            System.err.println("Module " + info.getModuleName(index) + " not found!");
            return;
        }
        SBThread thread = this.getManager().getEventThread();
        TargetThread eventThread = (TargetThread)this.getModel().getModelObject(thread);
        this.changeElements(List.of(), List.of(targetModule), Map.of(), "Loaded");
        this.broadcast().event((TargetObject)this.getProxy(), eventThread, TargetEventScope.TargetEventType.MODULE_LOADED, "Library " + info.getModuleName(index) + " loaded", List.of(targetModule));
    }

    @Override
    @Internal
    public void libraryUnloaded(DebugModuleInfo info, int index) {
        LldbModelTargetModule targetModule = this.getTargetModule(info.getModule(index));
        if (targetModule != null) {
            SBThread thread = this.getManager().getEventThread();
            TargetThread eventThread = (TargetThread)this.getModel().getModelObject(thread);
            this.broadcast().event((TargetObject)this.getProxy(), eventThread, TargetEventScope.TargetEventType.MODULE_UNLOADED, "Library " + info.getModuleName(index) + " unloaded", List.of(targetModule));
            LldbModelImpl impl = (LldbModelImpl)this.model;
            impl.deleteModelObject(targetModule.getModule());
        }
        this.changeElements(List.of(info.getModuleName(index)), List.of(), Map.of(), "Unloaded");
    }

    public boolean supportsSyntheticModules() {
        return false;
    }

    @Override
    public CompletableFuture<? extends TargetModule> addSyntheticModule(String name) {
        throw new UnsupportedOperationException("lldb does not support synthetic modules");
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getManager().listModules(this.session).thenAccept(byName -> {
            ArrayList<LldbModelTargetModule> result = new ArrayList<LldbModelTargetModule>();
            LldbModelTargetModuleContainerImpl lldbModelTargetModuleContainerImpl = this;
            synchronized (lldbModelTargetModuleContainerImpl) {
                for (Map.Entry ent : byName.entrySet()) {
                    result.add(this.getTargetModule((SBModule)ent.getValue()));
                }
            }
            this.changeElements(List.of(), result, Map.of(), "Refreshed");
        });
    }

    @Override
    public LldbModelTargetModule getTargetModule(SBModule module) {
        TargetObject targetObject = this.getMapObject(module);
        if (targetObject != null) {
            LldbModelTargetModule targetModule = (LldbModelTargetModule)targetObject;
            targetModule.setModelObject(module);
            return targetModule;
        }
        return new LldbModelTargetModuleImpl(this, module);
    }
}

