/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.NotFoundException;

public class RISCV_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 243;
    }

    public RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (!this.canRelocate(elf)) {
            return RelocationResult.FAILURE;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        boolean is32 = elf.is32Bit();
        int type = relocation.getType();
        if (0 == type) {
            return RelocationResult.SKIPPED;
        }
        long addend = relocation.hasAddend() ? relocation.getAddend() : (is32 ? (long)memory.getInt(relocationAddress) : memory.getLong(relocationAddress));
        long offset = relocationAddress.getOffset();
        long base = elfRelocationContext.getImageBaseWordAdjustmentOffset();
        int symbolIndex = relocation.getSymbolIndex();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        Address symbolAddr = elfRelocationContext.getSymbolAddress(sym);
        long symbolValue = elfRelocationContext.getSymbolValue(sym);
        String symbolName = elfRelocationContext.getSymbolName(symbolIndex);
        switch (type) {
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            default: {
                System.out.println("DEBUG RISCV: " + type + " " + relocationAddress + " " + String.format("%x", symbolValue) + " " + String.format("%x", addend) + " " + String.format("%x", offset) + " " + String.format("%x", base));
            }
        }
        long value64 = 0L;
        int value32 = 0;
        short value16 = 0;
        byte value8 = 0;
        int byteLength = 4;
        switch (type) {
            case 1: {
                value32 = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, value32);
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                RISCV_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                if (!elf.is32Bit()) break;
                RISCV_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 2: {
                value64 = symbolValue + addend;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                RISCV_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                if (!elf.is64Bit()) break;
                RISCV_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 3: {
                if (is32) {
                    value32 = (int)(base + addend);
                    memory.setInt(relocationAddress, value32);
                    break;
                }
                value64 = base + addend;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                break;
            }
            case 4: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_COPY", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 5: {
                if (is32) {
                    value32 = (int)symbolValue;
                    memory.setInt(relocationAddress, value32);
                    break;
                }
                value64 = symbolValue;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                break;
            }
            case 6: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_DTPMOD32", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 7: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_DTPMOD32", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 8: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_DTPREL32", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 9: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_DTPREL64", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 10: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_DTREL32", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 11: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_TPREL64", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 16: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_BRANCH", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 17: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_JAL", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 18: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_CALL", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 19: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_CALL_PLT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 20: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_GOT_HI20", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 21: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_GOT_HI20", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 22: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_GD_HI20", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 23: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_PCREL_HI20", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 24: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_PCREL_LO12_I", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 25: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_PCREL_LO12_S", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 26: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_HI20", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 27: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_LO12_I", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 28: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_LO12_S", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 29: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TPREL_HI20", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 30: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TPREL_LO12_I", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 31: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TPREL_LO12_S", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 32: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TPREL_ADD", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 33: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_ADD8", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                value8 = memory.getByte(relocationAddress);
                value8 = (byte)(value8 + (byte)symbolValue);
                value8 = (byte)(value8 + (byte)addend);
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case 34: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_ADD16", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                value16 = memory.getShort(relocationAddress);
                value16 = (short)(value16 + (short)symbolValue);
                value16 = (short)(value16 + (short)addend);
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case 35: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_ADD32", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                value32 = memory.getInt(relocationAddress);
                value32 += (int)symbolValue;
                memory.setInt(relocationAddress, value32 += (int)addend);
                break;
            }
            case 36: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_ADD64", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                value64 = memory.getLong(relocationAddress);
                value64 += symbolValue;
                memory.setLong(relocationAddress, value64 += addend);
                byteLength = 8;
                break;
            }
            case 37: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_SUB8", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                value8 = memory.getByte(relocationAddress);
                value8 = (byte)(value8 - (byte)symbolValue);
                value8 = (byte)(value8 - (byte)addend);
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case 38: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_SUB16", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                value16 = memory.getShort(relocationAddress);
                value16 = (short)(value16 - (short)symbolValue);
                value16 = (short)(value16 - (short)addend);
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case 39: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_SUB32", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                value32 = memory.getInt(relocationAddress);
                value32 -= (int)symbolValue;
                memory.setInt(relocationAddress, value32 -= (int)addend);
                break;
            }
            case 40: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_SUB64", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                value64 = memory.getLong(relocationAddress);
                value64 -= symbolValue;
                memory.setLong(relocationAddress, value64 -= addend);
                byteLength = 8;
                break;
            }
            case 41: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_GNU_VTINHERIT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 42: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_GNU_VTENTRY", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 43: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_ALIGN", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 44: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_RVC_BRANCH", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 45: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_RVC_BRANCH", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 46: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_RVC_LUI", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 47: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_GPREL_I", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 48: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_GPREL_S", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 49: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TPREL_I", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 50: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TPREL_S", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 51: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_RELAX", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 52: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_SUB6", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 53: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_SET6", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 54: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_SET8", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 55: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_SET16", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 56: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_SET32", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 57: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_32_PCREL", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            default: {
                RISCV_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

