/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;

public class ByteCountProgramLocationBasedTableColumn
extends ProgramLocationTableColumnExtensionPoint<ProgramLocation, Integer> {
    public String getColumnName() {
        return "Byte Count";
    }

    public Integer getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        CodeUnit cu = program.getListing().getCodeUnitContaining(rowObject.getAddress());
        if (cu == null) {
            return 0;
        }
        try {
            return cu.getBytes().length;
        }
        catch (MemoryAccessException e) {
            return 0;
        }
    }

    @Override
    public ProgramLocation getProgramLocation(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        return rowObject;
    }
}

