/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.AddressTranslator;
import ghidra.program.util.DefaultAddressTranslator;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.FunctionMerge;
import ghidra.program.util.ProgramMerge;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.util.Msg;
import ghidra.util.datastruct.LongLongHashtable;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NoValueException;
import ghidra.util.task.TaskMonitor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

class SymbolMerge {
    private static final int PROGRESS_COUNTER_GRANULARITY = 129;
    private AddressTranslator originToResultTranslator;
    private Program fromProgram;
    private Program toProgram;
    private SymbolTable fromSymbolTable;
    private SymbolTable toSymbolTable;

    SymbolMerge(Program fromProgram, Program toProgram) {
        this.originToResultTranslator = new DefaultAddressTranslator(toProgram, fromProgram);
        this.fromProgram = fromProgram;
        this.toProgram = toProgram;
        this.fromSymbolTable = fromProgram.getSymbolTable();
        this.toSymbolTable = toProgram.getSymbolTable();
    }

    SymbolMerge(AddressTranslator originToResultTranslator) {
        this.originToResultTranslator = originToResultTranslator;
        this.fromProgram = originToResultTranslator.getSourceProgram();
        this.toProgram = originToResultTranslator.getDestinationProgram();
        this.fromSymbolTable = this.fromProgram.getSymbolTable();
        this.toSymbolTable = this.toProgram.getSymbolTable();
    }

    Namespace resolveNamespace(Namespace fromNamespace, LongLongHashtable conflictSymbolIDMap) throws DuplicateNameException, InvalidInputException {
        Namespace fromGlobalNs = this.fromProgram.getGlobalNamespace();
        if (fromNamespace == null) {
            return null;
        }
        if (fromNamespace.equals(fromGlobalNs)) {
            return this.toProgram.getGlobalNamespace();
        }
        Namespace resolvedNamespace = DiffUtility.getNamespace(fromNamespace, this.toProgram);
        if (resolvedNamespace != null) {
            return resolvedNamespace;
        }
        Symbol fromNamespaceSymbol = fromNamespace.getSymbol();
        Namespace fromParentNs = fromNamespace.getParentNamespace();
        Namespace resolvedParentNs = this.resolveNamespace(fromParentNs, conflictSymbolIDMap);
        String name = fromNamespaceSymbol.getName();
        SymbolType fromNamespaceSymbolType = fromNamespaceSymbol.getSymbolType();
        Address toNamespaceSymbolAddr = this.originToResultTranslator.getAddress(fromNamespaceSymbol.getAddress());
        List toNamespaceSymbols = this.toSymbolTable.getSymbols(name, resolvedParentNs);
        for (Symbol toNamespaceSymbol : toNamespaceSymbols) {
            SymbolType toNamespaceSymbolType = toNamespaceSymbol.getSymbolType();
            if (!toNamespaceSymbolType.isNamespace() || !toNamespaceSymbolType.equals((Object)fromNamespaceSymbolType) || !toNamespaceSymbolAddr.equals((Object)toNamespaceSymbol.getAddress())) continue;
            return (Namespace)toNamespaceSymbol.getObject();
        }
        resolvedNamespace = this.createNamespace(name, fromNamespaceSymbolType, toNamespaceSymbolAddr, resolvedParentNs, fromNamespaceSymbol.getSource());
        if (!resolvedNamespace.getName().equals(name)) {
            conflictSymbolIDMap.put(fromNamespace.getSymbol().getID(), resolvedNamespace.getSymbol().getID());
        }
        return resolvedNamespace;
    }

    private Namespace createNamespace(String name, SymbolType symbolType, Address address, Namespace toParentNamespace, SourceType source) throws DuplicateNameException, InvalidInputException {
        if (symbolType == SymbolType.FUNCTION) {
            return (Namespace)this.createSymbol(name, symbolType, address, toParentNamespace, source);
        }
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            Object obj;
            Object uniqueName = i == 0 ? name : name + ProgramMerge.SYMBOL_CONFLICT_SUFFIX + i;
            Namespace ns = this.toSymbolTable.getNamespace((String)uniqueName, toParentNamespace);
            if (ns != null) {
                Symbol s = ns.getSymbol();
                if (!s.getAddress().equals((Object)address) || !s.getSymbolType().equals((Object)symbolType)) continue;
                return ns;
            }
            Symbol uniqueSymbol = this.createSymbol((String)uniqueName, symbolType, address, toParentNamespace, source);
            if (uniqueSymbol == null || !((obj = uniqueSymbol.getObject()) instanceof Namespace)) break;
            return (Namespace)obj;
        }
        throw new DuplicateNameException("Couldn't create namespace '" + name + "' in namespace '" + toParentNamespace.getName(true) + "'.");
    }

    private Symbol createSymbol(String name, SymbolType type, Address address, Namespace parentNamespace, SourceType source) throws DuplicateNameException, InvalidInputException {
        Symbol symbol = null;
        if (type == SymbolType.LABEL) {
            if (address.isExternalAddress()) {
                ExternalManagerDB extMgr = (ExternalManagerDB)this.toProgram.getExternalManager();
                ExternalLocation addExtLocation = extMgr.addExtLocation(parentNamespace.getName(), name, address, source);
                return addExtLocation.getSymbol();
            }
            symbol = this.toSymbolTable.createLabel(address, name, parentNamespace, source);
        } else if (type == SymbolType.CLASS) {
            GhidraClass newGhidraClass = this.toSymbolTable.createClass(parentNamespace, name, source);
            symbol = newGhidraClass.getSymbol();
        } else if (type == SymbolType.NAMESPACE) {
            Namespace newNamespace = this.toSymbolTable.createNameSpace(parentNamespace, name, source);
            symbol = newNamespace.getSymbol();
        } else if (type == SymbolType.LIBRARY) {
            ExternalManager fromExtMgr = this.fromProgram.getExternalManager();
            String path = fromExtMgr.getExternalLibraryPath(name);
            ExternalManagerDB extMgr = (ExternalManagerDB)this.toProgram.getExternalManager();
            extMgr.setExternalPath(name, path, source == SourceType.USER_DEFINED);
            symbol = this.toSymbolTable.getLibrarySymbol(name);
        } else if (type == SymbolType.FUNCTION) {
            FunctionManager fromFunctionMgr = this.fromProgram.getFunctionManager();
            AddressSetView body = fromFunctionMgr.getFunctionAt(address).getBody();
            FunctionManager functionMgr = this.toProgram.getFunctionManager();
            try {
                functionMgr.createFunction(name, parentNamespace, address, body, source);
            }
            catch (OverlappingFunctionException e) {
                throw new InvalidInputException(e.getMessage());
            }
            symbol = this.toSymbolTable.getSymbol(name, address, parentNamespace);
        }
        return symbol;
    }

    void replaceSymbols(Address address, LongLongHashtable conflictSymbolIDMap, TaskMonitor monitor) throws CancelledException, DuplicateNameException, InvalidInputException {
        this.removeUniqueToSymbols(address, monitor);
        this.replaceFunctionSymbol(address, address, conflictSymbolIDMap, monitor);
        this.addFromSymbols(address, true, conflictSymbolIDMap, monitor);
        this.replacePrimary(address, conflictSymbolIDMap);
        if (this.toSymbolTable.isExternalEntryPoint(address) && !this.fromSymbolTable.isExternalEntryPoint(address)) {
            this.toSymbolTable.removeExternalEntryPoint(address);
        } else if (this.fromSymbolTable.isExternalEntryPoint(address) && !this.toSymbolTable.isExternalEntryPoint(address)) {
            this.toSymbolTable.addExternalEntryPoint(address);
        }
    }

    private void removeUniqueToSymbols(Address fromAddress, TaskMonitor monitor) throws CancelledException {
        Symbol[] toSymbols;
        Address toAddress = this.originToResultTranslator.getAddress(fromAddress);
        for (Symbol toSymbol : toSymbols = this.toSymbolTable.getUserSymbols(toAddress)) {
            Namespace expectedToNamespace;
            Symbol fromSymbol = SimpleDiffUtility.getSymbol((Symbol)toSymbol, (Program)this.fromProgram);
            if (fromSymbol == null) {
                if (toSymbol.getSymbolType() == SymbolType.FUNCTION) continue;
                this.toSymbolTable.removeSymbolSpecial(toSymbol);
                continue;
            }
            if (fromSymbol.getSymbolType() == SymbolType.FUNCTION) continue;
            Namespace fromNamespace = fromSymbol.getParentNamespace();
            Namespace toNamespace = toSymbol.getParentNamespace();
            if (toNamespace != (expectedToNamespace = DiffUtility.getNamespace(fromNamespace, this.toProgram))) {
                this.toSymbolTable.removeSymbolSpecial(toSymbol);
            }
            monitor.checkCancelled();
        }
    }

    private void addFromSymbols(Address fromAddress, boolean replace, LongLongHashtable conflictSymbolIDMap, TaskMonitor monitor) throws CancelledException, InvalidInputException, DuplicateNameException {
        Symbol[] fromSymbols;
        Address toAddress = this.originToResultTranslator.getAddress(fromAddress);
        for (Symbol fromSymbol : fromSymbols = this.fromSymbolTable.getUserSymbols(fromAddress)) {
            Namespace fromNamespace;
            Namespace desiredToNamespace;
            monitor.checkCancelled();
            if (fromSymbol.getSymbolType().equals((Object)SymbolType.FUNCTION)) continue;
            SourceType fromSource = fromSymbol.getSource();
            String fromName = fromSymbol.getName();
            Symbol toSymbol = this.toSymbolTable.getSymbol(fromName, toAddress, desiredToNamespace = this.determineToNamespace(toAddress, fromNamespace = fromSymbol.getParentNamespace(), conflictSymbolIDMap));
            if (toSymbol == null) {
                toSymbol = this.toSymbolTable.createLabel(toAddress, fromName, desiredToNamespace, fromSource);
            } else if (replace && toSymbol.getSource() != fromSource) {
                try {
                    toSymbol.setSource(fromSource);
                }
                catch (IllegalArgumentException e) {
                    Msg.warn((Object)this, (Object)e.getMessage());
                }
            }
            boolean pinned = fromSymbol.isPinned();
            if (!replace || toSymbol.isPinned() == pinned) continue;
            toSymbol.setPinned(pinned);
        }
    }

    private Namespace determineToNamespace(Address toAddress, Namespace fromNamespace, LongLongHashtable conflictSymbolIDMap) {
        if (fromNamespace.getSymbol().getSymbolType() == SymbolType.FUNCTION) {
            Function toFunction = this.toProgram.getFunctionManager().getFunctionContaining(toAddress);
            if (toFunction != null) {
                return toFunction;
            }
        } else {
            try {
                Namespace newNamespace = this.resolveNamespace(fromNamespace, conflictSymbolIDMap);
                if (newNamespace != null) {
                    return newNamespace;
                }
            }
            catch (DuplicateNameException | InvalidInputException throwable) {
                // empty catch block
            }
        }
        return this.toProgram.getGlobalNamespace();
    }

    private void replaceFunctionSymbol(Address fromEntryPoint, Address toEntryPoint, LongLongHashtable conflictSymbolIDMap, TaskMonitor monitor) throws DuplicateNameException, InvalidInputException {
        Symbol toSymbol;
        Namespace fromNamespace;
        FunctionManager fromFunctionMgr = this.fromProgram.getFunctionManager();
        FunctionManager toFunctionMgr = this.toProgram.getFunctionManager();
        Function fromFunc = fromFunctionMgr.getFunctionAt(fromEntryPoint);
        Function toFunc = toFunctionMgr.getFunctionAt(toEntryPoint);
        if (fromFunc == null) {
            return;
        }
        Symbol fromSymbol = fromFunc.getSymbol();
        SourceType fromSource = fromSymbol.getSource();
        boolean isFromDefaultThunk = FunctionMerge.isDefaultThunk(fromFunc);
        String fromName = fromSymbol.getName();
        Namespace namespace = fromNamespace = isFromDefaultThunk ? this.fromProgram.getGlobalNamespace() : fromSymbol.getParentNamespace();
        if (toFunc == null) {
            if (fromSource == SourceType.DEFAULT) {
                return;
            }
            Namespace toNamespace = this.toProgram.getGlobalNamespace();
            toFunc = toFunctionMgr.getFunctionContaining(toEntryPoint);
            if (toFunc != null) {
                toNamespace = toFunc;
            }
            toSymbol = this.toSymbolTable.createLabel(toEntryPoint, fromName, toNamespace, fromSource);
        } else {
            toSymbol = toFunc.getSymbol();
            if (toSymbol.equals(fromSymbol)) {
                if (fromSource != SourceType.DEFAULT && toSymbol.getSource() != fromSource) {
                    try {
                        toSymbol.setSource(fromSource);
                    }
                    catch (IllegalArgumentException e) {
                        Msg.warn((Object)this, (Object)e.getMessage());
                    }
                }
                boolean pinned = fromSymbol.isPinned();
                if (toSymbol.isPinned() != pinned) {
                    toSymbol.setPinned(pinned);
                }
                return;
            }
            Namespace newToNamespace = this.resolveNamespace(fromNamespace, conflictSymbolIDMap);
            try {
                toFunc.setParentNamespace(newToNamespace);
            }
            catch (CircularDependencyException | InvalidInputException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
            String toName = toSymbol.getName();
            if (toSymbol.getSource() != fromSource || !toName.equals(fromName)) {
                toFunc.setName(fromName, fromSource);
            }
        }
        boolean pinned = fromSymbol.isPinned();
        if (toSymbol.isPinned() != pinned) {
            toSymbol.setPinned(pinned);
        }
    }

    private void mergeFunctionSymbol(Address fromEntryPoint, boolean replacePrimary, LongLongHashtable conflictSymbolIDMap, TaskMonitor monitor) throws DuplicateNameException, InvalidInputException {
        FunctionManager fromFunctionMgr = this.fromProgram.getFunctionManager();
        FunctionManager toFunctionMgr = this.toProgram.getFunctionManager();
        Address toEntryPoint = this.originToResultTranslator.getAddress(fromEntryPoint);
        Function fromFunc = fromFunctionMgr.getFunctionAt(fromEntryPoint);
        Function toFunc = toFunctionMgr.getFunctionAt(toEntryPoint);
        SymbolTable toSymTab = this.toProgram.getSymbolTable();
        if (fromFunc != null) {
            Symbol fromSymbol = fromFunc.getSymbol();
            String fromName = fromSymbol.getName();
            boolean fromDefault = fromSymbol.getSource() == SourceType.DEFAULT;
            boolean isFromDefaultThunk = FunctionMerge.isDefaultThunk(fromFunc);
            Namespace fromNamespace = isFromDefaultThunk ? this.fromProgram.getGlobalNamespace() : fromSymbol.getParentNamespace();
            Namespace resolveNamespace = this.resolveNamespace(fromNamespace, conflictSymbolIDMap);
            if (toFunc != null && replacePrimary && !fromDefault) {
                String toName = toFunc.getName();
                SourceType toSource = toFunc.getSymbol().getSource();
                boolean toDefault = toSource == SourceType.DEFAULT;
                Namespace toNamespace = toFunc.getParentNamespace();
                this.replaceFunctionSymbol(fromEntryPoint, toEntryPoint, conflictSymbolIDMap, monitor);
                if (!toDefault && !toName.equals(fromName)) {
                    this.addFunctionAsLabel(toEntryPoint, conflictSymbolIDMap, toSymTab, toSource, toName, toNamespace, -1L);
                }
            } else if (toFunc != null) {
                if (isFromDefaultThunk && FunctionMerge.isDefaultThunk(toFunc)) {
                    return;
                }
                if (toFunc.getSymbol().getSource() == SourceType.DEFAULT) {
                    this.replaceFunctionSymbol(fromEntryPoint, toEntryPoint, conflictSymbolIDMap, monitor);
                } else if (!fromDefault) {
                    this.addFunctionAsLabel(toEntryPoint, conflictSymbolIDMap, toSymTab, fromSymbol.getSource(), fromName, resolveNamespace, fromSymbol.getID());
                }
            } else if (!isFromDefaultThunk) {
                this.addFunctionAsLabel(toEntryPoint, conflictSymbolIDMap, toSymTab, fromSymbol.getSource(), fromName, resolveNamespace, fromSymbol.getID());
            }
        }
    }

    private void addFunctionAsLabel(Address entryPoint, LongLongHashtable conflictSymbolIDMap, SymbolTable toSymTab, SourceType source, String fromName, Namespace toNamespace, long oldID) throws InvalidInputException {
        Symbol toSymbol = toSymTab.getSymbol(fromName, entryPoint, toNamespace);
        if (!(toSymbol != null && toSymbol.getSymbolType().equals((Object)SymbolType.LABEL) || source == SourceType.DEFAULT || toSymTab.getSymbol(fromName, entryPoint, toNamespace) != null)) {
            toSymbol = this.toSymbolTable.createLabel(entryPoint, fromName, toNamespace, source);
        }
    }

    void mergeLabels(AddressSetView fromAddressSet, int setting, boolean replacePrimary, boolean replaceFunction, LongLongHashtable conflictSymbolIDMap, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        if (!this.originToResultTranslator.isOneForOneTranslator()) {
            String message = this.originToResultTranslator.getClass().getName() + " is not a one for one translator and can't merge code units.";
            throw new UnsupportedOperationException(message);
        }
        monitor.setMessage("Merging Labels...");
        if (fromAddressSet.isEmpty()) {
            return;
        }
        CodeUnitIterator fromCui = this.fromProgram.getListing().getCodeUnits(fromAddressSet, true);
        long count = 0L;
        while (fromCui.hasNext() && !monitor.isCancelled()) {
            CodeUnit fromCu = fromCui.next();
            Address fromMin = fromCu.getMinAddress();
            Address fromMax = fromCu.getMaxAddress();
            Address fromAddress = fromMin;
            while (fromAddress.compareTo((Object)fromMax) <= 0) {
                Address toAddress = this.originToResultTranslator.getAddress(fromAddress);
                try {
                    if (this.fromSymbolTable.hasSymbol(fromAddress) || this.toSymbolTable.hasSymbol(toAddress)) {
                        if (setting == 2) {
                            if (count == 129L) {
                                monitor.setMessage("Merging Labels...   " + fromAddress.toString(true));
                                count = 0L;
                            }
                            this.copySymbols(fromAddress, replacePrimary, replaceFunction, conflictSymbolIDMap, monitor);
                        } else if (setting == 1) {
                            if (count == 129L) {
                                monitor.setMessage("Replacing Labels...   " + fromAddress.toString(true));
                                count = 0L;
                            }
                            this.replaceSymbols(fromAddress, conflictSymbolIDMap, monitor);
                        }
                    }
                }
                catch (DuplicateNameException e1) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
                }
                catch (InvalidInputException e1) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
                }
                try {
                    fromAddress = fromAddress.addNoWrap(1L);
                }
                catch (AddressOverflowException e) {
                    break;
                }
            }
            ++count;
        }
    }

    void copySymbols(Address fromAddress, boolean replacePrimary, boolean replaceFunction, LongLongHashtable conflictSymbolIDMap, TaskMonitor monitor) throws CancelledException, DuplicateNameException, InvalidInputException {
        Address toAddress = this.originToResultTranslator.getAddress(fromAddress);
        this.addFromSymbols(fromAddress, false, conflictSymbolIDMap, monitor);
        this.mergeFunctionSymbol(fromAddress, replacePrimary || replaceFunction, conflictSymbolIDMap, monitor);
        if (replacePrimary) {
            this.replacePrimary(toAddress, conflictSymbolIDMap);
        }
        if (this.fromSymbolTable.isExternalEntryPoint(fromAddress) && !this.toSymbolTable.isExternalEntryPoint(toAddress)) {
            this.toSymbolTable.addExternalEntryPoint(toAddress);
        }
    }

    private void replacePrimary(Address address, LongLongHashtable conflictSymbolIDMap) {
        Symbol fromPrimary = this.fromSymbolTable.getPrimarySymbol(address);
        if (fromPrimary != null) {
            Symbol newToPrimary = null;
            try {
                long newToPrimaryID = conflictSymbolIDMap.get(fromPrimary.getID());
                newToPrimary = this.toSymbolTable.getSymbol(newToPrimaryID);
            }
            catch (NoValueException e) {
                newToPrimary = SimpleDiffUtility.getSymbol((Symbol)fromPrimary, (Program)this.toProgram);
            }
            if (newToPrimary != null && !newToPrimary.isPrimary()) {
                newToPrimary.setPrimary();
            }
        }
    }

    static void reApplyDuplicateSymbols(Hashtable<Symbol, Symbol> dupSyms) {
        Enumeration<Symbol> keys = dupSyms.keys();
        while (keys.hasMoreElements()) {
            Symbol fromSym = keys.nextElement();
            Symbol toSym = dupSyms.get(fromSym);
            try {
                toSym.setName(fromSym.getName(), fromSym.getSource());
                dupSyms.remove(fromSym);
            }
            catch (DuplicateNameException e) {
            }
            catch (InvalidInputException e) {}
        }
    }

    static String getDuplicateSymbolsInfo(Hashtable<Symbol, Symbol> dupSyms) {
        StringBuffer buf = new StringBuffer();
        Enumeration<Symbol> keys = dupSyms.keys();
        while (keys.hasMoreElements()) {
            Symbol fromSym = keys.nextElement();
            Symbol toSym = dupSyms.get(fromSym);
            String msg = "Symbol '" + fromSym.getName(true) + "' renamed to '" + toSym.getName(true) + "' due to name conflict.\n";
            buf.append(msg);
        }
        return buf.toString();
    }
}

