/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.ComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.dialogs.MultiLineMessageDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.services.FileSystemBrowserService;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.TextEditorService;
import ghidra.app.util.opinion.LoaderService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemProbeConflictResolver;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.main.ApplicationLevelPlugin;
import ghidra.framework.main.FrontEndService;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugin.importer.ProgramMappingService;
import ghidra.plugins.fsbrowser.FSBUtils;
import ghidra.plugins.fsbrowser.FileSystemBrowserComponentProvider;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import utilities.util.FileUtilities;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Browse Filesystems in containers", description="This plugin allows users to browse and use the contents of containers (zips, tars, filesystems, etc)", servicesProvided={FileSystemBrowserService.class}, servicesRequired={TextEditorService.class}, eventsConsumed={ProgramActivatedPluginEvent.class})
public class FileSystemBrowserPlugin
extends Plugin
implements ApplicationLevelPlugin,
ProjectListener,
FileSystemBrowserService {
    DockingAction openFilesystemAction;
    DockingAction showFileSystemImplsAction;
    private GhidraFileChooser chooserOpen;
    private FrontEndService frontEndService;
    private Map<FSRL, FileSystemBrowserComponentProvider> currentBrowsers = new HashMap<FSRL, FileSystemBrowserComponentProvider>();
    private FileSystemService fsService;

    public FileSystemBrowserPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        this.frontEndService = (FrontEndService)this.tool.getService(FrontEndService.class);
        if (this.frontEndService != null) {
            this.frontEndService.addProjectListener((ProjectListener)this);
        } else {
            FSBUtils.getProgramManager(this.tool, false);
        }
        this.setupActions();
    }

    private void setupActions() {
        this.openFilesystemAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Open File System", this.getName()).description(this.getPluginDescription().getDescription())).enabledWhen(ac -> this.tool.getProject() != null)).menuPath(new String[]{"&File", "Open File System..."})).menuGroup("Import", "z")).keyBinding(KeyStroke.getKeyStroke(73, 128))).onAction(ac -> this.doOpenFileSystem())).buildAndInstall((Tool)this.tool);
        this.showFileSystemImplsAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Display Supported File Systems and Loaders", this.getName()).description("Display Supported File Systems and Loaders")).enabledWhen(ac -> true)).menuPath(new String[]{"&Help", "List File Systems"})).menuGroup("AAAZ")).onAction(ac -> this.showSupportedFileSystems())).buildAndInstall((Tool)this.tool);
    }

    protected void dispose() {
        super.dispose();
        if (this.openFilesystemAction != null) {
            this.openFilesystemAction.dispose();
        }
        if (this.frontEndService != null) {
            this.frontEndService.removeProjectListener((ProjectListener)this);
            this.frontEndService = null;
        }
        if (this.chooserOpen != null) {
            this.chooserOpen.dispose();
        }
        for (FileSystemBrowserComponentProvider provider : this.currentBrowsers.values()) {
            provider.dispose();
        }
        this.currentBrowsers.clear();
    }

    @Override
    public void openFileSystem(FSRL fsrl) {
        TaskLauncher.launchModal((String)"Open File System", monitor -> this.doOpenFilesystem(fsrl, this.tool.getActiveWindow(), monitor));
    }

    void createNewFileSystemBrowser(FileSystemRef fsRef, boolean show) {
        Swing.runIfSwingOrRunLater(() -> this.doCreateNewFileSystemBrowser(fsRef, show));
    }

    private void doCreateNewFileSystemBrowser(FileSystemRef fsRef, boolean show) {
        FSRLRoot fsFSRL = fsRef.getFilesystem().getFSRL();
        FileSystemBrowserComponentProvider provider = this.currentBrowsers.get(fsFSRL);
        if (provider != null) {
            Msg.info((Object)this, (Object)("Filesystem browser already open for " + fsFSRL));
            fsRef.close();
        } else {
            provider = new FileSystemBrowserComponentProvider(this, fsRef);
            this.currentBrowsers.put(fsFSRL, provider);
            this.getTool().addComponentProvider((ComponentProvider)provider, false);
            provider.afterAddedToTool();
        }
        if (show) {
            this.getTool().showComponentProvider((ComponentProvider)provider, true);
            this.getTool().toFront((ComponentProvider)provider);
            provider.contextChanged();
        }
    }

    void removeFileSystemBrowserComponent(FileSystemBrowserComponentProvider componentProvider) {
        if (componentProvider != null) {
            Swing.runIfSwingOrRunLater(() -> this.currentBrowsers.remove(componentProvider.getFSRL()));
        }
    }

    private void removeAllFileSystemBrowsers() {
        Swing.runIfSwingOrRunLater(() -> {
            for (FileSystemBrowserComponentProvider fsbcp : new ArrayList<FileSystemBrowserComponentProvider>(this.currentBrowsers.values())) {
                fsbcp.dispose();
            }
            this.currentBrowsers.clear();
        });
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent pape = (ProgramActivatedPluginEvent)event;
            ProgramMappingService.createAutoAssocation(pape.getActiveProgram());
        }
    }

    public void projectClosed(Project project) {
        this.removeAllFileSystemBrowsers();
        if (FileSystemService.isInitialized()) {
            this.fsService().closeUnusedFileSystems();
        }
    }

    public void projectOpened(Project project) {
    }

    private void openChooser(String title, String buttonText, boolean multiSelect) {
        if (this.chooserOpen == null) {
            this.chooserOpen = new GhidraFileChooser((Component)this.tool.getActiveWindow());
            this.chooserOpen.addFileFilter(ImporterUtilities.LOADABLE_FILES_FILTER);
            this.chooserOpen.addFileFilter(ImporterUtilities.CONTAINER_FILES_FILTER);
            this.chooserOpen.setSelectedFileFilter(GhidraFileFilter.ALL);
        }
        this.chooserOpen.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        this.chooserOpen.setMultiSelectionEnabled(multiSelect);
        this.chooserOpen.setTitle(title);
        this.chooserOpen.setApproveButtonText(buttonText);
    }

    private void doOpenFilesystem(FSRL containerFSRL, Component parent, TaskMonitor monitor) {
        try {
            monitor.setMessage("Probing " + containerFSRL.getName() + " for filesystems");
            FileSystemRef ref = this.fsService().probeFileForFilesystem(containerFSRL, monitor, FileSystemProbeConflictResolver.GUI_PICKER);
            if (ref == null) {
                Msg.showWarn((Object)this, (Component)parent, (String)"Open Filesystem", (Object)("No filesystem provider for " + containerFSRL.getName()));
                return;
            }
            this.createNewFileSystemBrowser(ref, true);
        }
        catch (CancelledException | IOException e) {
            FSUtilities.displayException(this, parent, "Open Filesystem Error", "Error opening filesystem for " + containerFSRL.getName(), e);
        }
    }

    void openFileSystem() {
        Swing.runLater(this::doOpenFileSystem);
    }

    private void doOpenFileSystem() {
        Window parent = this.getTool().getActiveWindow();
        this.openChooser("Select Filesystem Container To Open", "Open", false);
        this.chooserOpen.setFileSelectionMode(GhidraFileChooserMode.FILES_AND_DIRECTORIES);
        File file = this.chooserOpen.getSelectedFile();
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            Msg.showInfo((Object)this, (Component)parent, (String)"Open File System Failed", (Object)("The specified file does not exist: " + file.getPath()));
            return;
        }
        if (FileUtilities.isEmpty((File)file)) {
            Msg.showInfo((Object)this, (Component)parent, (String)"Empty file", (Object)"The selected file is 0 bytes long, skipping.");
            return;
        }
        FSRL containerFSRL = this.fsService().getLocalFSRL(file);
        TaskLauncher.launchModal((String)"Open File System", monitor -> this.doOpenFilesystem(containerFSRL, parent, monitor));
    }

    private FileSystemService fsService() {
        if (this.fsService == null) {
            this.fsService = FileSystemService.getInstance();
        }
        return this.fsService;
    }

    boolean hasProgramManager() {
        return this.tool.getService(ProgramManager.class) != null || FSBUtils.getRunningProgramManagerTools(this.getTool()).size() == 1;
    }

    FileSystemBrowserComponentProvider getProviderFor(FSRLRoot fsFSRL) {
        FileSystemBrowserComponentProvider provider = this.currentBrowsers.get(fsFSRL);
        if (provider == null) {
            Msg.info((Object)this, (Object)("Could not find browser for " + fsFSRL));
            return null;
        }
        return provider;
    }

    private void showSupportedFileSystems() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><table><tr><td>Supported File Systems</td><td>Supported Loaders</td></tr>\n");
        sb.append("<tr valign='top'><td><ul>");
        for (String fileSystemName : this.fsService().getAllFilesystemNames()) {
            sb.append("<li>" + fileSystemName + "\n");
        }
        sb.append("</ul></td><td><ul>");
        for (String loaderName : LoaderService.getAllLoaderNames()) {
            sb.append("<li>" + loaderName + "\n");
        }
        sb.append("</ul></td></tr></table>");
        MultiLineMessageDialog.showModalMessageDialog((Component)this.getTool().getActiveWindow(), (String)"Supported File Systems and Loaders", (String)"", (String)sb.toString(), (int)1);
    }
}

