/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.context.ListingActionContext;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.services.FileImporterService;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.TextEditorService;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.LibrarySearchPathManager;
import ghidra.app.util.opinion.LoaderMap;
import ghidra.app.util.opinion.LoaderService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileCache;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.ApplicationLevelPlugin;
import ghidra.framework.main.FrontEndService;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.main.datatree.JavaFileListHandler;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.store.local.ItemDeserializer;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.plugin.importer.ImporterDialog;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugin.importer.ProgramMappingService;
import ghidra.plugins.importer.batch.BatchImportDialog;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Import External Files (NEW)", description="This plugin manages importing files, including those contained within firmware/filesystem images.", servicesRequired={TextEditorService.class}, servicesProvided={FileImporterService.class}, eventsConsumed={ProgramActivatedPluginEvent.class})
public class ImporterPlugin
extends Plugin
implements FileImporterService,
ApplicationLevelPlugin,
ProjectListener {
    private static final String IMPORT_MENU_GROUP = "Import";
    static final String IMPORTER_PLUGIN_DESC = "This plugin manages importing files, including those contained within firmware/filesystem images.";
    private static final String SIMPLE_UNPACK_OPTION = "Enable simple GZF/GDT unpack";
    private static final boolean SIMPLE_UNPACK_OPTION_DEFAULT = false;
    private DockingAction importAction;
    private DockingAction importSelectionAction;
    private DockingAction addToProgramAction;
    private GhidraFileChooser chooser;
    private FrontEndService frontEndService;
    private DockingAction batchImportAction;

    public ImporterPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        this.frontEndService = (FrontEndService)this.tool.getService(FrontEndService.class);
        if (this.frontEndService != null) {
            this.frontEndService.addProjectListener((ProjectListener)this);
            ToolOptions options = this.tool.getOptions("File Import");
            HelpLocation help = new HelpLocation("ImporterPlugin", "Project_Tree");
            options.registerOption(SIMPLE_UNPACK_OPTION, (Object)false, help, "Perform simple unpack when any packed DB file is imported");
        }
        this.setupImportAction();
        this.setupImportSelectionAction();
        this.setupAddToProgramAction();
        this.setupBatchImportAction();
    }

    public void readConfigState(SaveState saveState) {
        super.readConfigState(saveState);
        String[] paths = saveState.getStrings("library search paths", null);
        if (paths != null) {
            LibrarySearchPathManager.setLibraryPaths(paths);
        }
    }

    public void writeConfigState(SaveState saveState) {
        super.writeConfigState(saveState);
        String[] paths = LibrarySearchPathManager.getLibraryPaths();
        saveState.putStrings("library search paths", paths);
    }

    protected void dispose() {
        super.dispose();
        if (this.importAction != null) {
            this.importAction.dispose();
        }
        if (this.importSelectionAction != null) {
            this.importSelectionAction.dispose();
        }
        if (this.addToProgramAction != null) {
            this.addToProgramAction.dispose();
        }
        if (this.frontEndService != null) {
            this.frontEndService.removeProjectListener((ProjectListener)this);
            this.frontEndService = null;
        }
        if (this.chooser != null) {
            this.chooser.dispose();
        }
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent pape = (ProgramActivatedPluginEvent)event;
            Program currentProgram = pape.getActiveProgram();
            this.importSelectionAction.setEnabled(currentProgram != null);
            this.addToProgramAction.setEnabled(currentProgram != null);
        }
    }

    @Override
    public void importFiles(DomainFolder destFolder, List<File> files) {
        if (destFolder == null) {
            destFolder = this.tool.getProject().getProjectData().getRootFolder();
        }
        if ((files = this.handleSimpleDBUnpack(destFolder, files)).isEmpty()) {
            return;
        }
        BatchImportDialog.showAndImport(this.tool, null, this.files2FSRLs(files), destFolder, (ProgramManager)this.getTool().getService(ProgramManager.class));
    }

    private List<FSRL> files2FSRLs(List<File> files) {
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<FSRL> result = new ArrayList<FSRL>(files.size());
        for (File f : files) {
            result.add(FileSystemService.getInstance().getLocalFSRL(f));
        }
        return result;
    }

    @Override
    public void importFile(DomainFolder folder, File file) {
        if (folder == null) {
            folder = this.tool.getProject().getProjectData().getRootFolder();
        }
        if (this.handleSimpleDBUnpack(folder, file)) {
            return;
        }
        FSRL fsrl = FileSystemService.getInstance().getLocalFSRL(file);
        ProgramManager manager = (ProgramManager)this.tool.getService(ProgramManager.class);
        ImporterUtilities.showImportDialog(this.tool, manager, fsrl, folder, null);
    }

    private static String makeValidUniqueFilename(String name, DomainFolder folder) {
        int extIndex = ((String)name).lastIndexOf(".g");
        if (extIndex > 1 && ((String)name).length() - extIndex == 4) {
            name = ((String)name).substring(0, extIndex);
        }
        CharBuffer buf = CharBuffer.wrap(((String)name).toCharArray());
        for (int i = 0; i < buf.length(); ++i) {
            if (LocalFileSystem.isValidNameCharacter((char)buf.get(i))) continue;
            buf.put(i, '_');
        }
        String baseName = buf.toString();
        name = baseName;
        int count = 0;
        while (folder.getFile((String)name) != null) {
            name = baseName + "." + ++count;
        }
        return name;
    }

    private List<File> handleSimpleDBUnpack(final DomainFolder folder, final List<File> files) {
        if (this.frontEndService == null || !this.isSimpleUnpackEnabled()) {
            return files;
        }
        final ArrayList<File> remainingFiles = new ArrayList<File>();
        Task task = new Task("", true, true, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(TaskMonitor monitor) throws CancelledException {
                for (File f : files) {
                    monitor.checkCancelled();
                    ItemDeserializer itemDeserializer = null;
                    try {
                        itemDeserializer = new ItemDeserializer(f);
                    }
                    catch (IOException e) {
                        remainingFiles.add(f);
                        continue;
                    }
                    finally {
                        if (itemDeserializer == null) continue;
                        itemDeserializer.dispose();
                        continue;
                    }
                    monitor.setMessage("Unpacking " + f.getName() + " ...");
                    String filename = ImporterPlugin.makeValidUniqueFilename(f.getName(), folder);
                    try {
                        DomainFile df = folder.createFile(filename, f, monitor);
                        Msg.info((Object)((Object)this), (Object)("Imported " + f.getName() + " to " + df.getPathname()));
                    }
                    catch (InvalidNameException e) {
                        throw new AssertException((Throwable)e);
                    }
                    catch (IOException e) {
                        Msg.showError(JavaFileListHandler.class, (Component)ImporterPlugin.this.tool.getToolFrame(), (String)"Packed DB Import Failed", (Object)("Failed to import " + f.getName()), (Throwable)e);
                    }
                }
            }
        };
        TaskLauncher.launchModal((String)IMPORT_MENU_GROUP, (MonitoredRunnable)task);
        if (task.isCancelled()) {
            return List.of();
        }
        return remainingFiles;
    }

    private boolean handleSimpleDBUnpack(DomainFolder folder, File file) {
        List<File> files = this.handleSimpleDBUnpack(folder, List.of(file));
        return files.isEmpty();
    }

    private boolean isSimpleUnpackEnabled() {
        if (this.frontEndService == null) {
            return false;
        }
        ToolOptions options = this.tool.getOptions("File Import");
        return options.getBoolean(SIMPLE_UNPACK_OPTION, false);
    }

    public void projectClosed(Project project) {
        if (this.importAction != null) {
            this.importAction.setEnabled(false);
        }
        if (this.importSelectionAction != null) {
            this.importSelectionAction.setEnabled(false);
        }
        if (this.addToProgramAction != null) {
            this.addToProgramAction.setEnabled(false);
        }
        ProgramMappingService.clear();
    }

    public void projectOpened(Project project) {
        if (this.importAction != null) {
            this.importAction.setEnabled(true);
        }
        if (this.importSelectionAction != null) {
            this.importSelectionAction.setEnabled(false);
        }
        if (this.addToProgramAction != null) {
            this.addToProgramAction.setEnabled(false);
        }
        ProgramMappingService.clear();
    }

    private void setupImportAction() {
        String title = "Import File";
        this.importAction = new DockingAction(title, this.getName()){

            public void actionPerformed(ActionContext context) {
                ImporterPlugin.this.doSingleImportAction(ImporterPlugin.getFolderFromContext(context));
            }
        };
        this.importAction.setMenuBarData(new MenuData(new String[]{"&File", title + "..."}, null, IMPORT_MENU_GROUP, -1, "1"));
        this.importAction.setKeyBindingData(new KeyBindingData(73, 0));
        this.importAction.setDescription(IMPORTER_PLUGIN_DESC);
        this.importAction.setEnabled(this.tool.getProject() != null);
        this.importAction.setHelpLocation(new HelpLocation("ImporterPlugin", "Import_File"));
        this.tool.addAction((DockingActionIf)this.importAction);
    }

    private void setupBatchImportAction() {
        String title = "Batch Import";
        this.batchImportAction = new DockingAction(title, this.getName()){

            public void actionPerformed(ActionContext context) {
                BatchImportDialog.showAndImport(ImporterPlugin.this.tool, null, null, ImporterPlugin.getFolderFromContext(context), (ProgramManager)ImporterPlugin.this.getTool().getService(ProgramManager.class));
            }

            public boolean isEnabledForContext(ActionContext context) {
                return ImporterPlugin.this.tool.getProject() != null;
            }
        };
        this.batchImportAction.setMenuBarData(new MenuData(new String[]{"&File", title + "..."}, null, IMPORT_MENU_GROUP, -1, "2"));
        this.batchImportAction.setDescription(IMPORTER_PLUGIN_DESC);
        this.batchImportAction.setHelpLocation(new HelpLocation("ImporterPlugin", title));
        this.tool.addAction((DockingActionIf)this.batchImportAction);
    }

    private void setupImportSelectionAction() {
        String title = "Extract and Import";
        this.importSelectionAction = new DockingAction(title, this.getName()){

            public void actionPerformed(ActionContext context) {
                if (context instanceof ListingActionContext) {
                    ListingActionContext lac = (ListingActionContext)context;
                    ImporterPlugin.this.doImportSelectionAction(lac.getProgram(), lac.getSelection());
                }
            }

            public boolean isValidContext(ActionContext context) {
                if (context instanceof ListingActionContext) {
                    ProgramSelection selection = ((ListingActionContext)context).getNavigatable().getSelection();
                    return selection != null && selection.getNumAddressRanges() == 1;
                }
                return false;
            }
        };
        this.importSelectionAction.setPopupMenuData(new MenuData(new String[]{title + "..."}, null, IMPORT_MENU_GROUP, -1, "d"));
        this.importSelectionAction.setKeyBindingData(new KeyBindingData(73, 640));
        this.importSelectionAction.setDescription(IMPORTER_PLUGIN_DESC);
        this.importSelectionAction.setEnabled(this.tool.getProject() != null);
        this.tool.addAction((DockingActionIf)this.importSelectionAction);
    }

    private void setupAddToProgramAction() {
        String title = "Add To Program";
        this.addToProgramAction = new DockingAction(title, this.getName()){

            public void actionPerformed(ActionContext context) {
                ImporterPlugin.this.doAddToProgram();
            }
        };
        this.addToProgramAction.setMenuBarData(new MenuData(new String[]{"&File", title + "..."}, null, IMPORT_MENU_GROUP, -1, "zz"));
        this.addToProgramAction.setDescription(IMPORTER_PLUGIN_DESC);
        this.addToProgramAction.setEnabled(false);
        if (!(this.tool instanceof FrontEndTool)) {
            this.tool.addAction((DockingActionIf)this.addToProgramAction);
        }
    }

    private static DomainFolder getFolderFromContext(ActionContext context) {
        Object contextObj = context.getContextObject();
        if (contextObj instanceof DomainFolderNode) {
            DomainFolderNode node = (DomainFolderNode)contextObj;
            return node.getDomainFolder();
        }
        if (contextObj instanceof DomainFileNode) {
            DomainFileNode node = (DomainFileNode)contextObj;
            DomainFile domainFile = node.getDomainFile();
            return domainFile != null ? domainFile.getParent() : null;
        }
        return AppInfo.getActiveProject().getProjectData().getRootFolder();
    }

    private void initializeChooser(String title, String buttonText, boolean multiSelect) {
        if (this.chooser == null) {
            this.chooser = new GhidraFileChooser((Component)this.tool.getActiveWindow());
            this.chooser.addFileFilter(ImporterUtilities.LOADABLE_FILES_FILTER);
            this.chooser.addFileFilter(ImporterUtilities.CONTAINER_FILES_FILTER);
            this.chooser.setSelectedFileFilter(GhidraFileFilter.ALL);
        }
        this.chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        this.chooser.setMultiSelectionEnabled(multiSelect);
        this.chooser.setTitle(title);
        this.chooser.setApproveButtonText(buttonText);
        String lastFile = Preferences.getProperty((String)"LastImportFile");
        if (lastFile != null) {
            this.chooser.setSelectedFile(new File(lastFile));
        }
    }

    private void doSingleImportAction(DomainFolder defaultFolder) {
        this.initializeChooser("Select File to Import", "Select File To Import", false);
        File file = this.chooser.getSelectedFile();
        if (this.chooser.wasCancelled()) {
            return;
        }
        if (file == null) {
            Msg.showInfo((Object)this, (Component)this.tool.getActiveWindow(), (String)"No file selected", (Object)"No file will be imported.");
        } else if (!file.exists()) {
            Msg.showInfo((Object)this, (Component)this.tool.getActiveWindow(), (String)"File Error", (Object)("File does not exist: " + file.getPath()));
        } else {
            this.importFile(defaultFolder, file);
        }
    }

    private void doAddToProgram() {
        this.initializeChooser("Add To Program", "Add To Program", false);
        File file = this.chooser.getSelectedFile();
        if (file == null) {
            Msg.showInfo(this.getClass(), null, (String)"No file selected", (Object)"No file will be imported.");
            return;
        }
        this.addToProgram(file);
    }

    private void addToProgram(File file) {
        if (file.length() == 0L) {
            Msg.showInfo((Object)this, null, (String)"Import File Failed", (Object)("File " + file.getName() + " is empty (0 bytes)."));
            return;
        }
        ProgramManager manager = (ProgramManager)this.tool.getService(ProgramManager.class);
        Program program = manager.getCurrentProgram();
        FSRL fsrl = FileSystemService.getInstance().getLocalFSRL(file);
        TaskLauncher.launchModal((String)"Show Add To Program Dialog", monitor -> ImporterUtilities.showAddToProgramDialog(fsrl, program, this.tool, monitor));
    }

    protected void doImportSelectionAction(Program program, ProgramSelection selection) {
        if (selection == null || selection.getNumAddressRanges() != 1) {
            return;
        }
        AddressRange range = selection.getFirstRange();
        if (range.getLength() >= Integer.MAX_VALUE) {
            Msg.showInfo(this.getClass(), (Component)this.tool.getActiveWindow(), (String)"Selection Too Large", (Object)"The selection is too large to extract.");
            return;
        }
        try {
            FileCache.FileCacheEntry tmpFile;
            Memory memory = program.getMemory();
            FileSystemService fsService = FileSystemService.getInstance();
            try (FileCache.FileCacheEntryBuilder tmpFileBuilder = fsService.createTempFile(range.getLength());){
                byte[] bytes = new byte[(int)range.getLength()];
                memory.getBytes(range.getMinAddress(), bytes);
                tmpFileBuilder.write(bytes);
                tmpFile = tmpFileBuilder.finish();
            }
            MemoryBlock block = memory.getBlock(range.getMinAddress());
            String rangeName = block.getName() + "[" + range.getMinAddress() + "," + range.getMaxAddress() + "]";
            ByteProvider bp = fsService.getNamedTempFile(tmpFile, program.getName() + " " + rangeName);
            LoaderMap loaderMap = LoaderService.getAllSupportedLoadSpecs(bp);
            ImporterDialog importerDialog = new ImporterDialog(this.tool, (ProgramManager)this.tool.getService(ProgramManager.class), loaderMap, bp, null);
            this.tool.showDialog((DialogComponentProvider)importerDialog);
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"I/O Error Occurred", (Object)e.getMessage(), (Throwable)e);
        }
        catch (MemoryAccessException e) {
            Msg.showError((Object)this, null, (String)"Memory Access Error Occurred", (Object)e.getMessage(), (Throwable)e);
        }
    }
}

