/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.util.template.TemplateSimplifier;
import ghidra.app.util.viewer.field.NamespacePropertyEditor;
import ghidra.app.util.viewer.field.NamespaceWrappedOption;
import ghidra.app.util.viewer.field.OptionsBasedDataTypeDisplayOptions;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.CodeUnitFormatOptions;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import java.beans.PropertyEditor;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BrowserCodeUnitFormatOptions
extends CodeUnitFormatOptions
implements OptionsChangeListener {
    private static final String REGISTER_VARIABLE_MARKUP_OPTION = "Operands Field.Markup Register Variable References";
    private static final String STACK_VARIABLE_MARKUP_OPTION = "Operands Field.Markup Stack Variable References";
    private static final String INFERRED_VARIABLE_MARKUP_OPTION = "Operands Field.Markup Inferred Variable References";
    private static final String ALWAYS_SHOW_PRIMARY_REFERENCE_MARKUP_OPTION = "Operands Field.Always Show Primary Reference";
    private static final String FOLLOW_POINTER_REFERENCE_MARKUP_OPTION = "Operands Field.Follow Read or Indirect Pointer References";
    private static final String SCALAR_ADJUSTMENT_OPTION = "Operands Field.Include Scalar Reference Adjustment";
    private static final String NAMESPACE_OPTIONS = "Operands Field.Display Namespace";
    private static final String NAMESPACE_OPTIONS_DESCRIPTIONS = "Adjusts the Operands Field namespace display";
    private static final String SHOW_MUTABILITY_OPTION = "Mnemonic Field.Show Data Mutability";
    private static final String SHOW_OFFCUT_INFO_OPTION = "Operands Field.Show Offcut Information";
    private WeakSet<ChangeListener> listeners = WeakDataStructureFactory.createCopyOnReadWeakSet();
    private Options fieldOptions;

    BrowserCodeUnitFormatOptions(ToolOptions fieldOptions, boolean autoUpdate) {
        this.fieldOptions = fieldOptions;
        this.displayOptions = new OptionsBasedDataTypeDisplayOptions((Options)fieldOptions);
        this.templateSimplifier = new TemplateSimplifier(fieldOptions);
        boolean exists = fieldOptions.isRegistered(NAMESPACE_OPTIONS);
        if (!exists) {
            fieldOptions.registerOption(NAMESPACE_OPTIONS, OptionType.CUSTOM_TYPE, (Object)new NamespaceWrappedOption(), null, NAMESPACE_OPTIONS_DESCRIPTIONS, (PropertyEditor)new NamespacePropertyEditor());
            HelpLocation hl = new HelpLocation("CodeBrowserPlugin", "Operands_Field");
            fieldOptions.getOptions("Operands Field").setOptionsHelpLocation(hl);
            fieldOptions.registerOption("Operands Field.Show Block Names", (Object)false, hl, "Prepends memory block names to labels in the operands field.");
            fieldOptions.registerOption(REGISTER_VARIABLE_MARKUP_OPTION, (Object)true, hl, "Markup function register variable references");
            fieldOptions.registerOption(STACK_VARIABLE_MARKUP_OPTION, (Object)true, hl, "Markup function stack variable references");
            fieldOptions.registerOption(INFERRED_VARIABLE_MARKUP_OPTION, (Object)true, hl, "Include INFERRED variable references in markup");
            fieldOptions.registerOption(ALWAYS_SHOW_PRIMARY_REFERENCE_MARKUP_OPTION, (Object)true, hl, "Forces the primary reference to be rendered with the operand, using the => separator if necessary");
            fieldOptions.registerOption(FOLLOW_POINTER_REFERENCE_MARKUP_OPTION, (Object)true, hl, "Markup pointer READ/INDIRECT reference with symbol referenced by pointer.  An indirectly referenced symbol name will be prefixed with -> .");
            fieldOptions.registerOption(SCALAR_ADJUSTMENT_OPTION, (Object)false, hl, "Include scalar adjustment of certain reference offsets to maintain replaced scalar value");
            fieldOptions.registerOption(SHOW_MUTABILITY_OPTION, (Object)false, hl, "Include data mnemonic prefix of 'const' or 'volatile' based upon data setting");
            fieldOptions.registerOption(SHOW_OFFCUT_INFO_OPTION, (Object)true, hl, "Include trailing offcut address + offset data when showing offcut data");
        }
        this.updateFormat();
        if (autoUpdate) {
            fieldOptions.addOptionsChangeListener((OptionsChangeListener)this);
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (this.templateSimplifier.fieldOptionsChanged((Options)options, optionName, oldValue, newValue)) {
            this.notifyListeners();
        } else if (optionName.equals("Operands Field.Show Block Names") || optionName.equals(REGISTER_VARIABLE_MARKUP_OPTION) || optionName.equals(STACK_VARIABLE_MARKUP_OPTION) || optionName.equals(INFERRED_VARIABLE_MARKUP_OPTION) || optionName.equals(ALWAYS_SHOW_PRIMARY_REFERENCE_MARKUP_OPTION) || optionName.equals(FOLLOW_POINTER_REFERENCE_MARKUP_OPTION) || optionName.equals(SCALAR_ADJUSTMENT_OPTION) || optionName.equals(NAMESPACE_OPTIONS) || optionName.equals(SHOW_MUTABILITY_OPTION) || optionName.equals(SHOW_OFFCUT_INFO_OPTION)) {
            this.updateFormat();
            this.notifyListeners();
        }
    }

    private void updateFormat() {
        this.fieldOptions.registerOption(NAMESPACE_OPTIONS, OptionType.CUSTOM_TYPE, (Object)new NamespaceWrappedOption(), null, NAMESPACE_OPTIONS_DESCRIPTIONS, (PropertyEditor)new NamespacePropertyEditor());
        CustomOption customOption = this.fieldOptions.getCustomOption(NAMESPACE_OPTIONS, (CustomOption)new NamespaceWrappedOption());
        if (!(customOption instanceof NamespaceWrappedOption)) {
            throw new AssertException("Someone set an option for Operands Field.Display Namespace that is not the expected ghidra.app.util.viewer.field.NamespaceWrappedOption type.");
        }
        NamespaceWrappedOption namespaceOption = (NamespaceWrappedOption)customOption;
        this.showBlockName = this.fieldOptions.getBoolean("Operands Field.Show Block Names", false) ? CodeUnitFormatOptions.ShowBlockName.NON_LOCAL : CodeUnitFormatOptions.ShowBlockName.NEVER;
        this.showNamespace = CodeUnitFormatOptions.ShowNamespace.NEVER;
        this.localPrefixOverride = null;
        if (namespaceOption.isShowLocalNamespace()) {
            this.showNamespace = namespaceOption.isShowNonLocalNamespace() ? CodeUnitFormatOptions.ShowNamespace.ALWAYS : CodeUnitFormatOptions.ShowNamespace.LOCAL;
            if (namespaceOption.isUseLocalPrefixOverride()) {
                this.localPrefixOverride = namespaceOption.getLocalPrefixText().trim();
                if (this.localPrefixOverride.length() == 0) {
                    this.localPrefixOverride = null;
                }
            }
        } else if (namespaceOption.isShowNonLocalNamespace()) {
            this.showNamespace = CodeUnitFormatOptions.ShowNamespace.NON_LOCAL;
        }
        this.showLibraryInNamespace = namespaceOption.isShowLibraryInNamespace();
        this.doRegVariableMarkup = this.fieldOptions.getBoolean(REGISTER_VARIABLE_MARKUP_OPTION, true);
        this.doStackVariableMarkup = this.fieldOptions.getBoolean(STACK_VARIABLE_MARKUP_OPTION, true);
        this.includeInferredVariableMarkup = this.fieldOptions.getBoolean(INFERRED_VARIABLE_MARKUP_OPTION, true);
        this.alwaysShowPrimaryReference = this.fieldOptions.getBoolean(ALWAYS_SHOW_PRIMARY_REFERENCE_MARKUP_OPTION, true);
        this.followReferencedPointers = this.fieldOptions.getBoolean(FOLLOW_POINTER_REFERENCE_MARKUP_OPTION, true);
        this.includeScalarReferenceAdjustment = this.fieldOptions.getBoolean(SCALAR_ADJUSTMENT_OPTION, false);
        this.showOffcutInfo = this.fieldOptions.getBoolean(SHOW_OFFCUT_INFO_OPTION, true);
        this.showDataMutability = this.fieldOptions.getBoolean(SHOW_MUTABILITY_OPTION, false);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void notifyListeners() {
        ChangeEvent event = new ChangeEvent(this);
        SwingUtilities.invokeLater(() -> {
            for (ChangeListener listener : this.listeners) {
                listener.stateChanged(event);
            }
        });
    }

    public boolean followReferencedPointers() {
        return this.followReferencedPointers;
    }
}

