/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.program.model.address.Address;
import java.util.Set;

public class OmfSymbol {
    private String symbolName;
    private int typeIndex;
    private int dataType;
    private int byteLength;
    private int segmentRef = 0;
    private long offset;
    private Address address;
    private static final Set<String> FLOATINGPOINT_SPECIALNAMES = Set.of("FIWRQQ", "FIDRQQ", "FIERQQ", "FICRQQ", "FJCRQQ", "FISRQQ", "FJSRQQ", "FIARQQ", "FJARQQ", "FIFRQQ", "FJFRQQ", "FIGRQQ", "FJGRQQ");

    public OmfSymbol(String name, int type, long off, int dT, int bL) {
        this.symbolName = name;
        this.typeIndex = type;
        this.offset = off;
        this.dataType = dT;
        this.byteLength = bL;
    }

    public String getName() {
        return this.symbolName;
    }

    public int getDataType() {
        return this.dataType;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSegmentRef() {
        return this.segmentRef;
    }

    public void setSegmentRef(int val) {
        this.segmentRef = val;
    }

    public void setAddress(Address addr) {
        this.address = addr;
    }

    public Address getAddress() {
        return this.address;
    }

    public int getFrameDatum() {
        return 0;
    }

    public boolean isFloatingPointSpecial() {
        return FLOATINGPOINT_SPECIALNAMES.contains(this.symbolName);
    }
}

