/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.commands.DyldChainedStartsInSegment;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;

public class DyldChainedStartsInImage
implements StructConverter {
    private int seg_count;
    private int[] seg_info_offset;
    private DyldChainedStartsInSegment[] chainedStarts;

    DyldChainedStartsInImage(BinaryReader reader) throws IOException {
        long ptrIndex = reader.getPointerIndex();
        this.seg_count = reader.readNextInt();
        this.seg_info_offset = reader.readNextIntArray(this.seg_count);
        ArrayList<DyldChainedStartsInSegment> starts = new ArrayList<DyldChainedStartsInSegment>();
        for (int off : this.seg_info_offset) {
            if (off == 0) continue;
            reader.setPointerIndex(ptrIndex + (long)off);
            starts.add(new DyldChainedStartsInSegment(reader));
        }
        this.chainedStarts = (DyldChainedStartsInSegment[])starts.toArray(DyldChainedStartsInSegment[]::new);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_chained_starts_in_image", 0);
        struct.add(DWORD, "seg_count", null);
        struct.add((DataType)new ArrayDataType(DWORD, this.seg_count, 1), "seg_info_offset", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public int getSeg_count() {
        return this.seg_count;
    }

    public int[] getSeg_info_offset() {
        return this.seg_info_offset;
    }

    public DyldChainedStartsInSegment[] getChainedStarts() {
        return this.chainedStarts;
    }
}

