/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.DyldChainedFixupHeader;
import ghidra.app.util.bin.format.macho.commands.DyldChainedStartsInImage;
import ghidra.app.util.bin.format.macho.commands.DyldChainedStartsInSegment;
import ghidra.app.util.bin.format.macho.commands.LinkEditDataCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class DyldChainedFixupsCommand
extends LinkEditDataCommand {
    private DyldChainedFixupHeader chainHeader;

    DyldChainedFixupsCommand(BinaryReader loadCommandReader, BinaryReader dataReader) throws IOException {
        super(loadCommandReader, dataReader);
        this.chainHeader = new DyldChainedFixupHeader(dataReader);
    }

    @Override
    public String getCommandName() {
        return "dyld_chained_fixups_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                super.markup(header, api, baseAddress, isBinary, parentModule, monitor, log);
                List addrs = api.getCurrentProgram().getMemory().locateAddressesForFileOffset((long)this.getDataOffset());
                if (addrs.size() <= 0) {
                    throw new Exception("Chain Header does not exist in program");
                }
                Address dyldChainedHeader = (Address)addrs.get(0);
                this.markupChainedFixupHeader(header, api, dyldChainedHeader, parentModule, monitor);
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
            log.appendException((Throwable)e);
        }
    }

    private void markupChainedFixupHeader(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor) throws DuplicateNameException, IOException, CodeUnitInsertionException, Exception {
        DataType cHeader = this.chainHeader.toDataType();
        api.createData(baseAddress, cHeader);
        Address segsAddr = baseAddress.add((long)this.chainHeader.getStarts_offset());
        DyldChainedStartsInImage chainedStartsInImage = this.chainHeader.getChainedStartsInImage();
        int[] seg_info_offset = chainedStartsInImage.getSeg_info_offset();
        DyldChainedStartsInSegment[] chainedStarts = chainedStartsInImage.getChainedStarts();
        for (int i = 0; i < chainedStarts.length; ++i) {
            DyldChainedStartsInSegment startsInSeg = chainedStarts[i];
            DataType dataType = startsInSeg.toDataType();
            api.createData(segsAddr.add((long)seg_info_offset[i]), dataType);
        }
    }

    public DyldChainedFixupHeader getChainHeader() {
        return this.chainHeader;
    }
}

