/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.structmapping;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.golang.structmapping.DataTypeMapper;
import ghidra.app.util.bin.format.golang.structmapping.FieldContext;
import ghidra.app.util.bin.format.golang.structmapping.FieldMappingInfo;
import ghidra.app.util.bin.format.golang.structmapping.FieldMarkupFunction;
import ghidra.app.util.bin.format.golang.structmapping.ReflectionHelper;
import ghidra.app.util.bin.format.golang.structmapping.StructureMappingInfo;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkupFunction;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import java.io.IOException;

public class StructureContext<T> {
    protected final DataTypeMapper dataTypeMapper;
    protected final StructureMappingInfo<T> mappingInfo;
    protected final BinaryReader reader;
    protected final long structureStart;
    protected T structureInstance;
    protected Structure structureDataType;

    public StructureContext(DataTypeMapper dataTypeMapper, StructureMappingInfo<T> mappingInfo, BinaryReader reader) {
        this.dataTypeMapper = dataTypeMapper;
        this.mappingInfo = mappingInfo;
        this.reader = reader;
        this.structureStart = reader.getPointerIndex();
        this.structureDataType = mappingInfo.getStructureDataType();
    }

    public T readNewInstance() throws IOException {
        this.structureInstance = this.mappingInfo.getInstanceCreator().get(this);
        this.mappingInfo.assignContextFieldValues(this);
        this.mappingInfo.readStructure(this);
        ReflectionHelper.invokeMethods(this.mappingInfo.getAfterMethods(), this.structureInstance, new Object[0]);
        return this.structureInstance;
    }

    public StructureMappingInfo<T> getMappingInfo() {
        return this.mappingInfo;
    }

    public DataTypeMapper getDataTypeMapper() {
        return this.dataTypeMapper;
    }

    public Program getProgram() {
        return this.dataTypeMapper.program;
    }

    public Address getStructureAddress() {
        return this.dataTypeMapper.getDataAddress(this.structureStart);
    }

    public Address getFieldAddress(long fieldOffset) {
        return this.getStructureAddress().add(fieldOffset);
    }

    public long getFieldLocation(long fieldOffset) {
        return this.structureStart + fieldOffset;
    }

    public long getStructureStart() {
        return this.structureStart;
    }

    public long getStructureEnd() {
        return this.structureStart + (long)this.getStructureLength();
    }

    public int getStructureLength() {
        return this.structureDataType != null ? this.structureDataType.getLength() : 0;
    }

    public T getStructureInstance() {
        return this.structureInstance;
    }

    public BinaryReader getReader() {
        return this.reader;
    }

    public BinaryReader getFieldReader(long fieldOffset) {
        return this.reader.clone(this.structureStart + fieldOffset);
    }

    public FieldContext<T> createFieldContext(FieldMappingInfo<T> fmi, boolean includeReader) {
        DataTypeComponent dtc = fmi.getDtc(this.structureDataType);
        BinaryReader fieldReader = includeReader ? this.getFieldReader(dtc.getOffset()) : null;
        FieldContext<T> readContext = new FieldContext<T>(this, fmi, dtc, fieldReader);
        return readContext;
    }

    public void appendComment(int commentType, String prefix, String comment, String sep) throws IOException {
        DWARFUtil.appendComment(this.dataTypeMapper.getProgram(), this.getStructureAddress(), commentType, prefix, comment, sep);
    }

    public boolean isAlreadyMarkedup() {
        Address addr = this.getStructureAddress();
        Data data = this.getProgram().getListing().getDataContaining(addr);
        return data != null && data.getBaseDataType() instanceof Structure;
    }

    public void markupStructure(boolean nested) throws IOException {
        StructureMarkup sm;
        T t;
        Address addr = this.getStructureAddress();
        if (!nested && !this.dataTypeMapper.markedupStructs.add(addr)) {
            return;
        }
        if (!nested) {
            String structureLabel;
            try {
                Structure structDT = this.getStructureDataType();
                this.dataTypeMapper.markupAddress(addr, (DataType)structDT);
            }
            catch (IOException e) {
                throw new IOException("Markup failed for structure %s at %s".formatted(this.mappingInfo.getDescription(), this.getStructureAddress()), e);
            }
            t = this.structureInstance;
            if (t instanceof StructureMarkup && (structureLabel = (sm = (StructureMarkup)t).getStructureLabel()) != null) {
                this.dataTypeMapper.labelAddress(addr, structureLabel);
            }
        }
        this.markupFields();
        t = this.structureInstance;
        if (t instanceof StructureMarkup) {
            sm = (StructureMarkup)t;
            sm.additionalMarkup();
        }
    }

    public void markupFields() throws IOException {
        for (FieldMappingInfo<T> fieldMappingInfo : this.mappingInfo.getFields()) {
            for (FieldMarkupFunction<T> func : fieldMappingInfo.getMarkupFuncs()) {
                func.markupField(this.createFieldContext(fieldMappingInfo, false));
            }
        }
        T t = this.structureInstance;
        if (t instanceof StructureMarkup) {
            StructureMarkup sm = (StructureMarkup)t;
            for (Object externalInstance : sm.getExternalInstancesToMarkup()) {
                this.dataTypeMapper.markup(externalInstance, false);
            }
        }
        for (StructureMarkupFunction structureMarkupFunction : this.mappingInfo.getMarkupFuncs()) {
            structureMarkupFunction.markupStructure(this);
        }
    }

    public Structure getStructureDataType() throws IOException {
        if (this.structureDataType == null) {
            this.structureDataType = this.mappingInfo.createStructureDataType(this);
        }
        return this.structureDataType;
    }

    public String toString() {
        return "StructureContext<%s> { offset: %s}".formatted(this.mappingInfo.getTargetClass().getSimpleName(), Long.toUnsignedString(this.structureStart, 16));
    }
}

