/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.datamgr.util.DataTypeArchiveUtility;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.golang.GoBuildInfo;
import ghidra.app.util.bin.format.golang.GoConstants;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.app.util.bin.format.golang.rtti.GoFuncData;
import ghidra.app.util.bin.format.golang.rtti.GoFunctabEntry;
import ghidra.app.util.bin.format.golang.rtti.GoIface;
import ghidra.app.util.bin.format.golang.rtti.GoItab;
import ghidra.app.util.bin.format.golang.rtti.GoModuledata;
import ghidra.app.util.bin.format.golang.rtti.GoName;
import ghidra.app.util.bin.format.golang.rtti.GoPcHeader;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.GoString;
import ghidra.app.util.bin.format.golang.rtti.GoVarlenString;
import ghidra.app.util.bin.format.golang.rtti.types.GoArrayType;
import ghidra.app.util.bin.format.golang.rtti.types.GoBaseType;
import ghidra.app.util.bin.format.golang.rtti.types.GoChanType;
import ghidra.app.util.bin.format.golang.rtti.types.GoFuncType;
import ghidra.app.util.bin.format.golang.rtti.types.GoIMethod;
import ghidra.app.util.bin.format.golang.rtti.types.GoInterfaceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoMapType;
import ghidra.app.util.bin.format.golang.rtti.types.GoMethod;
import ghidra.app.util.bin.format.golang.rtti.types.GoPlainType;
import ghidra.app.util.bin.format.golang.rtti.types.GoPointerType;
import ghidra.app.util.bin.format.golang.rtti.types.GoSliceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoStructField;
import ghidra.app.util.bin.format.golang.rtti.types.GoStructType;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.rtti.types.GoTypeDetector;
import ghidra.app.util.bin.format.golang.rtti.types.GoUncommonType;
import ghidra.app.util.bin.format.golang.structmapping.DataTypeMapper;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.Structure;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class GoRttiMapper
extends DataTypeMapper {
    private static final CategoryPath RECOVERED_TYPES_CP = new CategoryPath("/golang-recovered");
    private static final CategoryPath GOLANG_CP = GoConstants.GOLANG_CATEGORYPATH;
    private static final CategoryPath VARLEN_STRUCTS_CP = GoConstants.GOLANG_CATEGORYPATH;
    private static final List<Class<?>> GOLANG_STRUCTMAPPED_CLASSES = List.of(GoModuledata.class, GoName.class, GoVarlenString.class, GoSlice.class, GoBaseType.class, GoTypeDetector.class, GoPlainType.class, GoUncommonType.class, GoArrayType.class, GoChanType.class, GoFuncType.class, GoInterfaceType.class, GoMapType.class, GoPointerType.class, GoSliceType.class, GoIface.class, GoStructType.class, GoMethod.class, GoStructField.class, GoIMethod.class, GoFunctabEntry.class, GoFuncData.class, GoItab.class, GoString.class, GoPcHeader.class);
    private final BinaryReader reader;
    private final GoVer goVersion;
    private final int ptrSize;
    private final Endian endian;
    private final DataType uintptrDT;
    private final DataType int32DT;
    private final DataType uint32DT;
    private final Map<Long, GoType> goTypes = new HashMap<Long, GoType>();
    private final Map<String, GoType> typeNameIndex = new HashMap<String, GoType>();
    private final Map<Long, DataType> cachedRecoveredDataTypes = new HashMap<Long, DataType>();
    private final List<GoModuledata> modules = new ArrayList<GoModuledata>();
    private GoType mapGoType;
    private GoType chanGoType;

    public static GoRttiMapper getMapperFor(Program program, MessageLog log) throws IOException {
        GoVer goVer;
        GoBuildInfo buildInfo = GoBuildInfo.fromProgram(program);
        if (buildInfo == null || (goVer = buildInfo.getVerEnum()) == GoVer.UNKNOWN) {
            return null;
        }
        ResourceFile gdtFile = GoRttiMapper.findGolangBootstrapGDT(goVer, buildInfo.getPointerSize(), GoRttiMapper.getGolangOSString(program));
        if (gdtFile == null) {
            Msg.error(GoRttiMapper.class, (Object)("Missing golang gdt archive for " + goVer));
        }
        try {
            return new GoRttiMapper(program, buildInfo.getPointerSize(), buildInfo.getEndian(), buildInfo.getVerEnum(), gdtFile);
        }
        catch (IllegalArgumentException e) {
            log.appendMsg(e.getMessage());
            return null;
        }
    }

    public static String getGDTFilename(GoVer goVer, int pointerSizeInBytes, String osName) {
        String bitSize = pointerSizeInBytes > 0 ? Integer.toString(pointerSizeInBytes * 8) : "any";
        String gdtFilename = "golang_%d.%d_%sbit_%s.gdt".formatted(goVer.getMajor(), goVer.getMinor(), bitSize, osName);
        return gdtFilename;
    }

    public static String getGolangOSString(Program program) {
        String loaderName = program.getExecutableFormat();
        if ("Executable and Linking Format (ELF)".equals(loaderName)) {
            return "linux";
        }
        if ("Portable Executable (PE)".equals(loaderName)) {
            return "win";
        }
        return null;
    }

    public static ResourceFile findGolangBootstrapGDT(GoVer goVer, int ptrSize, String osName) {
        ResourceFile result = null;
        if (osName != null) {
            result = DataTypeArchiveUtility.findArchiveFile(GoRttiMapper.getGDTFilename(goVer, ptrSize, osName));
        }
        if (result == null) {
            result = DataTypeArchiveUtility.findArchiveFile(GoRttiMapper.getGDTFilename(goVer, ptrSize, "any"));
        }
        if (result == null) {
            result = DataTypeArchiveUtility.findArchiveFile(GoRttiMapper.getGDTFilename(goVer, -1, "any"));
        }
        return result;
    }

    public GoRttiMapper(Program program, int ptrSize, Endian endian, GoVer goVersion, ResourceFile archiveGDT) throws IOException {
        super(program, archiveGDT);
        this.goVersion = goVersion;
        this.ptrSize = ptrSize;
        this.endian = endian;
        this.reader = super.createProgramReader();
        this.addArchiveSearchCategoryPath(CategoryPath.ROOT, GOLANG_CP);
        this.addProgramSearchCategoryPath(DWARFProgram.DWARF_ROOT_CATPATH, DWARFProgram.UNCAT_CATPATH);
        this.uintptrDT = this.getTypeOrDefault("uintptr", DataType.class, AbstractIntegerDataType.getUnsignedDataType((int)ptrSize, (DataTypeManager)this.getDTM()));
        this.int32DT = this.getTypeOrDefault("int32", DataType.class, AbstractIntegerDataType.getSignedDataType((int)4, null));
        this.uint32DT = this.getTypeOrDefault("uint32", DataType.class, AbstractIntegerDataType.getUnsignedDataType((int)4, null));
        try {
            this.registerStructures(GOLANG_STRUCTMAPPED_CLASSES);
        }
        catch (IOException e) {
            if (archiveGDT == null) {
                throw new IllegalArgumentException("Missing golang .gdt archive for %s, no fallback DWARF info, unable to extract golang RTTI info.".formatted(new Object[]{goVersion}));
            }
            throw new IOException("Invalid or missing Golang bootstrap GDT file: %s".formatted(archiveGDT.getAbsolutePath()));
        }
    }

    public GoVer getGolangVersion() {
        return this.goVersion;
    }

    public GoModuledata getFirstModule() {
        return this.modules.get(0);
    }

    public void addModule(GoModuledata module) {
        this.modules.add(module);
    }

    public GoModuledata findContainingModule(long offset) {
        for (GoModuledata module : this.modules) {
            if (module.getTypesOffset() > offset || offset >= module.getTypesEndOffset()) continue;
            return module;
        }
        return null;
    }

    public GoModuledata findContainingModuleByFuncData(long offset) {
        for (GoModuledata module : this.modules) {
            if (!module.containsFuncDataInstance(offset)) continue;
            return module;
        }
        return null;
    }

    @Override
    public CategoryPath getDefaultVariableLengthStructCategoryPath() {
        return VARLEN_STRUCTS_CP;
    }

    public DataType getUintptrDT() {
        return this.uintptrDT;
    }

    public DataType getInt32DT() {
        return this.int32DT;
    }

    public DataType getUint32DT() {
        return this.uint32DT;
    }

    public Structure getGenericSliceDT() {
        return this.getStructureDataType(GoSlice.class);
    }

    public GoType getMapGoType() {
        return this.mapGoType;
    }

    public GoType getChanGoType() {
        return this.chanGoType;
    }

    @Override
    protected BinaryReader createProgramReader() {
        return this.reader.clone();
    }

    public int getPtrSize() {
        return this.ptrSize;
    }

    public GoName resolveNameOff(long ptrInModule, long off) throws IOException {
        if (off == 0L) {
            return null;
        }
        GoModuledata module = this.findContainingModule(ptrInModule);
        long nameStart = module.getTypesOffset() + off;
        return this.getGoName(nameStart);
    }

    public GoName getGoName(long offset) throws IOException {
        return offset != 0L ? this.readStructure(GoName.class, offset) : null;
    }

    public GoType resolveTypeOff(long ptrInModule, long off) throws IOException {
        if (off == 0L || off == 0xFFFFFFFFL || off == -1L) {
            return null;
        }
        GoModuledata module = this.findContainingModule(ptrInModule);
        return this.getGoType(module.getTypesOffset() + off);
    }

    public GoType getGoType(long offset) throws IOException {
        if (offset == 0L) {
            return null;
        }
        GoType goType = this.goTypes.get(offset);
        if (goType == null) {
            Class<? extends GoType> typeClass = GoType.getSpecializedTypeClass(this, offset);
            goType = this.readStructure(typeClass, offset);
            this.goTypes.put(offset, goType);
        }
        return goType;
    }

    public GoType getGoType(Address addr) throws IOException {
        return this.getGoType(addr.getOffset());
    }

    public GoType findGoType(String typeName) {
        return this.typeNameIndex.get(typeName);
    }

    public <T extends DataType> T getGhidraDataType(String goTypeName, Class<T> clazz) {
        GoType goType;
        Object dt = this.getType(goTypeName, clazz);
        if (dt == null && (goType = this.findGoType(goTypeName)) != null) {
            try {
                DataType tmpDT = goType.recoverDataType();
                if (clazz.isInstance(tmpDT)) {
                    dt = (DataType)clazz.cast(tmpDT);
                }
            }
            catch (IOException e) {
                Msg.warn((Object)this, (Object)"Failed to get Ghidra data type from go type: %s[%x]".formatted(goTypeName, goType.getStructureContext().getStructureStart()));
            }
        }
        return dt;
    }

    public Address resolveTextOff(long ptrInModule, long off) {
        if (off == -1L || off == 0xFFFFFFFFL) {
            return null;
        }
        GoModuledata module = this.findContainingModule(ptrInModule);
        return module != null ? module.getText().add(off) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTypesToGDT(File gdtFile, TaskMonitor monitor) throws IOException {
        List registeredStructDTs = this.mappingInfo.values().stream().map(smi -> {
            if (smi.getStructureDataType() == null) {
                return null;
            }
            DataType existingDT = this.findType(smi.getStructureName(), List.of(DWARFProgram.DWARF_ROOT_CATPATH, DWARFProgram.UNCAT_CATPATH), this.programDTM);
            if (existingDT == null) {
                existingDT = smi.getStructureDataType();
            }
            if (existingDT == null) {
                Msg.warn((Object)this, (Object)("Missing type: " + smi.getDescription()));
            }
            return existingDT;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        File tmpGDTFile = new File(gdtFile.getParentFile(), gdtFile.getName() + ".step1.gdt");
        FileDataTypeManager tmpFdtm = FileDataTypeManager.createFileArchive((File)tmpGDTFile);
        int tx = -1;
        try {
            tx = tmpFdtm.startTransaction("Import");
            tmpFdtm.addDataTypes(registeredStructDTs, DataTypeConflictHandler.DEFAULT_HANDLER, monitor);
            this.moveAllDataTypesTo((DataTypeManager)tmpFdtm, DWARFProgram.DWARF_ROOT_CATPATH, GOLANG_CP);
            for (SourceArchive sa : tmpFdtm.getSourceArchives()) {
                tmpFdtm.removeSourceArchive(sa);
            }
            tmpFdtm.getRootCategory().removeCategory(DWARFProgram.DWARF_ROOT_CATPATH.getName(), monitor);
        }
        catch (CancelledException | DuplicateNameException e) {
            Msg.error((Object)this, (Object)"Error when exporting types to file: %s".formatted(gdtFile), (Throwable)e);
        }
        finally {
            if (tx != -1) {
                tmpFdtm.endTransaction(tx, true);
            }
        }
        tmpFdtm.save();
        FileDataTypeManager fdtm = FileDataTypeManager.createFileArchive((File)gdtFile);
        tx = -1;
        try {
            tx = fdtm.startTransaction("Import");
            tmpFdtm.getAllDataTypes().forEachRemaining(dt -> fdtm.addDataType(dt, DataTypeConflictHandler.DEFAULT_HANDLER));
            for (SourceArchive sa : fdtm.getSourceArchives()) {
                fdtm.removeSourceArchive(sa);
            }
        }
        finally {
            if (tx != -1) {
                fdtm.endTransaction(tx, true);
            }
        }
        fdtm.save();
        tmpFdtm.close();
        fdtm.close();
        tmpGDTFile.delete();
    }

    private void moveAllDataTypesTo(DataTypeManager dtm, CategoryPath srcCP, CategoryPath destCP) throws DuplicateNameException {
        Category srcCat = dtm.getCategory(srcCP);
        if (srcCat != null) {
            for (DataType dataType : srcCat.getDataTypes()) {
                if (dataType instanceof Array || dataType instanceof Pointer) continue;
                dataType.setCategoryPath(destCP);
            }
            for (DataType dataType : srcCat.getCategories()) {
                this.moveAllDataTypesTo(dtm, dataType.getCategoryPath(), destCP);
            }
        }
    }

    public CategoryPath getRecoveredTypesCp() {
        return RECOVERED_TYPES_CP;
    }

    public DataType getRecoveredType(GoType typ) throws IOException {
        long offset = this.getExistingStructureAddress(typ).getOffset();
        DataType dt = this.cachedRecoveredDataTypes.get(offset);
        if (dt != null) {
            return dt;
        }
        dt = typ.recoverDataType();
        this.cachedRecoveredDataTypes.put(offset, dt);
        return dt;
    }

    public void cacheRecoveredDataType(GoType typ, DataType dt) throws IOException {
        long offset = this.getExistingStructureAddress(typ).getOffset();
        this.cachedRecoveredDataTypes.put(offset, dt);
    }

    public DataType getCachedRecoveredDataType(GoType typ) throws IOException {
        long offset = this.getExistingStructureAddress(typ).getOffset();
        return this.cachedRecoveredDataTypes.get(offset);
    }

    public void recoverDataTypes(TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Converting Golang types to Ghidra data types");
        monitor.initialize((long)this.goTypes.size());
        List typeOffsets = this.goTypes.keySet().stream().sorted().collect(Collectors.toList());
        for (Long typeOffset : typeOffsets) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            GoType typ = this.getGoType(typeOffset);
            DataType dt = typ.recoverDataType();
            if (this.programDTM.getDataType(dt.getDataTypePath()) != null) continue;
            this.programDTM.addDataType(dt, DataTypeConflictHandler.DEFAULT_HANDLER);
        }
    }

    public void discoverGoTypes(TaskMonitor monitor) throws IOException, CancelledException {
        GoModuledata firstModule = this.findFirstModuledata(monitor);
        if (firstModule == null) {
            return;
        }
        this.addModule(firstModule);
        UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor, 50L);
        upwtm.setMessage("Iterating Golang RTTI types");
        upwtm.initialize(0L);
        this.goTypes.clear();
        HashSet<Long> discoveredTypes = new HashSet<Long>();
        Iterator<GoType> it = firstModule.iterateTypes();
        while (it.hasNext()) {
            upwtm.checkCancelled();
            upwtm.setProgress((long)discoveredTypes.size());
            GoType type = it.next();
            type.discoverGoTypes(discoveredTypes);
        }
        this.typeNameIndex.clear();
        for (GoType goType : this.goTypes.values()) {
            String typeName = goType.getBaseType().getNameString();
            this.typeNameIndex.put(typeName, goType);
        }
        Msg.info((Object)this, (Object)"Found %d golang types".formatted(this.goTypes.size()));
        this.initHiddenCompilerTypes();
    }

    private void initHiddenCompilerTypes() {
        this.mapGoType = this.findGoType("runtime.hmap");
        this.chanGoType = this.findGoType("runtime.hchan");
    }

    private GoModuledata findFirstModuledata(TaskMonitor monitor) throws IOException {
        GoModuledata result = GoModuledata.getFirstModuledata(this);
        if (result == null) {
            monitor.setMessage("Searching for Golang pclntab");
            monitor.initialize(0L);
            Address pclntabAddress = GoPcHeader.getPclntabAddress(this.program);
            if (pclntabAddress == null) {
                pclntabAddress = GoPcHeader.findPclntabAddress(this, this.getPclntabSearchRange(), monitor);
            }
            if (pclntabAddress != null) {
                monitor.setMessage("Searching for Golang firstmoduledata");
                monitor.initialize(0L);
                GoPcHeader pclntab = this.readStructure(GoPcHeader.class, pclntabAddress);
                result = GoModuledata.findFirstModule(this, pclntabAddress, pclntab, this.getModuledataSearchRange(), monitor);
            }
        }
        if (result != null && !result.isValid()) {
            throw new IOException("Invalid Golang moduledata at %s".formatted(result.getStructureContext().getStructureAddress()));
        }
        return result;
    }

    private AddressRange getPclntabSearchRange() {
        Memory memory = this.program.getMemory();
        for (String blockToSearch : List.of(".noptrdata", ".rdata")) {
            MemoryBlock noptrdataBlock = memory.getBlock(blockToSearch);
            if (noptrdataBlock == null) continue;
            return new AddressRangeImpl(noptrdataBlock.getStart(), noptrdataBlock.getEnd());
        }
        return null;
    }

    private AddressRange getModuledataSearchRange() {
        Memory memory = this.program.getMemory();
        for (String blockToSearch : List.of(".noptrdata", ".data")) {
            MemoryBlock noptrdataBlock = memory.getBlock(blockToSearch);
            if (noptrdataBlock == null) continue;
            return new AddressRangeImpl(noptrdataBlock.getStart(), noptrdataBlock.getEnd());
        }
        return null;
    }
}

