/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.util.DataTypeNamingUtil;
import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.DebugInfoEntry;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf4.encoding.DWARFEndianity;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf4.next.DWARFDataTypeConflictHandler;
import ghidra.app.util.bin.format.dwarf4.next.DWARFDataTypeManager;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportOptions;
import ghidra.app.util.bin.format.dwarf4.next.DWARFNameInfo;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.dwarf4.next.DWARFSourceInfo;
import ghidra.app.util.bin.format.golang.rtti.types.GoKind;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DWARFDataTypeImporter {
    private DWARFProgram prog;
    private DataTypeManager dataTypeManager;
    private DWARFDataTypeManager dwarfDTM;
    private DWARFImportOptions importOptions;
    private DWARFDataType voidDDT;
    private Map<Long, Integer> recursionTrackingOffsetToLoopCount = new HashMap<Long, Integer>();
    private Map<Long, DWARFDataType> dieOffsetToDataTypeMap = new HashMap<Long, DWARFDataType>();
    private IdentityHashMap<DataType, DWARFDataType> dataTypeInstanceToDDTMap = new IdentityHashMap();

    public DWARFDataTypeImporter(DWARFProgram prog, DWARFDataTypeManager dwarfDTM) {
        this.prog = prog;
        this.dataTypeManager = prog.getGhidraProgram().getDataTypeManager();
        this.dwarfDTM = dwarfDTM;
        this.importOptions = prog.getImportOptions();
        this.voidDDT = new DWARFDataType(dwarfDTM.getVoidType(), DWARFNameInfo.fromDataType(dwarfDTM.getVoidType()), -1L);
    }

    public DWARFDataType getDDTByInstance(DataType dtInstance) {
        return this.dataTypeInstanceToDDTMap.get(dtInstance);
    }

    private boolean trackRecursion(long id, int delta) {
        Integer count = this.recursionTrackingOffsetToLoopCount.getOrDefault(id, 0);
        count = count + delta;
        switch (count) {
            case 2: {
                break;
            }
            case 3: {
                Msg.error((Object)this, (Object)("Recursive loop in datatype detected at " + Long.toHexString(id)));
                return false;
            }
        }
        this.recursionTrackingOffsetToLoopCount.put(id, count);
        return true;
    }

    public DWARFDataType getDataType(DIEAggregate diea, DWARFDataType defaultValue) throws IOException, DWARFExpressionException {
        if (diea == null) {
            return defaultValue;
        }
        DWARFDataType result = this.dieOffsetToDataTypeMap.get(diea.getOffset());
        if (result != null) {
            return result;
        }
        DataType alreadyImportedDT = this.dwarfDTM.getDataType(diea.getOffset(), null);
        if (this.shouldReuseAlreadyImportedDT(alreadyImportedDT)) {
            return new DWARFDataType(alreadyImportedDT, null, diea.getOffset());
        }
        if (!this.trackRecursion(diea.getOffset(), 1)) {
            return defaultValue;
        }
        switch (diea.getTag()) {
            case 15: 
            case 16: 
            case 66: {
                result = this.makeDataTypeForPointer(diea);
                break;
            }
            case 31: {
                result = this.makeDataTypeForPtrToMemberType(diea);
                break;
            }
            case 36: {
                result = this.makeDataTypeForBaseType(diea);
                break;
            }
            case 22: {
                result = this.makeDataTypeForTypedef(diea);
                break;
            }
            case 59: {
                result = this.makeDataTypeForUnspecifiedType(diea);
                break;
            }
            case 38: 
            case 53: 
            case 55: 
            case 64: 
            case 17152: {
                result = this.makeDataTypeForConst(diea);
                break;
            }
            case 4: {
                result = this.makeDataTypeForEnum(diea);
                break;
            }
            case 1: {
                result = this.makeDataTypeForArray(diea);
                break;
            }
            case 2: 
            case 19: 
            case 23: {
                result = this.makeDataTypeForStruct(diea);
                this.recordTempDataType(result);
                this.finishStruct(diea, result);
                break;
            }
            case 21: {
                result = this.makeDataTypeForFunctionDefinition(diea, true);
                break;
            }
            case 46: {
                result = this.makeDataTypeForFunctionDefinition(diea, false);
                break;
            }
            default: {
                Msg.warn((Object)this, (Object)("Unsupported datatype in die: " + diea.toString()));
            }
        }
        this.trackRecursion(diea.getOffset(), -1);
        if (result == null) {
            return defaultValue;
        }
        if (result.dsi == null) {
            result.dsi = DWARFSourceInfo.create(diea);
        }
        this.recordTempDataType(result);
        return result;
    }

    private boolean shouldReuseAlreadyImportedDT(DataType alreadyImportedDT) {
        return alreadyImportedDT != null && !alreadyImportedDT.isNotYetDefined();
    }

    private void updateMapping(DataType prevDT, DataType newDT) {
        DWARFDataType byPrevDT = this.dataTypeInstanceToDDTMap.get(prevDT);
        if (byPrevDT != null) {
            this.dataTypeInstanceToDDTMap.put(newDT, byPrevDT);
            byPrevDT.dataType = newDT;
        }
    }

    private void recordTempDataType(DWARFDataType ddt) {
        if (ddt.dataType instanceof DatabaseObject) {
            return;
        }
        this.dataTypeInstanceToDDTMap.put(ddt.dataType, ddt);
        for (Long offset : ddt.offsets) {
            this.dieOffsetToDataTypeMap.put(offset, ddt);
        }
    }

    private DWARFDataType makeDataTypeForFunctionDefinition(DIEAggregate diea, boolean mangleAnonFuncNames) throws IOException, DWARFExpressionException {
        DWARFNameInfo dni = this.prog.getName(diea);
        DWARFDataType returnType = this.getDataType(diea.getTypeRef(), this.voidDDT);
        boolean foundThisParam = false;
        ArrayList<ParameterDefinitionImpl> params = new ArrayList<ParameterDefinitionImpl>();
        for (DIEAggregate paramDIEA : diea.getFunctionParamList()) {
            String paramName = paramDIEA.getName();
            DWARFDataType paramDT = this.getDataType(paramDIEA.getTypeRef(), null);
            DataType dt = this.fixupDataTypeInconsistencies(paramDT);
            if (dt == null && DWARFUtil.isPointerDataType(paramDIEA.getTypeRef())) {
                Msg.error((Object)this, (Object)("Error resolving parameter data type, probable recursive definition, replacing with void*: " + dni.getName()));
                Msg.debug((Object)this, (Object)("Problem funcDef: " + diea.toString()));
                Msg.debug((Object)this, (Object)("Problem param: " + paramDIEA));
                dt = this.dwarfDTM.getPtrTo(this.dwarfDTM.getVoidType());
            }
            if (dt == null || dt.getLength() <= 0) {
                Msg.error((Object)this, (Object)("Bad function parameter type for " + dni.asCategoryPath()));
                return null;
            }
            ParameterDefinitionImpl pd = new ParameterDefinitionImpl(paramName, dt, null);
            params.add(pd);
            foundThisParam |= DWARFUtil.isThisParam(paramDIEA);
        }
        FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(dni.getParentCP(), dni.getName(), this.dataTypeManager);
        funcDef.setReturnType(returnType.dataType);
        funcDef.setNoReturn(diea.getBool(135, false));
        funcDef.setArguments(params.toArray(new ParameterDefinition[params.size()]));
        if (!diea.getChildren(24).isEmpty()) {
            funcDef.setVarArgs(true);
        }
        if (foundThisParam) {
            try {
                funcDef.setCallingConvention("__thiscall");
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)"Unexpected calling convention error", (Throwable)e);
            }
        }
        if (dni.isAnon() && mangleAnonFuncNames) {
            String mangledName = DataTypeNamingUtil.setMangledAnonymousFunctionName(funcDef);
            dni = dni.replaceName(mangledName, dni.getOriginalName());
        }
        for (int i = 0; i < funcDef.getArguments().length; ++i) {
            ParameterDefinition origPD = (ParameterDefinition)params.get(i);
            ParameterDefinition newPD = funcDef.getArguments()[i];
            this.updateMapping(origPD.getDataType(), newPD.getDataType());
        }
        FunctionDefinitionDataType dtToAdd = funcDef;
        if (diea.hasAttribute(11)) {
            long ptrSize = diea.getUnsignedLong(11, -1L);
            if (ptrSize == (long)this.dataTypeManager.getDataOrganization().getPointerSize()) {
                ptrSize = -1L;
            }
            dtToAdd = this.dwarfDTM.getPtrTo((DataType)dtToAdd, (int)ptrSize);
        }
        return new DWARFDataType((DataType)dtToAdd, dni, diea.getOffset());
    }

    private DWARFDataType makeDataTypeForBaseType(DIEAggregate diea) throws IOException, DWARFExpressionException {
        return this.makeNamedBaseType(this.prog.getName(diea), diea);
    }

    private DWARFDataType makeNamedBaseType(DWARFNameInfo dni, DIEAggregate diea) throws IOException, DWARFExpressionException {
        int dwarfSize = diea.parseInt(11, 0);
        int dwarfEncoding = (int)diea.getUnsignedLong(62, -1L);
        boolean isBigEndian = DWARFEndianity.getEndianity(diea.getUnsignedLong(101, 0L), this.prog.isBigEndian());
        if (diea.hasAttribute(13)) {
            Msg.warn((Object)this, (Object)"Warning: Base type bit size and bit offset not currently handled for data type %s, DIE %s".formatted(dni.toString(), diea.getHexOffset()));
        }
        boolean explictSize = false;
        if (diea.hasAttribute(10496)) {
            long goKindInt = diea.getLong(10496, 0L);
            GoKind kind = GoKind.parseByte((byte)goKindInt);
            explictSize = this.isExplictSizedGolangType(kind);
        }
        DataType dt = this.dwarfDTM.getBaseType(dni.getOriginalName(), dwarfSize, dwarfEncoding, isBigEndian, explictSize);
        return new DWARFDataType(dt, dni, diea.getOffset());
    }

    private boolean isExplictSizedGolangType(GoKind kind) {
        switch (kind) {
            case Int8: 
            case Int16: 
            case Int32: 
            case Int64: 
            case Uint8: 
            case Uint16: 
            case Uint32: 
            case Uint64: 
            case Float32: 
            case Float64: 
            case Complex64: 
            case Complex128: {
                return true;
            }
        }
        return false;
    }

    private DWARFDataType makeDataTypeForConst(DIEAggregate diea) throws IOException, DWARFExpressionException {
        DWARFDataType refdDT = this.getDataType(diea.getTypeRef(), this.voidDDT);
        refdDT.offsets.add(diea.getOffset());
        return refdDT;
    }

    private DWARFDataType makeDataTypeForEnum(DIEAggregate diea) {
        DWARFNameInfo dni = this.prog.getName(diea);
        int enumSize = (int)diea.getUnsignedLong(11, -1L);
        if (enumSize == 0) {
            Msg.warn((Object)this, (Object)("Enum " + dni.getNamespacePath() + "[DWARF DIE " + diea.getHexOffset() + "] has a size of 0, forcing to 1"));
            enumSize = 1;
        }
        if (enumSize == -1) {
            Msg.warn((Object)this, (Object)("Enum " + dni.getNamespacePath() + "[DWARF DIE " + diea.getHexOffset() + "] does not have a size specified, forcing to 1"));
            enumSize = 1;
        }
        EnumDataType enumDT = new EnumDataType(dni.getParentCP(), dni.getName(), enumSize, this.dataTypeManager);
        this.populateStubEnum((Enum)enumDT, diea, false);
        for (DataType prevDT : this.dwarfDTM.forAllConflicts(dni.asDataTypePath())) {
            Enum prevEnum;
            if (!(prevDT instanceof Enum) || (prevEnum = (Enum)prevDT).getLength() != enumDT.getLength() || !this.isCompatEnumValues((Enum)enumDT, prevEnum)) continue;
            this.mergeEnumValues(prevEnum, (Enum)enumDT);
            return new DWARFDataType((DataType)prevEnum, dni, diea.getOffset());
        }
        DataType result = this.dataTypeManager.addDataType((DataType)enumDT, (DataTypeConflictHandler)DWARFDataTypeConflictHandler.INSTANCE);
        return new DWARFDataType(result, dni, diea.getOffset());
    }

    private void populateStubEnum(Enum enumDT, DIEAggregate diea, boolean defaultSignedness) {
        for (DebugInfoEntry childEntry : diea.getChildren(40)) {
            DIEAggregate childDIEA = this.prog.getAggregate(childEntry);
            String valueName = childDIEA.getName();
            DWARFNumericAttribute enumValAttr = childDIEA.getAttribute(28, DWARFNumericAttribute.class);
            if (enumValAttr == null) continue;
            long enumVal = enumValAttr.getValueWithSignednessHint(defaultSignedness);
            try {
                enumDT.add(valueName, enumVal);
            }
            catch (IllegalArgumentException iae) {
                Msg.error((Object)this, (Object)"Failed to add value %s=%d[%x] to enum %s".formatted(valueName, enumVal, enumVal, enumDT.getCategoryPath()), (Throwable)iae);
            }
        }
    }

    private boolean mergeEnumValues(Enum destEnum, Enum srcEnum) {
        for (String srcKey : srcEnum.getNames()) {
            long srcValue = srcEnum.getValue(srcKey);
            try {
                long destValue = destEnum.getValue(srcKey);
                if (destValue == srcValue) continue;
                return false;
            }
            catch (NoSuchElementException nse) {
                try {
                    destEnum.add(srcKey, srcValue);
                }
                catch (IllegalArgumentException iae) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isCompatEnumValues(Enum srcEnum, Enum destEnum) {
        for (String srcKey : srcEnum.getNames()) {
            long srcValue = srcEnum.getValue(srcKey);
            try {
                long destValue = destEnum.getValue(srcKey);
                if (destValue == srcValue) continue;
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return true;
    }

    private DWARFDataType makeDataTypeForStruct(DIEAggregate diea) {
        UnionDataType struct;
        long structSize;
        DWARFNameInfo dni = this.prog.getName(diea);
        long origStructSize = structSize = diea.getUnsignedLong(11, 0L);
        if (this.isStructTooBigForGhidra(structSize)) {
            Msg.error((Object)this, (Object)("Large DWARF structure encountered, substituting empty struct for " + dni + ", size: " + Long.toString(structSize) + " at DIE " + diea.getHexOffset()));
            structSize = 0L;
        }
        boolean isUnion = diea.getTag() == 23;
        boolean isDecl = diea.getBool(60, false);
        Object object = struct = isUnion ? new UnionDataType(dni.getParentCP(), dni.getName(), this.dataTypeManager) : new StructureDataType(dni.getParentCP(), dni.getName(), (int)structSize, this.dataTypeManager);
        if (!isDecl && origStructSize == 0L) {
            ((Composite)struct).setToDefaultPacking();
        }
        DWARFDataType result = new DWARFDataType((DataType)struct, dni, diea.getOffset());
        result.dsi = DWARFSourceInfo.create(diea);
        if (dni.isNameModified() && !dni.isAnon()) {
            DWARFUtil.appendDescription((DataType)struct, "Original name: " + dni.getOriginalName(), "\n");
        }
        if (this.importOptions.isOutputDIEInfo()) {
            DWARFUtil.appendDescription((DataType)struct, "DWARF DIE: " + diea.getHexOffset(), "\n");
        }
        if (this.importOptions.isOutputSourceLocationInfo() && result.dsi != null && result.dsi.getDescriptionStr() != null) {
            DWARFUtil.appendDescription((DataType)struct, result.dsi.getDescriptionStr(), "\n");
        }
        if (this.isStructTooBigForGhidra(origStructSize)) {
            DWARFUtil.appendDescription((DataType)struct, "Structure oversize error, original size: " + Long.toString(origStructSize), "\n");
        }
        return result;
    }

    private boolean isStructTooBigForGhidra(long structSize) {
        return structSize < 0L || structSize > Integer.MAX_VALUE;
    }

    private void finishStruct(DIEAggregate diea, DWARFDataType ddt) throws IOException, DWARFExpressionException {
        if (ddt.dataType instanceof UnionDataType) {
            this.populateStubUnion(ddt, diea);
        } else if (ddt.dataType instanceof StructureDataType) {
            this.populateStubStruct(ddt, diea);
        } else {
            throw new RuntimeException("bad datatype");
        }
    }

    private void populateStubUnion(DWARFDataType ddt, DIEAggregate diea) throws IOException, DWARFExpressionException {
        long unionSize = diea.getUnsignedLong(11, -1L);
        UnionDataType union = (UnionDataType)ddt.dataType;
        for (DebugInfoEntry childEntry : diea.getChildren(13)) {
            DWARFDataType childDT;
            DIEAggregate childDIEA = this.prog.getAggregate(childEntry);
            if (childDIEA.hasAttribute(63)) continue;
            int bitSize = childDIEA.parseInt(13, -1);
            boolean isBitField = bitSize != -1;
            Object memberName = childDIEA.getName();
            if (memberName == null) {
                memberName = "field_" + union.getNumComponents();
            }
            if ((childDT = this.getDataType(childDIEA.getTypeRef(), null)) == null) {
                Msg.warn((Object)this, (Object)("Bad union member data type for " + (String)memberName + " in " + union.getDataTypePath() + "[DWARF DIE " + diea.getHexOffset() + "], skipping"));
                continue;
            }
            DataType dt = this.fixupDataTypeInconsistencies(childDT);
            String memberComment = null;
            if (dt instanceof Dynamic || dt instanceof FactoryDataType) {
                memberComment = "Unsupported dynamic size data type: " + dt;
                dt = Undefined.getUndefinedDataType((int)1);
            }
            int dtLen = dt.getLength();
            if (unionSize != -1L && !isBitField && (long)dtLen > unionSize) {
                if (dtLen > 1) {
                    memberComment = "Data type larger than union's declared size: " + dt;
                    dt = Undefined.getUndefinedDataType((int)1);
                } else {
                    DWARFUtil.appendDescription((DataType)union, DWARFDataTypeImporter.memberDesc("Missing member", "data type larger than union", (String)memberName, dt, -1, bitSize, -1), "\n");
                    continue;
                }
            }
            if (isBitField) {
                if (!BitFieldDataType.isValidBaseDataType((DataType)dt)) {
                    DWARFUtil.appendDescription((DataType)union, DWARFDataTypeImporter.memberDesc("Missing member", "Bad data type for bitfield: " + dt.getName(), (String)memberName, dt, -1, bitSize, -1), "\n");
                    continue;
                }
                try {
                    union.addBitField(dt, bitSize, (String)memberName, memberComment);
                }
                catch (InvalidDataTypeException e) {
                    Msg.error((Object)this, (Object)("Unable to add member " + (String)memberName + " to structure " + union.getDataTypePath() + "[DWARF DIE " + diea.getHexOffset() + "], skipping: " + e.getMessage()));
                    DWARFUtil.appendDescription((DataType)union, DWARFDataTypeImporter.memberDesc("Missing member ", "Failed to add bitfield", (String)memberName, dt, -1, bitSize, -1), "\n");
                }
                continue;
            }
            try {
                DataTypeComponent dataTypeComponent = union.add(dt, (String)memberName, memberComment);
                this.updateMapping(dt, dataTypeComponent.getDataType());
            }
            catch (IllegalArgumentException exc) {
                Msg.error((Object)this, (Object)("Bad union member " + (String)memberName + " in " + union.getDataTypePath() + "[DWARF DIE " + diea.getHexOffset() + "] of type " + childDT + ", skipping"));
            }
        }
        if ((long)union.getLength() < unionSize) {
            DataType padding = Undefined.getUndefinedDataType((int)((int)unionSize));
            try {
                union.add(padding, null, "Automatically generated padding to match DWARF declared size");
            }
            catch (IllegalArgumentException exc) {
                DWARFUtil.appendDescription((DataType)union, "Failed to add padding to union, size should be " + unionSize, "\n");
            }
        }
        if (unionSize > 0L && (long)union.getLength() > unionSize) {
            DWARFUtil.appendDescription((DataType)union, "Imported union size (" + union.getLength() + ") is larger than DWARF value (" + unionSize + ")", "\n");
        }
        if (this.importOptions.isTryPackStructs()) {
            DWARFUtil.packCompositeIfPossible((Composite)ddt.dataType, this.dataTypeManager);
        }
    }

    private void populateStubStruct(DWARFDataType ddt, DIEAggregate diea) throws IOException, DWARFExpressionException {
        StructureDataType structure = (StructureDataType)ddt.dataType;
        long structSize = diea.getUnsignedLong(11, 0L);
        if (this.isStructTooBigForGhidra(structSize)) {
            return;
        }
        this.populateStubStruct_worker(ddt, structure, diea, 13);
        this.populateStubStruct_worker(ddt, structure, diea, 28);
        this.removeUneededStructMemberShrinkage(structure);
        if (this.importOptions.isTryPackStructs()) {
            DWARFUtil.packCompositeIfPossible((Composite)ddt.dataType, this.dataTypeManager);
        }
    }

    private void removeUneededStructMemberShrinkage(StructureDataType structure) {
        DataTypeComponent[] definedComponents = structure.getDefinedComponents();
        for (int i = 0; i < definedComponents.length; ++i) {
            DataTypeComponent newDTC;
            DataType newDT;
            DataTypeComponent dtc = definedComponents[i];
            DataType dtcDT = dtc.getDataType();
            if (dtcDT.isZeroLength()) continue;
            int nextDTCOffset = i < definedComponents.length - 1 ? definedComponents[i + 1].getOffset() : structure.getLength();
            int emptySpaceBetween = nextDTCOffset - (dtc.getEndOffset() + 1);
            if (dtc.getLength() >= dtcDT.getLength() || emptySpaceBetween <= 0 || (newDT = (newDTC = structure.replaceAtOffset(dtc.getOffset(), dtcDT, Math.min(nextDTCOffset - dtc.getOffset(), dtc.getDataType().getLength()), dtc.getFieldName(), dtc.getComment())).getDataType()) == dtcDT) continue;
            this.updateMapping(dtcDT, newDT);
        }
    }

    private int getUnpaddedDataTypeLength(DataType dt) {
        Structure structure;
        DataTypeComponent[] definedComponents;
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (dt instanceof Structure && (definedComponents = (structure = (Structure)dt).getDefinedComponents()).length > 0) {
            DataTypeComponent lastDTC = definedComponents[definedComponents.length - 1];
            return lastDTC.getOffset() + lastDTC.getLength();
        }
        return dt.isZeroLength() ? 0 : dt.getLength();
    }

    private void populateStubStruct_worker(DWARFDataType ddt, StructureDataType structure, DIEAggregate diea, int childTagType) throws IOException, DWARFExpressionException {
        for (DebugInfoEntry childEntry : diea.getChildren(childTagType)) {
            int childLength;
            boolean isDynamicSizedType;
            DIEAggregate childDIEA = this.prog.getAggregate(childEntry);
            if (childDIEA.hasAttribute(63)) continue;
            int bitSize = childDIEA.parseInt(13, -1);
            boolean isBitField = bitSize != -1;
            DWARFDataType childDT = this.getDataType(childDIEA.getTypeRef(), null);
            if (childDT == null) {
                Msg.error((Object)this, (Object)("Failed to get data type for struct field: " + childDIEA.getHexOffset()));
                continue;
            }
            DataType dt = this.fixupDataTypeInconsistencies(childDT);
            Object memberName = childDIEA.getName();
            if (memberName == null) {
                memberName = childDIEA.getTag() == 28 ? "super_" + dt.getName() : "field_" + structure.getNumDefinedComponents();
            }
            boolean hasMemberOffset = childDIEA.hasAttribute(56);
            int memberOffset = 0;
            if (hasMemberOffset) {
                try {
                    memberOffset = childDIEA.parseDataMemberOffset(56, 0);
                }
                catch (DWARFExpressionException e) {
                    DWARFUtil.appendDescription((DataType)structure, DWARFDataTypeImporter.memberDesc("Missing member", "failed to parse location", (String)memberName, dt, -1, bitSize, -1), "\n");
                    continue;
                }
            }
            if (isBitField) {
                int ghidraBitOffset;
                int byteSize;
                if (!BitFieldDataType.isValidBaseDataType((DataType)dt)) {
                    DWARFUtil.appendDescription((DataType)structure, DWARFDataTypeImporter.memberDesc("Missing member", "Bad data type for bitfield: " + dt.getName(), (String)memberName, dt, -1, bitSize, -1), "\n");
                    continue;
                }
                int containerLen = hasMemberOffset ? ((byteSize = childDIEA.parseInt(11, -1)) <= 0 ? dt.getLength() : byteSize) : structure.getLength();
                int containerBitLen = containerLen * 8;
                int bitOffset = childDIEA.parseInt(107, -1);
                if (bitOffset == -1) {
                    bitOffset = childDIEA.parseInt(12, -1);
                    ghidraBitOffset = containerBitLen - bitOffset - bitSize;
                } else {
                    ghidraBitOffset = bitOffset - memberOffset * 8;
                    boolean isBE = this.prog.getGhidraProgram().getMemory().isBigEndian();
                    if (isBE) {
                        ghidraBitOffset = containerBitLen - ghidraBitOffset - bitSize;
                    }
                }
                if (bitOffset < 0 || ghidraBitOffset < 0 || ghidraBitOffset >= containerBitLen) {
                    DWARFUtil.appendDescription((DataType)structure, DWARFDataTypeImporter.memberDesc("Missing member", "bad bitOffset", (String)memberName, dt, memberOffset, bitSize, bitOffset), "\n");
                    continue;
                }
                try {
                    structure.insertBitFieldAt(memberOffset, containerLen, ghidraBitOffset, dt, bitSize, (String)memberName, null);
                }
                catch (InvalidDataTypeException e) {
                    Msg.error((Object)this, (Object)("Unable to add member " + (String)memberName + " to structure " + structure.getDataTypePath() + "[DWARF DIE " + diea.getHexOffset() + "], skipping: " + e.getMessage()));
                    DWARFUtil.appendDescription((DataType)structure, DWARFDataTypeImporter.memberDesc("Missing member ", "Failed to add bitfield", (String)memberName, dt, memberOffset, bitSize, bitOffset), "\n");
                }
                continue;
            }
            String memberComment = null;
            boolean bl = isDynamicSizedType = dt instanceof Dynamic || dt instanceof FactoryDataType;
            if (isDynamicSizedType) {
                memberComment = "Unsupported dynamic size data type: " + dt;
                dt = Undefined.getUndefinedDataType((int)1);
            }
            if (memberOffset + (childLength = this.getUnpaddedDataTypeLength(dt)) > structure.getLength()) {
                DWARFUtil.appendDescription((DataType)structure, DWARFDataTypeImporter.memberDesc("Missing member", "exceeds parent struct len", (String)memberName, dt, memberOffset, -1, -1), "\n");
                continue;
            }
            try {
                DataTypeComponentImpl dtc;
                if (DataTypeComponent.usesZeroLengthComponent((DataType)dt)) {
                    if (!this.isUndefinedOrZeroLenAtOffset((Structure)structure, memberOffset)) {
                        DWARFUtil.appendDescription((DataType)structure, DWARFDataTypeImporter.memberDesc("Missing member", "conflicting member at same offset", (String)memberName, dt, memberOffset, -1, -1), "\n");
                        continue;
                    }
                    dtc = structure.insertAtOffset(memberOffset, dt, 0, (String)memberName, memberComment);
                } else {
                    int ordinalToReplace = this.getUndefinedOrdinalAt((Structure)structure, memberOffset);
                    if (ordinalToReplace == -1) {
                        DataTypeComponent existingDTC = structure.getComponentContaining(memberOffset);
                        if (existingDTC == null) continue;
                        DWARFUtil.appendDescription((DataType)structure, DWARFDataTypeImporter.memberDesc("Missing member", "conflict with " + existingDTC.getFieldName(), (String)memberName, dt, memberOffset, -1, -1), "\n");
                        continue;
                    }
                    dtc = structure.replace(ordinalToReplace, dt, childLength, (String)memberName, memberComment);
                }
                this.updateMapping(dt, dtc.getDataType());
            }
            catch (IllegalArgumentException exc) {
                Msg.error((Object)this, (Object)("Unable to add member " + (String)memberName + " to structure " + structure.getDataTypePath() + "[DWARF DIE " + diea.getHexOffset() + "], skipping: " + exc.getMessage()));
                DWARFUtil.appendDescription((DataType)structure, DWARFDataTypeImporter.memberDesc("Missing member ", "", (String)memberName, dt, memberOffset, -1, -1), "\n");
            }
        }
    }

    private boolean isUndefinedOrZeroLenAtOffset(Structure struct, int offset) {
        DataTypeComponent lastComp;
        List compsAt = struct.getComponentsContaining(offset);
        DataTypeComponent dataTypeComponent = lastComp = !compsAt.isEmpty() ? (DataTypeComponent)compsAt.get(compsAt.size() - 1) : null;
        if (lastComp == null) {
            return true;
        }
        if (lastComp.getOffset() != offset) {
            return false;
        }
        DataType dt = lastComp.getDataType();
        return dt.isZeroLength() || dt instanceof DefaultDataType;
    }

    private int getUndefinedOrdinalAt(Structure struct, int offset) {
        DataTypeComponent lastComp;
        List compsAt = struct.getComponentsContaining(offset);
        DataTypeComponent dataTypeComponent = lastComp = !compsAt.isEmpty() ? (DataTypeComponent)compsAt.get(compsAt.size() - 1) : null;
        if (lastComp == null || lastComp.getOffset() != offset || !(lastComp.getDataType() instanceof DefaultDataType)) {
            return -1;
        }
        return lastComp.getOrdinal();
    }

    private static String memberDesc(String prefix, String errorStr, String memberName, DataType dt, int memberOffset, int bitSize, int bitOffset) {
        return (String)(!StringUtils.isBlank((CharSequence)prefix) ? prefix + " " : "") + memberName + " : " + dt.getName() + (String)(bitSize != -1 ? ":" + bitSize : "") + " at offset " + (String)(memberOffset != -1 ? "0x" + Long.toHexString(memberOffset) : "unknown") + (String)(bitOffset != -1 ? ":" + bitOffset : "") + (String)(!StringUtils.isBlank((CharSequence)errorStr) ? " [" + errorStr + "]" : "");
    }

    private DataType fixupDataTypeInconsistencies(DWARFDataType ddt) {
        if (ddt == null) {
            return null;
        }
        DataType result = ddt.dataType;
        if (result instanceof FunctionDefinition) {
            result = this.dwarfDTM.getPtrTo(result);
        }
        return result;
    }

    private DWARFDataType makeDataTypeForArray(DIEAggregate diea) throws IOException, DWARFExpressionException {
        DWARFDataType elementType = this.getDataType(diea.getTypeRef(), this.voidDDT);
        DWARFDataType self = this.dieOffsetToDataTypeMap.get(diea.getOffset());
        if (self != null) {
            return self;
        }
        DataType elementDT = this.fixupDataTypeInconsistencies(elementType);
        long explictArraySize = diea.getUnsignedLong(11, -1L);
        if (elementType.dataType.isZeroLength() || explictArraySize == 0L) {
            ArrayDataType zeroLenArray = new ArrayDataType(elementDT, 0, -1, this.dataTypeManager);
            return new DWARFDataType((DataType)zeroLenArray, null, diea.getOffset());
        }
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        List<DebugInfoEntry> subrangeDIEs = diea.getChildren(33);
        for (int subRangeDIEIndex = 0; subRangeDIEIndex < subrangeDIEs.size(); ++subRangeDIEIndex) {
            DIEAggregate subrangeAggr = this.prog.getAggregate(subrangeDIEs.get(subRangeDIEIndex));
            long numElements = -1L;
            try {
                if (subrangeAggr.hasAttribute(55)) {
                    numElements = subrangeAggr.parseUnsignedLong(55, 195935983L);
                } else if (subrangeAggr.hasAttribute(47)) {
                    long upperBound = subrangeAggr.parseUnsignedLong(47, 195935983L);
                    if (upperBound == 0xFFFFFFFFL || upperBound == -1L) {
                        upperBound = 0L;
                    } else {
                        numElements = upperBound + 1L;
                    }
                }
            }
            catch (DWARFExpressionException | IOException | IndexOutOfBoundsException | UnsupportedOperationException exception) {
                // empty catch block
            }
            if (numElements == -1L) {
                numElements = 0L;
            } else if (numElements > Integer.MAX_VALUE) {
                Msg.error((Object)this, (Object)("Bad value [" + numElements + "] for array's size in DIE: " + diea.getHexOffset() + ", forcing to 1"));
                numElements = 1L;
            }
            dimensions.add((int)numElements);
        }
        DataType dt = elementDT;
        for (int i = dimensions.size() - 1; i >= 0; --i) {
            int numElements = (Integer)dimensions.get(i);
            ArrayDataType subArray = new ArrayDataType(dt, numElements, -1, this.dataTypeManager);
            if (dt == elementDT) {
                this.updateMapping(dt, subArray.getDataType());
            }
            dt = subArray;
        }
        DWARFDataType result = new DWARFDataType(dt, null, diea.getOffset());
        return result;
    }

    private DWARFDataType makeDataTypeForPointer(DIEAggregate diea) throws IOException, DWARFExpressionException {
        DWARFDataType refdDT = this.getDataType(diea.getTypeRef(), this.voidDDT);
        int byteSize = diea.parseInt(11, diea.getCompilationUnit().getPointerSize());
        DWARFDataType self = this.dieOffsetToDataTypeMap.get(diea.getOffset());
        if (self != null) {
            return self;
        }
        if (byteSize == this.dataTypeManager.getDataOrganization().getPointerSize()) {
            byteSize = -1;
        }
        PointerDataType resultDataType = refdDT.dataType instanceof DataTypeImpl ? new PointerDataType(refdDT.dataType, byteSize, this.dataTypeManager) : this.dataTypeManager.resolve((DataType)this.dataTypeManager.getPointer(refdDT.dataType, byteSize), DataTypeConflictHandler.DEFAULT_HANDLER);
        return new DWARFDataType((DataType)resultDataType, null, diea.getOffset());
    }

    private DWARFDataType makeDataTypeForPtrToMemberType(DIEAggregate diea) throws IOException, DWARFExpressionException {
        DWARFNameInfo dni = this.prog.getName(diea);
        DIEAggregate type = diea.getTypeRef();
        DIEAggregate containingType = diea.getContainingTypeRef();
        if (type == null || containingType == null) {
            Msg.error((Object)this, (Object)("No type info for ptr_to_member: " + diea.toString()));
            return null;
        }
        int byteSize = diea.parseInt(11, diea.getCompilationUnit().getPointerSize());
        DataType offsetType = this.dwarfDTM.getOffsetType(byteSize);
        String x = "offset_in_" + containingType.getName() + "_to_" + type.getName();
        TypedefDataType dt = new TypedefDataType(dni.getParentCP(), x, offsetType, this.dataTypeManager);
        if (!dni.isAnon()) {
            dt = new TypedefDataType(dni.getParentCP(), dni.getName(), (DataType)dt, this.dataTypeManager);
        }
        return new DWARFDataType((DataType)dt, dni, diea.getOffset());
    }

    private DWARFDataType makeDataTypeForTypedef(DIEAggregate diea) throws IOException, DWARFExpressionException {
        Pointer ptrDT;
        DataType dataType;
        DWARFNameInfo typedefDNI = this.prog.getName(diea);
        DIEAggregate refdDIEA = diea.getTypeRef();
        if (refdDIEA != null && refdDIEA.getTag() == 36) {
            return this.makeNamedBaseType(typedefDNI, refdDIEA);
        }
        DWARFDataType refdDT = this.getDataType(refdDIEA, this.voidDDT);
        DWARFDataType self = this.dieOffsetToDataTypeMap.get(diea.getOffset());
        if (self != null) {
            return self;
        }
        boolean typedefWithSameName = DataTypeUtilities.equalsIgnoreConflict((String)typedefDNI.asDataTypePath().getPath(), (String)refdDT.dataType.getPathName());
        if (!typedefWithSameName && (dataType = refdDT.dataType) instanceof Pointer && (dataType = (ptrDT = (Pointer)dataType).getDataType()) instanceof FunctionDefinition) {
            FunctionDefinition pointedToFuncDefDT = (FunctionDefinition)dataType;
            typedefWithSameName = DataTypeUtilities.equalsIgnoreConflict((String)typedefDNI.asDataTypePath().getPath(), (String)pointedToFuncDefDT.getPathName());
        }
        if (typedefWithSameName) {
            if (this.importOptions.isElideTypedefsWithSameName()) {
                refdDT.offsets.add(diea.getOffset());
                return refdDT;
            }
            String newName = typedefDNI.getName() + "_typedef";
            typedefDNI = typedefDNI.replaceName(newName, newName);
        }
        TypedefDataType typedefDT = new TypedefDataType(typedefDNI.getParentCP(), typedefDNI.getName(), refdDT.dataType, this.dataTypeManager);
        this.updateMapping(refdDT.dataType, typedefDT.getDataType());
        return new DWARFDataType((DataType)typedefDT, typedefDNI, diea.getOffset());
    }

    private DWARFDataType makeDataTypeForUnspecifiedType(DIEAggregate diea) {
        DWARFNameInfo dni = this.prog.getName(diea);
        DataType dt = this.dwarfDTM.getBaseType(dni.getOriginalName());
        if (dt == null) {
            return this.voidDDT;
        }
        return new DWARFDataType(dt, dni, diea.getOffset());
    }

    static class DWARFDataType {
        DataType dataType;
        DWARFNameInfo dni;
        DWARFSourceInfo dsi;
        Set<Long> offsets = new HashSet<Long>();

        DWARFDataType(DataType dataType, DWARFNameInfo dni, long offset) {
            this.dataType = dataType;
            this.dni = dni;
            this.offsets.add(offset);
        }

        DWARFDataType(DataType dataType, DWARFNameInfo dni, Set<Long> offsets) {
            this.dataType = dataType;
            this.dni = dni;
            this.offsets.addAll(offsets);
        }

        public String toString() {
            return this.dataType.getName() + " | " + (this.dni != null ? this.dni.toString() : "na") + " | " + this.hexOffsets() + " | zerolen: " + this.dataType.isZeroLength();
        }

        public String hexOffsets() {
            return this.offsets.stream().sorted().map(Long::toHexString).collect(Collectors.joining(","));
        }
    }
}

