/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.funcfixup;

import ghidra.app.util.bin.format.dwarf4.funcfixup.DWARFFunctionFixup;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunction;
import ghidra.app.util.bin.format.dwarf4.next.DWARFVariable;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.listing.Function;
import ghidra.util.Msg;
import ghidra.util.classfinder.ExtensionPointProperties;

@ExtensionPointProperties(priority=3000)
public class ThisCallingConventionDWARFFunctionFixup
implements DWARFFunctionFixup {
    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc, Function gfunc) {
        if (dfunc.params.isEmpty() || dfunc.callingConvention != null) {
            return;
        }
        DWARFVariable firstParam = dfunc.params.get(0);
        if (firstParam.isThis) {
            if (!firstParam.name.isAnon() && !Function.THIS_PARAM_NAME.equals(firstParam.name.getOriginalName())) {
                Msg.error((Object)this, (Object)String.format("WARNING: Renaming %s to %s in function %s@%s", firstParam.name.getName(), Function.THIS_PARAM_NAME, gfunc.getName(), gfunc.getEntryPoint()));
            }
            firstParam.name = firstParam.name.replaceName(Function.THIS_PARAM_NAME, Function.THIS_PARAM_NAME);
            dfunc.callingConvention = GenericCallingConvention.thiscall;
        }
    }
}

