/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import ghidra.app.plugin.debug.EventDisplayComponentProvider;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginEventListener;
import ghidra.framework.plugintool.util.PluginStatus;
import help.Help;
import help.HelpService;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Developer", category="Testing", shortDescription="Show plugin events", description="This plugin is a debug aid that prints plugin event information. It can also be used as a sample of how to handle plugin events and how to write a component provider.")
public class EventDisplayPlugin
extends Plugin {
    private EventDisplayComponentProvider provider;

    public EventDisplayPlugin(PluginTool tool) {
        super(tool);
        this.provider = new EventDisplayComponentProvider(tool, this.getName());
        HelpService helpService = Help.getHelpService();
        helpService.excludeFromHelp((Object)this.provider);
        tool.addListenerForAllPluginEvents((PluginEventListener)this);
    }

    protected void dispose() {
        this.tool.removeListenerForAllPluginEvents((PluginEventListener)this);
    }

    public void processEvent(PluginEvent event) {
        this.provider.processEvent(event);
    }
}

