/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.osgi.BundleHost;
import ghidra.app.plugin.core.osgi.GhidraBundle;
import ghidra.app.plugin.core.osgi.GhidraSourceBundle;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.util.Swing;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.task.SwingUpdateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScriptList {
    private BundleHost bundleHost;
    private List<ResourceFile> scriptFiles = new ArrayList<ResourceFile>();
    private WeakSet<ChangeListener> listeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private SwingUpdateManager refreshUpdateManager = new SwingUpdateManager(this::doRefresh);

    ScriptList(BundleHost bundleHost) {
        this.bundleHost = bundleHost;
    }

    void addListener(ChangeListener l) {
        this.listeners.add((Object)l);
    }

    void removeListener(ChangeListener l) {
        this.listeners.remove((Object)l);
    }

    private void notifyScriptsChanged() {
        ChangeEvent e = new ChangeEvent(this);
        this.listeners.forEach(l -> l.stateChanged(e));
    }

    void refresh() {
        this.refreshUpdateManager.update();
    }

    private void doRefresh() {
        ArrayList<ResourceFile> scriptAccumulator = new ArrayList<ResourceFile>();
        for (ResourceFile bundleDir : this.getScriptDirectories()) {
            this.updateAvailableScriptFilesForDirectory(scriptAccumulator, bundleDir);
        }
        this.scriptFiles = scriptAccumulator;
        this.notifyScriptsChanged();
    }

    void load() {
        Swing.runNow(() -> {
            if (this.scriptFiles.isEmpty()) {
                this.doRefresh();
            }
        });
    }

    List<ResourceFile> getScriptFiles() {
        this.load();
        return Collections.unmodifiableList(this.scriptFiles);
    }

    List<ResourceFile> getScriptDirectories() {
        return this.bundleHost.getGhidraBundles().stream().filter(GhidraSourceBundle.class::isInstance).filter(GhidraBundle::isEnabled).map(GhidraBundle::getFile).collect(Collectors.toList());
    }

    private void updateAvailableScriptFilesForDirectory(List<ResourceFile> scriptAccumulator, ResourceFile directory) {
        ResourceFile[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (ResourceFile scriptFile : files) {
            if (!scriptFile.isFile() || !GhidraScriptUtil.hasScriptProvider(scriptFile)) continue;
            scriptAccumulator.add(scriptFile);
        }
    }
}

