/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.builder.ActionBuilder;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.table.AbstractSortedTableModel;
import generic.theme.GIcon;
import ghidra.app.cmd.refs.AddExternalNameCmd;
import ghidra.app.cmd.refs.ClearExternalNameCmd;
import ghidra.app.cmd.refs.RemoveExternalNameCmd;
import ghidra.app.cmd.refs.SetExternalNameCmd;
import ghidra.app.cmd.refs.UpdateExternalNameCmd;
import ghidra.app.plugin.core.references.ReferencesPlugin;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import resources.Icons;

public class ExternalReferencesProvider
extends ComponentProviderAdapter {
    private static Icon ADD_ICON = Icons.ADD_ICON;
    private static Icon DELETE_ICON = Icons.DELETE_ICON;
    private static Icon EDIT_ICON = new GIcon("icon.base.edit.bytes");
    private static Icon CLEAR_ICON = Icons.CLEAR_ICON;
    private JPanel mainPanel;
    private ExternalNamesTableModel tableModel;
    private GhidraTable table;
    private Program program;
    private String rowToHighlightDuringNextReload;
    private DomainObjectListener domainObjectListener = ev -> {
        if (this.isVisible()) {
            this.tableModel.updateTableData();
            if (this.rowToHighlightDuringNextReload != null) {
                int row = this.tableModel.indexOf(this.rowToHighlightDuringNextReload);
                this.rowToHighlightDuringNextReload = null;
                if (row >= 0) {
                    this.table.selectRow(row);
                }
            }
        }
    };

    public ExternalReferencesProvider(ReferencesPlugin plugin) {
        super(plugin.getTool(), "External Programs", plugin.getName());
        this.mainPanel = this.buildMainPanel();
        this.createActions();
        this.setHelpLocation(new HelpLocation("ReferencesPlugin", "ExternalNamesDialog"));
        this.addToTool();
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Add External Program Name", this.getOwner()).popupMenuPath(new String[]{"Add External Program"})).popupMenuIcon(ADD_ICON)).toolBarIcon(ADD_ICON)).enabledWhen(ac -> this.program != null)).onAction(ac -> this.addExternalProgram())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Delete External Program Name", this.getOwner()).popupMenuPath(new String[]{"Delete External Program"})).popupMenuIcon(DELETE_ICON)).toolBarIcon(DELETE_ICON)).enabledWhen(ac -> this.hasSelectedRows())).onAction(ac -> this.deleteExternalProgram())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Set External Name Association", this.getOwner()).popupMenuPath(new String[]{"Set External Name Association"})).popupMenuIcon(EDIT_ICON)).toolBarIcon(EDIT_ICON)).enabledWhen(ac -> this.isSingleRowSelected())).onAction(ac -> this.setExternalProgramAssociation())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Clear External Name Association", this.getOwner()).popupMenuPath(new String[]{"Clear External Name Association"})).popupMenuIcon(CLEAR_ICON)).toolBarIcon(CLEAR_ICON)).enabledWhen(ac -> this.hasSelectedRows())).onAction(ac -> this.clearExternalAssociation())).buildAndInstallLocal((ComponentProvider)this);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    void setProgram(Program program) {
        this.rowToHighlightDuringNextReload = null;
        if (this.program != null) {
            this.program.removeListener(this.domainObjectListener);
        }
        this.program = program;
        if (this.program != null) {
            this.program.addListener(this.domainObjectListener);
        }
        if (this.isVisible()) {
            this.tableModel.updateTableData();
        }
    }

    public void componentHidden() {
        this.tableModel.updateTableData();
    }

    public void componentShown() {
        this.tableModel.updateTableData();
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new ActionContext((ComponentProvider)this, (Component)((Object)this.table));
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.tableModel = new ExternalNamesTableModel();
        this.table = new GhidraTable((TableModel)((Object)this.tableModel));
        JScrollPane sp = new JScrollPane((Component)((Object)this.table));
        this.table.setSelectionMode(2);
        this.table.setAutoResizeMode(4);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.table));
        panel.add((Component)sp, "Center");
        return panel;
    }

    private boolean isSingleRowSelected() {
        return this.table.getSelectedRowCount() == 1;
    }

    private boolean hasSelectedRows() {
        return this.table.getSelectedRowCount() > 0;
    }

    public List<String> getSelectedExternalNames() {
        ArrayList<String> externalNames = new ArrayList<String>();
        for (int rowIndex : this.table.getSelectedRows()) {
            ExternalNamesRow row = (ExternalNamesRow)this.tableModel.getRowObject(rowIndex);
            externalNames.add(row.getName());
        }
        return externalNames;
    }

    void dispose() {
        this.table.dispose();
    }

    private void addExternalProgram() {
        InputDialog dialog = new InputDialog("New External Program", "Enter Name");
        dialog.setHelpLocation(new HelpLocation("ReferencesPlugin", "Add_External_Program_Name"));
        this.getTool().showDialog((DialogComponentProvider)dialog, (ComponentProvider)this);
        if (dialog.isCanceled()) {
            return;
        }
        String newExternalName = dialog.getValue().trim();
        if (newExternalName.isEmpty()) {
            Msg.showError((Object)((Object)this), (Component)dialog.getComponent(), (String)"Invalid Input", (Object)"External program name cannot be empty");
            return;
        }
        AddExternalNameCmd cmd = new AddExternalNameCmd(newExternalName, SourceType.USER_DEFINED);
        this.getTool().execute((Command)cmd, (DomainObject)this.program);
    }

    private void deleteExternalProgram() {
        ExternalManager externalManager = this.program.getExternalManager();
        StringBuilder buf = new StringBuilder();
        CompoundCmd cmd = new CompoundCmd("Delete External Program Name");
        for (String externalName : this.getSelectedExternalNames()) {
            boolean hasLocations = externalManager.getExternalLocations(externalName).hasNext();
            if (hasLocations) {
                buf.append("\n     ");
                buf.append(externalName);
                continue;
            }
            cmd.add((Command)new RemoveExternalNameCmd(externalName));
        }
        if (cmd.size() > 0) {
            this.getTool().execute((Command)cmd, (DomainObject)this.program);
        }
        if (buf.length() > 0) {
            Msg.showError((Object)((Object)this), (Component)this.mainPanel, (String)"Delete Failure", (Object)("The following external reference names could not be deleted\nbecause they contain external locations:\n" + buf.toString()));
        }
    }

    private void setExternalProgramAssociation() {
        List<String> selectedExternalNames = this.getSelectedExternalNames();
        String externalName = selectedExternalNames.get(0);
        DataTreeDialog dialog = new DataTreeDialog(this.mainPanel, "Choose External Program (" + externalName + ")", 0);
        dialog.setSearchText(externalName);
        dialog.addOkActionListener(e1 -> {
            DomainFile domainFile = dialog.getDomainFile();
            if (domainFile == null) {
                return;
            }
            String pathName = domainFile.toString();
            dialog.close();
            ExternalManager externalManager = this.program.getExternalManager();
            String externalLibraryPath = externalManager.getExternalLibraryPath(externalName);
            if (!pathName.equals(externalLibraryPath)) {
                SetExternalNameCmd cmd = new SetExternalNameCmd(externalName, domainFile.getPathname());
                this.getTool().execute((Command)cmd, (DomainObject)this.program);
            }
        });
        dialog.setHelpLocation(new HelpLocation("ReferencesPlugin", "ChooseExternalProgram"));
        this.getTool().showDialog((DialogComponentProvider)dialog);
    }

    private void clearExternalAssociation() {
        CompoundCmd cmd = new CompoundCmd("Clear External Program Associations");
        for (String externalName : this.getSelectedExternalNames()) {
            cmd.add((Command)new ClearExternalNameCmd(externalName));
        }
        this.getTool().execute((Command)cmd, (DomainObject)this.program);
    }

    class ExternalNamesTableModel
    extends AbstractSortedTableModel<ExternalNamesRow> {
        static final int NAME_COL = 0;
        static final int PATH_COL = 1;
        static final String EXTERNAL_NAME = "Name";
        static final String PATH_NAME = "Ghidra Program";
        private final List<String> columns = List.of("Name", "Ghidra Program");
        private List<ExternalNamesRow> paths = new ArrayList<ExternalNamesRow>();

        ExternalNamesTableModel() {
        }

        void updateTableData() {
            this.paths.clear();
            if (ExternalReferencesProvider.this.program != null && ExternalReferencesProvider.this.isVisible()) {
                ExternalManager extMgr = ExternalReferencesProvider.this.program.getExternalManager();
                Object[] programNames = extMgr.getExternalLibraryNames();
                Arrays.sort(programNames);
                for (Object programName : programNames) {
                    if ("<EXTERNAL>".equals(programName)) continue;
                    ExternalNamesRow path = new ExternalNamesRow((String)programName, extMgr.getExternalLibraryPath((String)programName));
                    this.paths.add(path);
                }
            }
            ExternalReferencesProvider.this.tableModel.fireTableDataChanged();
        }

        private boolean rowAlreadyExists(String name) {
            return this.indexOf(name) != -1;
        }

        private int indexOf(String name) {
            for (int i = 0; i < this.paths.size(); ++i) {
                ExternalNamesRow path = this.paths.get(i);
                if (!path.getName().equals(name)) continue;
                return i;
            }
            return -1;
        }

        public void dispose() {
            super.dispose();
            this.paths.clear();
        }

        public int getColumnCount() {
            return this.columns.size();
        }

        public String getColumnName(int column) {
            return this.columns.get(column);
        }

        public String getName() {
            return "External Programs Model";
        }

        public boolean isSortable(int columnIndex) {
            return true;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public List<ExternalNamesRow> getModelData() {
            return this.paths;
        }

        public Object getColumnValueForRow(ExternalNamesRow t, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return t.getName();
                }
                case 1: {
                    return t.getPath();
                }
            }
            return "Unknown Column!";
        }

        public void setValueAt(Object aValue, int row, int column) {
            if (column != 0) {
                return;
            }
            String newName = ((String)aValue).trim();
            ExternalNamesRow path = this.paths.get(row);
            if (StringUtils.isBlank((CharSequence)newName) || path.getName().equals(newName)) {
                return;
            }
            if (this.rowAlreadyExists(newName)) {
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)ExternalReferencesProvider.this.mainPanel, (String)"Duplicate Name", (Object)("Name already exists: " + newName));
                return;
            }
            ExternalReferencesProvider.this.rowToHighlightDuringNextReload = newName;
            String oldName = path.getName();
            UpdateExternalNameCmd cmd = new UpdateExternalNameCmd(oldName, newName, SourceType.USER_DEFINED);
            if (!ExternalReferencesProvider.this.tool.execute((Command)cmd, (DomainObject)ExternalReferencesProvider.this.program)) {
                ExternalReferencesProvider.this.tool.setStatusInfo(cmd.getStatusMsg());
            }
        }

        protected Comparator<ExternalNamesRow> createSortComparator(int columnIndex) {
            if (columnIndex == 1) {
                Comparator c1 = (r1, r2) -> Objects.requireNonNullElse(r1.getPath(), "").compareTo(Objects.requireNonNullElse(r2.getPath(), ""));
                return c1.thenComparing((r1, r2) -> r1.getName().compareTo(r2.getName()));
            }
            return super.createSortComparator(columnIndex);
        }
    }

    private static class ExternalNamesRow {
        private String name;
        private String path;

        ExternalNamesRow(String name, String path) {
            this.name = name;
            this.path = path;
        }

        String getName() {
            return this.name;
        }

        String getPath() {
            return this.path;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExternalNamesRow other = (ExternalNamesRow)obj;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return Objects.equals(this.path, other.path);
        }
    }
}

