/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import docking.action.KeyBindingData;
import docking.action.ToolBarData;
import generic.util.image.ImageUtils;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import resources.Icons;
import resources.MultiIconBuilder;
import resources.QUADRANT;

public abstract class AbstractNextPreviousAction
extends NavigatableContextAction {
    private static final Icon INVERTED_OVERLAY_ICON = ImageUtils.makeTransparent((Icon)Icons.NOT_ALLOWED_ICON, (float)0.5f);
    private boolean isForward = true;
    private PluginTool tool;
    protected boolean isInverted;
    private Icon invertedIcon;

    public AbstractNextPreviousAction(PluginTool tool, String name, String owner, String subGroup) {
        super(name, owner);
        this.tool = tool;
        this.setSupportsDefaultToolContext(true);
        ToolBarData toolBarData = new ToolBarData(this.getIcon(), "4_Toolbar_Navigation_Group");
        toolBarData.setToolBarSubGroup(subGroup);
        this.setToolBarData(toolBarData);
        this.setKeyBindingData(new KeyBindingData(this.getKeyStroke()));
        this.setHelpLocation(new HelpLocation("Navigation", name));
        this.setDescription(this.getDescriptionString());
        this.addToWindowWhen(NavigatableActionContext.class);
        MultiIconBuilder builder = new MultiIconBuilder(this.getIcon());
        builder.addIcon(INVERTED_OVERLAY_ICON, 10, 10, QUADRANT.LR);
        this.invertedIcon = builder.build();
    }

    protected void setInverted(boolean isInverted) {
        this.isInverted = isInverted;
        this.getToolBarData().setIcon(isInverted ? this.invertedIcon : this.getIcon());
        this.setDescription(this.getDescriptionString());
    }

    protected abstract Icon getIcon();

    protected abstract KeyStroke getKeyStroke();

    @Override
    public void actionPerformed(final NavigatableActionContext context) {
        Task t = new Task("Searching for " + this.doGetNavigationTypeName(), true, false, true){

            public void run(TaskMonitor monitor) {
                AbstractNextPreviousAction.this.gotoNextPrevious(monitor, context);
            }
        };
        new TaskLauncher(t);
    }

    void gotoNextPrevious(TaskMonitor monitor, NavigatableActionContext context) {
        try {
            boolean direction = this.isForward;
            if (context.hasAnyEventClickModifiers(1)) {
                direction = !direction;
            }
            Address address = direction ? this.getNextAddress(monitor, context.getProgram(), context.getAddress()) : this.getPreviousAddress(monitor, context.getProgram(), context.getAddress());
            Swing.runLater(() -> this.gotoAddress(context, address));
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private void gotoAddress(NavigatableActionContext actionContext, Address address) {
        if (address == null) {
            this.tool.setStatusInfo("Unable to locate another \"" + this.doGetNavigationTypeName() + "\" past the current range, in the current direction.");
            return;
        }
        this.tool.clearStatusInfo();
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            Navigatable navigatable = actionContext.getNavigatable();
            this.gotoAddress(service, navigatable, address);
        }
    }

    protected void gotoAddress(GoToService service, Navigatable navigatable, Address address) {
        Program program = navigatable.getProgram();
        service.goTo(navigatable, (ProgramLocation)new AddressFieldLocation(program, address), program);
    }

    void setDirection(boolean isForward) {
        this.isForward = isForward;
        this.setDescription(this.getDescriptionString());
    }

    private String getDescriptionString() {
        String prefix = this.isForward ? "Go To Next " : "Go To Previous ";
        return prefix + this.doGetNavigationTypeName() + " (shift-click inverts direction)";
    }

    private String doGetNavigationTypeName() {
        if (this.isInverted) {
            return this.getInvertedNavigationTypeName();
        }
        return this.getNavigationTypeName();
    }

    protected abstract String getNavigationTypeName();

    protected String getInvertedNavigationTypeName() {
        return "Non-" + this.getNavigationTypeName();
    }

    protected abstract Address getNextAddress(TaskMonitor var1, Program var2, Address var3) throws CancelledException;

    protected abstract Address getPreviousAddress(TaskMonitor var1, Program var2, Address var3) throws CancelledException;
}

