/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare.actions;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.app.util.viewer.util.CodeComparisonPanelActionContext;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionUtility;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;

public abstract class AbstractApplyFunctionSignatureAction
extends DockingAction {
    private static final String MENU_GROUP = "A0_Apply";
    private static final String HELP_TOPIC = "FunctionComparison";
    private static final String ACTION_NAME = "Apply Function Signature To Other Side";

    public AbstractApplyFunctionSignatureAction(String owner) {
        super(ACTION_NAME, owner);
        this.setDescription(HTMLUtilities.toHTML((String)"Apply the signature of the function in the currently active side of a code comparison panel to the function in the other side of the panel."));
        MenuData menuData = new MenuData(new String[]{ACTION_NAME}, null, MENU_GROUP);
        this.setPopupMenuData(menuData);
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation(HELP_TOPIC, ACTION_NAME));
    }

    public abstract boolean isAddToPopup(ActionContext var1);

    public abstract boolean isEnabledForContext(ActionContext var1);

    public void actionPerformed(ActionContext context) {
        if (context instanceof CodeComparisonPanelActionContext) {
            CodeComparisonPanelActionContext compareContext = (CodeComparisonPanelActionContext)context;
            CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel = compareContext.getCodeComparisonPanel();
            Function leftFunction = codeComparisonPanel.getLeftFunction();
            Function rightFunction = codeComparisonPanel.getRightFunction();
            if (leftFunction == null || rightFunction == null) {
                return;
            }
            ComponentProvider componentProvider = context.getComponentProvider();
            boolean leftHasFocus = codeComparisonPanel.leftPanelHasFocus();
            boolean commit = leftHasFocus ? this.updateFunction(componentProvider, rightFunction, leftFunction) : this.updateFunction(componentProvider, leftFunction, rightFunction);
            if (commit) {
                if (leftHasFocus) {
                    codeComparisonPanel.refreshRightPanel();
                } else {
                    codeComparisonPanel.refreshLeftPanel();
                }
            }
        }
    }

    protected boolean hasReadOnlyNonFocusedSide(CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel) {
        Function leftFunction = codeComparisonPanel.getLeftFunction();
        Function rightFunction = codeComparisonPanel.getRightFunction();
        if (leftFunction == null || rightFunction == null) {
            return false;
        }
        boolean leftHasFocus = codeComparisonPanel.leftPanelHasFocus();
        Program leftProgram = leftFunction.getProgram();
        Program rightProgram = rightFunction.getProgram();
        return !leftHasFocus && leftProgram.getDomainFile().isReadOnly() || leftHasFocus && rightProgram.getDomainFile().isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateFunction(ComponentProvider provider, Function destinationFunction, Function sourceFunction) {
        Program program = destinationFunction.getProgram();
        int txID = program.startTransaction(ACTION_NAME);
        boolean commit = false;
        try {
            FunctionUtility.updateFunction(destinationFunction, sourceFunction);
            commit = true;
        }
        catch (DuplicateNameException | InvalidInputException e) {
            String message = "Couldn't apply the function signature from " + sourceFunction.getName() + " to " + destinationFunction.getName() + " @ " + destinationFunction.getEntryPoint().toString() + ". " + e.getMessage();
            Msg.showError((Object)((Object)this), (Component)provider.getComponent(), (String)ACTION_NAME, (Object)message, (Throwable)e);
        }
        finally {
            program.endTransaction(txID, commit);
        }
        return commit;
    }
}

