/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.util;

import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.app.plugin.core.datamgr.util.CaseInsensitveDataTypeLookupComparator;
import ghidra.app.plugin.core.datamgr.util.DataTypeIconWrapper;
import ghidra.app.plugin.core.datamgr.util.HighlightIcon;
import ghidra.app.services.DataTypeQueryService;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FileArchiveBasedDataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.ProjectArchiveBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.util.Msg;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import resources.MultiIcon;
import resources.ResourceManager;

public class DataTypeUtils {
    private static final Comparator<Object> DATA_TYPE_LOOKUP_COMPARATOR = new CaseInsensitveDataTypeLookupComparator();
    private static final char END_CHAR = '\uffff';
    private static final char BEGIN_CHAR = '\u0000';
    private static final Color COLOR_ICON_HIGHLIGHT = new GColor("color.bg.plugin.datamgr.icon.highlight");
    private static Map<Icon, MultiIcon> highlightIconMap = new HashMap<Icon, MultiIcon>();
    private static Icon defaultIcon;
    private static Icon disabledIcon;
    private static Icon favoriteIcon;
    private static Icon disabledFavoriteIcon;
    private static Icon builtInIcon;
    private static Icon disabledBuiltInIcon;
    private static Icon rootIcon;
    private static Icon openRootIcon;
    private static Icon openFolderIcon;
    private static Icon disabledOpenFolderIcon;
    private static Icon closedFolderIcon;
    private static Icon disabledClosedFolderIcon;
    private static Icon lockedOpenFolderIcon;
    private static Icon lockedClosedFolderIcon;
    private static Icon openArchiveFolderIcon;
    private static Icon closedArchiveFolderIcon;
    private static DataTypeIconWrapper[] dataTypeIconWrappers;
    private static boolean imagesLoaded;

    private DataTypeUtils() {
    }

    private static void loadImages() {
        if (imagesLoaded) {
            return;
        }
        imagesLoaded = true;
        defaultIcon = new GIcon("icon.plugin.datatypes.default");
        disabledIcon = new GIcon("icon.plugin.datatypes.default.disabled");
        favoriteIcon = new GIcon("icon.plugin.datatypes.util.favorite");
        disabledFavoriteIcon = new GIcon("icon.plugin.datatypes.util.favorite.disabled");
        builtInIcon = new GIcon("icon.plugin.datatypes.built.in");
        disabledBuiltInIcon = new GIcon("icon.plugin.datatypes.built.in.disabled");
        rootIcon = new GIcon("icon.plugin.datatypes.util.root");
        openRootIcon = new GIcon("icon.plugin.datatypes.util.open.root");
        openFolderIcon = new GIcon("icon.plugin.datatypes.util.open.folder");
        disabledOpenFolderIcon = new GIcon("icon.plugin.datatypes.util.open.folder.disabled");
        closedFolderIcon = new GIcon("icon.plugin.datatypes.util.closed.folder");
        disabledClosedFolderIcon = new GIcon("icon.plugin.datatypes.util.closed.folder.disabled");
        lockedOpenFolderIcon = new GIcon("icon.plugin.datatypes.util.open.folder.locked");
        lockedClosedFolderIcon = new GIcon("icon.plugin.datatypes.util.closed.folder.locked");
        openArchiveFolderIcon = new GIcon("icon.plugin.datatypes.util.open.archive");
        closedArchiveFolderIcon = new GIcon("icon.plugin.datatypes.util.closed.archive");
        DataTypeUtils.createDataTypeIcons();
    }

    private static void createDataTypeIcons() {
        ArrayList<DataTypeIconWrapper> list = new ArrayList<DataTypeIconWrapper>();
        GIcon enumIcon = new GIcon("icon.plugin.datatypes.enum");
        list.add(new DataTypeIconWrapper(Enum.class, (Icon)enumIcon, ResourceManager.getDisabledIcon((Icon)enumIcon)));
        GIcon functionIcon = new GIcon("icon.plugin.datatypes.function");
        list.add(new DataTypeIconWrapper(FunctionDefinition.class, (Icon)functionIcon, ResourceManager.getDisabledIcon((Icon)functionIcon)));
        GIcon pointerIcon = new GIcon("icon.plugin.datatypes.pointer");
        list.add(new DataTypeIconWrapper(Pointer.class, (Icon)pointerIcon, ResourceManager.getDisabledIcon((Icon)pointerIcon)));
        GIcon typedefIcon = new GIcon("icon.plugin.datatypes.typedef");
        list.add(new DataTypeIconWrapper(TypeDef.class, (Icon)typedefIcon, ResourceManager.getDisabledIcon((Icon)typedefIcon)));
        GIcon unionIcon = new GIcon("icon.plugin.datatypes.union");
        list.add(new DataTypeIconWrapper(Union.class, (Icon)unionIcon, ResourceManager.getDisabledIcon((Icon)unionIcon)));
        GIcon structureIcon = new GIcon("icon.plugin.datatypes.structure");
        list.add(new DataTypeIconWrapper(Structure.class, (Icon)structureIcon, ResourceManager.getDisabledIcon((Icon)structureIcon)));
        dataTypeIconWrappers = list.toArray(new DataTypeIconWrapper[list.size()]);
    }

    public static Icon getRootIcon(boolean expanded) {
        DataTypeUtils.loadImages();
        return expanded ? openRootIcon : rootIcon;
    }

    public static Icon getOpenFolderIcon(boolean disabled) {
        DataTypeUtils.loadImages();
        if (disabled) {
            return disabledOpenFolderIcon;
        }
        return openFolderIcon;
    }

    public static Icon getClosedFolderIcon(boolean disabled) {
        DataTypeUtils.loadImages();
        if (disabled) {
            return disabledClosedFolderIcon;
        }
        return closedFolderIcon;
    }

    public static Icon getOpenArchiveFolder(boolean isLocked) {
        DataTypeUtils.loadImages();
        if (isLocked) {
            return lockedOpenFolderIcon;
        }
        return openArchiveFolderIcon;
    }

    public static Icon getClosedArchiveFolder(boolean isLocked) {
        DataTypeUtils.loadImages();
        if (isLocked) {
            return lockedClosedFolderIcon;
        }
        return closedArchiveFolderIcon;
    }

    public static Icon getBuiltInIcon(boolean disabled) {
        DataTypeUtils.loadImages();
        if (disabled) {
            return disabledBuiltInIcon;
        }
        return builtInIcon;
    }

    public static Icon getFavoriteIcon(boolean disabled) {
        DataTypeUtils.loadImages();
        if (disabled) {
            return disabledFavoriteIcon;
        }
        return favoriteIcon;
    }

    public static Icon getIconForDataType(DataType dataType, boolean disabled) {
        DataTypeUtils.loadImages();
        for (DataTypeIconWrapper element : dataTypeIconWrappers) {
            Icon icon = element.getIcon(dataType, disabled);
            if (icon == null) continue;
            return icon;
        }
        if (disabled) {
            return disabledIcon;
        }
        return defaultIcon;
    }

    public static Icon getHighlightIcon(Icon baseIcon) {
        DataTypeUtils.loadImages();
        MultiIcon highlightIcon = highlightIconMap.get(baseIcon);
        if (highlightIcon == null) {
            highlightIcon = new MultiIcon((Icon)new HighlightIcon(COLOR_ICON_HIGHLIGHT));
            highlightIcon.addIcon(baseIcon);
            highlightIconMap.put(baseIcon, highlightIcon);
        }
        return highlightIcon;
    }

    public static List<DataType> getStartsWithMatchingDataTypes(String searchString, DataTypeQueryService dataService) {
        return DataTypeUtils.getMatchingSubList(searchString, searchString + "\uffff", dataService.getSortedDataTypeList());
    }

    public static List<DataType> getExactMatchingDataTypes(String searchString, DataTypeQueryService dataService) {
        return DataTypeUtils.getMatchingSubList(searchString, searchString + "\u0000", dataService.getSortedDataTypeList());
    }

    public static String prepareSearchText(String searchText) {
        return searchText.replaceAll(" ", "");
    }

    static List<DataType> getMatchingSubList(String searchTextStart, String searchTextEnd, List<DataType> dataTypeList) {
        searchTextStart = DataTypeUtils.prepareSearchText(searchTextStart);
        searchTextEnd = DataTypeUtils.prepareSearchText(searchTextEnd);
        int startIndex = DataTypeUtils.binarySearchWithDuplicates(dataTypeList, searchTextStart, DATA_TYPE_LOOKUP_COMPARATOR);
        int endIndex = DataTypeUtils.binarySearchWithDuplicates(dataTypeList, searchTextEnd, DATA_TYPE_LOOKUP_COMPARATOR);
        return dataTypeList.subList(startIndex, endIndex);
    }

    public static DataType getBaseDataType(DataType dt) {
        DataType baseDataType = dt;
        while (baseDataType instanceof Pointer || baseDataType instanceof Array || baseDataType instanceof TypeDef) {
            if (baseDataType instanceof Pointer) {
                DataType innerDt = ((Pointer)baseDataType).getDataType();
                if (innerDt != null) {
                    baseDataType = innerDt;
                    continue;
                }
                return baseDataType;
            }
            if (baseDataType instanceof Array) {
                baseDataType = ((Array)baseDataType).getDataType();
                continue;
            }
            baseDataType = ((TypeDef)baseDataType).getDataType();
        }
        return baseDataType;
    }

    public static DataType getNamedBaseDataType(DataType dt) {
        DataType baseDataType = dt;
        while (baseDataType instanceof Pointer || baseDataType instanceof Array) {
            if (baseDataType instanceof Pointer) {
                DataType innerDt = ((Pointer)baseDataType).getDataType();
                if (innerDt != null) {
                    baseDataType = innerDt;
                    continue;
                }
                return baseDataType;
            }
            if (!(baseDataType instanceof Array)) continue;
            baseDataType = ((Array)baseDataType).getDataType();
        }
        return baseDataType;
    }

    public static DataType copyToNamedBaseDataType(DataType dataType, DataTypeManager dtm) {
        if (dataType instanceof Pointer) {
            Pointer pdt = (Pointer)dataType;
            return new PointerDataType(DataTypeUtils.copyToNamedBaseDataType(pdt.getDataType(), dtm), pdt.hasLanguageDependantLength() ? -1 : pdt.getLength(), dtm);
        }
        if (dataType instanceof Array) {
            Array adt = (Array)dataType;
            return new ArrayDataType(DataTypeUtils.copyToNamedBaseDataType(adt.getDataType(), dtm), adt.getNumElements(), adt.getElementLength(), dtm);
        }
        return dataType.copy(dtm);
    }

    public static void showUnmodifiableArchiveErrorMessage(Component parent, String title, DataTypeManager dtm) {
        ProjectArchiveBasedDataTypeManager projectDtm;
        Object msg = dtm instanceof ProgramBasedDataTypeManager ? "The Program is not modifiable!\n" : (dtm instanceof FileArchiveBasedDataTypeManager ? "The archive file is not modifiable!\nYou must open the archive for editing\nbefore performing this operation.\n" + dtm.getName() : (dtm instanceof ProjectArchiveBasedDataTypeManager ? (!(projectDtm = (ProjectArchiveBasedDataTypeManager)dtm).isUpdatable() && !projectDtm.getDomainFile().canCheckout() ? "The project archive is not modifiable!\n" + dtm.getName() : "The project archive is not modifiable!\nYou must check out the archive\nbefore performing this operation.\n" + dtm.getName()) : "The Archive is not modifiable!\n"));
        Msg.showInfo(DataTypeUtils.class, (Component)parent, (String)title, (Object)msg);
    }

    public static int binarySearchWithDuplicates(List<DataType> data, String searchItem, Comparator<Object> comparator) {
        int index = Collections.binarySearch(data, searchItem, comparator);
        index = index < 0 ? -index - 1 : DataTypeUtils.findTrueStartIndex(searchItem, data, index, comparator);
        return index;
    }

    private static int findTrueStartIndex(String searchItem, List<DataType> dataList, int startIndex, Comparator<Object> comparator) {
        if (startIndex < 0) {
            return startIndex;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (comparator.compare(dataList.get(i), searchItem) == 0) continue;
            return ++i;
        }
        return 0;
    }
}

