/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.tree.ArrayPointerFilterState;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.util.HTMLUtilities;
import ghidra.util.task.SwingUpdateManager;
import java.util.List;
import javax.swing.Icon;

public class ArchiveNode
extends CategoryNode {
    protected static final String DEFAULT_DATA_ORG_DESCRIPTION = "[Using Default Data Organization]";
    protected Archive archive;
    protected ArchiveNodeCategoryChangeListener listener;
    private DataTypeManager dataTypeManager;

    public ArchiveNode(Archive archive, ArrayPointerFilterState filterState) {
        this(archive, archive.getDataTypeManager() == null ? null : archive.getDataTypeManager().getRootCategory(), filterState);
        this.dataTypeManager = archive.getDataTypeManager();
        this.updateDataTypeManager();
    }

    protected ArchiveNode(Archive archive, Category rootCategory, ArrayPointerFilterState filterState) {
        super(rootCategory, filterState);
        this.archive = archive;
    }

    protected String buildTooltip(String path) {
        DataTypeManager dtm = this.archive.getDataTypeManager();
        if (dtm == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder("<HTML>");
        buf.append(HTMLUtilities.escapeHTML((String)path));
        buf.append("<BR>");
        String programArchSummary = dtm.getProgramArchitectureSummary();
        if (programArchSummary != null) {
            buf.append(HTMLUtilities.HTML_SPACE);
            buf.append(HTMLUtilities.HTML_SPACE);
            buf.append(HTMLUtilities.escapeHTML((String)programArchSummary));
            this.addArchiveWarnings(dtm, buf);
        } else {
            buf.append(DEFAULT_DATA_ORG_DESCRIPTION);
        }
        return buf.toString();
    }

    private void addArchiveWarnings(DataTypeManager dtm, StringBuilder buf) {
        if (dtm instanceof StandAloneDataTypeManager) {
            StandAloneDataTypeManager archiveDtm = (StandAloneDataTypeManager)dtm;
            if (archiveDtm.isProgramArchitectureMissing()) {
                buf.append("<BR>");
                buf.append("<font color=\"" + GThemeDefaults.Colors.Messages.ERROR + "\">** Missing Language/Compiler Specification **</font>");
            } else if (archiveDtm.isProgramArchitectureUpgradeRequired()) {
                buf.append("<BR>");
                buf.append("<font color=\"" + GThemeDefaults.Colors.Messages.WARNING + "\">** Language Upgrade Required **</font>");
            }
        }
    }

    protected void archiveStateChanged() {
        this.nodeChanged();
    }

    protected void dataTypeManagerChanged() {
        this.updateDataTypeManager();
        this.structureChanged();
        this.nodeChanged();
    }

    protected void installDataTypeManagerListener() {
        if (this.dataTypeManager == null) {
            return;
        }
        this.listener = new ArchiveNodeCategoryChangeListener();
        this.dataTypeManager.addDataTypeManagerListener((DataTypeManagerChangeListener)this.listener);
    }

    protected void updateDataTypeManager() {
        if (this.dataTypeManager == null) {
            return;
        }
        if (this.listener != null) {
            this.dataTypeManager.removeDataTypeManagerListener((DataTypeManagerChangeListener)this.listener);
            this.listener.dispose();
        }
        this.dataTypeManager = this.archive.getDataTypeManager();
        this.installDataTypeManagerListener();
        this.setCategory(this.dataTypeManager.getRootCategory());
    }

    public void dispose() {
        if (this.dataTypeManager != null) {
            this.dataTypeManager.removeDataTypeManagerListener((DataTypeManagerChangeListener)this.listener);
        }
        if (this.listener != null) {
            this.listener.dispose();
        }
        super.dispose();
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return this.archive.getIcon(expanded);
    }

    @Override
    public String getName() {
        return this.archive.getName();
    }

    @Override
    public String getToolTip() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public Archive getArchive() {
        return this.archive;
    }

    public void structureChanged() {
        this.setChildren(null);
    }

    public void nodeChanged() {
        this.fireNodeChanged();
        GTree tree = this.getTree();
        if (tree != null) {
            tree.repaint();
        }
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public boolean isCut() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ArchiveNode otherNode = (ArchiveNode)((Object)o);
        return this.getArchive().equals(otherNode.getArchive());
    }

    @Override
    public int compareTo(GTreeNode node) {
        if (node instanceof ArchiveNode) {
            return this.archive.compareTo(((ArchiveNode)node).archive);
        }
        return -1;
    }

    @Override
    public int hashCode() {
        return this.getArchive().hashCode();
    }

    @Override
    public ArchiveNode getArchiveNode() {
        return this;
    }

    @Override
    public boolean isModifiable() {
        return this.archive.isModifiable();
    }

    public CategoryNode findCategoryNode(Category localCategory) {
        return this.findCategoryNode(localCategory, false);
    }

    public CategoryNode findCategoryNode(Category localCategory, boolean loadChildren) {
        if (!loadChildren && !this.isLoaded()) {
            return null;
        }
        if (localCategory == null) {
            return null;
        }
        if (this.getCategory() == localCategory) {
            return this;
        }
        Category parentCategory = localCategory.getParent();
        if (this.getParent() == null) {
            return null;
        }
        CategoryNode node = this.findCategoryNode(parentCategory, loadChildren);
        if (node == null) {
            return null;
        }
        List children = node.getChildren();
        for (GTreeNode child : children) {
            CategoryNode categoryNode;
            if (!(child instanceof CategoryNode) || (categoryNode = (CategoryNode)child).getCategory() != localCategory) continue;
            return categoryNode;
        }
        return null;
    }

    private class ArchiveNodeCategoryChangeListener
    implements DataTypeManagerChangeListener {
        private SwingUpdateManager nodeChangedUpdater = new SwingUpdateManager(() -> ArchiveNode.this.nodeChanged());

        private ArchiveNodeCategoryChangeListener() {
        }

        public void categoryAdded(DataTypeManager dtm, CategoryPath path) {
            Category newCategory = dtm.getCategory(path);
            if (newCategory == null) {
                return;
            }
            Category category = newCategory.getParent();
            CategoryNode categoryNode = ArchiveNode.this.findCategoryNode(category);
            if (categoryNode != null) {
                categoryNode.categoryAdded(newCategory);
            }
        }

        void dispose() {
            this.nodeChangedUpdater.dispose();
        }

        public void categoryMoved(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            Category newCategory = dtm.getCategory(newPath);
            Category oldParent = dtm.getCategory(oldPath.getParent());
            CategoryNode categoryNode = ArchiveNode.this.findCategoryNode(oldParent);
            if (categoryNode != null) {
                categoryNode.categoryRemoved(oldPath.getName());
            }
            if ((categoryNode = ArchiveNode.this.findCategoryNode(newCategory.getParent())) != null) {
                categoryNode.categoryAdded(newCategory);
            }
        }

        public void categoryRemoved(DataTypeManager dtm, CategoryPath path) {
            Category parentCategory = dtm.getCategory(path.getParent());
            CategoryNode categoryNode = ArchiveNode.this.findCategoryNode(parentCategory);
            if (categoryNode != null) {
                categoryNode.categoryRemoved(path.getName());
            }
        }

        public void categoryRenamed(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            if (oldPath.getParent() == null) {
                ArchiveNode.this.fireNodeChanged();
                return;
            }
            Category parentCategory = dtm.getCategory(oldPath.getParent());
            CategoryNode categoryNode = ArchiveNode.this.findCategoryNode(parentCategory);
            if (categoryNode != null) {
                categoryNode.categoryRemoved(oldPath.getName());
                Category newCategory = dtm.getCategory(newPath);
                categoryNode.categoryAdded(newCategory);
            }
        }

        public void dataTypeAdded(DataTypeManager dtm, DataTypePath path) {
            DataType dataType;
            Category parentCategory = dtm.getCategory(path.getCategoryPath());
            CategoryNode categoryNode = ArchiveNode.this.findCategoryNode(parentCategory);
            if (categoryNode != null && (dataType = dtm.getDataType(path)) != null) {
                categoryNode.dataTypeAdded(dataType);
            }
        }

        public void favoritesChanged(DataTypeManager dtm, DataTypePath path, boolean isFavorite) {
            DataType dataType = dtm.getDataType(path);
            Category category = dtm.getCategory(path.getCategoryPath());
            CategoryNode categoryNode = ArchiveNode.this.findCategoryNode(category);
            if (categoryNode == null) {
                return;
            }
            List children = categoryNode.getChildren();
            for (GTreeNode node : children) {
                DataTypeNode dataTypeNode;
                if (!(node instanceof DataTypeNode) || (dataTypeNode = (DataTypeNode)node).getDataType() != dataType) continue;
                dataTypeNode.dataTypeStatusChanged();
                return;
            }
        }

        public void dataTypeChanged(DataTypeManager dtm, DataTypePath path) {
            DataType dataType;
            Category dtmCategory = dtm.getCategory(path.getCategoryPath());
            CategoryNode categoryNode = ArchiveNode.this.findCategoryNode(dtmCategory);
            if (categoryNode != null && (dataType = dtm.getDataType(path)) != null) {
                categoryNode.dataTypeChanged(dataType);
            }
        }

        public void dataTypeMoved(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            DataType dataType;
            Category newParent;
            Category oldParent = dtm.getCategory(oldPath.getCategoryPath());
            CategoryNode categoryNode = ArchiveNode.this.findCategoryNode(oldParent);
            if (categoryNode != null) {
                categoryNode.dataTypeRemoved(oldPath.getDataTypeName());
            }
            if ((categoryNode = ArchiveNode.this.findCategoryNode(newParent = dtm.getCategory(newPath.getCategoryPath()))) != null && (dataType = dtm.getDataType(newPath)) != null) {
                categoryNode.dataTypeAdded(dataType);
            }
        }

        public void dataTypeRemoved(DataTypeManager dtm, DataTypePath path) {
            Category oldParent = dtm.getCategory(path.getCategoryPath());
            CategoryNode categoryNode = ArchiveNode.this.findCategoryNode(oldParent);
            if (categoryNode != null) {
                categoryNode.dataTypeRemoved(path.getDataTypeName());
            }
        }

        public void dataTypeRenamed(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            Category dtmCategory = dtm.getCategory(newPath.getCategoryPath());
            CategoryNode categoryNode = ArchiveNode.this.findCategoryNode(dtmCategory);
            if (categoryNode != null) {
                categoryNode.dataTypeRemoved(oldPath.getDataTypeName());
                DataType dataType = dtm.getDataType(newPath);
                if (dataType != null) {
                    categoryNode.dataTypeAdded(dataType);
                }
            }
        }

        public void dataTypeReplaced(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
            this.dataTypeRemoved(dtm, oldPath);
        }

        public void sourceArchiveAdded(DataTypeManager manager, SourceArchive sourceArchive) {
        }

        public void sourceArchiveChanged(DataTypeManager manager, SourceArchive sourceArchive) {
            this.nodeChangedUpdater.update();
        }

        public void programArchitectureChanged(DataTypeManager manager) {
            ArchiveNode.this.unloadChildren();
            this.nodeChangedUpdater.update();
        }
    }
}

