/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.app.plugin.core.processors.SetLanguageDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.store.LockException;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import javax.swing.tree.TreePath;

public class SetArchiveArchitectureAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public SetArchiveArchitectureAction(DataTypeManagerPlugin plugin) {
        super("Set Archive Architecture", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Set Architecture..."}, null, "SetArch"));
        this.setDescription("Set program-architecture associated with a data type archive");
        this.setEnabled(true);
    }

    private TreePath getSelectionPath(ActionContext context) {
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return null;
        }
        return selectionPaths[0];
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        TreePath selectionPath = this.getSelectionPath(context);
        if (selectionPath == null) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPath.getLastPathComponent();
        if (!(node instanceof FileArchiveNode) && !(node instanceof ProjectArchiveNode)) {
            return false;
        }
        ArchiveNode archiveNode = (ArchiveNode)node;
        StandAloneDataTypeManager dtm = (StandAloneDataTypeManager)archiveNode.getArchive().getDataTypeManager();
        return dtm.isUpdatable();
    }

    public void actionPerformed(ActionContext context) {
        ProjectArchiveNode paNode;
        ProjectArchive pa;
        TreePath selectionPath = this.getSelectionPath(context);
        if (selectionPath == null) {
            return;
        }
        GTreeNode node = (GTreeNode)selectionPath.getLastPathComponent();
        if (!(node instanceof FileArchiveNode) && !(node instanceof ProjectArchiveNode)) {
            return;
        }
        if (node instanceof ProjectArchiveNode && !(pa = (ProjectArchive)(paNode = (ProjectArchiveNode)node).getArchive()).hasExclusiveAccess()) {
            Msg.showError((Object)((Object)this), null, (String)"Set Program Architecture Failed", (Object)"Setting program-architecture on Project Archive requires exclusive checkout.");
            return;
        }
        ArchiveNode archiveNode = (ArchiveNode)node;
        StandAloneDataTypeManager dtm = (StandAloneDataTypeManager)archiveNode.getArchive().getDataTypeManager();
        if (dtm.isChanged()) {
            if (1 != OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Save Archive Changes", (String)"Archive has unsaved changes which must be saved before continuing.\nThis is required to allow for a reversion to the previous saved state.", (String)"Save")) {
                return;
            }
            try {
                archiveNode.getArchive().save();
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), null, (String)"Save Archive Failed", (Object)("Failed to save changes for Archive: " + dtm.getName() + "\n" + e.getMessage()));
                return;
            }
        }
        SetLanguageDialog dialog = new SetLanguageDialog(this.plugin.getTool(), dtm.getProgramArchitecture(), "Select Program Architecture for Archive: " + dtm.getName());
        LanguageID languageId = dialog.getLanguageDescriptionID();
        CompilerSpecID compilerSpecId = dialog.getCompilerSpecDescriptionID();
        if (languageId == null || compilerSpecId == null) {
            return;
        }
        try {
            Language language = DefaultLanguageService.getLanguageService().getLanguage(languageId);
            StringBuilder buf = new StringBuilder();
            buf.append(languageId.getIdAsString());
            buf.append(" / ");
            buf.append(compilerSpecId.getIdAsString());
            String newProgramArchitectureSummary = buf.toString();
            String programArchitectureSummary = dtm.getProgramArchitectureSummary();
            String msg = "<html>Set program-architecture for Archive?<BR><font color=\"" + GThemeDefaults.Colors.Messages.NORMAL + "\">" + dtm.getPath() + "</font><pre>";
            msg = programArchitectureSummary != null ? msg + "\nChange Language/Compiler\n  from:  <font color=\"" + GThemeDefaults.Colors.Messages.NORMAL + "\">" + programArchitectureSummary + "</font>\n    to:  " : msg + "\n\nLanguage/Compiler: ";
            msg = msg + "<font color=\"" + GThemeDefaults.Colors.Messages.NORMAL + "\">";
            msg = msg + newProgramArchitectureSummary;
            msg = msg + "</font></pre>";
            int response = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Confirm Archive Architecture Change", (String)msg, (String)"Set Architecture", (int)2);
            if (response != 1) {
                return;
            }
            new TaskLauncher((Task)new SetProgramArchitectureTask(archiveNode.getArchive(), dtm, language, compilerSpecId));
        }
        catch (LanguageNotFoundException e) {
            Msg.showError((Object)((Object)this), null, (String)"Archive Update Failed", (Object)("Failed to set program-architecture for Archive: " + dtm.getName() + "\n" + e.getMessage()));
        }
    }

    private class SetProgramArchitectureTask
    extends Task {
        private final Archive archive;
        private final StandAloneDataTypeManager dtm;
        private final Language language;
        private final CompilerSpecID compilerSpecId;

        public SetProgramArchitectureTask(Archive archive, StandAloneDataTypeManager dtm, Language language, CompilerSpecID compilerSpecId) {
            super("Updating Program-Architecture for Archive", true, false, true, false);
            this.archive = archive;
            this.dtm = dtm;
            this.language = language;
            this.compilerSpecId = compilerSpecId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) throws CancelledException {
            boolean success = false;
            try {
                try {
                    this.dtm.setProgramArchitecture(this.language, this.compilerSpecId, StandAloneDataTypeManager.LanguageUpdateOption.TRANSLATE, monitor);
                    success = true;
                }
                catch (IncompatibleLanguageException e) {
                    int resp = OptionDialog.showOptionDialog(null, (String)"Archive Architecture Change", (String)("<html>Unable to translate storage for specified architecture change.<BR><font color=\"" + GThemeDefaults.Colors.Messages.NORMAL + "\">" + this.dtm.getPath() + "</font><BR><BR>Would you like to Clear custom storage information or Cancel change?"), (String)"Clear");
                    if (resp == 0) {
                        success = true;
                        if (!success) {
                            Swing.runNow(() -> {});
                            if (this.archive instanceof FileArchive) {
                                try {
                                    ((FileArchive)this.archive).releaseWriteLock();
                                    ((FileArchive)this.archive).acquireWriteLock();
                                }
                                catch (LockException | IOException e2) {
                                    this.archive.close();
                                }
                            } else {
                                this.archive.close();
                                DomainFile df = ((ProjectArchive)this.archive).getDomainFile();
                                SetArchiveArchitectureAction.this.plugin.openArchive(df);
                            }
                        }
                        return;
                    }
                    try {
                        StandAloneDataTypeManager.LanguageUpdateOption updateOption = StandAloneDataTypeManager.LanguageUpdateOption.CLEAR;
                        if (resp == 2) {
                            updateOption = StandAloneDataTypeManager.LanguageUpdateOption.UNCHANGED;
                        }
                        this.dtm.setProgramArchitecture(this.language, this.compilerSpecId, updateOption, monitor);
                        success = true;
                    }
                    catch (CancelledException e3) {
                        throw e3;
                    }
                    catch (Exception e4) {
                        Msg.showError((Object)((Object)this), null, (String)"Archive Update Failed", (Object)("Failed to set program-architecture for Archive: " + this.dtm.getName() + "\n" + e4.getMessage()));
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (!success) {
                    Swing.runNow(() -> {});
                    if (this.archive instanceof FileArchive) {
                        try {
                            ((FileArchive)this.archive).releaseWriteLock();
                            ((FileArchive)this.archive).acquireWriteLock();
                        }
                        catch (LockException | IOException e) {
                            this.archive.close();
                        }
                    } else {
                        this.archive.close();
                        DomainFile df = ((ProjectArchive)this.archive).getDomainFile();
                        SetArchiveArchitectureAction.this.plugin.openArchive(df);
                    }
                }
            }
        }
    }
}

