/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.tree.TreePath;

public class CreateEnumFromSelectionAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public CreateEnumFromSelectionAction(DataTypeManagerPlugin plugin) {
        super("Enum From Selection", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Create Enum From Selection"}, null, "Edit"));
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "CreateEnumFromSelection"));
        this.setEnabled(true);
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        GTree gtree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length <= 1) {
            return false;
        }
        return !this.containsInvalidNodes(selectionPaths);
    }

    public void actionPerformed(ActionContext context) {
        ProgramBasedDataTypeManager dtm = this.plugin.getProgram().getDataTypeManager();
        Category category = dtm.getRootCategory();
        String newName = this.getEnumName(category);
        if (newName == null) {
            return;
        }
        List<Enum> enums = this.getSelectedEnums(context);
        this.createMergedEnum(category, enums, newName);
        this.selectNewEnum((GTree)context.getContextObject(), dtm.getName(), newName);
    }

    private void selectNewEnum(GTree gTree, String parentName, String name) {
        Swing.runLater(() -> {
            GTreeNode rootNode = gTree.getViewRoot();
            gTree.setSelectedNodeByNamePath(new String[]{rootNode.getName(), parentName, name});
        });
    }

    private List<Enum> getSelectedEnums(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] paths = gTree.getSelectionPaths();
        ArrayList<Enum> enums = new ArrayList<Enum>();
        for (TreePath path : paths) {
            DataTypeNode dtNode = (DataTypeNode)((Object)path.getLastPathComponent());
            enums.add((Enum)dtNode.getDataType());
        }
        return enums;
    }

    private String getEnumName(Category category) {
        ProgramBasedDataTypeManager dtm = this.plugin.getProgram().getDataTypeManager();
        PluginTool tool = this.plugin.getTool();
        CategoryPath categoryPath = category.getCategoryPath();
        InputDialog inputDialog = new InputDialog("Enter Enum Name", "Please enter a name for the new Enum: ");
        tool.showDialog((DialogComponentProvider)inputDialog);
        if (inputDialog.isCanceled()) {
            return null;
        }
        String newName = inputDialog.getValue();
        DataType dt = dtm.getDataType(categoryPath, newName);
        while (dt != null) {
            InputDialog dialog = new InputDialog("Duplicate Enum Name", "Please enter a unique name for the new Enum: ");
            tool.showDialog((DialogComponentProvider)dialog);
            if (dialog.isCanceled()) {
                return null;
            }
            newName = dialog.getValue();
            dt = dtm.getDataType(categoryPath, newName);
        }
        return newName;
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        GTree gtree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length <= 1) {
            return false;
        }
        return !this.containsInvalidNodes(selectionPaths);
    }

    private boolean containsInvalidNodes(TreePath[] selectionPaths) {
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (!(node instanceof DataTypeNode)) {
                return true;
            }
            DataTypeNode dataTypeNode = (DataTypeNode)node;
            DataType dataType = dataTypeNode.getDataType();
            if (dataType instanceof Enum) continue;
            return true;
        }
        return false;
    }

    private void createMergedEnum(Category category, List<Enum> enumsToMerge, String enumName) {
        int maxEnumSize = this.computeNewEnumSize(enumsToMerge);
        DataTypeManager dtm = category.getDataTypeManager();
        SourceArchive sourceArchive = dtm.getLocalSourceArchive();
        EnumDataType baseEnum = new EnumDataType(category.getCategoryPath(), enumName, maxEnumSize, dtm);
        baseEnum.setSourceArchive(sourceArchive);
        for (Enum enumToMerge : enumsToMerge) {
            this.mergeEnum((Enum)baseEnum, enumToMerge);
        }
        this.addEnumDataType(category, (Enum)baseEnum);
        dtm.flushEvents();
    }

    private void mergeEnum(Enum baseEnum, Enum enumToMerge) {
        boolean hasConflict = false;
        for (String name : enumToMerge.getNames()) {
            if (this.isDuplicateEntry(baseEnum, enumToMerge, name)) continue;
            long value = enumToMerge.getValue(name);
            String comment = "";
            if (this.isConflictingEntry(baseEnum, enumToMerge, name)) {
                name = this.getUniqueName(baseEnum, name);
                comment = "NOTE: Duplicate name with different value";
                hasConflict = true;
            }
            baseEnum.add(name, value, comment);
        }
        if (hasConflict) {
            Msg.showWarn((Object)((Object)this), null, (String)"Duplicate Entry Name(s)", (Object)("Merged Enum " + baseEnum.getName() + " has one or more entries with duplicate names.\nUnderscore(s) have been appended to make them unique."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEnumDataType(Category category, Enum mergedEnum) {
        DataTypeManager dtm = category.getDataTypeManager();
        int id = dtm.startTransaction("Create New Enum Data Type");
        try {
            dtm.addDataType((DataType)mergedEnum, DataTypeConflictHandler.REPLACE_HANDLER);
        }
        finally {
            dtm.endTransaction(id, true);
        }
    }

    private String getUniqueName(Enum baseEnum, String name) {
        List<String> existingNames = Arrays.asList(baseEnum.getNames());
        while (existingNames.contains(name)) {
            name = (String)name + "_";
        }
        return name;
    }

    private boolean isDuplicateEntry(Enum baseEnum, Enum enumToMerge, String name) {
        List<String> existingNames = Arrays.asList(baseEnum.getNames());
        if (!existingNames.contains(name)) {
            return false;
        }
        long existingValue = baseEnum.getValue(name);
        long newValue = enumToMerge.getValue(name);
        return newValue == existingValue;
    }

    private boolean isConflictingEntry(Enum mergedEnum, Enum enumToMerge, String name) {
        long existingValue;
        List<String> existingNames = Arrays.asList(mergedEnum.getNames());
        if (!existingNames.contains(name)) {
            return false;
        }
        long valueToAdd = enumToMerge.getValue(name);
        return valueToAdd != (existingValue = mergedEnum.getValue(name));
    }

    private int computeNewEnumSize(List<Enum> enums) {
        int max = 1;
        for (Enum element : enums) {
            max = Math.max(max, element.getLength());
        }
        return max;
    }
}

