/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.cparser;

import docking.widgets.dialogs.MultiLineMessageDialog;
import ghidra.app.plugin.core.cparser.CParserPlugin;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import javax.swing.SwingUtilities;

class CParserTask
extends Task {
    private CParserPlugin plugin;
    private String dataFileName;
    private String[] filenames;
    private String[] includePaths;
    private String options;
    private String languageString;
    private String compilerString;
    private DataTypeManager dtMgr;

    CParserTask(CParserPlugin plugin, String dataFileName) {
        super("Parsing C Files", true, false, false);
        this.plugin = plugin;
        this.dataFileName = dataFileName;
    }

    public CParserTask(CParserPlugin plugin, DataTypeManager dataTypeManager) {
        super("Parsing C Files", true, false, false);
        this.plugin = plugin;
        this.dtMgr = dataTypeManager;
    }

    public CParserTask(CParserPlugin plugin, ProgramBasedDataTypeManager dataTypeManager) {
        super("Parsing C Files", true, false, false);
        this.plugin = plugin;
        this.dtMgr = dataTypeManager;
    }

    public CParserTask setLanguageID(String languageID) {
        this.languageString = languageID;
        return this;
    }

    public CParserTask setCompilerID(String compilerID) {
        this.compilerString = compilerID;
        return this;
    }

    public CParserTask setIncludePaths(String[] includePaths) {
        this.includePaths = (String[])includePaths.clone();
        return this;
    }

    public CParserTask setFileNames(String[] names) {
        this.filenames = (String[])names.clone();
        return this;
    }

    public CParserTask setOptions(String options) {
        this.options = options;
        return this;
    }

    private String getFirstMessageLine(String errMsg) {
        int indexOf = errMsg.indexOf(10);
        String msg = errMsg;
        if (indexOf > 0) {
            msg = msg.substring(0, indexOf);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        block20: {
            try (DataTypeManager fileDtMgr = null;){
                if (this.dtMgr == null) {
                    File file = new File(this.dataFileName);
                    fileDtMgr = this.dtMgr = FileDataTypeManager.createFileArchive((File)file);
                }
                this.plugin.parse(this.filenames, this.includePaths, this.options, this.languageString, this.compilerString, this.dtMgr, monitor);
                if (this.dataFileName == null) break block20;
                if (this.dtMgr.getDataTypeCount(true) != 0) {
                    try {
                        ((FileDataTypeManager)this.dtMgr).save();
                        this.dtMgr.close();
                        break block20;
                    }
                    catch (DuplicateFileException e) {
                        Msg.showError((Object)((Object)this), (Component)this.plugin.getDialog().getComponent(), (String)"Error During Save", (Object)e.getMessage());
                        break block20;
                    }
                    catch (Exception e) {
                        Msg.showError((Object)((Object)this), (Component)this.plugin.getDialog().getComponent(), (String)"Error During Save", (Object)("Could not save to file " + this.dataFileName), (Throwable)e);
                        break block20;
                    }
                    finally {
                        if (this.dtMgr instanceof FileDataTypeManager) {
                            this.dtMgr.close();
                        }
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CParserTask.this.plugin.getParseResults() == null) {
                            return;
                        }
                        MultiLineMessageDialog.showModalMessageDialog((Component)CParserTask.this.plugin.getDialog().getComponent(), (String)"Parse Errors", (String)("File was not created due to parse errors: " + ((FileDataTypeManager)CParserTask.this.dtMgr).getFilename()), (String)CParserTask.this.plugin.getFormattedParseMessage(null), (int)1);
                    }
                });
            }
        }
    }
}

