/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.widgets.dialogs.NumberInputDialog;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class DuplicateMultipleAction
extends CompositeEditorTableAction {
    private static final Icon ICON = new GIcon("icon.plugin.composite.editor.duplicate.multiple");
    public static final String ACTION_NAME = "Duplicate Multiple of Component";
    private static final String GROUP_NAME = "3_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Duplicate multiple of the selected component";
    private static final String[] POPUP_PATH = new String[]{"Duplicate Multiple of Component"};
    private KeyStroke keyStroke = KeyStroke.getKeyStroke(77, 512);

    public DuplicateMultipleAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Duplicate Multiple of Component", GROUP_NAME, POPUP_PATH, null, ICON);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(this.keyStroke));
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        int[] indices = this.model.getSelectedComponentRows();
        if (indices.length != 1) {
            return;
        }
        int row = indices[0];
        int min = 1;
        int max = this.model.getMaxDuplicates(row);
        if (max == 0) {
            return;
        }
        int initial = this.model.getLastNumDuplicates();
        NumberInputDialog numberInputDialog = new NumberInputDialog("duplicates", initial > 0 ? initial : 1, min, max);
        String helpAnchor = this.provider.getHelpName() + "_Duplicates_NumberInputDialog";
        HelpLocation helpLoc = new HelpLocation(this.provider.getHelpTopic(), helpAnchor);
        numberInputDialog.setHelpLocation(helpLoc);
        if (numberInputDialog.show()) {
            int count = numberInputDialog.getValue();
            TaskLauncher.launchModal((String)"Duplicating Component", monitor -> this.doInsert(row, count, monitor));
        }
        this.requestTableFocus();
    }

    private void doInsert(int row, int count, TaskMonitor monitor) {
        try {
            this.model.duplicateMultiple(row, count, monitor);
        }
        catch (CancelledException cancelledException) {
        }
        catch (UsrException e) {
            this.model.setStatus(e.getMessage(), true);
        }
        this.model.fireTableDataChanged();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.model.isDuplicateAllowed());
    }
}

