/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.widgets.dialogs.NumberInputDialog;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModelListener;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerDataTypeManager;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerModel;
import ghidra.app.plugin.core.compositeeditor.DataTypeHelper;
import ghidra.app.plugin.core.compositeeditor.EditorModel;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CycleGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.MissingBuiltInDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.UsrException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public abstract class CompositeEditorModel
extends CompositeViewerModel
implements EditorModel {
    protected boolean applyingFieldEdit = false;
    protected boolean stillBeginningEdit = false;
    protected boolean validName = true;
    protected String currentName = "";
    protected boolean editingField = false;
    protected boolean settingValueAt = false;
    protected int lastNumDuplicates = 1;
    protected int lastNumElements = 1;
    protected int lastNumBytes = 1;
    protected boolean hadChanges = false;
    protected boolean originalIsChanging = false;
    protected ArrayList<CompositeEditorModelListener> listeners = new ArrayList(1);

    public CompositeEditorModel(CompositeEditorProvider provider) {
        super(provider);
    }

    @Override
    public void load(Composite dataType) {
        if (dataType == null) {
            return;
        }
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        if (dataTypeManager == null) {
            throw new IllegalArgumentException("Datatype " + dataType.getName() + " doesn't have a data type manager specified.");
        }
        long lastCompositeId = this.originalCompositeId;
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        if (this.isLoaded()) {
            this.unload();
        }
        this.originalComposite = dataType;
        this.originalDataTypePath = this.originalComposite.getDataTypePath();
        this.currentName = dataType.getName();
        DataTypeManager originalDTM = dataTypeManager;
        this.viewComposite = this.createViewCompositeFromOriginalComposite(this.originalComposite);
        this.viewDTM = this.viewComposite.getDataTypeManager();
        this.originalCompositeId = -1L;
        if (originalDTM.contains((DataType)dataType)) {
            this.originalCompositeId = originalDTM.getID((DataType)dataType);
        }
        originalDTM.addDataTypeManagerListener((DataTypeManagerChangeListener)this);
        this.hadChanges = false;
        if (this.originalCompositeId == -1L || lastCompositeId != this.originalCompositeId) {
            this.setSelection(new FieldSelection());
        }
        this.clearStatus();
        this.compositeInfoChanged();
        this.fireTableDataChanged();
        this.componentDataChanged();
        this.editorStateChanged(3);
    }

    protected Composite createViewCompositeFromOriginalComposite(Composite original) {
        CompositeViewerDataTypeManager dtm = new CompositeViewerDataTypeManager(original.getDataTypeManager().getName(), original);
        Composite composite = (Composite)dtm.resolve((DataType)original, null);
        this.cloneAllComponentSettings(original, composite);
        dtm.addDataTypeManagerListener(this);
        return composite;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public CompositeEditorProvider getProvider() {
        return this.provider;
    }

    @Override
    public void addCompositeEditorModelListener(CompositeEditorModelListener listener) {
        this.listeners.add(listener);
        super.addCompositeViewerModelListener(listener);
    }

    @Override
    public void removeCompositeEditorModelListener(CompositeEditorModelListener listener) {
        this.listeners.remove(listener);
        super.removeCompositeViewerModelListener(listener);
    }

    @Override
    public DataType resolve(DataType dt) {
        return this.viewDTM.resolve(dt, null);
    }

    protected DataTypeInstance getDropDataType(int rowIndex, DataType dt) throws InvalidDataTypeException, CancelledException {
        FieldRange range = this.getSelectedRangeContaining(rowIndex);
        if (range != null) {
            rowIndex = range.getStart().getIndex().intValue();
        }
        DataType currentDt = null;
        DataTypeComponent dtc = this.getComponent(rowIndex);
        if (dtc != null) {
            currentDt = dtc.getDataType();
        }
        if (!(currentDt instanceof Pointer)) {
            this.checkIsAllowableDataType(dt);
        }
        DataType resultDt = DataUtilities.reconcileAppliedDataType((DataType)currentDt, (DataType)dt, (boolean)true);
        int resultLen = resultDt.getAlignedLength();
        if (resultDt instanceof Dynamic) {
            resultLen = DataTypeHelper.requestDtSize(this.getProvider(), resultDt.getDisplayName(), this.lastNumBytes, this.getMaxAddLength(rowIndex));
        } else if (resultLen == 0) {
            throw new InvalidDataTypeException("Data types of size 0 are not allowed.");
        }
        return DataTypeInstance.getDataTypeInstance((DataType)resultDt, (int)resultLen, (boolean)true);
    }

    @Override
    public void endFieldEditing() {
        if (!this.isEditingField()) {
            return;
        }
        for (CompositeEditorModelListener listener : this.listeners) {
            listener.endFieldEditing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int modelColumnIndex) {
        try {
            this.settingValueAt = true;
            this.fieldEdited(aValue, rowIndex, modelColumnIndex);
        }
        finally {
            this.settingValueAt = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fieldEdited(Object value, int rowIndex, int columnIndex) {
        if (this.applyingFieldEdit) {
            return true;
        }
        try {
            this.applyingFieldEdit = true;
            if (columnIndex == this.getDataTypeColumn()) {
                this.setComponentDataType(rowIndex, value);
            } else if (columnIndex == this.getNameColumn()) {
                this.setComponentName(rowIndex, ((String)value).trim());
            } else if (columnIndex == this.getCommentColumn()) {
                this.setComponentComment(rowIndex, (String)value);
            } else {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (UsrException e) {
            this.setStatus(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.updateAndCheckChangeState();
            this.applyingFieldEdit = false;
        }
    }

    protected void editorStateChanged(int type) {
        for (CompositeEditorModelListener listener : this.listeners) {
            listener.compositeEditStateChanged(type);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setName(String name) throws DuplicateNameException, InvalidNameException {
        if (name.equals(this.currentName)) {
            return;
        }
        this.currentName = name;
        boolean nameModified = !this.currentName.equals(this.getOriginalDataTypeName());
        this.updateAndCheckChangeState();
        int type = nameModified ? 1 : 2;
        this.editorStateChanged(type);
        if (this.viewComposite != null) {
            this.validName = false;
            this.viewComposite.setName(name);
            this.checkName(name);
            this.validName = true;
        }
    }

    @Override
    public String getCompositeName() {
        return this.currentName;
    }

    @Override
    public void setDescription(String desc) {
        boolean descriptionModified;
        Composite original = this.getOriginalComposite();
        boolean bl = descriptionModified = original != null && !desc.equals(original.getDescription());
        if (this.viewComposite != null && !desc.equals(this.viewComposite.getDescription())) {
            this.viewComposite.setDescription(desc);
        }
        this.updateAndCheckChangeState();
        int type = descriptionModified ? 1 : 2;
        this.editorStateChanged(type);
    }

    @Override
    public void setComponentDataType(int rowIndex, Object dataTypeObject) throws UsrException {
        DataType previousDt = null;
        int previousLength = 0;
        String dtName = "";
        DataTypeComponent element = this.getComponent(rowIndex);
        if (element != null) {
            previousDt = element.getDataType();
            previousLength = element.getLength();
            dtName = previousDt.getDisplayName();
        }
        DataType newDt = null;
        int newLength = -1;
        if (dataTypeObject instanceof DataTypeInstance) {
            DataTypeInstance dti = (DataTypeInstance)dataTypeObject;
            newDt = dti.getDataType();
            newLength = dti.getLength();
        } else if (dataTypeObject instanceof DataType) {
            newDt = (DataType)dataTypeObject;
            newLength = newDt.getLength();
        } else if (dataTypeObject instanceof String) {
            String dtString = (String)dataTypeObject;
            if (dtString.equals(dtName)) {
                return;
            }
            DataTypeManager originalDTM = this.getOriginalDataTypeManager();
            newDt = DataTypeHelper.parseDataType(rowIndex, dtString, this, originalDTM, this.provider.dtmService);
            newLength = newDt.getLength();
        }
        if (newDt == null) {
            return;
        }
        if (DataTypeComponent.usesZeroLengthComponent((DataType)newDt)) {
            newLength = 0;
        }
        this.checkIsAllowableDataType(newDt);
        newDt = this.resolveDataType(newDt, this.viewDTM, DataTypeConflictHandler.DEFAULT_HANDLER);
        if (newLength < 0) {
            int suggestedLength = previousLength <= 0 ? this.lastNumBytes : previousLength;
            DataTypeInstance sizedDataType = DataTypeHelper.getSizedDataType(this.provider, newDt, suggestedLength, this.getMaxReplaceLength(rowIndex));
            if (sizedDataType == null) {
                return;
            }
            newDt = this.resolveDataType(sizedDataType.getDataType(), this.viewDTM, DataTypeConflictHandler.DEFAULT_HANDLER);
            newLength = sizedDataType.getLength();
            if (newLength <= 0) {
                throw new UsrException("Can't currently add this data type.");
            }
        }
        if (previousDt != null && newDt.isEquivalent(previousDt) && newLength == previousLength) {
            return;
        }
        int maxLength = this.getMaxReplaceLength(rowIndex);
        if (maxLength > 0 && newLength > maxLength) {
            throw new UsrException(newDt.getDisplayName() + " doesn't fit within " + maxLength + " bytes, need " + newLength + " bytes");
        }
        this.setComponentDataTypeInstance(rowIndex, newDt, newLength);
        this.notifyCompositeChanged();
    }

    public DataType resolveDataType(DataType dt, DataTypeManager resolveDtm, DataTypeConflictHandler conflictHandler) {
        return resolveDtm.resolve(dt, conflictHandler);
    }

    protected void clearComponents(int[] rows) throws UsrException {
        for (int i = rows.length - 1; i >= 0; --i) {
            this.clearComponent(rows[i]);
        }
        this.notifyCompositeChanged();
    }

    protected void deleteComponents(int[] rows) {
        for (int i = rows.length - 1; i >= 0; --i) {
            this.deleteComponent(rows[i]);
        }
        this.notifyCompositeChanged();
    }

    protected abstract void deleteComponent(int var1);

    @Override
    public void createArray() throws UsrException {
        if (!this.isArrayAllowed()) {
            throw new UsrException("Array not permitted in current context");
        }
        int min = 1;
        int max = this.getMaxElements();
        if (this.isSingleRowSelection()) {
            if (max != 0) {
                int initial = this.getLastNumElements();
                NumberInputDialog numberInputDialog = new NumberInputDialog("elements", initial > 0 ? initial : 1, min, max);
                String helpAnchor = this.provider.getHelpName() + "_Elements_NumberInputDialog";
                HelpLocation helpLoc = new HelpLocation(this.provider.getHelpTopic(), helpAnchor);
                numberInputDialog.setHelpLocation(helpLoc);
                if (numberInputDialog.show()) {
                    int numOfElements = numberInputDialog.getValue();
                    try {
                        this.createArray(numOfElements);
                    }
                    catch (Exception e1) {
                        this.setStatus(e1.getMessage(), true);
                    }
                }
            }
        } else if (this.isContiguousComponentSelection() && max > 1) {
            try {
                this.createArray(max);
            }
            catch (Exception e1) {
                this.setStatus(e1.getMessage(), true);
            }
        }
    }

    protected void createArray(int numElements) throws InvalidDataTypeException, UsrException {
        DataTypeComponent comp;
        DataType dt;
        if (this.selection.getNumRanges() != 1) {
            throw new UsrException("Can only create arrays on a contiguous selection.");
        }
        int currentIndex = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        if (currentIndex >= this.getNumComponents()) {
            throw new UsrException("A component must be selected.");
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        int len = (dt = (comp = this.getComponent(currentIndex)).getDataType()).getLength() > 0 ? dt.getLength() : comp.getLength();
        ArrayDataType array = new ArrayDataType(dt, numElements, len, this.viewDTM);
        this.replace(currentIndex, (DataType)array, array.getLength());
    }

    @Override
    public void clearSelectedComponents() throws UsrException {
        if (!this.isClearAllowed()) {
            throw new UsrException("Clearing is not allowed.");
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        this.clearComponents(this.getSelectedComponentRows());
    }

    @Override
    public void deleteSelectedComponents() throws UsrException {
        if (!this.isDeleteAllowed()) {
            throw new UsrException("Deleting is not allowed.");
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        this.deleteComponents(this.getSelectedComponentRows());
        this.selection.clear();
    }

    public boolean isValidName() {
        return this.validName;
    }

    @Override
    public boolean hasChanges() {
        return this.hadChanges;
    }

    public boolean updateAndCheckChangeState() {
        String oldDesc;
        if (this.originalIsChanging) {
            return false;
        }
        Composite oldComposite = this.getOriginalComposite();
        String oldName = this.getOriginalDataTypeName();
        String newDesc = this.viewComposite.getDescription();
        if (newDesc == null) {
            newDesc = "";
        }
        String string = oldDesc = oldComposite != null ? oldComposite.getDescription() : "";
        if (oldDesc == null) {
            oldDesc = "";
        }
        boolean noCompChanges = false;
        noCompChanges = oldComposite != null ? this.viewComposite.isEquivalent((DataType)oldComposite) && this.hasSameComponentSettings(this.viewComposite, oldComposite) && !this.hasCompPathNameChanges(this.viewComposite, oldComposite) : this.getNumComponents() == 0;
        this.hadChanges = !this.currentName.equals(oldName) || !newDesc.equals(oldDesc) || !noCompChanges;
        return this.hadChanges;
    }

    private boolean hasSameComponentSettings(Composite currentViewComposite, Composite oldComposite) {
        DataTypeComponent[] oldComps;
        DataTypeComponent[] viewComps = currentViewComposite.getDefinedComponents();
        if (viewComps.length != (oldComps = oldComposite.getDefinedComponents()).length) {
            return false;
        }
        for (int i = 0; i < viewComps.length; ++i) {
            if (this.hasSameSettings(viewComps[i], oldComps[i])) continue;
            return false;
        }
        return true;
    }

    private boolean hasSameSettings(DataTypeComponent viewDtc, DataTypeComponent oldDtc) {
        Object[] oldSettingsNames;
        Settings viewDtcSettings = viewDtc.getDefaultSettings();
        Settings oldDtcSettings = oldDtc.getDefaultSettings();
        Object[] viewSettingsNames = viewDtcSettings.getNames();
        if (viewSettingsNames.length != (oldSettingsNames = oldDtcSettings.getNames()).length) {
            return false;
        }
        Arrays.sort(viewSettingsNames);
        Arrays.sort(oldSettingsNames);
        if (!Arrays.equals(viewSettingsNames, oldSettingsNames)) {
            return false;
        }
        for (Object name : viewSettingsNames) {
            if (Objects.equals(viewDtcSettings.getValue((String)name), oldDtcSettings.getValue((String)name))) continue;
            return false;
        }
        return true;
    }

    private void cloneAllComponentSettings(Composite sourceComposite, Composite destComposite) {
        DataTypeComponent[] sourceComps = sourceComposite.getDefinedComponents();
        DataTypeComponent[] destComps = destComposite.getDefinedComponents();
        assert (sourceComps.length == destComps.length);
        for (int i = 0; i < sourceComps.length; ++i) {
            Settings sourceDtcSettings = sourceComps[i].getDefaultSettings();
            Settings destDtcSettings = destComps[i].getDefaultSettings();
            destDtcSettings.clearAllSettings();
            for (String name : sourceDtcSettings.getNames()) {
                destDtcSettings.setValue(name, sourceDtcSettings.getValue(name));
            }
        }
    }

    protected void updateOriginalComponentSettings(Composite sourceComposite, Composite destComposite) {
        DataTypeComponent[] sourceComps = sourceComposite.getDefinedComponents();
        DataTypeComponent[] destComps = destComposite.getDefinedComponents();
        assert (sourceComps.length == destComps.length);
        for (int i = 0; i < sourceComps.length; ++i) {
            if (this.hasSameSettings(sourceComps[i], destComps[i])) continue;
            Settings sourceDtcSettings = sourceComps[i].getDefaultSettings();
            Settings destDtcSettings = destComps[i].getDefaultSettings();
            destDtcSettings.clearAllSettings();
            for (String name : sourceDtcSettings.getNames()) {
                destDtcSettings.setValue(name, sourceDtcSettings.getValue(name));
            }
        }
    }

    private boolean hasCompPathNameChanges(Composite currentViewComposite, Composite oldComposite) {
        DataTypeComponent[] oldComps;
        DataTypeComponent[] comps = currentViewComposite.getDefinedComponents();
        if (comps.length != (oldComps = oldComposite.getDefinedComponents()).length) {
            return true;
        }
        for (int i = 0; i < comps.length; ++i) {
            String oldDtPathName;
            String dtPathName = comps[i].getDataType().getPathName();
            if (dtPathName.equals(oldDtPathName = oldComps[i].getDataType().getPathName())) continue;
            return true;
        }
        return false;
    }

    protected void notifyCompositeChanged() {
        this.updateAndCheckChangeState();
        this.fireTableDataChanged();
        this.compositeInfoChanged();
        this.componentDataChanged();
    }

    @Override
    public void fireTableDataChanged() {
        this.swing(() -> super.fireTableDataChanged());
    }

    @Override
    public boolean beginEditingField(int rowIndex, int columnIndex) {
        if (this.isEditingField()) {
            return false;
        }
        try {
            this.stillBeginningEdit = true;
            this.editingField = true;
            this.setLocation(rowIndex, columnIndex);
            this.setSelection(new int[]{rowIndex});
            this.notifyEditingChanged();
        }
        finally {
            this.stillBeginningEdit = false;
        }
        return true;
    }

    @Override
    public boolean endEditingField() {
        if (!this.isEditingField()) {
            return false;
        }
        this.editingField = false;
        this.notifyEditingChanged();
        return true;
    }

    @Override
    public boolean isEditingField() {
        return !this.settingValueAt && this.editingField;
    }

    @Override
    public int getFirstEditableColumn(int rowIndex) {
        int numFields = this.getColumnCount();
        for (int i = 0; i < numFields; ++i) {
            if (!this.isCellEditable(rowIndex, i)) continue;
            return i;
        }
        return -1;
    }

    private void notifyEditingChanged() {
        for (CompositeEditorModelListener listener : this.listeners) {
            listener.compositeEditStateChanged(this.isEditingField() ? 5 : 6);
        }
    }

    @Override
    public void cycleDataType(CycleGroup cycleGroup) {
        if (this.getNumSelectedRows() != 1) {
            this.setStatus("Can only cycle when a single row is selected.", true);
            return;
        }
        try {
            int currentIndex = this.getMinIndexSelected();
            DataType dt = this.getNextCycleDataType(cycleGroup);
            if (dt != null) {
                DataTypeInstance dti = DataTypeHelper.getFixedLength(this, currentIndex, dt);
                if (dti == null) {
                    return;
                }
                this.replace(currentIndex, dti.getDataType(), dti.getLength());
                this.setSelection(new int[]{currentIndex});
            } else {
                this.setStatus("No new data type in the cycle group fits.", true);
            }
        }
        catch (UsrException e1) {
            this.setStatus(e1.getMessage(), true);
        }
    }

    protected DataType getNextCycleDataType(CycleGroup cycleGroup) throws UsrException {
        if (this.getNumSelectedRows() != 1) {
            throw new UsrException("Single row selection needed to cycle data types.");
        }
        DataType startDataType = null;
        DataType dataType = null;
        int currentIndex = this.getMinIndexSelected();
        DataTypeComponent dtc = this.getComponent(currentIndex);
        if (dtc == null) {
            return cycleGroup.getNextDataType(null, true);
        }
        dataType = startDataType = dtc.getDataType();
        int cnt = cycleGroup.size();
        do {
            if ((dataType = cycleGroup.getNextDataType(dataType, true)) == null || dataType.isEquivalent(startDataType)) {
                return null;
            }
            if (!this.isReplaceAllowed(currentIndex, dataType)) continue;
            return dataType;
        } while (--cnt > 0);
        return null;
    }

    protected boolean nameExistsElsewhere(String name, int rowIndex) {
        if (name != null) {
            int i;
            if ((name = name.trim()).length() == 0) {
                return false;
            }
            int numComponents = this.getNumComponents();
            for (i = 0; i < rowIndex && i < numComponents; ++i) {
                if (!name.equals(this.getComponent(i).getFieldName())) continue;
                return true;
            }
            for (i = rowIndex + 1; i < numComponents; ++i) {
                if (!name.equals(this.getComponent(i).getFieldName())) continue;
                return true;
            }
        }
        return false;
    }

    protected void checkIsAllowableDataType(DataType datatype) throws InvalidDataTypeException {
        if (!this.allowsZeroLengthComponents() && DataTypeComponent.usesZeroLengthComponent((DataType)datatype)) {
            throw new InvalidDataTypeException("Zero-length datatype not permitted: " + datatype.getName());
        }
        if (!this.allowsBitFields() && datatype instanceof BitFieldDataType) {
            throw new InvalidDataTypeException("Bitfield not permitted: " + datatype.getName());
        }
        if (datatype instanceof TypeDef) {
            datatype = ((TypeDef)datatype).getBaseDataType();
        }
        if (datatype instanceof FactoryDataType) {
            throw new InvalidDataTypeException("Factory data types are not allowed in a composite data type.");
        }
        if (datatype instanceof Dynamic && !((Dynamic)datatype).canSpecifyLength()) {
            throw new InvalidDataTypeException("Non-sizable Dynamic data types are not allowed in a composite data type.");
        }
    }

    protected boolean allowsZeroLengthComponents() {
        return true;
    }

    protected boolean allowsBitFields() {
        return true;
    }

    @Override
    public boolean isAddAllowed(int currentIndex, DataType datatype) {
        return false;
    }

    @Override
    public boolean isArrayAllowed() {
        return false;
    }

    @Override
    public boolean isClearAllowed() {
        return false;
    }

    @Override
    public boolean isCycleAllowed(CycleGroup cycleGroup) {
        return false;
    }

    @Override
    public boolean isDeleteAllowed() {
        return false;
    }

    @Override
    public boolean isDuplicateAllowed() {
        return false;
    }

    @Override
    public boolean isEditComponentAllowed() {
        if (this.getNumSelectedComponentRows() != 1) {
            return false;
        }
        int currentIndex = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        DataTypeComponent comp = this.getComponent(currentIndex);
        DataType baseDt = null;
        if (comp != null) {
            baseDt = comp.getDataType();
            baseDt = DataTypeUtils.getBaseDataType(baseDt);
        }
        return baseDt != null && !(baseDt instanceof BuiltInDataType) && !(baseDt instanceof MissingBuiltInDataType) && (baseDt instanceof Structure || baseDt instanceof Union || baseDt instanceof Enum);
    }

    @Override
    public boolean isEditFieldAllowed(int rowIndex, int columnIndex) {
        return !this.isEditingField();
    }

    @Override
    public boolean isInsertAllowed(int rowIndex, DataType datatype) {
        return false;
    }

    @Override
    public boolean isMoveDownAllowed() {
        return false;
    }

    @Override
    public boolean isMoveUpAllowed() {
        return false;
    }

    @Override
    public boolean isReplaceAllowed(int rowIndex, DataType dataType) {
        return false;
    }

    @Override
    public boolean isUnpackageAllowed() {
        return false;
    }

    @Override
    public void dataTypeRenamed(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (dtm != originalDTM) {
            return;
        }
        if (!this.isLoaded()) {
            return;
        }
        if (oldPath.getDataTypeName().equals(newPath.getDataTypeName())) {
            return;
        }
        String newName = newPath.getDataTypeName();
        String oldName = oldPath.getDataTypeName();
        if (this.originalCompositeId != -1L && oldPath.equals((Object)this.originalDataTypePath)) {
            this.originalDataTypePath = newPath;
            try {
                if (this.viewComposite.getName().equals(oldName)) {
                    this.setName(newName);
                    this.compositeInfoChanged();
                }
            }
            catch (DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
            catch (InvalidNameException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
        } else {
            DataType dt = this.viewDTM.getDataType(oldPath);
            if (dt != null) {
                try {
                    dt.setName(newName);
                    this.fireTableDataChanged();
                    this.componentDataChanged();
                }
                catch (InvalidNameException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
                catch (DuplicateNameException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    protected int getNumSubComponents(int rowIndex) {
        DataTypeComponent dtc = this.getComponent(rowIndex);
        if (dtc instanceof Composite) {
            Composite comp = (Composite)dtc;
            return comp.getNumComponents();
        }
        return 0;
    }

    @Override
    public int getLastNumBytes() {
        return this.lastNumBytes;
    }

    @Override
    public int getLastNumDuplicates() {
        return this.lastNumDuplicates;
    }

    @Override
    public int getLastNumElements() {
        return this.lastNumElements;
    }

    public void setLastNumBytes(int numBytes) {
        this.lastNumBytes = numBytes;
    }

    public void setLastNumDuplicates(int numDuplicates) {
        this.lastNumDuplicates = numDuplicates;
    }

    public void setLastNumElements(int numElements) {
        this.lastNumElements = numElements;
    }

    @Override
    public void setSelection(int[] rows) {
        if (this.updatingSelection) {
            return;
        }
        FieldSelection tmpSelection = new FieldSelection();
        int numComponents = this.getNumComponents();
        for (int row2 : rows) {
            if (row2 >= numComponents) continue;
            tmpSelection.addRange(row2, row2 + 1);
        }
        if (this.selection.equals((Object)tmpSelection)) {
            return;
        }
        if (!this.stillBeginningEdit) {
            this.endFieldEditing();
        }
        this.selection = tmpSelection;
        this.adjustCurrentRow();
        this.selectionChanged();
    }

    @Override
    public void setSelection(FieldSelection selection) {
        if (this.updatingSelection) {
            return;
        }
        if (this.selection.equals((Object)selection)) {
            return;
        }
        this.endFieldEditing();
        this.selection.clear();
        int numRanges = selection.getNumRanges();
        for (int i = 0; i < numRanges; ++i) {
            FieldRange range = selection.getFieldRange(i);
            this.selection.addRange(range.getStart().getIndex().intValue(), range.getEnd().getIndex().intValue());
        }
        this.adjustCurrentRow();
        this.selectionChanged();
    }

    public void validateComponentOffset(int rowIndex, String offset) throws UsrException {
    }

    public DataTypeInstance validateComponentDataType(int rowIndex, String dtString) throws UsrException {
        DataType dt = null;
        String dtName = "";
        dtString = DataTypeHelper.stripWhiteSpace(dtString);
        DataTypeComponent element = this.getComponent(rowIndex);
        if (element != null && dtString.equals(dtName = (dt = element.getDataType()).getDisplayName())) {
            return DataTypeInstance.getDataTypeInstance((DataType)element.getDataType(), (int)element.getLength(), (boolean)true);
        }
        int newLength = 0;
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        DataType newDt = DataTypeHelper.parseDataType(rowIndex, dtString, this, originalDTM, this.provider.dtmService);
        if (newDt == null) {
            if (dt != null) {
                throw new UsrException("No data type was specified.");
            }
            throw new AssertException("Can't set data type to null.");
        }
        this.checkIsAllowableDataType(newDt);
        newLength = newDt.getLength();
        if (newLength < 0) {
            DataTypeInstance sizedDataType = DataTypeHelper.getSizedDataType(this.provider, newDt, this.lastNumBytes, this.getMaxReplaceLength(rowIndex));
            newLength = sizedDataType.getLength();
        }
        newDt = this.viewDTM.resolve(newDt, null);
        int maxLength = this.getMaxReplaceLength(rowIndex);
        if (newLength <= 0) {
            throw new UsrException("Can't currently add this data type.");
        }
        if (maxLength > 0 && newLength > maxLength) {
            throw new UsrException(newDt.getDisplayName() + " doesn't fit.");
        }
        return DataTypeInstance.getDataTypeInstance((DataType)newDt, (int)newLength, (boolean)true);
    }

    public void validateComponentName(int rowIndex, String name) throws UsrException {
    }

    private void checkName(String name) throws DuplicateNameException {
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        DataType dt = originalDTM.getDataType(this.getOriginalCategoryPath(), name);
        if (dt != null && dt != this.originalComposite) {
            throw new DuplicateNameException("Data type named " + name + " already exists");
        }
    }

    protected boolean bitfieldsSupported() {
        return this.viewComposite instanceof Structure || this.viewComposite instanceof Union;
    }
}

