/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.clear;

import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.builder.AbstractActionBuilder;
import docking.action.builder.ActionBuilder;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.clear.ClearCmd;
import ghidra.app.plugin.core.clear.ClearDialog;
import ghidra.app.plugin.core.clear.ClearFlowAndRepairCmd;
import ghidra.app.plugin.core.clear.ClearFlowDialog;
import ghidra.app.plugin.core.clear.ClearOptions;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Clear Code and Program Annotations", description="This plugin clears instructions and provides options to clear other program annotations, such as comments, labels, etc.")
public class ClearPlugin
extends Plugin {
    private static final String CLEAR_WITH_OPTIONS_NAME = "Clear With Options";
    private static final String CLEAR_CODE_BYTES_NAME = "Clear Code Bytes";
    private static final String CLEAR_FLOW_AND_REPAIR = "Clear Flow and Repair";

    public ClearPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    void clearFlowAndRepair(ListingActionContext context, boolean clearSymbols, boolean clearData, boolean repair) {
        ProgramSelection selection = context.getSelection();
        ProgramLocation location = context.getLocation();
        ClearFlowAndRepairCmd cmd = selection == null || selection.isEmpty() ? new ClearFlowAndRepairCmd(location.getAddress(), clearData, clearSymbols, repair) : new ClearFlowAndRepairCmd(selection, clearData, clearSymbols, repair);
        this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)context.getProgram());
    }

    void clear(ClearOptions options, ListingActionContext context) {
        if (!options.clearAny()) {
            return;
        }
        if (!this.scheduleClear(options, context)) {
            return;
        }
        AddressSet set = new AddressSet((AddressSetView)context.getSelection());
        ClearCmd cmd = new ClearCmd((AddressSetView)set, options);
        this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)context.getProgram());
    }

    private boolean scheduleClear(ClearOptions options, ListingActionContext context) {
        ProgramSelection selection = context.getSelection();
        ProgramLocation location = context.getLocation();
        Program program = context.getProgram();
        if (selection == null || selection.isEmpty()) {
            this.clearWhenNoSelection(options, location, program);
            return false;
        }
        InteriorSelection interSel = selection.getInteriorSelection();
        if (interSel != null) {
            this.clearStructure(program, interSel.getFrom(), interSel.getTo());
            return false;
        }
        return true;
    }

    private void clearWhenNoSelection(ClearOptions options, ProgramLocation location, Program program) {
        if (location == null) {
            return;
        }
        int[] compPath = location.getComponentPath();
        if (compPath != null && compPath.length > 0) {
            this.clearStructure(program, location, null);
            return;
        }
        CodeUnit cu = program.getListing().getCodeUnitContaining(location.getAddress());
        ClearCmd cmd = new ClearCmd(cu, options);
        this.tool.execute((Command)cmd, (DomainObject)program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearStructure(Program program, ProgramLocation start, ProgramLocation end) {
        boolean commit = false;
        int id = program.startTransaction("Clear Structure");
        try {
            int index;
            Address dataAddr = start.getByteAddress();
            Data data = program.getListing().getDefinedDataContaining(dataAddr);
            if (data == null) {
                boolean bl = false;
                return bl;
            }
            Data compData = data.getComponent(start.getComponentPath());
            if (compData == null) {
                boolean bl = false;
                return bl;
            }
            DataType dataType = compData.getParent().getBaseDataType();
            if (!(dataType instanceof Composite)) {
                boolean bl = false;
                return bl;
            }
            int endIndex = index = compData.getComponentIndex();
            if (end != null) {
                int[] cpath = end.getComponentPath();
                endIndex = cpath[cpath.length - 1];
            }
            if (dataType instanceof Union) {
                Union union = (Union)dataType;
                for (int ordinal = endIndex; ordinal >= 0 && ordinal >= index; --ordinal) {
                    union.delete(ordinal);
                }
            } else {
                Structure structure = (Structure)dataType;
                for (int ordinal = endIndex; ordinal >= 0 && ordinal >= index; --ordinal) {
                    structure.clearComponent(ordinal);
                }
            }
            commit = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            program.endTransaction(id, commit);
        }
        return commit;
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(CLEAR_CODE_BYTES_NAME, this.getName()).menuPath(new String[]{"&Edit", CLEAR_CODE_BYTES_NAME})).menuGroup(CLEAR_CODE_BYTES_NAME, "1")).popupMenuPath(new String[]{CLEAR_CODE_BYTES_NAME})).popupMenuGroup(CLEAR_CODE_BYTES_NAME, "1")).keyBinding("C")).withContext(ListingActionContext.class).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).enabledWhen(this::isClearCodeBytesEnabled).onAction(this::clearCodeBytes).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(CLEAR_WITH_OPTIONS_NAME, this.getName()).menuPath(new String[]{"&Edit", "Clear With Options..."})).menuGroup(CLEAR_CODE_BYTES_NAME, "2")).popupMenuPath(new String[]{"Clear With Options..."})).popupMenuGroup(CLEAR_CODE_BYTES_NAME, "2")).withContext(ListingActionContext.class).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).onAction(this::showClearAllDialog).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(CLEAR_FLOW_AND_REPAIR, this.getName()).menuPath(new String[]{"&Edit", "Clear Flow and Repair..."})).menuGroup(CLEAR_CODE_BYTES_NAME, "3")).popupMenuPath(new String[]{"Clear Flow and Repair..."})).popupMenuGroup(CLEAR_CODE_BYTES_NAME, "3")).withContext(ListingActionContext.class).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).onAction(this::showClearFlowDialog).buildAndInstall((Tool)this.tool);
    }

    private boolean isClearCodeBytesEnabled(ListingActionContext context) {
        ProgramLocation loc = context.getLocation();
        ProgramSelection currentSelection = context.getSelection();
        if (currentSelection != null && !currentSelection.isEmpty()) {
            return true;
        }
        return loc != null && loc.getAddress() != null && loc instanceof CodeUnitLocation;
    }

    private void clearCodeBytes(ListingActionContext context) {
        ClearOptions opts = new ClearOptions();
        opts.setClearCode(true);
        opts.setClearSymbols(false);
        opts.setClearComments(false);
        opts.setClearProperties(false);
        opts.setClearFunctions(false);
        opts.setClearRegisters(false);
        opts.setClearEquates(false);
        opts.setClearUserReferences(true);
        opts.setClearAnalysisReferences(true);
        opts.setClearImportReferences(true);
        opts.setClearDefaultReferences(false);
        opts.setClearBookmarks(false);
        this.clear(opts, context);
    }

    private void showClearAllDialog(ListingActionContext programActionContext) {
        ClearDialog clearDialog = new ClearDialog(this);
        clearDialog.setProgramActionContext(programActionContext);
        this.tool.showDialog((DialogComponentProvider)clearDialog);
    }

    private void showClearFlowDialog(ListingActionContext context) {
        ClearFlowDialog clearFlowDialog = new ClearFlowDialog(this);
        clearFlowDialog.setProgramActionContext(context);
        this.tool.showDialog((DialogComponentProvider)clearFlowDialog);
    }
}

