/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.widgets.label.GDLabel;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.analysis.StoredAnalyzerTimes;
import ghidra.framework.options.CustomOptionsEditor;
import ghidra.util.layout.PairLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.beans.PropertyEditorSupport;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StoredAnalyzerTimesPropertyEditor
extends PropertyEditorSupport
implements CustomOptionsEditor {
    private StoredAnalyzerTimes times;

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    public String[] getOptionNames() {
        if (this.times == null) {
            return new String[0];
        }
        return this.times.getTaskNames();
    }

    public String[] getOptionDescriptions() {
        return null;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof StoredAnalyzerTimes)) {
            return;
        }
        this.times = (StoredAnalyzerTimes)value;
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this.times.clone();
    }

    @Override
    public Component getCustomEditor() {
        return this.buildEditor();
    }

    private Component buildEditor() {
        if (this.times == null || this.times.isEmpty()) {
            JPanel panel = new JPanel(new FlowLayout());
            panel.add(new JLabel("No Data Available"));
            return panel;
        }
        JPanel panel = new JPanel((LayoutManager)new PairLayout(6, 10));
        panel.add((Component)new GDLabel(""));
        GDLabel label = new GDLabel("seconds", 4);
        panel.add((Component)label);
        for (String taskName : this.getOptionNames()) {
            label = new GDLabel(taskName, 4);
            label.setToolTipText(taskName);
            panel.add((Component)label);
            Long timeMS = this.times.getTime(taskName);
            if (timeMS == null) continue;
            JTextField valueField = new JTextField(StoredAnalyzerTimes.formatTimeMS(timeMS));
            valueField.setEditable(false);
            valueField.setHorizontalAlignment(4);
            panel.add(valueField);
        }
        label = new GDLabel("TOTAL", 4);
        label.setFont(label.getFont().deriveFont(1));
        panel.add((Component)label);
        JTextField valueField = new JTextField(StoredAnalyzerTimes.formatTimeMS(this.times.getTotalTime()));
        valueField.setEditable(false);
        valueField.setHorizontalAlignment(4);
        valueField.setBorder(BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.BORDER, 2));
        panel.add(valueField);
        return panel;
    }
}

