/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.listing.ConflictInfoPanel;
import ghidra.app.merge.listing.ListingMergeConstants;
import ghidra.app.merge.listing.VerticalChoicesPanel;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.Memory;
import ghidra.program.util.CombinedAddressRangeIterator;
import ghidra.program.util.ProgramDiff;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.program.util.ProgramMerge;
import ghidra.program.util.ProgramMergeFilter;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class RegisterMergeManager
implements ListingMergeConstants {
    private int conflictOption = 0;
    private ProgramMultiUserMergeManager mergeManager;
    private ConflictInfoPanel conflictInfoPanel;
    private ListingMergePanel listingMergePanel;
    private VerticalChoicesPanel conflictPanel;
    private String registerName;
    private Address min;
    private Address max;
    private Register resultReg;
    private AddressSet autoSet;
    private AddressSet conflictSet;
    private AddressRange[] rvrs;
    Program resultPgm;
    Program originalPgm;
    Program latestPgm;
    Program myPgm;
    ProgramChangeSet latestChanges;
    ProgramChangeSet myChanges;
    AddressSetView latestSet;
    AddressSetView mySet;
    ProgramContext originalContext;
    ProgramContext latestContext;
    ProgramContext myContext;
    ProgramContext resultContext;
    ProgramDiff diffOriginalLatest;
    ProgramDiff diffOriginalMy;
    ProgramDiffFilter diffFilter;
    ProgramMergeFilter mergeFilter;
    ProgramMerge pm;
    private int contextChoice = 0;

    RegisterMergeManager(String registerName, ProgramMultiUserMergeManager mergeManager, Program resultPgm, Program originalPgm, Program latestPgm, Program myPgm, ProgramChangeSet latestChanges, ProgramChangeSet myChanges) {
        this.registerName = registerName;
        this.mergeManager = mergeManager;
        this.resultPgm = resultPgm;
        this.originalPgm = originalPgm;
        this.latestPgm = latestPgm;
        this.myPgm = myPgm;
        this.latestChanges = latestChanges;
        this.myChanges = myChanges;
        this.latestSet = latestChanges.getRegisterAddressSet();
        this.mySet = myChanges.getRegisterAddressSet();
        this.originalContext = originalPgm.getProgramContext();
        this.latestContext = latestPgm.getProgramContext();
        this.myContext = myPgm.getProgramContext();
        this.resultContext = resultPgm.getProgramContext();
        this.resultReg = this.resultContext.getRegister(registerName);
        if (this.resultReg.isProcessorContext()) {
            throw new IllegalArgumentException("Processor context register not allowed");
        }
    }

    public void apply() {
        this.conflictOption = this.conflictPanel.getSelectedOptions();
        if (this.conflictPanel.getUseForAll()) {
            this.contextChoice = this.conflictOption;
        }
        this.merge(this.min, this.max, this.resultReg);
    }

    public void cancel() {
        this.conflictOption = -1;
    }

    public String getDescription() {
        return "Merge Register";
    }

    public String getName() {
        return "Register Merger";
    }

    private void determineConflicts(TaskMonitor monitor) throws CancelledException {
        if (this.conflictSet != null) {
            return;
        }
        RegisterConflicts rc = new RegisterConflicts(this.registerName, this.originalContext, this.latestContext, this.myContext, this.resultContext);
        Memory resultMem = this.resultPgm.getMemory();
        AddressSet myDiffs = rc.getRegisterDifferences(this.registerName, this.originalContext, this.myContext, this.mySet, monitor);
        AddressSet setToCheck = resultMem.intersect((AddressSetView)myDiffs);
        this.conflictSet = new AddressSet();
        this.rvrs = rc.getConflicts((AddressSetView)setToCheck, monitor);
        if (this.rvrs.length > 0) {
            for (int j = 0; j < this.rvrs.length; ++j) {
                this.conflictSet.add(this.rvrs[j]);
            }
        }
        this.autoSet = setToCheck.subtract((AddressSetView)this.conflictSet);
    }

    public void merge(TaskMonitor monitor) throws CancelledException {
        int totalConflicts;
        monitor.setMessage("Auto-merging " + this.registerName + " Register Values and determining conflicts.");
        this.determineConflicts(monitor);
        AddressRangeIterator arIter = this.autoSet.getAddressRanges();
        try {
            while (arIter.hasNext() && !monitor.isCancelled()) {
                AddressRange range = (AddressRange)arIter.next();
                Address rangeMin = range.getMinAddress();
                Address rangeMax = range.getMaxAddress();
                this.resultContext.remove(rangeMin, rangeMax, this.resultReg);
                AddressRangeIterator it = this.myContext.getRegisterValueAddressRanges(this.resultReg, rangeMin, rangeMax);
                while (it.hasNext()) {
                    AddressRange valueRange = (AddressRange)it.next();
                    BigInteger value = this.myContext.getValue(this.resultReg, valueRange.getMinAddress(), false);
                    this.resultContext.setValue(this.resultReg, valueRange.getMinAddress(), valueRange.getMaxAddress(), value);
                }
            }
        }
        catch (ContextChangeException range) {
            // empty catch block
        }
        if ((totalConflicts = this.rvrs.length) == 0) {
            return;
        }
        this.listingMergePanel = this.mergeManager.getListingMergePanel();
        this.conflictInfoPanel = new ConflictInfoPanel();
        this.listingMergePanel.setTopComponent(this.conflictInfoPanel);
        monitor.setMessage("Resolving " + this.registerName + " Register Value conflicts.");
        boolean askUser = this.conflictOption == 0;
        for (int conflictIndex = 0; conflictIndex < totalConflicts; ++conflictIndex) {
            AddressRange range = this.rvrs[conflictIndex];
            Address rangeMin = range.getMinAddress();
            Address rangeMax = range.getMaxAddress();
            BigInteger myValue = this.myContext.getValue(this.resultReg, rangeMin, false);
            BigInteger latestValue = this.latestContext.getValue(this.resultReg, rangeMin, false);
            BigInteger originalValue = this.originalContext.getValue(this.resultReg, rangeMin, false);
            if (this.contextChoice != 0) {
                if (this.conflictOption != this.contextChoice) {
                    this.conflictOption = this.contextChoice;
                }
                boolean bl = askUser = this.conflictOption == 0;
            }
            if (askUser) {
                this.conflictInfoPanel.setRegisterInfo(this.registerName);
                this.conflictInfoPanel.setCodeUnitInfo((AddressRange)new AddressRangeImpl(rangeMin, rangeMax), conflictIndex + 1, totalConflicts);
                this.showMergePanel(rangeMin, rangeMax, latestValue, myValue, originalValue);
                if (this.conflictOption != -1) continue;
                throw new CancelledException();
            }
            this.merge(rangeMin, rangeMax, this.resultReg);
        }
    }

    private void merge(Address minAddress, Address maxAddress, Register resultRegister) {
        switch (this.conflictOption) {
            case 2: {
                this.merge(minAddress, maxAddress, resultRegister, this.latestContext.getValue(resultRegister, minAddress, false));
                break;
            }
            case 4: {
                this.merge(minAddress, maxAddress, resultRegister, this.myContext.getValue(resultRegister, minAddress, false));
                break;
            }
            case 1: {
                this.merge(minAddress, maxAddress, resultRegister, this.originalContext.getValue(resultRegister, minAddress, false));
            }
        }
    }

    private void merge(Address minAddress, Address maxAddress, Register resultRegister, BigInteger myValue) {
        try {
            this.resultContext.setValue(resultRegister, minAddress, maxAddress, myValue);
        }
        catch (ContextChangeException contextChangeException) {
            // empty catch block
        }
    }

    void setConflictDecision(int decision) {
        if (decision != 0 && decision != 2 && decision != 4) {
            throw new IllegalArgumentException();
        }
        this.conflictOption = decision;
    }

    private void showMergePanel(final Address minAddress, final Address maxAddress, final BigInteger latestValue, final BigInteger myValue, final BigInteger originalValue) {
        this.min = minAddress;
        this.max = maxAddress;
        try {
            final ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    RegisterMergeManager.this.conflictOption = RegisterMergeManager.this.conflictPanel.getSelectedOptions();
                    if (RegisterMergeManager.this.conflictOption == 0) {
                        if (RegisterMergeManager.this.mergeManager != null) {
                            RegisterMergeManager.this.mergeManager.setApplyEnabled(false);
                        }
                        return;
                    }
                    if (RegisterMergeManager.this.mergeManager != null) {
                        RegisterMergeManager.this.mergeManager.clearStatusText();
                        RegisterMergeManager.this.mergeManager.setApplyEnabled(true);
                    }
                }
            };
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    VerticalChoicesPanel panel = RegisterMergeManager.this.getConflictsPanel(minAddress, maxAddress, latestValue, myValue, originalValue, changeListener);
                    RegisterMergeManager.this.listingMergePanel.setBottomComponent(panel);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RegisterMergeManager.this.listingMergePanel.clearAllBackgrounds();
                    RegisterMergeManager.this.listingMergePanel.paintAllBackgrounds((AddressSetView)new AddressSet(minAddress, maxAddress));
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (this.mergeManager != null) {
            this.mergeManager.setApplyEnabled(false);
            this.mergeManager.showListingMergePanel(minAddress);
        }
    }

    private VerticalChoicesPanel getConflictsPanel(Address minAddress, Address maxAddress, BigInteger latestValue, BigInteger myValue, BigInteger originalValue, ChangeListener changeListener) {
        if (this.conflictPanel == null) {
            this.conflictPanel = new VerticalChoicesPanel();
        } else {
            this.conflictPanel.clear();
        }
        this.conflictPanel.setTitle("\"" + this.registerName + "\" Register Value");
        String text = "Register: " + ConflictUtility.getEmphasizeString(this.registerName) + ConflictUtility.spaces(4) + "Address Range: " + ConflictUtility.getAddressString(minAddress) + " - " + ConflictUtility.getAddressString(maxAddress) + "<br>Select the desired register value for the address range.";
        this.conflictPanel.setHeader(text);
        this.conflictPanel.setRowHeader(this.getRegisterInfo(-1, null));
        this.conflictPanel.addRadioButtonRow(this.getRegisterInfo(1, latestValue), "LatestVersionRB", 2, changeListener);
        this.conflictPanel.addRadioButtonRow(this.getRegisterInfo(2, myValue), "CheckedOutVersionRB", 4, changeListener);
        this.conflictPanel.addRadioButtonRow(this.getRegisterInfo(3, originalValue), "OriginalVersionRB", 1, changeListener);
        this.conflictPanel.setConflictType(this.registerName + " Register Value");
        return this.conflictPanel;
    }

    private String[] getRegisterInfo(int version, BigInteger value) {
        String[] info = new String[]{"", ""};
        if (version == 1) {
            info[0] = " 'Latest' version";
        } else if (version == 2) {
            info[0] = " 'Checked Out' version";
        } else if (version == 3) {
            info[0] = " 'Original' version";
        } else {
            return new String[]{"Option", "Register Value"};
        }
        info[1] = value != null ? "0x" + value.toString(16) : ConflictUtility.NO_VALUE;
        return info;
    }

    private class RegisterConflicts {
        String conflictRegisterName;
        ProgramContext conflictOriginalContext;
        ProgramContext conflictLatestContext;
        ProgramContext conflictMyContext;
        ProgramContext conflictResultContext;
        Register conflictOriginalReg;
        Register conflictLatestReg;
        Register conflictMyReg;
        Register conflictResultReg;

        RegisterConflicts(String registerName, ProgramContext originalContext, ProgramContext latestContext, ProgramContext myContext, ProgramContext resultContext) {
            this.conflictRegisterName = registerName;
            this.conflictOriginalContext = originalContext;
            this.conflictLatestContext = latestContext;
            this.conflictMyContext = myContext;
            this.conflictResultContext = resultContext;
            this.conflictOriginalReg = originalContext.getRegister(registerName);
            this.conflictLatestReg = latestContext.getRegister(registerName);
            this.conflictMyReg = myContext.getRegister(registerName);
            this.conflictResultReg = resultContext.getRegister(registerName);
        }

        private AddressSet getRegisterDifferences(String regName, ProgramContext context1, ProgramContext context2, AddressSetView addressSet, TaskMonitor monitor) {
            AddressSet differences = new AddressSet();
            ProgramContext pc1 = context1;
            ProgramContext pc2 = context2;
            Register rb1 = pc1.getRegister(regName);
            Register rb2 = pc2.getRegister(regName);
            AddressRangeIterator iter = addressSet.getAddressRanges();
            while (iter.hasNext()) {
                AddressRange range = (AddressRange)iter.next();
                Address rangeMin = range.getMinAddress();
                Address rangeMax = range.getMaxAddress();
                AddressRangeIterator it1 = pc1.getRegisterValueAddressRanges(rb1, rangeMin, rangeMax);
                AddressRangeIterator it2 = pc2.getRegisterValueAddressRanges(rb2, rangeMin, rangeMax);
                CombinedAddressRangeIterator it = new CombinedAddressRangeIterator(it1, it2);
                while (it.hasNext()) {
                    AddressRange addrRange = (AddressRange)it.next();
                    BigInteger value1 = pc1.getValue(rb1, addrRange.getMinAddress(), false);
                    BigInteger value2 = pc2.getValue(rb2, addrRange.getMinAddress(), false);
                    boolean sameValue = value1 == null ? value2 == null : value1.equals(value2);
                    if (sameValue) continue;
                    differences.addRange(addrRange.getMinAddress(), addrRange.getMaxAddress());
                }
                if (!monitor.isCancelled()) continue;
                return null;
            }
            return differences;
        }

        AddressRange[] getConflicts(AddressSetView addressSet, TaskMonitor monitor) throws CancelledException {
            ArrayList<AddressRange> conflicts = new ArrayList<AddressRange>();
            AddressSet tempLatestChanges = this.getRegisterDifferences(this.conflictRegisterName, this.conflictOriginalContext, this.conflictLatestContext, addressSet, monitor);
            AddressSet tempMyChanges = this.getRegisterDifferences(this.conflictRegisterName, this.conflictOriginalContext, this.conflictMyContext, addressSet, monitor);
            AddressSet bothChanged = tempMyChanges.intersect((AddressSetView)tempLatestChanges);
            AddressRangeIterator iter = bothChanged.getAddressRanges();
            while (iter.hasNext()) {
                AddressRange range = (AddressRange)iter.next();
                Address rangeMin = range.getMinAddress();
                Address rangeMax = range.getMaxAddress();
                AddressRangeIterator it1 = this.conflictLatestContext.getRegisterValueAddressRanges(this.conflictLatestReg, rangeMin, rangeMax);
                AddressRangeIterator it2 = this.conflictMyContext.getRegisterValueAddressRanges(this.conflictMyReg, rangeMin, rangeMax);
                CombinedAddressRangeIterator it = new CombinedAddressRangeIterator(it1, it2);
                while (it.hasNext()) {
                    AddressRange addrRange = (AddressRange)it.next();
                    BigInteger lastestValue = this.conflictLatestContext.getValue(this.conflictLatestReg, addrRange.getMinAddress(), false);
                    BigInteger myValue = this.conflictMyContext.getValue(this.conflictMyReg, addrRange.getMinAddress(), false);
                    boolean sameValue = lastestValue == null ? myValue == null : lastestValue.equals(myValue);
                    if (sameValue) continue;
                    conflicts.add(addrRange);
                }
                monitor.checkCancelled();
            }
            return conflicts.toArray(new AddressRange[conflicts.size()]);
        }
    }
}

