/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import docking.DialogComponentProvider;
import docking.widgets.dialogs.ReadTextDialog;
import ghidra.app.merge.MergeResolver;
import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.listing.ListingMergeConstants;
import ghidra.app.merge.listing.VerticalChoicesPanel;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.program.model.symbol.ExternalLocationIterator;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramMerge;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.LongLongHashtable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NoValueException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;

public class ExternalProgramMerger
implements MergeResolver,
ListingMergeConstants {
    private static String[] EXTERNAL_PROGRAM_PHASE = new String[]{"External Programs"};
    private VerticalChoicesPanel conflictPanel;
    private int conflictOption;
    private IDGroup currentIDGroup;
    private TaskMonitor currentMonitor;
    private ArrayList<IDGroup> extPgms;
    private ProgramMultiUserMergeManager mergeManager;
    private Program resultPgm;
    private Program originalPgm;
    private Program latestPgm;
    private Program myPgm;
    private ExternalManager originalExtMgr;
    private ExternalManager latestExtMgr;
    private ExternalManager myExtMgr;
    private ExternalManager resultExtMgr;
    private StringBuffer infoBuf;
    private int externalProgramChoice = 0;
    LongLongHashtable originalResolvedSymbols;
    LongLongHashtable latestResolvedSymbols;
    LongLongHashtable myResolvedSymbols;
    LongLongHashtable resultToOriginalMap;
    LongLongHashtable resultToLatestMap;
    LongLongHashtable resultToMyMap;
    Set<Long> resultIDsInAGroup = new HashSet<Long>();

    public ExternalProgramMerger(ProgramMultiUserMergeManager mergeManager, Program resultPgm, Program originalPgm, Program latestPgm, Program myPgm, ProgramChangeSet latestChanges, ProgramChangeSet myChanges) {
        this.mergeManager = mergeManager;
        this.resultPgm = resultPgm;
        this.originalPgm = originalPgm;
        this.latestPgm = latestPgm;
        this.myPgm = myPgm;
        this.init();
    }

    public void init() {
        this.extPgms = new ArrayList();
        this.originalExtMgr = this.originalPgm.getExternalManager();
        this.latestExtMgr = this.latestPgm.getExternalManager();
        this.myExtMgr = this.myPgm.getExternalManager();
        this.resultExtMgr = this.resultPgm.getExternalManager();
        this.infoBuf = new StringBuffer();
        this.originalResolvedSymbols = new LongLongHashtable();
        this.latestResolvedSymbols = new LongLongHashtable();
        this.myResolvedSymbols = new LongLongHashtable();
        this.resultToOriginalMap = new LongLongHashtable();
        this.resultToLatestMap = new LongLongHashtable();
        this.resultToMyMap = new LongLongHashtable();
    }

    void setConflictDecision(int decision) {
        switch (decision) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                this.conflictOption = decision;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    void clearResolveInfo() {
        if (this.infoBuf.length() > 0) {
            this.infoBuf = new StringBuffer();
        }
    }

    void showResolveInfo() {
        if (this.infoBuf.length() > 0) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String title = ExternalProgramMerger.this.getConflictType() + " Merge Information";
                        String msg = ExternalProgramMerger.this.infoBuf.toString();
                        ReadTextDialog dialog = new ReadTextDialog(title, msg);
                        ExternalProgramMerger.this.mergeManager.getMergeTool().showDialog((DialogComponentProvider)dialog, (Component)ExternalProgramMerger.this.mergeManager.getMergeTool().getToolFrame());
                    }
                });
            }
            catch (InterruptedException e) {
                throw new AssertException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    public void autoMerge(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Auto-merging External Program Names and determining conflicts.");
        if (monitor.isCancelled()) {
            throw new CancelledException();
        }
        if (this.mergeManager != null) {
            this.latestResolvedSymbols = (LongLongHashtable)this.mergeManager.getResolveInformation("ResolvedLatestSymbols");
            this.myResolvedSymbols = (LongLongHashtable)this.mergeManager.getResolveInformation("ResolvedMySymbols");
            this.originalResolvedSymbols = (LongLongHashtable)this.mergeManager.getResolveInformation("ResolvedOriginalSymbols");
            this.mapResultsToOriginalLibs();
            this.mapResultsToLatestLibs();
            this.mapResultsToMyLibs();
        }
        ArrayList<IDGroup> idGroups = new ArrayList<IDGroup>();
        idGroups.addAll(this.getGroupsForOriginalLibs());
        idGroups.addAll(this.getGroupsForLatestNewLibs());
        idGroups.addAll(this.getGroupsForMyNewLibs());
        int resolveCount = 0;
        int maximum = idGroups.size();
        monitor.initialize((long)maximum);
        for (IDGroup idGroup : idGroups) {
            int progress = (int)((float)(resolveCount / maximum) * 100.0f);
            this.autoMergeNamedExternalProgram(idGroup, progress);
            monitor.setProgress((long)(++resolveCount));
        }
    }

    private void mapResultsToOriginalLibs() {
        String[] originalNames;
        SymbolTable originalSymbolManager = this.originalPgm.getSymbolTable();
        for (String originalName : originalNames = this.originalExtMgr.getExternalLibraryNames()) {
            Symbol librarySymbol = originalSymbolManager.getLibrarySymbol(originalName);
            long originalID = librarySymbol.getID();
            long resultID = this.getResultIDFromOriginalID(originalID);
            if (resultID == -1L) continue;
            this.resultToOriginalMap.put(resultID, originalID);
        }
    }

    private void mapResultsToLatestLibs() {
        String[] latestNames;
        SymbolTable latestSymbolManager = this.latestPgm.getSymbolTable();
        for (String latestName : latestNames = this.latestExtMgr.getExternalLibraryNames()) {
            long resultID;
            Symbol librarySymbol = latestSymbolManager.getLibrarySymbol(latestName);
            long latestID = librarySymbol.getID();
            try {
                resultID = this.getResultIDFromLatestID(latestID);
            }
            catch (NoValueException e) {
                resultID = latestID;
            }
            if (resultID == -1L) continue;
            this.resultToLatestMap.put(resultID, latestID);
        }
    }

    private void mapResultsToMyLibs() {
        String[] myNames;
        SymbolTable mySymbolManager = this.myPgm.getSymbolTable();
        for (String myName : myNames = this.myExtMgr.getExternalLibraryNames()) {
            long resultID;
            Symbol librarySymbol = mySymbolManager.getLibrarySymbol(myName);
            long myID = librarySymbol.getID();
            try {
                resultID = this.getResultIDFromMyID(myID);
            }
            catch (NoValueException e) {
                resultID = myID;
            }
            if (resultID == -1L || resultID == myID) continue;
            this.resultToMyMap.put(resultID, myID);
        }
    }

    private List<IDGroup> getGroupsForOriginalLibs() {
        ArrayList<IDGroup> idGroups = new ArrayList<IDGroup>();
        String[] originalNames = this.originalExtMgr.getExternalLibraryNames();
        SymbolTable originalSymbolTable = this.originalPgm.getSymbolTable();
        SymbolTable latestSymbolTable = this.latestPgm.getSymbolTable();
        SymbolTable mySymbolTable = this.myPgm.getSymbolTable();
        for (String originalName : originalNames) {
            long myID;
            Symbol originalLibrarySymbol = originalSymbolTable.getLibrarySymbol(originalName);
            long originalID = originalLibrarySymbol.getID();
            long resultID = this.getResultIDFromOriginalID(originalID);
            long latestID = latestSymbolTable.getSymbol(originalID) != null ? originalID : -1L;
            long l = myID = mySymbolTable.getSymbol(originalID) != null ? originalID : -1L;
            if (this.resultIDsInAGroup.contains(resultID)) continue;
            idGroups.add(new IDGroup(resultID, originalID, latestID, myID));
            if (resultID == -1L) continue;
            this.resultIDsInAGroup.add(resultID);
        }
        return idGroups;
    }

    private List<IDGroup> getGroupsForLatestNewLibs() {
        ArrayList<IDGroup> idGroups = new ArrayList<IDGroup>();
        String[] latestNames = this.latestExtMgr.getExternalLibraryNames();
        SymbolTable originalSymbolTable = this.originalPgm.getSymbolTable();
        SymbolTable latestSymbolTable = this.latestPgm.getSymbolTable();
        for (String latestName : latestNames) {
            long resultID;
            Symbol latestLibrarySymbol = latestSymbolTable.getLibrarySymbol(latestName);
            long latestID = latestLibrarySymbol.getID();
            if (originalSymbolTable.getSymbol(latestID) != null) continue;
            try {
                resultID = this.getResultIDFromLatestID(latestID);
            }
            catch (NoValueException e) {
                resultID = latestID;
            }
            long originalID = this.getOriginalIDForResultID(resultID);
            long myID = this.getMyIDForResultID(resultID);
            if (this.resultIDsInAGroup.contains(resultID)) continue;
            idGroups.add(new IDGroup(resultID, originalID, latestID, myID));
            if (resultID == -1L) continue;
            this.resultIDsInAGroup.add(resultID);
        }
        return idGroups;
    }

    private List<IDGroup> getGroupsForMyNewLibs() {
        ArrayList<IDGroup> idGroups = new ArrayList<IDGroup>();
        String[] myNames = this.myExtMgr.getExternalLibraryNames();
        SymbolTable originalSymbolTable = this.originalPgm.getSymbolTable();
        SymbolTable mySymbolTable = this.myPgm.getSymbolTable();
        for (String myName : myNames) {
            long resultID;
            Symbol myLibrarySymbol = mySymbolTable.getLibrarySymbol(myName);
            long myID = myLibrarySymbol.getID();
            if (originalSymbolTable.getSymbol(myID) != null) continue;
            try {
                resultID = this.getResultIDFromMyID(myID);
            }
            catch (NoValueException e) {
                resultID = myID;
            }
            long originalID = this.getOriginalIDForResultID(resultID);
            long latestID = this.getLatestIDForResultID(resultID);
            if (this.resultIDsInAGroup.contains(resultID)) continue;
            idGroups.add(new IDGroup(resultID, originalID, latestID, myID));
            if (resultID == -1L) continue;
            this.resultIDsInAGroup.add(resultID);
        }
        return idGroups;
    }

    private long getOriginalIDForResultID(long resultID) {
        if (resultID == -1L) {
            return -1L;
        }
        try {
            return this.resultToOriginalMap.get(resultID);
        }
        catch (NoValueException noValueException) {
            return -1L;
        }
    }

    private long getLatestIDForResultID(long resultID) {
        if (resultID == -1L) {
            return -1L;
        }
        try {
            return this.resultToLatestMap.get(resultID);
        }
        catch (NoValueException noValueException) {
            return -1L;
        }
    }

    private long getMyIDForResultID(long resultID) {
        if (resultID == -1L) {
            return -1L;
        }
        try {
            return this.resultToMyMap.get(resultID);
        }
        catch (NoValueException noValueException) {
            return -1L;
        }
    }

    private void autoMergeNamedExternalProgram(IDGroup idGroup, int progress) {
        boolean changedMy;
        String myPath;
        long resultID = idGroup.getResultID();
        String resultName = idGroup.getResultName();
        String originalName = idGroup.getOriginalName();
        String latestName = idGroup.getLatestName();
        String myName = idGroup.getMyName();
        String name = resultName != null ? resultName : (originalName != null ? originalName : (latestName != null ? latestName : (myName != null ? myName : "unknown")));
        this.mergeManager.updateProgress(progress, "Merging external program information for " + name + "...");
        String originalPath = originalName != null ? this.originalExtMgr.getExternalLibraryPath(originalName) : null;
        String latestPath = latestName != null ? this.latestExtMgr.getExternalLibraryPath(latestName) : null;
        String string = myPath = myName != null ? this.myExtMgr.getExternalLibraryPath(myName) : null;
        if (this.same(latestName, myName) && this.same(latestPath, myPath)) {
            return;
        }
        boolean changedLatestName = !this.same(originalName, latestName);
        boolean changedMyName = !this.same(originalName, myName);
        boolean changedLatestPath = !this.same(originalPath, latestPath);
        boolean changedMyPath = !this.same(originalPath, myPath);
        boolean changedLatest = changedLatestName || changedLatestPath;
        boolean bl = changedMy = changedMyName || changedMyPath;
        if (changedLatest) {
            if (changedMy) {
                this.extPgms.add(idGroup);
            } else {
                if (resultID != -1L && resultName == null) {
                    resultName = latestName;
                }
                this.autoMergeWhenOnlyLatestChanged(resultName, latestName, latestPath);
            }
        } else if (changedMy) {
            if (resultID != -1L && resultName == null) {
                resultName = myName;
                SymbolTable resultSymbolTable = this.resultPgm.getSymbolTable();
                Symbol symbol = resultSymbolTable.getSymbol(resultName, Address.NO_ADDRESS, this.resultPgm.getGlobalNamespace());
                if (symbol != null && symbol.getSymbolType() != SymbolType.LIBRARY) {
                    resultName = ProgramMerge.getUniqueName(resultSymbolTable, resultName, Address.NO_ADDRESS, this.resultPgm.getGlobalNamespace(), symbol.getSymbolType());
                }
            }
            this.autoMergeWhenOnlyMyChanged(resultName, myName, myPath);
        }
    }

    private void autoMergeWhenOnlyLatestChanged(String resultName, String latestName, String latestPath) {
        if (resultName == null) {
            return;
        }
        try {
            if (latestName == null) {
                this.removeExternalLibrary(this.resultPgm, resultName);
            } else {
                this.resultExtMgr.setExternalPath(resultName, latestPath, this.isExternalUserDefined(this.latestPgm, latestName));
            }
        }
        catch (InvalidInputException e) {
            this.infoBuf.append(e.getMessage() + "\n");
        }
    }

    private void autoMergeWhenOnlyMyChanged(String resultName, String myName, String myPath) {
        if (resultName == null) {
            return;
        }
        try {
            if (myName == null) {
                this.removeExternalLibrary(this.resultPgm, resultName);
            } else {
                this.resultExtMgr.setExternalPath(resultName, myPath, this.isExternalUserDefined(this.myPgm, myName));
            }
        }
        catch (InvalidInputException e) {
            this.infoBuf.append(e.getMessage() + "\n");
        }
    }

    private boolean isExternalUserDefined(Program pgm, String externalName) {
        SymbolTable symTab = pgm.getSymbolTable();
        Symbol s = symTab.getLibrarySymbol(externalName);
        if (s != null) {
            return s.getSource() == SourceType.USER_DEFINED;
        }
        return false;
    }

    private void removeExternalLibrary(Program program, String libName) throws InvalidInputException {
        ExternalManager extMgr = program.getExternalManager();
        ExternalLocationIterator iter = extMgr.getExternalLocations(libName);
        if (iter.hasNext()) {
            throw new InvalidInputException("Didn't remove external library " + libName + " since it isn't empty.");
        }
        if (!extMgr.removeExternalLibrary(libName)) {
            throw new InvalidInputException("Didn't remove external library " + libName);
        }
    }

    private boolean same(String latestName, String myName) {
        return SystemUtilities.isEqual((Object)latestName, (Object)myName);
    }

    public void mergeConflicts(int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Resolving External Program Name conflicts");
        boolean askUser = chosenConflictOption == 0;
        int totalConflicts = this.extPgms.size();
        monitor.initialize((long)totalConflicts);
        for (int conflictIndex = 0; conflictIndex < totalConflicts; ++conflictIndex) {
            IDGroup idGroup = this.extPgms.get(conflictIndex);
            if (this.externalProgramChoice == 0 && askUser && this.mergeManager != null) {
                monitor.checkCancelled();
                this.showMergePanel(idGroup, monitor);
            } else {
                int optionToUse = this.externalProgramChoice == 0 ? chosenConflictOption : this.externalProgramChoice;
                this.merge(idGroup, optionToUse, monitor);
            }
            monitor.setProgress((long)(conflictIndex + 1));
        }
    }

    private void showMergePanel(IDGroup idGroup, TaskMonitor monitor) {
        this.currentIDGroup = idGroup;
        this.currentMonitor = monitor;
        try {
            ChangeListener changeListener = e -> {
                this.conflictOption = this.conflictPanel.getSelectedOptions();
                if (this.conflictOption == 0 || this.conflictOption == -1) {
                    if (this.mergeManager != null) {
                        this.mergeManager.setApplyEnabled(false);
                    }
                    return;
                }
                if (this.mergeManager != null) {
                    this.mergeManager.clearStatusText();
                }
                this.merge(idGroup, this.conflictOption, this.currentMonitor);
                if (this.mergeManager != null) {
                    this.mergeManager.setApplyEnabled(true);
                }
            };
            SwingUtilities.invokeAndWait(() -> {
                this.conflictPanel = this.getConflictPanel(this.currentIDGroup, changeListener);
            });
        }
        catch (InterruptedException | InvocationTargetException e2) {
            Msg.error((Object)this, (Object)("Unexpected error showing merge panel for external program " + idGroup.getName()), (Throwable)e2);
        }
        if (this.mergeManager != null) {
            this.mergeManager.setApplyEnabled(false);
            boolean useForAll = this.externalProgramChoice != 0;
            this.conflictPanel.setUseForAll(useForAll);
            this.conflictPanel.setConflictType("External Program");
            this.mergeManager.showComponent(this.conflictPanel, "ExternalProgramMerge", new HelpLocation("Repository", "ExternalConflict"));
        }
    }

    VerticalChoicesPanel getConflictPanel(IDGroup idGroup, ChangeListener listener) {
        if (this.conflictPanel == null) {
            this.conflictPanel = new VerticalChoicesPanel();
            this.conflictPanel.setTitle(this.getConflictType());
        }
        this.conflictPanel.clear();
        this.conflictPanel.setHeader(this.getConflictInfo(idGroup, 1, 1));
        this.conflictPanel.setRowHeader(this.getExternalNameInfo(null, null, null, null));
        ExternalManager latestMgr = this.latestPgm.getExternalManager();
        ExternalManager myMgr = this.myPgm.getExternalManager();
        String latestName = idGroup.getLatestName();
        String myName = idGroup.getMyName();
        String originalName = idGroup.getOriginalName();
        boolean inLatest = latestName != null ? latestMgr.contains(latestName) : false;
        boolean inMy = myName != null ? myMgr.contains(myName) : false;
        String latestPrefix = inLatest ? "Change as in '" : "Remove as in '";
        String myPrefix = inMy ? "Change as in '" : "Remove as in '";
        String suffix = "' version";
        this.conflictPanel.addRadioButtonRow(this.getExternalNameInfo(this.latestPgm, latestName, latestPrefix, suffix), "LatestVersionRB", 2, listener);
        this.conflictPanel.addRadioButtonRow(this.getExternalNameInfo(this.myPgm, myName, myPrefix, suffix), "CheckedOutVersionRB", 4, listener);
        this.conflictPanel.addInfoRow(this.getExternalNameInfo(this.originalPgm, originalName, "'", suffix));
        return this.conflictPanel;
    }

    private String[] getExternalNameInfo(Program pgm, String extPgmName, String prefix, String suffix) {
        if (pgm == null) {
            return new String[]{"Option", "Name", "Path"};
        }
        String[] info = new String[]{"", "", ""};
        String version = "";
        if (pgm == this.originalPgm) {
            version = "Original";
        } else if (pgm == this.latestPgm) {
            version = "Latest";
        } else if (pgm == this.myPgm) {
            version = "Checked Out";
        } else if (pgm == this.resultPgm) {
            version = "Result";
        }
        info[0] = prefix + version + suffix;
        ExternalManager em = pgm.getExternalManager();
        if (extPgmName != null && em.contains(extPgmName)) {
            info[1] = extPgmName;
            info[2] = em.getExternalLibraryPath(extPgmName);
        }
        return info;
    }

    public String getConflictInfo(IDGroup idGroup, int conflictIndex, int totalConflicts) {
        String leftText = this.getConflictCount(conflictIndex, totalConflicts);
        String rightText = this.createNameInfo(idGroup.getName());
        String text = leftText + ConflictUtility.spaces(8) + rightText;
        return text;
    }

    private String getConflictCount(int conflictNum, int totalConflicts) {
        return "Conflict #" + ConflictUtility.getNumberString(conflictNum) + " of " + ConflictUtility.getNumberString(totalConflicts);
    }

    private String createNameInfo(String name) {
        return "External Program Name: " + ConflictUtility.getEmphasizeString(name);
    }

    private void merge(IDGroup idGroup, int chosenConflictOption, TaskMonitor monitor) {
        Program fromPgm = null;
        switch (chosenConflictOption) {
            case 2: {
                fromPgm = this.latestPgm;
                break;
            }
            case 4: {
                fromPgm = this.myPgm;
                break;
            }
            case 1: {
                fromPgm = this.originalPgm;
                break;
            }
            default: {
                return;
            }
        }
        this.mergeExternalProgramName(this.resultPgm, fromPgm, idGroup, monitor);
    }

    public boolean hasConflict() {
        return this.extPgms.size() > 0;
    }

    public int getConflictCount() {
        return this.extPgms.size();
    }

    public IDGroup[] getConflicts() {
        return this.extPgms.toArray(new IDGroup[this.extPgms.size()]);
    }

    @Override
    public String getName() {
        return "External Program Merger";
    }

    @Override
    public String getDescription() {
        return "Merge External Program Names";
    }

    String getConflictType() {
        return "External Program Name";
    }

    @Override
    public void apply() {
        this.conflictOption = this.conflictPanel.getSelectedOptions();
        if (this.conflictPanel.getUseForAll()) {
            this.externalProgramChoice = this.conflictOption;
        }
    }

    @Override
    public void cancel() {
        this.conflictOption = -1;
        if (this.conflictPanel != null) {
            this.conflictPanel.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(TaskMonitor monitor) {
        this.mergeManager.setInProgress(EXTERNAL_PROGRAM_PHASE);
        int transactionID = this.resultPgm.startTransaction(this.getDescription());
        boolean commit = false;
        try {
            monitor.checkCancelled();
            this.clearResolveInfo();
            this.autoMerge(monitor);
            monitor.checkCancelled();
            this.mergeConflicts(0, monitor);
            monitor.checkCancelled();
            this.clearConflictPanel();
            this.showResolveInfo();
            commit = true;
        }
        catch (CancelledException e) {
            this.mergeManager.setStatusText("User cancelled merge.");
            this.cancel();
        }
        finally {
            this.resultPgm.endTransaction(transactionID, commit);
        }
        this.mergeManager.setCompleted(EXTERNAL_PROGRAM_PHASE);
    }

    private void clearConflictPanel() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (ExternalProgramMerger.this.conflictPanel != null) {
                        ExternalProgramMerger.this.conflictPanel.clear();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    public void mergeExternalProgramName(Program program1, Program program2, IDGroup idGroup, TaskMonitor monitor) {
        boolean removed;
        ExternalManager em1 = program1.getExternalManager();
        ExternalManager em2 = program2.getExternalManager();
        String libName1 = idGroup.getName(program1);
        String libName2 = idGroup.getName(program2);
        if (libName2 != null && em2.contains(libName2)) {
            try {
                em1.setExternalPath(libName2, em2.getExternalLibraryPath(libName2), this.isExternalUserDefined(program2, libName2));
            }
            catch (InvalidInputException e) {
                Msg.showError((Object)this, null, (String)"Error Setting External Program Name", (Object)("Couldn't set path to '" + em2.getExternalLibraryPath(libName2) + "' for external program name '" + libName2 + "'"));
            }
        } else if (libName1 != null && em1.contains(libName1) && !(removed = em1.removeExternalLibrary(libName1))) {
            Msg.showError((Object)this, null, (String)"Error Removing External Program Name", (Object)("Couldn't remove external program name '" + libName1 + "'"));
        }
    }

    @Override
    public String[][] getPhases() {
        return new String[][]{EXTERNAL_PROGRAM_PHASE};
    }

    private long getResultIDFromOriginalID(long originalSymbolID) {
        try {
            return this.originalResolvedSymbols.get(originalSymbolID);
        }
        catch (NoValueException e) {
            if (this.resultPgm.getSymbolTable().getSymbol(originalSymbolID) != null) {
                return originalSymbolID;
            }
            return -1L;
        }
    }

    private long getResultIDFromLatestID(long latestSymbolID) throws NoValueException {
        try {
            return this.latestResolvedSymbols.get(latestSymbolID);
        }
        catch (NoValueException e) {
            Symbol resultSymbol;
            if (this.resultPgm.getSymbolTable().getSymbol(latestSymbolID) != null) {
                return latestSymbolID;
            }
            Symbol latestSymbol = this.latestPgm.getSymbolTable().getSymbol(latestSymbolID);
            if (latestSymbol != null && (resultSymbol = SimpleDiffUtility.getSymbol((Symbol)latestSymbol, (Program)this.resultPgm)) != null) {
                return resultSymbol.getID();
            }
            throw e;
        }
    }

    private long getResultIDFromMyID(long mySymbolID) throws NoValueException {
        try {
            return this.myResolvedSymbols.get(mySymbolID);
        }
        catch (NoValueException e) {
            Symbol resultSymbol;
            Symbol originalSymbol = this.originalPgm.getSymbolTable().getSymbol(mySymbolID);
            if (originalSymbol == null) {
                throw e;
            }
            if (this.resultPgm.getSymbolTable().getSymbol(mySymbolID) != null) {
                return mySymbolID;
            }
            Symbol mySymbol = this.myPgm.getSymbolTable().getSymbol(mySymbolID);
            if (mySymbol != null && (resultSymbol = SimpleDiffUtility.getSymbol((Symbol)mySymbol, (Program)this.resultPgm)) != null) {
                return resultSymbol.getID();
            }
            throw e;
        }
    }

    private class IDGroup {
        private long resultID;
        private long originalID;
        private long latestID;
        private long myID;

        private IDGroup(long resultID, long originalID, long latestID, long myID) {
            this.resultID = resultID;
            this.originalID = originalID;
            this.latestID = latestID;
            this.myID = myID;
        }

        private long getResultID() {
            return this.resultID;
        }

        private Symbol getResultSymbol() {
            SymbolTable resultSymbolTable = ExternalProgramMerger.this.resultPgm.getSymbolTable();
            return this.resultID != -1L ? resultSymbolTable.getSymbol(this.resultID) : null;
        }

        private Symbol getOriginalSymbol() {
            SymbolTable originalSymbolTable = ExternalProgramMerger.this.originalPgm.getSymbolTable();
            return this.originalID != -1L ? originalSymbolTable.getSymbol(this.originalID) : null;
        }

        private Symbol getLatestSymbol() {
            SymbolTable latestSymbolTable = ExternalProgramMerger.this.latestPgm.getSymbolTable();
            return this.latestID != -1L ? latestSymbolTable.getSymbol(this.latestID) : null;
        }

        private Symbol getMySymbol() {
            SymbolTable mySymbolTable = ExternalProgramMerger.this.myPgm.getSymbolTable();
            return this.myID != -1L ? mySymbolTable.getSymbol(this.myID) : null;
        }

        private String getResultName() {
            Symbol resultSymbol = this.getResultSymbol();
            return resultSymbol != null ? resultSymbol.getName() : null;
        }

        private String getOriginalName() {
            Symbol originalSymbol = this.getOriginalSymbol();
            return originalSymbol != null ? originalSymbol.getName() : null;
        }

        private String getLatestName() {
            Symbol latestSymbol = this.getLatestSymbol();
            return latestSymbol != null ? latestSymbol.getName() : null;
        }

        private String getMyName() {
            Symbol mySymbol = this.getMySymbol();
            return mySymbol != null ? mySymbol.getName() : null;
        }

        private String getName() {
            String resultName = this.getResultName();
            String originalName = this.getOriginalName();
            String latestName = this.getLatestName();
            String myName = this.getMyName();
            return resultName != null ? resultName : (originalName != null ? originalName : (latestName != null ? latestName : (myName != null ? myName : "unknown")));
        }

        private String getName(Program program) {
            if (program == ExternalProgramMerger.this.resultPgm) {
                return this.getResultName();
            }
            if (program == ExternalProgramMerger.this.originalPgm) {
                return this.getOriginalName();
            }
            if (program == ExternalProgramMerger.this.latestPgm) {
                return this.getLatestName();
            }
            if (program == ExternalProgramMerger.this.myPgm) {
                return this.getMyName();
            }
            return null;
        }
    }
}

