/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import docking.widgets.label.GDHtmlLabel;
import generic.theme.GThemeDefaults;
import ghidra.app.merge.util.ConflictUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ExternalConflictInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String conflictType;
    private int conflictNum;
    private int totalConflicts;
    private String versionTitle;
    private String labelPathName;
    private JLabel eastLabel;
    private JLabel westLabel;

    public ExternalConflictInfoPanel() {
        this.create();
    }

    private void create() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Resolve External Location Conflict"));
        this.westLabel = new GDHtmlLabel("<html></html>");
        this.eastLabel = new GDHtmlLabel("<html></html>");
        this.add((Component)this.westLabel, "West");
        this.add((Component)this.eastLabel, "East");
    }

    String getConflictType() {
        return this.conflictType;
    }

    String getLabelPathName() {
        return this.labelPathName;
    }

    void setConflictType(String conflictType) {
        this.conflictType = conflictType;
        TitledBorder tBorder = (TitledBorder)this.getBorder();
        tBorder.setTitle("Resolve " + conflictType + " Conflict");
    }

    void setConflictInfo(int conflictNum, int totalConflicts) {
        this.conflictNum = conflictNum;
        this.totalConflicts = totalConflicts;
        this.updateEast();
    }

    void setExternalName(String versionTitle, String labelPathName) {
        this.versionTitle = versionTitle;
        this.labelPathName = labelPathName;
        this.updateWest();
    }

    private void addCount(StringBuffer buf, int value) {
        buf.append("<font color=\"" + GThemeDefaults.Colors.Palette.MAROON + "\">" + value + "</font>");
    }

    private void addName(StringBuffer buf, String name) {
        buf.append("<font color=\"" + GThemeDefaults.Colors.Palette.MAROON + "\">" + name + "</font>");
    }

    private void updateWest() {
        StringBuffer buf = new StringBuffer();
        buf.append(" Conflict for ");
        this.addName(buf, this.versionTitle);
        buf.append(" version of external ");
        this.addName(buf, this.labelPathName);
        this.westLabel.setText(ConflictUtility.wrapAsHTML(buf.toString()));
    }

    private void updateEast() {
        StringBuffer buf = new StringBuffer();
        buf.append("External Conflict #");
        this.addCount(buf, this.conflictNum);
        buf.append(" of ");
        this.addCount(buf, this.totalConflicts);
        buf.append(". ");
        this.eastLabel.setText(ConflictUtility.wrapAsHTML(buf.toString()));
    }
}

