/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.util;

import com.dropbox.core.util.LangUtil;

public abstract class Maybe<T> {
    private static final Maybe<Object> Nothing = new Nothing<Object>();

    private Maybe() {
    }

    public abstract boolean isNothing();

    public abstract boolean isJust();

    public abstract T getJust();

    public abstract T get(T var1);

    public abstract String toString();

    public abstract int hashCode();

    public abstract boolean equals(Maybe<T> var1);

    public static <T> Maybe<T> Just(T value) {
        return new Just(value);
    }

    public static <T> Maybe<T> Nothing() {
        return Nothing;
    }

    private static final class Nothing<T>
    extends Maybe<T> {
        private Nothing() {
        }

        @Override
        public boolean isNothing() {
            return true;
        }

        @Override
        public boolean isJust() {
            return false;
        }

        @Override
        public T getJust() {
            throw new IllegalStateException("can't call getJust() on a Nothing");
        }

        @Override
        public T get(T def) {
            return def;
        }

        @Override
        public String toString() {
            return "Nothing";
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Maybe<T> other) {
            return other == this;
        }
    }

    private static final class Just<T>
    extends Maybe<T> {
        private final T value;

        private Just(T value) {
            this.value = value;
        }

        @Override
        public boolean isNothing() {
            return false;
        }

        @Override
        public boolean isJust() {
            return true;
        }

        @Override
        public T getJust() {
            return this.value;
        }

        @Override
        public T get(T def) {
            return this.value;
        }

        @Override
        public String toString() {
            return "Just(" + this.value + ")";
        }

        @Override
        public int hashCode() {
            return 1 + LangUtil.nullableHashCode(this.value);
        }

        @Override
        public boolean equals(Maybe<T> other) {
            if (other instanceof Just) {
                Just j = (Just)other;
                return LangUtil.nullableEquals(this.value, j.value);
            }
            if (other instanceof Nothing) {
                return false;
            }
            throw LangUtil.badType(other);
        }
    }
}

