/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.SymbolPathParser;
import ghidra.app.util.bin.format.pdb.DefaultCompositeMember;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractBitfieldMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractComplexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractCompositeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractFieldListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractIndirectVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractStaticMemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractStructureMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractUnionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsProperty;
import ghidra.app.util.pdb.pdbapplicator.AbstractComplexTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ArrayTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.BaseClassTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.BitfieldTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ClassTypeUtils;
import ghidra.app.util.pdb.pdbapplicator.CppCompositeType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbUniversalMember;
import ghidra.app.util.pdb.pdbapplicator.EnumTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.EnumerateTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.FieldListTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MemberTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ModifierTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.NestedTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.NoTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PointerTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PrimitiveTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.VirtualFunctionTablePointerTypeApplier;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CompositeDataTypeImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompositeTypeApplier
extends AbstractComplexTypeApplier {
    private static boolean applyBaseClasses = true;
    private CppCompositeType classType;
    private Map<Integer, String> componentComments;
    private List<DefaultPdbUniversalMember> members;

    public CompositeTypeApplier(DefaultPdbApplicator applicator, AbstractCompositeMsType msType) {
        super(applicator, msType);
        String fullPathName = msType.getName();
        this.symbolPath = new SymbolPath(SymbolPathParser.parse((String)fullPathName));
    }

    CppCompositeType getClassType() {
        if (this.definitionApplier != null) {
            return ((CompositeTypeApplier)this.definitionApplier).getClassTypeInternal();
        }
        return this.classType;
    }

    CppCompositeType getClassTypeInternal() {
        return this.classType;
    }

    List<DefaultPdbUniversalMember> getMembers() {
        return this.members;
    }

    private void getOrCreateComposite() {
        if (this.dataType != null) {
            return;
        }
        AbstractComplexTypeApplier alternativeApplier = this.getAlternativeTypeApplier();
        if (alternativeApplier != null) {
            this.dataType = alternativeApplier.getDataTypeInternal();
            this.classType = ((CompositeTypeApplier)alternativeApplier).getClassTypeInternal();
        }
        if (this.dataType != null) {
            return;
        }
        SymbolPath sp = this.getFixedSymbolPath();
        CategoryPath categoryPath = this.applicator.getCategory(sp.getParent());
        ComboType c = CompositeTypeApplier.getOrCreateComposite(this.applicator, this, (AbstractCompositeMsType)this.msType, categoryPath, sp);
        this.dataType = c.dt();
        this.classType = c.ct();
    }

    private static ComboType getOrCreateComposite(DefaultPdbApplicator myApplicator, AbstractComplexTypeApplier myCompositeApplier, AbstractCompositeMsType compositeMsType, CategoryPath categoryPath, SymbolPath fixedSymbolPath) {
        CppCompositeType myClassType;
        StructureDataType myComposite;
        String mangledName = compositeMsType.getMangledName();
        if (compositeMsType instanceof AbstractClassMsType) {
            myApplicator.predefineClass(fixedSymbolPath);
            myComposite = new StructureDataType(categoryPath, fixedSymbolPath.getName(), 0, myApplicator.getDataTypeManager());
            myClassType = new CppCompositeType((Composite)myComposite, mangledName);
            myClassType.setClass();
        } else if (compositeMsType instanceof AbstractStructureMsType) {
            myComposite = new StructureDataType(categoryPath, fixedSymbolPath.getName(), 0, myApplicator.getDataTypeManager());
            myClassType = new CppCompositeType((Composite)myComposite, mangledName);
            myClassType.setStruct();
        } else if (compositeMsType instanceof AbstractUnionMsType) {
            myComposite = new UnionDataType(categoryPath, fixedSymbolPath.getName(), myApplicator.getDataTypeManager());
            myClassType = new CppCompositeType((Composite)myComposite, mangledName);
            myClassType.setUnion();
        } else {
            String message = "Unsupported datatype (" + compositeMsType.getClass().getSimpleName() + "): " + fixedSymbolPath.getPath();
            myApplicator.appendLogMsg(message);
            return null;
        }
        myClassType.setName(myCompositeApplier.getMsType().getName());
        myClassType.setSize(DefaultPdbApplicator.bigIntegerToInt(myApplicator, myCompositeApplier.getSize()));
        myClassType.setFinal(compositeMsType.getMsProperty().isSealed());
        return new ComboType((DataType)myComposite, myClassType);
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.getOrCreateComposite();
        Composite composite = (Composite)this.dataType;
        AbstractCompositeMsType type = (AbstractCompositeMsType)this.msType;
        MsProperty property = type.getMsProperty();
        if (property.isForwardReference() && this.definitionApplier != null) {
            return;
        }
        if (!(composite instanceof CompositeDataTypeImpl)) {
            return;
        }
        this.applyOrDeferForDependencies();
    }

    @Override
    void resolve() {
        if (!(this.isForwardReference() || this.isNested() || this.isUnnamed())) {
            super.resolve();
        }
    }

    private boolean isUnnamed() {
        if (this.msType instanceof AbstractClassMsType) {
            return false;
        }
        return "__unnamed".equals(((AbstractComplexMsType)this.msType).getName());
    }

    private void applyOrDeferForDependencies() throws PdbException, CancelledException {
        AbstractCompositeMsType type = (AbstractCompositeMsType)this.msType;
        MsProperty property = type.getMsProperty();
        if (property.isForwardReference() && this.definitionApplier != null) {
            return;
        }
        this.applicator.addApplierDependency(this);
        FieldListTypeApplier fieldListApplier = FieldListTypeApplier.getFieldListApplierSpecial(this.applicator, type.getFieldDescriptorListRecordNumber());
        for (MsTypeApplier baseApplierIterated : fieldListApplier.getBaseClassList()) {
            BaseClassTypeApplier baseTypeApplier;
            MsTypeApplier applier;
            if (!(baseApplierIterated instanceof BaseClassTypeApplier) || !((applier = this.applicator.getTypeApplier((baseTypeApplier = (BaseClassTypeApplier)baseApplierIterated).getBaseClassRecordNumber())) instanceof CompositeTypeApplier)) continue;
            CompositeTypeApplier dependencyApplier = ((CompositeTypeApplier)applier).getDependencyApplier();
            this.applicator.addApplierDependency(this, dependencyApplier);
            this.setDeferred();
        }
        for (MsTypeApplier memberTypeApplierIterated : fieldListApplier.getMemberList()) {
            this.applicator.checkCancelled();
            if (memberTypeApplierIterated instanceof MemberTypeApplier) {
                MemberTypeApplier memberTypeApplier = (MemberTypeApplier)memberTypeApplierIterated;
                MsTypeApplier fieldApplier = memberTypeApplier.getFieldTypeApplier();
                this.recurseAddDependency(fieldApplier);
                continue;
            }
            if (!(memberTypeApplierIterated instanceof VirtualFunctionTablePointerTypeApplier)) continue;
            this.applicator.addApplierDependency(this, memberTypeApplierIterated);
        }
        if (!this.isDeferred() || this.isUnnamed()) {
            this.applyInternal();
        }
    }

    private void recurseAddDependency(MsTypeApplier dependee) throws CancelledException, PdbException {
        RecordNumber recNum;
        MsTypeApplier underlyingApplier;
        if (dependee instanceof ModifierTypeApplier) {
            ModifierTypeApplier modifierApplier = (ModifierTypeApplier)dependee;
            this.recurseAddDependency(modifierApplier.getModifiedTypeApplier());
        } else if (dependee instanceof CompositeTypeApplier) {
            CompositeTypeApplier defApplier = ((CompositeTypeApplier)dependee).getDefinitionApplier(CompositeTypeApplier.class);
            if (defApplier != null) {
                this.applicator.addApplierDependency(this, defApplier);
            } else {
                this.applicator.addApplierDependency(this, dependee);
            }
            this.setDeferred();
        } else if (dependee instanceof ArrayTypeApplier) {
            this.applicator.addApplierDependency(this, dependee);
            this.setDeferred();
        } else if (dependee instanceof BitfieldTypeApplier && (underlyingApplier = this.applicator.getTypeApplier(recNum = ((AbstractBitfieldMsType)((BitfieldTypeApplier)dependee).getMsType()).getElementRecordNumber())) instanceof EnumTypeApplier) {
            this.applicator.addApplierDependency(this, underlyingApplier);
            this.setDeferred();
        }
    }

    private void applyInternal() throws CancelledException, PdbException {
        if (this.isApplied()) {
            return;
        }
        this.applyInternal((Composite)this.dataType);
        this.setApplied();
    }

    private void applyInternal(Composite composite) throws CancelledException, PdbException {
        AbstractCompositeMsType type = (AbstractCompositeMsType)this.msType;
        boolean applyCpp = applyBaseClasses;
        if (type instanceof AbstractUnionMsType) {
            applyCpp = false;
            if (this.hasBaseClasses()) {
                this.pdbLogAndInfoMessage(this, "Unexpected base classes for union type: " + type.getName());
            }
        }
        if (this.isUnnamed()) {
            applyCpp = false;
        }
        if (applyCpp) {
            this.applyCpp(composite, type);
        } else {
            this.applyBasic(composite, type);
        }
    }

    private void applyBasic(Composite composite, AbstractCompositeMsType type) throws CancelledException, PdbException {
        boolean isClass = type instanceof AbstractClassMsType;
        int size = this.getSizeInt();
        FieldListTypeApplier fieldListApplier = FieldListTypeApplier.getFieldListApplierSpecial(this.applicator, type.getFieldDescriptorListRecordNumber());
        CompositeTypeApplier.clearComponents(composite);
        this.members = new ArrayList<DefaultPdbUniversalMember>();
        this.componentComments = new HashMap<Integer, String>();
        this.addMembers(composite, fieldListApplier);
        if (!DefaultCompositeMember.applyDataTypeMembers(composite, isClass, size, this.members, msg -> this.reconstructionWarn((String)msg), this.applicator.getCancelOnlyWrappingMonitor())) {
            CompositeTypeApplier.clearComponents(composite);
        }
        this.setComponentComments(composite);
    }

    private void setComponentComments(Composite composite) {
        if (composite instanceof Structure) {
            Structure structure = (Structure)composite;
            for (Map.Entry<Integer, String> entry : this.componentComments.entrySet()) {
                DataTypeComponent component = structure.getComponentAt(entry.getKey().intValue());
                if (component == null) {
                    this.pdbLogAndInfoMessage(this, "Could not set comment for 'missing' componenent " + entry.getKey() + " for: " + structure.getName());
                    return;
                }
                component.setComment(entry.getValue());
            }
        }
    }

    private void applyCpp(Composite composite, AbstractCompositeMsType type) throws PdbException, CancelledException {
        FieldListTypeApplier fieldListApplier = FieldListTypeApplier.getFieldListApplierSpecial(this.applicator, type.getFieldDescriptorListRecordNumber());
        CompositeTypeApplier.clearComponents(composite);
        this.members = new ArrayList<DefaultPdbUniversalMember>();
        this.componentComments = new HashMap<Integer, String>();
        this.addClassTypeBaseClasses(composite, fieldListApplier);
        this.addMembers(composite, fieldListApplier);
        if (!this.classType.validate()) {
            // empty if block
        }
        this.classType.createLayout(this.applicator.getPdbApplicatorOptions().getCompositeLayout(), this.applicator.getVbtManager(), this.applicator.getCancelOnlyWrappingMonitor());
    }

    private void reconstructionWarn(String msg) {
        if (msg.contains("failed to align") && this.hasHiddenComponents()) {
            msg = msg.replaceFirst("PDB", "PDB CLASS");
        }
        Msg.warn((Object)this, (Object)msg);
    }

    @Override
    void deferredApply() throws PdbException, CancelledException {
        if (this.isDeferred()) {
            this.applyInternal();
        }
    }

    @Override
    CompositeTypeApplier getDependencyApplier() {
        if (this.definitionApplier != null && this.definitionApplier instanceof CompositeTypeApplier) {
            return (CompositeTypeApplier)this.definitionApplier;
        }
        return this;
    }

    String getName() {
        return this.getMsType().getName();
    }

    @Override
    DataType getDataType() {
        if (this.resolved) {
            return this.resolvedDataType;
        }
        this.getOrCreateComposite();
        return this.dataType;
    }

    DataType getDataType(CategoryPath categoryPath, int ordinal) throws CancelledException, PdbException {
        if (!this.isUnnamed()) {
            return this.getDataType();
        }
        return this.mintNestedUnnamedDataType(categoryPath, ordinal);
    }

    private DataType mintNestedUnnamedDataType(CategoryPath categoryPath, int ordinal) throws CancelledException, PdbException {
        SymbolPath sp = this.getFixedSymbolPath();
        SymbolPath modifiedSymbolPath = new SymbolPath(sp.getParent(), sp.getName() + "_" + ordinal);
        ComboType c = CompositeTypeApplier.getOrCreateComposite(this.applicator, this, (AbstractCompositeMsType)this.msType, categoryPath, modifiedSymbolPath);
        this.applyInternal((Composite)c.dt());
        return c.dt();
    }

    @Override
    DataType getCycleBreakType() {
        if (this.isForwardReference() && this.definitionApplier != null && this.definitionApplier.isApplied()) {
            return this.definitionApplier.getDataType();
        }
        return this.dataType;
    }

    boolean hasUniqueName() {
        return ((AbstractCompositeMsType)this.msType).getMsProperty().hasUniqueName();
    }

    @Override
    BigInteger getSize() {
        return ((AbstractCompositeMsType)this.getDependencyApplier().getMsType()).getSize();
    }

    static final void clearComponents(Composite composite) {
        if (composite instanceof Structure) {
            ((Structure)composite).deleteAll();
        } else {
            while (composite.getNumComponents() > 0) {
                composite.delete(0);
            }
        }
    }

    private boolean hasBaseClasses() {
        AbstractCompositeMsType defType;
        if (this.definitionApplier == null) {
            if (this.isForwardReference()) {
                return false;
            }
            defType = (AbstractCompositeMsType)this.msType;
        } else {
            defType = (AbstractCompositeMsType)this.definitionApplier.getMsType();
        }
        MsTypeApplier applier = this.applicator.getTypeApplier(defType.getFieldDescriptorListRecordNumber());
        if (!(applier instanceof FieldListTypeApplier)) {
            return false;
        }
        FieldListTypeApplier fieldListApplier = (FieldListTypeApplier)applier;
        AbstractFieldListMsType fieldListType = (AbstractFieldListMsType)fieldListApplier.getMsType();
        if (fieldListType.getBaseClassList().size() != 0) {
            return true;
        }
        return fieldListType.getBaseClassList().size() != 0;
    }

    private boolean hasHiddenComponents() {
        AbstractCompositeMsType defType;
        if (this.definitionApplier == null) {
            if (this.isForwardReference()) {
                return false;
            }
            defType = (AbstractCompositeMsType)this.msType;
        } else {
            defType = (AbstractCompositeMsType)this.definitionApplier.getMsType();
        }
        MsTypeApplier applier = this.applicator.getTypeApplier(defType.getFieldDescriptorListRecordNumber());
        if (!(applier instanceof FieldListTypeApplier)) {
            return false;
        }
        FieldListTypeApplier fieldListApplier = (FieldListTypeApplier)applier;
        AbstractFieldListMsType fieldListType = (AbstractFieldListMsType)fieldListApplier.getMsType();
        return fieldListType.getMethodList().size() != 0 || fieldListType.getBaseClassList().size() != 0;
    }

    private void addClassTypeBaseClasses(Composite composite, FieldListTypeApplier fieldListApplier) throws PdbException {
        AbstractCompositeMsType type = (AbstractCompositeMsType)this.msType;
        for (MsTypeApplier baseApplierIterated : fieldListApplier.getBaseClassList()) {
            if (!(baseApplierIterated instanceof BaseClassTypeApplier)) {
                this.applicator.appendLogMsg(baseApplierIterated.getClass().getSimpleName() + " seen where BaseClassTypeApplier expected for " + type.getName());
                continue;
            }
            BaseClassTypeApplier baseTypeApplier = (BaseClassTypeApplier)baseApplierIterated;
            MsTypeApplier baseClassTypeApplier = this.applicator.getTypeApplier(baseTypeApplier.getBaseClassRecordNumber());
            if (!(baseClassTypeApplier instanceof CompositeTypeApplier)) {
                this.applicator.appendLogMsg(baseApplierIterated.getClass().getSimpleName() + " seen where CompositeTypeApplier expected for " + type.getName());
                continue;
            }
            AbstractMsType baseClassMsType = baseTypeApplier.getMsType();
            if (baseClassMsType instanceof AbstractBaseClassMsType) {
                this.applyDirectBaseClass((AbstractBaseClassMsType)baseClassMsType);
                continue;
            }
            if (baseClassMsType instanceof AbstractVirtualBaseClassMsType) {
                this.applyDirectVirtualBaseClass((AbstractVirtualBaseClassMsType)baseClassMsType);
                continue;
            }
            if (baseClassMsType instanceof AbstractIndirectVirtualBaseClassMsType) {
                this.applyIndirectVirtualBaseClass((AbstractIndirectVirtualBaseClassMsType)baseClassMsType);
                continue;
            }
            throw new AssertException("Unknown base class type: " + baseClassMsType.getClass().getSimpleName());
        }
    }

    private void applyDirectBaseClass(AbstractBaseClassMsType base) throws PdbException {
        CppCompositeType underlyingClassType = this.getUnderlyingClassType(base.getBaseClassRecordNumber());
        if (underlyingClassType == null) {
            return;
        }
        ClassFieldMsAttributes atts = base.getAttributes();
        int offset = DefaultPdbApplicator.bigIntegerToInt(this.applicator, base.getOffset());
        this.classType.addDirectBaseClass(underlyingClassType, CompositeTypeApplier.convertAttributes(atts), offset);
    }

    private void applyDirectVirtualBaseClass(AbstractVirtualBaseClassMsType base) throws PdbException {
        CppCompositeType underlyingCt = this.getUnderlyingClassType(base.getBaseClassRecordNumber());
        if (underlyingCt == null) {
            return;
        }
        DataType vbtptr = this.getVirtualBaseTablePointerDataType(base.getVirtualBasePointerRecordNumber());
        ClassFieldMsAttributes atts = base.getAttributes();
        int basePointerOffset = DefaultPdbApplicator.bigIntegerToInt(this.applicator, base.getBasePointerOffset());
        int offsetFromVbt = DefaultPdbApplicator.bigIntegerToInt(this.applicator, base.getBaseOffsetFromVbt());
        this.classType.addDirectVirtualBaseClass(underlyingCt, CompositeTypeApplier.convertAttributes(atts), basePointerOffset, vbtptr, offsetFromVbt);
    }

    private void applyIndirectVirtualBaseClass(AbstractIndirectVirtualBaseClassMsType base) throws PdbException {
        CppCompositeType underlyingCt = this.getUnderlyingClassType(base.getBaseClassRecordNumber());
        if (underlyingCt == null) {
            return;
        }
        DataType vbtptr = this.getVirtualBaseTablePointerDataType(base.getVirtualBasePointerRecordNumber());
        ClassFieldMsAttributes atts = base.getAttributes();
        int basePointerOffset = DefaultPdbApplicator.bigIntegerToInt(this.applicator, base.getBasePointerOffset());
        int offsetFromVbt = DefaultPdbApplicator.bigIntegerToInt(this.applicator, base.getBaseOffsetFromVbt());
        this.classType.addIndirectVirtualBaseClass(underlyingCt, CompositeTypeApplier.convertAttributes(atts), basePointerOffset, vbtptr, offsetFromVbt);
    }

    private CppCompositeType getUnderlyingClassType(RecordNumber recordNumber) {
        MsTypeApplier baseUnderlyingApplier = this.applicator.getTypeApplier(recordNumber);
        if (!(baseUnderlyingApplier instanceof CompositeTypeApplier)) {
            this.applicator.appendLogMsg(baseUnderlyingApplier.getClass().getSimpleName() + " seen where CompositeTypeApplier expected for base class.");
            return null;
        }
        CompositeTypeApplier baseApplier = (CompositeTypeApplier)baseUnderlyingApplier;
        CppCompositeType underlyingClassType = baseApplier.getClassType();
        if (underlyingClassType == null) {
            this.applicator.appendLogMsg("Underlying base class type is null.");
        }
        return underlyingClassType;
    }

    private DataType getVirtualBaseTablePointerDataType(RecordNumber recordNumber) {
        MsTypeApplier vbptrApplier = this.applicator.getTypeApplier(recordNumber);
        if (vbptrApplier != null && vbptrApplier instanceof PointerTypeApplier) {
            return vbptrApplier.getDataType();
        }
        this.applicator.appendLogMsg("Generating a generic Virtual Base Table Pointer.");
        return new PointerDataType();
    }

    private static CppCompositeType.ClassFieldAttributes convertAttributes(ClassFieldMsAttributes atts) {
        return new CppCompositeType.ClassFieldAttributes(switch (atts.getAccess()) {
            case ClassFieldMsAttributes.Access.PUBLIC -> CppCompositeType.Access.PUBLIC;
            case ClassFieldMsAttributes.Access.PROTECTED -> CppCompositeType.Access.PROTECTED;
            case ClassFieldMsAttributes.Access.PRIVATE -> CppCompositeType.Access.PRIVATE;
            default -> CppCompositeType.Access.BLANK;
        }, switch (atts.getProperty()) {
            case ClassFieldMsAttributes.Property.VIRTUAL -> CppCompositeType.Property.VIRTUAL;
            case ClassFieldMsAttributes.Property.STATIC -> CppCompositeType.Property.STATIC;
            case ClassFieldMsAttributes.Property.FRIEND -> CppCompositeType.Property.FRIEND;
            default -> CppCompositeType.Property.BLANK;
        });
    }

    private void addMembers(Composite composite, FieldListTypeApplier fieldListApplier) throws CancelledException, PdbException {
        AbstractCompositeMsType type = (AbstractCompositeMsType)this.msType;
        for (MsTypeApplier memberTypeApplierIterated : fieldListApplier.getMemberList()) {
            boolean handled = true;
            if (memberTypeApplierIterated instanceof MemberTypeApplier) {
                MemberTypeApplier memberTypeApplier = (MemberTypeApplier)memberTypeApplierIterated;
                String memberName = memberTypeApplier.getName();
                int offset = DefaultPdbApplicator.bigIntegerToInt(this.applicator, memberTypeApplier.getOffset());
                ClassFieldMsAttributes memberAttributes = memberTypeApplier.getAttribute();
                memberAttributes.getAccess();
                MsTypeApplier fieldApplier = memberTypeApplier.getFieldTypeApplier();
                DataType fieldDataType = null;
                if (fieldApplier instanceof CompositeTypeApplier) {
                    CompositeTypeApplier defApplier = ((CompositeTypeApplier)fieldApplier).getDefinitionApplier(CompositeTypeApplier.class);
                    if (defApplier != null) {
                        fieldApplier = defApplier;
                    }
                    fieldDataType = ((CompositeTypeApplier)fieldApplier).getDataType(ClassTypeUtils.getInternalsCategoryPath(this), this.members.size());
                }
                if (fieldDataType == null) {
                    fieldDataType = fieldApplier.getDataType();
                }
                boolean isFlexibleArray = fieldApplier instanceof ArrayTypeApplier ? ((ArrayTypeApplier)fieldApplier).isFlexibleArray() : false;
                if (fieldApplier instanceof CompositeTypeApplier && ((CompositeTypeApplier)fieldApplier).isUnnamed()) {
                    member = new DefaultPdbUniversalMember(this.applicator, memberName, fieldDataType, offset);
                    this.members.add(member);
                } else if (fieldDataType == null) {
                    if (fieldApplier instanceof PrimitiveTypeApplier && ((PrimitiveTypeApplier)fieldApplier).isNoType()) {
                        member = new DefaultPdbUniversalMember(this.applicator, memberName, fieldApplier, offset);
                        this.members.add(member);
                        this.componentComments.put(offset, "NO_TYPE");
                    } else {
                        this.applicator.appendLogMsg("PDB Warning: No conversion for " + memberName + " " + fieldApplier.getMsType().getClass().getSimpleName() + " in composite " + composite.getName());
                    }
                } else {
                    String memberComment = null;
                    if (fieldApplier instanceof PointerTypeApplier) {
                        PointerTypeApplier ptrApplier = (PointerTypeApplier)fieldApplier;
                        memberComment = ptrApplier.getPointerCommentField();
                    }
                    DefaultPdbUniversalMember member = new DefaultPdbUniversalMember(this.applicator, memberName, fieldApplier, offset, memberComment);
                    this.members.add(member);
                    this.classType.addMember(memberName, fieldDataType, isFlexibleArray, CompositeTypeApplier.convertAttributes(memberAttributes), offset, memberComment);
                }
            } else if (memberTypeApplierIterated instanceof EnumerateTypeApplier) {
                EnumerateTypeApplier enumerateTypeApplier = (EnumerateTypeApplier)memberTypeApplierIterated;
                String fieldName = enumerateTypeApplier.getName();
                Numeric numeric = enumerateTypeApplier.getNumeric();
                this.pdbLogAndInfoMessage(this, "Don't know how to apply EnumerateTypeApplier fieldName " + fieldName + " and value " + numeric + " within " + this.msType.getName());
            } else if (memberTypeApplierIterated instanceof VirtualFunctionTablePointerTypeApplier) {
                VirtualFunctionTablePointerTypeApplier vtPtrApplier = (VirtualFunctionTablePointerTypeApplier)memberTypeApplierIterated;
                String vftPtrMemberName = vtPtrApplier.getMemberName();
                int offset = vtPtrApplier.getOffset();
                DefaultPdbUniversalMember member = new DefaultPdbUniversalMember(this.applicator, vftPtrMemberName, vtPtrApplier, offset);
                this.members.add(member);
                this.classType.addVirtualFunctionTablePointer(vftPtrMemberName, vtPtrApplier.getDataType(), offset);
            } else if (memberTypeApplierIterated instanceof NestedTypeApplier) {
                NestedTypeApplier nestedTypeApplier = (NestedTypeApplier)memberTypeApplierIterated;
                String memberTypeName = nestedTypeApplier.getTypeName();
                String memberName = nestedTypeApplier.getMemberName();
                if (type.getName().equals(memberTypeName)) {
                    continue;
                }
            } else if (memberTypeApplierIterated instanceof NoTypeApplier) {
                AbstractMsType msNoType = memberTypeApplierIterated.getMsType();
                if (!(msNoType instanceof AbstractStaticMemberMsType)) {
                    handled = false;
                }
            } else {
                handled = false;
            }
            if (handled) continue;
            this.applicator.appendLogMsg(memberTypeApplierIterated.getClass().getSimpleName() + " with contained " + memberTypeApplierIterated.getMsType().getClass().getSimpleName() + " unexpected for " + this.msType.getName());
        }
    }

    private record ComboType(DataType dt, CppCompositeType ct) {
    }
}

