/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DenseIntegerArray;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class NameTable {
    private static final long HEADER_MAGIC = 0xEFFEEFFEL;
    private AbstractPdb pdb;
    private int nameBufferSize = 0;
    private int numPairs = 0;
    private int domainSize = 0;
    private DenseIntegerArray presentList = new DenseIntegerArray();
    private DenseIntegerArray deletedList = new DenseIntegerArray();
    private String[] names;
    private int[] streamNumbers;
    private Map<String, Integer> streamNumbersByName = new HashMap<String, Integer>();
    private Map<Integer, String> namesByStreamNumber = new HashMap<Integer, String>();
    private Map<Integer, Map<Integer, String>> stringTablesByStreamNumber = new HashMap<Integer, Map<Integer, String>>();
    private Map<Integer, String> namesByOffset;

    public NameTable(AbstractPdb pdb) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
    }

    public String getNameFromStreamNumber(int index) {
        return this.namesByStreamNumber.get(index);
    }

    public int getStreamNumberFromName(String name) {
        Integer x = this.streamNumbersByName.getOrDefault(name, -1);
        return x;
    }

    public String getNameStringFromOffset(int offset) {
        if (this.namesByOffset == null) {
            return null;
        }
        return this.namesByOffset.get(offset);
    }

    public void forTestingOnlyAddOffsetNamePair(int offset, String name) {
        if (this.namesByOffset == null) {
            this.namesByOffset = new HashMap<Integer, String>();
        }
        this.namesByOffset.put(offset, name);
    }

    void deserializeDirectory(PdbByteReader reader) throws IOException, PdbException, CancelledException {
        this.nameBufferSize = reader.parseInt();
        PdbByteReader nameBufferReader = reader.getSubPdbByteReader(this.nameBufferSize);
        this.numPairs = reader.parseInt();
        this.domainSize = reader.parseInt();
        if (this.numPairs > 0x100000) {
            throw new PdbException("Num Pairs too large.");
        }
        if (this.numPairs < 0) {
            throw new PdbException("Illegal negative value.");
        }
        this.names = new String[this.numPairs];
        this.streamNumbers = new int[this.numPairs];
        this.presentList.parse(reader, this.pdb.getMonitor());
        this.deletedList.parse(reader, this.pdb.getMonitor());
        for (int i = 0; i < this.numPairs; ++i) {
            this.pdb.checkCancelled();
            int bufOffset = reader.parseInt();
            int streamNumber = reader.parseInt();
            nameBufferReader.setIndex(bufOffset);
            String name = nameBufferReader.parseNullTerminatedString(this.pdb.getPdbReaderOptions().getOneByteCharset());
            this.streamNumbers[i] = streamNumber;
            this.names[i] = name;
            this.namesByStreamNumber.put(streamNumber, name);
            this.streamNumbersByName.put(name, streamNumber);
        }
        this.deserializeNameTableStreams();
    }

    void deserializeNameTableStreams() throws IOException, PdbException, CancelledException {
        for (int streamNumber : this.streamNumbers) {
            HashMap<Integer, String> stringsByOffset;
            block5: {
                PdbByteReader reader;
                block6: {
                    this.pdb.checkCancelled();
                    stringsByOffset = new HashMap<Integer, String>();
                    reader = this.pdb.getReaderForStreamNumber(streamNumber);
                    if (reader.getLimit() < 12) break block5;
                    long hdrMagic = reader.parseUnsignedIntVal();
                    int hdrVer = reader.parseInt();
                    if (hdrMagic != 0xEFFEEFFEL || hdrVer == 0) break block6;
                    switch (hdrVer) {
                        case 1: {
                            int length = reader.parseInt();
                            PdbByteReader stringReader = reader.getSubPdbByteReader(length);
                            while (stringReader.hasMore()) {
                                this.pdb.checkCancelled();
                                int offset = stringReader.getIndex();
                                String string = stringReader.parseNullTerminatedUtf8String();
                                stringsByOffset.put(offset, string);
                            }
                            break block0;
                        }
                    }
                    break block5;
                }
                reader.setIndex(reader.getIndex() - 8);
            }
            this.stringTablesByStreamNumber.put(streamNumber, stringsByOffset);
        }
        int namesStreamNumber = this.getStreamNumberFromName("/names");
        this.namesByOffset = this.stringTablesByStreamNumber.get(namesStreamNumber);
    }

    protected String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append("NameTable---------------------------------------------------");
        builder.append("\nnameBufferSize: ");
        builder.append(this.nameBufferSize);
        builder.append("\nnumPairs: ");
        builder.append(this.numPairs);
        builder.append("\ndomainSize: ");
        builder.append(this.domainSize);
        builder.append("\nmaxPossiblePresent: ");
        builder.append(this.presentList.getMaxPossible());
        builder.append("\nPresent: {");
        boolean firstSeen = false;
        int i = 0;
        while ((long)i < this.presentList.getMaxPossible()) {
            if (this.presentList.contains(i)) {
                if (firstSeen) {
                    builder.append(", ");
                } else {
                    firstSeen = true;
                }
                builder.append(i);
            }
            ++i;
        }
        builder.append("}");
        builder.append("\nmaxPossibleDeleted: ");
        builder.append(this.deletedList.getMaxPossible());
        builder.append("\nDeleted: {");
        firstSeen = false;
        i = 0;
        while ((long)i < this.deletedList.getMaxPossible()) {
            if (this.deletedList.contains(i)) {
                if (firstSeen) {
                    builder.append(", ");
                } else {
                    firstSeen = true;
                }
                builder.append(i);
            }
            ++i;
        }
        builder.append("}\n");
        builder.append("------------------------------------------------------------\n");
        for (String name : this.streamNumbersByName.keySet()) {
            builder.append(name);
            builder.append(" : ");
            builder.append(this.streamNumbersByName.get(name));
            builder.append("\n");
        }
        builder.append("------------------------------------------------------------\n");
        Iterator<Object> iterator = this.namesByStreamNumber.keySet().iterator();
        while (iterator.hasNext()) {
            int streamNumber = (Integer)iterator.next();
            builder.append(streamNumber);
            builder.append(" : ");
            builder.append(this.namesByStreamNumber.get(streamNumber));
            builder.append("\n");
        }
        builder.append("End NameTable-----------------------------------------------\n");
        return builder.toString();
    }
}

