/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.decorators;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import org.jungrapht.visualization.decorators.ExpandXY;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.PolarPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArticulatedEdgeShapeFunctions {
    private static Logger log = LoggerFactory.getLogger(ArticulatedEdgeShapeFunctions.class);

    public static Shape makeUnitShape(List<Point> list) {
        GeneralPath path = new GeneralPath();
        for (int i = 0; i < list.size(); ++i) {
            Point pt = list.get(i);
            if (i == 0) {
                path.moveTo(pt.x, pt.y);
                log.trace("moveTo({}, {})", (Object)pt.x, (Object)pt.y);
                continue;
            }
            path.lineTo(pt.x, pt.y);
            log.trace("lineTo({}, {})", (Object)pt.x, (Object)pt.y);
        }
        Point firstPoint = list.get(0);
        Point lastPoint = list.get(list.size() - 1);
        Point sum = lastPoint.add(-firstPoint.x, -firstPoint.y);
        PolarPoint diffPolar = PolarPoint.cartesianToPolar((Point)sum);
        double theta = diffPolar.theta;
        log.trace("theta is {}", (Object)theta);
        AffineTransform at = AffineTransform.getScaleInstance(1.0 / diffPolar.radius, 1.0 / diffPolar.radius);
        at.rotate(-theta);
        at.translate(-list.get((int)0).x, -list.get((int)0).y);
        Shape theShape = at.createTransformedShape(path);
        return ExpandXY.of(theShape);
    }

    public static Shape makeReverseUnitShape(List<Point> list) {
        Shape shape;
        if (list.size() > 2 && (shape = ArticulatedEdgeShapeFunctions.makeUnitShape(list)) instanceof Path2D) {
            ArrayList<Point> pathPoints = new ArrayList<Point>();
            float[] coords = new float[6];
            Path2D path = (Path2D)shape;
            PathIterator iterator = path.getPathIterator(null, 1.0);
            while (!iterator.isDone()) {
                int type = iterator.currentSegment(coords);
                switch (type) {
                    case 0: 
                    case 1: {
                        pathPoints.add(Point.of((double)coords[0], (double)coords[1]));
                    }
                }
                iterator.next();
            }
            for (int i = 1; i < pathPoints.size() - 1; ++i) {
                Point p = (Point)pathPoints.get(i);
                double y = -p.y;
                double x = 1.0 - p.x;
                pathPoints.set(i, Point.of((double)x, (double)y));
            }
            GeneralPath newPath = new GeneralPath();
            Point p = (Point)pathPoints.get(0);
            ((Path2D)newPath).moveTo(p.x, p.y);
            for (int i = 1; i < pathPoints.size() - 1; ++i) {
                p = (Point)pathPoints.get(i);
                ((Path2D)newPath).lineTo(p.x, p.y);
            }
            p = (Point)pathPoints.get(pathPoints.size() - 1);
            ((Path2D)newPath).lineTo(p.x, p.y);
            return newPath;
        }
        return ArticulatedEdgeShapeFunctions.makeUnitShape(list);
    }
}

