/*
 * Decompiled with CFR 0.152.
 */
package help.validator.model;

import help.HelpBuildUtils;
import help.validator.location.DirectoryHelpModuleLocation;
import help.validator.location.HelpModuleLocation;
import help.validator.model.AnchorDefinition;
import help.validator.model.HREF;
import help.validator.model.HelpFile;
import help.validator.model.IMG;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class HelpTopic
implements Comparable<HelpTopic> {
    private final HelpModuleLocation help;
    private final Path topicFile;
    private final Path relativePath;
    private Map<Path, HelpFile> helpFiles = new LinkedHashMap<Path, HelpFile>();

    public static HelpTopic fromHTMLFile(Path topicFile) {
        Path topic = topicFile.getParent();
        Path topicsDir = topic.getParent();
        Path helpDir = topicsDir.getParent();
        DirectoryHelpModuleLocation loc = new DirectoryHelpModuleLocation(helpDir.toFile());
        HelpTopic helpTopic = new HelpTopic(loc, topicFile);
        return helpTopic;
    }

    public HelpTopic(HelpModuleLocation help, Path topicFile) {
        this.help = help;
        this.topicFile = topicFile;
        Path helpDir = help.getHelpLocation();
        Path unknownFSRelativePath = helpDir.relativize(topicFile);
        this.relativePath = HelpBuildUtils.toDefaultFS(unknownFSRelativePath);
        this.loadHelpFiles(topicFile);
    }

    public Path getTopicFile() {
        return this.topicFile;
    }

    private void loadHelpFiles(Path dir) {
        final PathMatcher matcher = dir.getFileSystem().getPathMatcher("glob:**/*.{[Hh][Tt][Mm],[Hh][Tt][Mm][Ll]}");
        final Path dirDefaultFS = HelpBuildUtils.toDefaultFS(dir);
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (matcher.matches(file)) {
                        Path fileDefaultFS = HelpBuildUtils.toDefaultFS(file);
                        Path relFilePath = dirDefaultFS.relativize(fileDefaultFS);
                        relFilePath = HelpTopic.this.relativePath.resolve(relFilePath);
                        HelpTopic.this.helpFiles.put(relFilePath, new HelpFile(HelpTopic.this.help, file));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            System.err.println("Error loading help files: " + dir.toUri());
            e.printStackTrace(System.err);
        }
    }

    void addHelpFile(Path relPath, HelpFile helpFile) {
        this.helpFiles.put(relPath, helpFile);
    }

    public Collection<HREF> getAllHREFs() {
        if (this.topicFile.getFileSystem() != FileSystems.getDefault()) {
            return Collections.emptyList();
        }
        ArrayList<HREF> list = new ArrayList<HREF>();
        for (HelpFile helpFile : this.helpFiles.values()) {
            list.addAll(helpFile.getAllHREFs());
        }
        return list;
    }

    public Collection<IMG> getAllIMGs() {
        if (this.topicFile.getFileSystem() != FileSystems.getDefault()) {
            return Collections.emptyList();
        }
        ArrayList<IMG> list = new ArrayList<IMG>();
        for (HelpFile helpFile : this.helpFiles.values()) {
            list.addAll(helpFile.getAllIMGs());
        }
        return list;
    }

    public Collection<AnchorDefinition> getAllAnchorDefinitions() {
        ArrayList<AnchorDefinition> list = new ArrayList<AnchorDefinition>();
        for (HelpFile helpFile : this.helpFiles.values()) {
            list.addAll(helpFile.getAllAnchorDefinitions());
        }
        return list;
    }

    public Collection<HelpFile> getHelpFiles() {
        return this.helpFiles.values();
    }

    Path getRelativePath() {
        return this.relativePath;
    }

    public HelpModuleLocation getHelpDirectory() {
        return this.help;
    }

    public String getName() {
        return this.topicFile.getFileName().toString();
    }

    @Override
    public int compareTo(HelpTopic o) {
        return this.topicFile.compareTo(o.topicFile);
    }

    public String toString() {
        return this.topicFile.toString();
    }
}

