/*
 * Decompiled with CFR 0.152.
 */
package help;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.util.SystemUtilities;
import help.GHelpBroker;
import help.GHelpHTMLEditorKit;
import help.Help;
import help.HelpService;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GHelpSet
extends HelpSet {
    private static java.util.Map<HelpSet, Map> helpSetsToCombinedMaps = new HashMap<HelpSet, Map>();
    private static java.util.Map<HelpSet, Map> helpSetsToLocalMaps = new HashMap<HelpSet, Map>();
    private Logger LOG = LogManager.getLogger(GHelpSet.class);
    private GHelpMap combinedMapWrapper;
    private GHelpMap localMapWrapper;

    public GHelpSet(ClassLoader loader, URL helpset) throws HelpSetException {
        super(loader, helpset);
        this.init();
    }

    private void init() {
        String type = "text/html";
        String editorKit = GHelpHTMLEditorKit.class.getName();
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.setKeyData(kitTypeRegistry, type, editorKit);
        this.setKeyData(kitLoaderRegistry, type, classLoader);
        this.initializeCombinedMapWrapper();
    }

    public HelpBroker createHelpBroker() {
        return new GHelpBroker(this);
    }

    public Map getLocalMap() {
        Map localMap = super.getLocalMap();
        if (localMap == null) {
            return null;
        }
        this.initializeLocalMapWrapper();
        return this.localMapWrapper;
    }

    private void initializeLocalMapWrapper() {
        if (this.localMapWrapper == null) {
            Map localMap = super.getLocalMap();
            helpSetsToLocalMaps.put(this, localMap);
            this.localMapWrapper = new GHelpMap(localMap);
        }
    }

    public Map getCombinedMap() {
        return this.combinedMapWrapper;
    }

    private void initializeCombinedMapWrapper() {
        if (this.combinedMapWrapper == null) {
            Map combinedMap = super.getCombinedMap();
            helpSetsToCombinedMaps.put(this, combinedMap);
            this.combinedMapWrapper = new GHelpMap(combinedMap);
        }
    }

    public String toString() {
        return this.getHelpSetURL().toString();
    }

    private class GHelpMap
    implements Map {
        private final Map mapDelegate;

        private GHelpMap(Map mapDelegate) {
            this.mapDelegate = mapDelegate;
        }

        public Enumeration<?> getAllIDs() {
            return this.mapDelegate.getAllIDs();
        }

        public Map.ID getClosestID(URL url) {
            Map.ID closestID = this.mapDelegate.getClosestID(url);
            if (closestID != null) {
                return closestID;
            }
            GHelpSet.this.LOG.trace("Help Set \"" + GHelpSet.this + "\" does not contain ID for URL: " + url);
            Set<Map.Entry<HelpSet, Map>> entrySet = helpSetsToCombinedMaps.entrySet();
            for (Map.Entry<HelpSet, Map> entry : entrySet) {
                Map map = entry.getValue();
                closestID = map.getClosestID(url);
                if (closestID == null) continue;
                return closestID;
            }
            GHelpSet.this.LOG.trace("No ID found in any HelpSet for URL: " + url);
            return null;
        }

        public Map.ID getIDFromURL(URL url) {
            return this.mapDelegate.getIDFromURL(url);
        }

        public Enumeration<?> getIDs(URL url) {
            return this.mapDelegate.getIDs(url);
        }

        public URL getURLFromID(Map.ID id) throws MalformedURLException {
            URL URL2 = this.mapDelegate.getURLFromID(id);
            if (URL2 != null) {
                return URL2;
            }
            Set<Map.Entry<HelpSet, Map>> entrySet = helpSetsToCombinedMaps.entrySet();
            for (Map.Entry<HelpSet, Map> entry : entrySet) {
                Map map = entry.getValue();
                URL2 = map.getURLFromID(id);
                if (URL2 == null) continue;
                return URL2;
            }
            GHelpSet.this.LOG.trace("No URL found in any HelpSet for ID: " + id);
            URL2 = this.tryToCreateURLFromID(id.id);
            if (URL2 != null) {
                return URL2;
            }
            return null;
        }

        private URL tryToCreateURLFromID(String id) {
            URL fileURL = this.createFileURL(id);
            if (fileURL != null) {
                return fileURL;
            }
            URL rawURL = this.createRawURL(id);
            return rawURL;
        }

        private URL createRawURL(String id) {
            URL url = null;
            try {
                url = new URL(id);
            }
            catch (MalformedURLException e) {
                GHelpSet.this.LOG.trace("ID is not a URL; tried to make URL from string: " + id);
                return null;
            }
            try {
                InputStream inputStream = url.openStream();
                inputStream.close();
                return url;
            }
            catch (IOException e) {
                GHelpSet.this.LOG.trace("ID is not a URL; unable to read URL: " + url);
                return null;
            }
        }

        private URL createFileURL(String id) {
            ResourceFile helpFile = this.fileFromID(id);
            if (!helpFile.exists()) {
                GHelpSet.this.LOG.trace("ID is not a file; tried: " + helpFile);
                return null;
            }
            try {
                return helpFile.toURL();
            }
            catch (MalformedURLException e) {
                GHelpSet.this.LOG.trace("ID is not a URL; tried to make URL from file: " + helpFile);
                return null;
            }
        }

        private ResourceFile fileFromID(String id) {
            ResourceFile installDir = Application.getInstallationDirectory();
            ResourceFile helpFile = new ResourceFile(installDir, id);
            return helpFile;
        }

        public boolean isID(URL url) {
            return this.mapDelegate.isID(url);
        }

        public boolean isValidID(String id, HelpSet hs) {
            HelpService service = Help.getHelpService();
            if (!service.helpExists()) {
                return true;
            }
            boolean isValid = this.mapDelegate.isValidID(id, hs);
            if (isValid) {
                return true;
            }
            Set<Map.Entry<HelpSet, Map>> entrySet = helpSetsToCombinedMaps.entrySet();
            for (Map.Entry<HelpSet, Map> entry : entrySet) {
                Map map = entry.getValue();
                if (!map.isValidID(id, hs)) continue;
                return true;
            }
            return this.ignoreExternalHelp(id);
        }

        private boolean ignoreExternalHelp(String id) {
            if (id.startsWith("help/topics")) {
                return false;
            }
            URL url = this.tryToCreateURLFromID(id);
            if (url != null) {
                return true;
            }
            return SystemUtilities.isInDevelopmentMode();
        }
    }
}

