/*
 * Decompiled with CFR 0.152.
 */
package help;

import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Objects;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpNavigator;
import javax.help.JHelpTOCNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.TreeItem;
import javax.help.TreeItemFactory;
import javax.help.event.HelpModelEvent;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicTOCCellRenderer;
import javax.help.plaf.basic.BasicTOCNavigatorUI;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CustomTOCView
extends TOCView {
    private CustomTOCNavigatorUI ui;
    private boolean isSelectingNodeInternally;

    public CustomTOCView(HelpSet hs, String name, String label, Hashtable params) {
        this(hs, name, label, hs.getLocale(), params);
    }

    public CustomTOCView(HelpSet hs, String name, String label, Locale locale, Hashtable params) {
        super(hs, name, label, locale, params);
    }

    public Component createNavigator(HelpModel model) {
        JHelpTOCNavigator helpTOCNavigator = new JHelpTOCNavigator((NavigatorView)this, model){

            public void setUI(HelpNavigatorUI newUI) {
                CustomTOCView.this.ui = new CustomTOCNavigatorUI(this);
                super.setUI((HelpNavigatorUI)CustomTOCView.this.ui);
            }
        };
        return helpTOCNavigator;
    }

    public HelpModel getHelpModel() {
        if (this.ui == null) {
            return null;
        }
        return this.ui.getHelpModel();
    }

    public DefaultMutableTreeNode getDataAsTree() {
        URL url;
        DefaultMutableTreeNode superNode = super.getDataAsTree();
        if (superNode.getChildCount() == 0) {
            return superNode;
        }
        Hashtable viewParameters = this.getParameters();
        String TOCData = (String)viewParameters.get("data");
        HelpSet helpSet = this.getHelpSet();
        URL helpSetURL = helpSet.getHelpSetURL();
        try {
            url = new URL(helpSetURL, TOCData);
        }
        catch (Exception ex) {
            throw new Error("Unable to create tree for view data: " + ex);
        }
        return CustomTOCView.parse((URL)url, (HelpSet)helpSet, (Locale)helpSet.getLocale(), (TreeItemFactory)new CustomDefaultTOCFactory(), (TOCView)this);
    }

    class CustomTOCNavigatorUI
    extends BasicTOCNavigatorUI {
        private static final String ROOT_TOC_ID = "Root";

        public CustomTOCNavigatorUI(JHelpTOCNavigator b) {
            super(b);
        }

        public void installUI(JComponent c) {
            super.installUI(c);
            this.tree.setExpandsSelectedPaths(true);
        }

        protected void setCellRenderer(NavigatorView view, JTree tree) {
            Map map = view.getHelpSet().getCombinedMap();
            tree.setCellRenderer((TreeCellRenderer)((Object)new CustomCellRenderer(map, (TOCView)view)));
            ToolTipManager.sharedInstance().registerComponent(tree);
        }

        public HelpModel getHelpModel() {
            JHelpNavigator helpNavigator = this.getHelpNavigator();
            return helpNavigator.getModel();
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (CustomTOCView.this.isSelectingNodeInternally) {
                return;
            }
            JHelpNavigator navigator = this.getHelpNavigator();
            HelpModel helpModel = navigator.getModel();
            TOCItem treeItem = this.getSelectedItem(e, navigator);
            if (treeItem == null) {
                return;
            }
            TOCItem item = treeItem;
            String presentation = item.getPresentation();
            if (presentation != null) {
                return;
            }
            CustomTreeItemDecorator customItem = (CustomTreeItemDecorator)item;
            Map.ID itemId = this.getId(customItem, helpModel);
            if (itemId == null) {
                Msg.debug((Object)((Object)this), (Object)("No help ID for " + item));
                return;
            }
            String customDisplayText = customItem.getDisplayText();
            try {
                helpModel.setCurrentID(itemId, customDisplayText, navigator);
            }
            catch (InvalidHelpSetContextException ex) {
                Msg.error((Object)((Object)this), (Object)"Exception setting new help item ID", (Throwable)ex);
            }
        }

        private Map.ID getId(CustomTreeItemDecorator item, HelpModel helpModel) {
            Map.ID itemId = item.getID();
            if (itemId != null) {
                return itemId;
            }
            String tocID = item.getTocID();
            if (Objects.equals(tocID, ROOT_TOC_ID)) {
                HelpSet hs = helpModel.getHelpSet();
                return hs.getHomeID();
            }
            return null;
        }

        private TOCItem getSelectedItem(TreeSelectionEvent e, JHelpNavigator navigator) {
            TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
            if (newLeadSelectionPath == null) {
                navigator.setSelectedItems(null);
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)newLeadSelectionPath.getLastPathComponent();
            TOCItem treeItem = (TOCItem)node.getUserObject();
            navigator.setSelectedItems(new TreeItem[]{treeItem});
            return treeItem;
        }

        public synchronized void idChanged(HelpModelEvent e) {
            this.selectNodeForID(e.getURL(), e.getID());
        }

        private void selectNodeForID(URL url, Map.ID ID2) {
            TreePath path;
            if (ID2 == null) {
                ID2 = this.getClosestID(url);
            }
            if (this.isAlreadySelected(path = this.tree.getSelectionPath(), ID2)) {
                return;
            }
            DefaultMutableTreeNode node = this.getNodeForID(this.topNode, ID2);
            if (node != null) {
                CustomTOCView.this.isSelectingNodeInternally = true;
                TreePath newPath = new TreePath(node.getPath());
                this.tree.setSelectionPath(newPath);
                this.tree.scrollPathToVisible(newPath);
                CustomTOCView.this.isSelectingNodeInternally = false;
                return;
            }
            if (url == null) {
                this.clearSelection();
                return;
            }
            String urlString = url.toExternalForm();
            int anchorIndex = urlString.indexOf(35);
            if (anchorIndex < 0) {
                this.clearSelection();
                return;
            }
            urlString = urlString.substring(0, anchorIndex);
            try {
                URL newURL = new URL(urlString);
                this.selectNodeForID(newURL, null);
            }
            catch (MalformedURLException e) {
                Msg.debug((Object)((Object)this), (Object)("Unexpected error create a help URL from an existing URL: " + urlString), (Throwable)e);
            }
        }

        private Map.ID getClosestID(URL url) {
            HelpModel helpModel = this.toc.getModel();
            HelpSet helpSet = helpModel.getHelpSet();
            Map combinedMap = helpSet.getCombinedMap();
            return combinedMap.getClosestID(url);
        }

        private boolean isAlreadySelected(TreePath path, Map.ID id) {
            if (path == null) {
                return false;
            }
            Object pathComponent = path.getLastPathComponent();
            if (!(pathComponent instanceof DefaultMutableTreeNode)) {
                return false;
            }
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)pathComponent;
            TOCItem item = (TOCItem)treeNode.getUserObject();
            if (item == null) {
                return false;
            }
            Map.ID selectedID = item.getID();
            return selectedID != null && selectedID.equals((Object)id);
        }

        private DefaultMutableTreeNode getNodeForID(DefaultMutableTreeNode node, Map.ID ID2) {
            if (ID2 == null) {
                return null;
            }
            if (this.isNodeID(node, ID2)) {
                return node;
            }
            int childCount = node.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                DefaultMutableTreeNode matchingNode = this.getNodeForID((DefaultMutableTreeNode)node.getChildAt(i), ID2);
                if (matchingNode == null) continue;
                return matchingNode;
            }
            return null;
        }

        private boolean isNodeID(DefaultMutableTreeNode node, Map.ID ID2) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof TOCItem)) {
                return false;
            }
            TOCItem item = (TOCItem)userObject;
            Map.ID nodeID = item.getID();
            if (nodeID == null) {
                return false;
            }
            return nodeID.equals((Object)ID2);
        }

        private void clearSelection() {
            CustomTOCView.this.isSelectingNodeInternally = true;
            this.tree.clearSelection();
            CustomTOCView.this.isSelectingNodeInternally = false;
        }
    }

    public static class CustomDefaultTOCFactory
    extends TOCView.DefaultTOCFactory {
        public TreeItem createItem(String tagName, Hashtable atts, HelpSet hs, Locale locale) {
            try {
                return this.doCreateItem(tagName, atts, hs, locale);
            }
            catch (Exception e) {
                Msg.error((Object)((Object)this), (Object)"Unexected error creating a TOC item", (Throwable)e);
                throw new RuntimeException("Unexpected error creating a TOC item", e);
            }
        }

        private TreeItem doCreateItem(String tagName, Hashtable atts, HelpSet hs, Locale locale) {
            TreeItem item = super.createItem(tagName, atts, hs, locale);
            CustomTreeItemDecorator newItem = new CustomTreeItemDecorator((TOCItem)item);
            if (atts != null) {
                String displayText = (String)atts.get("display");
                newItem.setDisplayText(displayText);
                String tocID = (String)atts.get("toc_id");
                newItem.setTocID(tocID);
            }
            return newItem;
        }
    }

    public static class CustomTreeItemDecorator
    extends TOCItem {
        private final TOCItem wrappedItem;
        private String displayText;
        private String tocID;
        private URL cachedURL;

        public CustomTreeItemDecorator(TOCItem wrappedItem) {
            super(wrappedItem.getID(), wrappedItem.getImageID(), wrappedItem.getHelpSet(), wrappedItem.getLocale());
            this.wrappedItem = wrappedItem;
        }

        void setDisplayText(String text) {
            this.displayText = text;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        void setTocID(String tocID) {
            this.tocID = tocID;
        }

        public String getTocID() {
            return this.tocID;
        }

        public boolean equals(Object obj) {
            return this.wrappedItem.equals(obj);
        }

        public int getExpansionType() {
            return this.wrappedItem.getExpansionType();
        }

        public HelpSet getHelpSet() {
            return this.wrappedItem.getHelpSet();
        }

        public Map.ID getID() {
            return this.wrappedItem.getID();
        }

        public Map.ID getImageID() {
            return this.wrappedItem.getImageID();
        }

        public Locale getLocale() {
            return this.wrappedItem.getLocale();
        }

        public String getMergeType() {
            return this.wrappedItem.getMergeType();
        }

        public String getName() {
            return this.wrappedItem.getName();
        }

        public String getPresentation() {
            return this.wrappedItem.getPresentation();
        }

        public String getPresentationName() {
            return this.wrappedItem.getPresentationName();
        }

        public URL getURL() {
            if (this.cachedURL == null) {
                this.cachedURL = this.wrappedItem.getURL();
            }
            return this.cachedURL;
        }

        public int hashCode() {
            return this.wrappedItem.hashCode();
        }

        public void setExpansionType(int type) {
            this.wrappedItem.setExpansionType(type);
        }

        public void setHelpSet(HelpSet hs) {
            this.wrappedItem.setHelpSet(hs);
        }

        public void setID(Map.ID id) {
            this.wrappedItem.setID(id);
        }

        public void setMergeType(String mergeType) {
            this.wrappedItem.setMergeType(mergeType);
        }

        public void setName(String name) {
            this.wrappedItem.setName(name);
        }

        public void setPresentation(String presentation) {
            this.wrappedItem.setPresentation(presentation);
        }

        public void setPresentationName(String presentationName) {
            this.wrappedItem.setPresentationName(presentationName);
        }

        public String toString() {
            return this.displayText;
        }
    }

    static class CustomCellRenderer
    extends BasicTOCCellRenderer {
        public CustomCellRenderer(Map map, TOCView view) {
            super(map, view);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean isFocused) {
            CustomCellRenderer renderer = (CustomCellRenderer)((Object)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, isFocused));
            TOCItem item = (TOCItem)((DefaultMutableTreeNode)value).getUserObject();
            if (item == null) {
                return renderer;
            }
            CustomTreeItemDecorator customItem = (CustomTreeItemDecorator)item;
            renderer.setText(customItem.getDisplayText());
            if (!SystemUtilities.isInDevelopmentMode()) {
                return renderer;
            }
            URL url = customItem.getURL();
            if (url != null) {
                renderer.setToolTipText(url.toExternalForm());
                return renderer;
            }
            Map.ID id = customItem.getID();
            if (id != null) {
                renderer.setToolTipText("Missing Help - " + id.id + " in '" + id.hs + "' help set");
                return renderer;
            }
            return renderer;
        }
    }
}

