/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import generic.stl.Pair;
import ghidra.feature.fid.db.FidDB;
import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.db.LibraryRecord;
import ghidra.feature.fid.db.RelationType;
import ghidra.feature.fid.hash.FidHashQuad;
import ghidra.feature.fid.hash.FidHasher;
import ghidra.feature.fid.service.FidPopulateResult;
import ghidra.feature.fid.service.FidService;
import ghidra.framework.Application;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;

class FidServiceLibraryIngest {
    private static final int MAXIMUM_NUMBER_OF_NAME_RESOLUTION_RELATIONS = 12;
    private FidDB fidDb;
    private FidService service;
    private String libraryFamilyName;
    private String libraryVersion;
    private String libraryVariant;
    private List<DomainFile> programFiles;
    private Predicate<Pair<Function, FidHashQuad>> functionFilter;
    private LanguageID languageId;
    private List<LibraryRecord> linkLibraries;
    private TaskMonitor monitor;
    private LibraryRecord library = null;
    private CompilerSpec compilerSpec = null;
    private Map<FunctionRecord, Set<ChildSymbol>> unresolvedSymbols = new HashMap<FunctionRecord, Set<ChildSymbol>>();
    private TreeSet<Long> globalUniqueFunction = new TreeSet();
    private FidPopulateResult result = null;
    private TreeMap<String, FidPopulateResult.Count> childHistogram = new TreeMap();

    public FidServiceLibraryIngest(FidDB fidDb, FidService service, String libraryFamilyName, String libraryVersion, String libraryVariant, List<DomainFile> programFiles, Predicate<Pair<Function, FidHashQuad>> functionFilter, LanguageID languageId, List<LibraryRecord> linkLibraries, TaskMonitor monitor) {
        this.fidDb = fidDb;
        this.service = service;
        this.libraryFamilyName = libraryFamilyName;
        this.libraryVersion = libraryVersion;
        this.libraryVariant = libraryVariant;
        this.programFiles = programFiles;
        this.functionFilter = functionFilter;
        this.languageId = languageId;
        this.linkLibraries = linkLibraries;
        this.monitor = monitor;
        if (languageId == null) {
            throw new IllegalArgumentException("LanugageID can't be null");
        }
    }

    public void markCommonChildReferences(List<String> symbols) {
        if (symbols == null) {
            return;
        }
        for (String symbol : symbols) {
            FidPopulateResult.Count count = new FidPopulateResult.Count();
            count.count = 0;
            count.isVeryCommon = true;
            this.childHistogram.put(symbol, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FidPopulateResult create() throws CancelledException, VersionException, IOException {
        this.monitor.setMessage("Populating library from programs...");
        this.monitor.initialize((long)this.programFiles.size());
        Object consumer = new Object();
        for (DomainFile programFile : this.programFiles) {
            this.monitor.checkCancelled();
            Program program = null;
            try {
                program = (Program)programFile.getDomainObject(consumer, false, false, TaskMonitor.DUMMY);
                this.monitor.incrementProgress(1L);
                if (!this.checkLanguageCompilerSpec(program)) continue;
                this.languageId = program.getLanguageID();
                this.compilerSpec = program.getCompilerSpec();
                if (this.library == null) {
                    Language language = program.getLanguage();
                    this.library = this.fidDb.createNewLibrary(this.libraryFamilyName, this.libraryVersion, this.libraryVariant, Application.getApplicationVersion(), this.languageId, language.getVersion(), language.getMinorVersion(), this.compilerSpec.getCompilerSpecID());
                    this.result = new FidPopulateResult(this.library);
                }
                this.populateLibraryFromProgram(program);
            }
            finally {
                if (program == null) continue;
                program.release(consumer);
            }
        }
        this.resolveNamedRelations();
        if (this.result != null) {
            this.result.addChildReferences(500, this.childHistogram);
        }
        return this.result;
    }

    private void populateLibraryFromProgram(Program program) throws CancelledException {
        FidHasher hasher = this.service.getHasher(program);
        ArrayList<Function> theFunctions = new ArrayList<Function>();
        HashMap<Function, FunctionRow> recordMap = new HashMap<Function, FunctionRow>();
        this.hashAllTheFunctions(program, hasher, theFunctions, recordMap);
        for (Map.Entry entry : recordMap.entrySet()) {
            this.monitor.checkCancelled();
            Function function = (Function)entry.getKey();
            FunctionRow functionRow = (FunctionRow)entry.getValue();
            if (functionRow == null) continue;
            functionRow.children = new ArrayList();
            this.addChildRelations(function, hasher, recordMap, functionRow.children);
            Collections.sort(functionRow.children);
            long hash = functionRow.generateHash();
            if (this.globalUniqueFunction.add(hash)) {
                functionRow.commit(this.fidDb, this.library);
                continue;
            }
            this.exclude(program.getDomainFile(), function, FidPopulateResult.Disposition.DUPLICATE_INFO);
        }
        for (Map.Entry entry : recordMap.entrySet()) {
            this.monitor.checkCancelled();
            FunctionRow functionRow = (FunctionRow)entry.getValue();
            FunctionRecord functionRecord = functionRow.functionRecord;
            if (functionRecord == null) continue;
            for (ChildRow childRow : functionRow.children) {
                if (childRow.isVeryCommon) continue;
                if (childRow.toRow == null) {
                    if (childRow.symbolName == null) continue;
                    this.addUnresolvedSymbol(functionRecord, childRow.symbolName, null);
                    continue;
                }
                if (childRow.toRow.functionRecord == null) {
                    this.addUnresolvedSymbol(functionRecord, childRow.toRow.name, childRow.toRow.hashQuad);
                    continue;
                }
                this.fidDb.createRelation(functionRecord, childRow.toRow.functionRecord, RelationType.DIRECT_CALL);
            }
        }
    }

    private void hashAllTheFunctions(Program program, FidHasher hasher, ArrayList<Function> theFunctions, Map<Function, FunctionRow> recordMap) throws CancelledException {
        DomainFile domainFile = program.getDomainFile();
        FunctionManager functionManager = program.getFunctionManager();
        FunctionIterator functions = functionManager.getFunctions(true);
        for (Function function : functions) {
            this.monitor.checkCancelled();
            if (FidServiceLibraryIngest.functionIsExternal(function)) continue;
            theFunctions.add(function);
            String name = null;
            if (function.getSymbol().getSource() == SourceType.DEFAULT) {
                this.exclude(domainFile, function, FidPopulateResult.Disposition.NO_DEFINED_SYMBOL);
            } else {
                name = function.getSymbol().getName();
            }
            FidHashQuad hashQuad = null;
            FunctionRow functionRow = null;
            if (function.isThunk()) {
                if (name == null) continue;
                this.exclude(domainFile, function, FidPopulateResult.Disposition.IS_THUNK);
                continue;
            }
            if (name == null) continue;
            try {
                hashQuad = hasher.hash(function);
                if (hashQuad == null) {
                    this.exclude(domainFile, function, FidPopulateResult.Disposition.FAILS_MINIMUM_SHORTHASH_LENGTH);
                    continue;
                }
                if (this.functionFilter != null && !this.functionFilter.test((Pair<Function, FidHashQuad>)new Pair((Object)function, (Object)hashQuad))) {
                    this.exclude(domainFile, function, FidPopulateResult.Disposition.FAILED_FUNCTION_FILTER);
                    continue;
                }
                boolean hasTerminator = FidServiceLibraryIngest.findTerminator(function, this.monitor);
                functionRow = new FunctionRow(domainFile, function, name, hashQuad, hasTerminator);
                recordMap.put(function, functionRow);
                this.result.disposition(domainFile, name, function.getEntryPoint(), FidPopulateResult.Disposition.INCLUDED);
            }
            catch (MemoryAccessException e) {
                this.exclude(domainFile, function, FidPopulateResult.Disposition.MEMORY_ACCESS_EXCEPTION);
            }
        }
    }

    private void addChildRelations(Function function, FidHasher hasher, Map<Function, FunctionRow> recordMap, ArrayList<ChildRow> children) throws CancelledException {
        HashSet<Address> alreadyDone = new HashSet<Address>();
        Program program = function.getProgram();
        FunctionManager functionManager = program.getFunctionManager();
        ReferenceManager referenceManager = program.getReferenceManager();
        SymbolTable symbolTable = program.getSymbolTable();
        AddressIterator referenceIterator = referenceManager.getReferenceSourceIterator(function.getBody(), true);
        for (Address address : referenceIterator) {
            Reference[] referencesFrom;
            this.monitor.checkCancelled();
            Instruction instruction = program.getListing().getInstructionAt(address);
            if (instruction == null || !instruction.getFlowType().isCall()) continue;
            for (Reference reference : referencesFrom = referenceManager.getReferencesFrom(address)) {
                this.monitor.checkCancelled();
                Address toAddress = reference.getToAddress();
                if (alreadyDone.contains(toAddress)) continue;
                Function relation = functionManager.getFunctionContaining(toAddress);
                if (relation != null && relation.isThunk()) {
                    relation = relation.getThunkedFunction(true);
                }
                if (relation == null || FidServiceLibraryIngest.functionIsExternal(relation)) {
                    ChildRow childRow = new ChildRow();
                    childRow.toRow = null;
                    childRow.symbolName = FidServiceLibraryIngest.grabSymbol(symbolTable, toAddress);
                    childRow.toAddress = toAddress;
                    children.add(childRow);
                    this.searchChildReferenceByName(childRow, childRow.symbolName);
                } else {
                    FunctionRow relationRow = recordMap.get(relation);
                    if (relationRow != null) {
                        ChildRow childRow = new ChildRow();
                        childRow.toRow = relationRow;
                        childRow.symbolName = null;
                        childRow.toAddress = toAddress;
                        children.add(childRow);
                        this.searchChildReferenceByName(childRow, relationRow.name);
                    }
                }
                alreadyDone.add(toAddress);
            }
        }
    }

    private static String grabSymbol(SymbolTable symbolTable, Address address) {
        Symbol primary = symbolTable.getPrimarySymbol(address);
        if (primary != null) {
            return primary.getName();
        }
        return null;
    }

    private void addUnresolvedSymbol(FunctionRecord functionRecord, String symbol, FidHashQuad fidHashQuad) {
        Set<ChildSymbol> set = this.unresolvedSymbols.get(functionRecord);
        if (set == null) {
            set = new HashSet<ChildSymbol>();
            this.unresolvedSymbols.put(functionRecord, set);
        }
        ChildSymbol childSym = new ChildSymbol();
        childSym.name = symbol;
        childSym.hashQuad = fidHashQuad;
        set.add(childSym);
    }

    private void resolveNamedRelations() throws CancelledException {
        for (Map.Entry<FunctionRecord, Set<ChildSymbol>> entry : this.unresolvedSymbols.entrySet()) {
            this.monitor.checkCancelled();
            FunctionRecord functionRecord = entry.getKey();
            Set<ChildSymbol> unresolvedForFunction = entry.getValue();
            for (ChildSymbol unresolvedSym : unresolvedForFunction) {
                this.monitor.checkCancelled();
                boolean handled = this.handleNamedRelationSearch(this.library, functionRecord, unresolvedSym, RelationType.INTRA_LIBRARY_CALL);
                if (!handled && this.linkLibraries != null) {
                    for (LibraryRecord linkLibrary : this.linkLibraries) {
                        this.monitor.checkCancelled();
                        handled = this.handleNamedRelationSearch(linkLibrary, functionRecord, unresolvedSym, RelationType.INTER_LIBRARY_CALL);
                        if (!handled) continue;
                        break;
                    }
                }
                if (handled) continue;
                this.result.addUnresolvedSymbol(unresolvedSym.name);
            }
        }
    }

    private static boolean findTerminator(Function function, TaskMonitor monitor) throws CancelledException {
        boolean retFound = false;
        AddressSetView body = function.getBody();
        CodeUnitIterator codeUnitIterator = function.getProgram().getListing().getCodeUnits(body, true);
        while (codeUnitIterator.hasNext()) {
            Instruction instruction;
            monitor.checkCancelled();
            CodeUnit codeUnit = codeUnitIterator.next();
            if (!(codeUnit instanceof Instruction) || !(instruction = (Instruction)codeUnit).getFlowType().isTerminal()) continue;
            retFound = true;
            break;
        }
        return retFound;
    }

    private boolean handleNamedRelationSearch(LibraryRecord libraryRecord, FunctionRecord functionRecord, ChildSymbol symbol, RelationType relType) throws CancelledException {
        List<FunctionRecord> list = this.fidDb.findFunctionsByLibraryAndName(libraryRecord, symbol.name);
        HashSet<Long> hashes = new HashSet<Long>();
        for (FunctionRecord relation : list) {
            this.monitor.checkCancelled();
            if (symbol.hashQuad != null && symbol.hashQuad.getFullHash() != relation.getFullHash()) continue;
            hashes.add(relation.getSpecificHash());
        }
        if (hashes.size() == 0 && !list.isEmpty()) {
            Msg.warn(FidServiceLibraryIngest.class, (Object)("direct relation " + symbol.name + "lost with hash filter"));
        } else if (hashes.size() <= 12) {
            for (FunctionRecord relative : list) {
                this.monitor.checkCancelled();
                if (symbol.hashQuad != null && symbol.hashQuad.getFullHash() != relative.getFullHash()) continue;
                this.fidDb.createRelation(functionRecord, relative, relType);
            }
        } else {
            Msg.warn(FidServiceLibraryIngest.class, (Object)("relation " + symbol.name + " unresolved; too many possibilities"));
        }
        return !list.isEmpty();
    }

    private boolean checkLanguageCompilerSpec(Program program) {
        if (!this.languageId.equals((Object)program.getLanguageID())) {
            return false;
        }
        if (this.compilerSpec != null && !this.compilerSpec.getCompilerSpecID().equals((Object)program.getCompilerSpec().getCompilerSpecID())) {
            throw new IllegalArgumentException("Program " + program.getName() + " has different compiler spec (" + program.getCompilerSpec().getCompilerSpecID() + ") than already established (" + this.compilerSpec.getCompilerSpecID() + ")");
        }
        return true;
    }

    private static boolean functionIsExternal(Function function) {
        if (function.isExternal()) {
            return true;
        }
        Address entryPoint = function.getEntryPoint();
        MemoryBlock block = function.getProgram().getMemory().getBlock(entryPoint);
        return !block.isInitialized();
    }

    private void exclude(DomainFile domainFile, Function function, FidPopulateResult.Disposition reason) {
        this.result.disposition(domainFile, function.getName(), function.getEntryPoint(), reason);
    }

    private void searchChildReferenceByName(ChildRow row, String name) {
        row.isVeryCommon = false;
        if (name == null) {
            return;
        }
        FidPopulateResult.Count count = this.childHistogram.get(name);
        if (count != null) {
            ++count.count;
            row.isVeryCommon = count.isVeryCommon;
        } else {
            count = new FidPopulateResult.Count();
            count.count = 1;
            count.isVeryCommon = false;
            this.childHistogram.put(name, count);
        }
    }

    private static class FunctionRow {
        public FunctionRecord functionRecord = null;
        public FidHashQuad hashQuad;
        public String name;
        public long offset;
        public String pathName;
        public boolean hasTerminator;
        public ArrayList<ChildRow> children;

        public FunctionRow(DomainFile domainFile, Function function, String name, FidHashQuad hashQuad, boolean hasTerminator) {
            this.hashQuad = hashQuad;
            this.name = name;
            this.offset = function.getEntryPoint().getOffset();
            this.pathName = domainFile.getPathname();
            this.hasTerminator = hasTerminator;
            this.children = null;
        }

        public void commit(FidDB fidDb, LibraryRecord library) {
            this.functionRecord = fidDb.createNewFunction(library, this.hashQuad, this.name, this.offset, this.pathName, this.hasTerminator);
        }

        public long generateHash() {
            long hash = this.hashQuad.getSpecificHash();
            hash *= 31L;
            hash += this.hashQuad.getFullHash();
            hash *= 31L;
            hash += (long)this.name.hashCode();
            for (ChildRow childRow : this.children) {
                if (childRow.toRow != null) {
                    hash *= 31L;
                    hash += childRow.toRow.hashQuad.getFullHash();
                    continue;
                }
                if (childRow.symbolName == null) continue;
                hash *= 31L;
                hash += (long)childRow.symbolName.hashCode();
            }
            return hash;
        }
    }

    private static class ChildRow
    implements Comparable<ChildRow> {
        public FunctionRow toRow;
        public String symbolName;
        public Address toAddress;
        public boolean isVeryCommon;

        private ChildRow() {
        }

        @Override
        public int compareTo(ChildRow o) {
            long offset2;
            if (this.toRow == null) {
                if (o.toRow != null) {
                    return 1;
                }
                if (this.symbolName == null) {
                    if (o.symbolName != null) {
                        return 1;
                    }
                    return this.toAddress.compareTo((Object)o.toAddress);
                }
                if (o.symbolName == null) {
                    return -1;
                }
                return this.symbolName.compareTo(o.symbolName);
            }
            if (o.toRow == null) {
                return -1;
            }
            long offset1 = this.toRow.hashQuad.getSpecificHash();
            if (offset1 == (offset2 = o.toRow.hashQuad.getSpecificHash())) {
                return 0;
            }
            return offset1 < offset2 ? -1 : 1;
        }
    }

    private static class ChildSymbol
    implements Comparable<ChildSymbol> {
        public String name;
        public FidHashQuad hashQuad;

        private ChildSymbol() {
        }

        @Override
        public int compareTo(ChildSymbol o) {
            return this.name.compareTo(o.name);
        }
    }
}

