/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.debug;

import docking.DialogComponentProvider;
import docking.widgets.label.GDLabel;
import generic.theme.Gui;
import ghidra.feature.fid.db.FidFileManager;
import ghidra.feature.fid.db.FidQueryService;
import ghidra.feature.fid.debug.FidDebugUtils;
import ghidra.feature.fid.service.FidService;
import ghidra.util.HelpLocation;
import ghidra.util.exception.VersionException;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FidSearchDebugDialog
extends DialogComponentProvider {
    private FidService service;
    private FidQueryService fidQueryService;
    private JTextField functionIdTextField;
    private JTextField nameTextField;
    private JTextField pathTextField;
    private JTextField fhTextField;
    private JTextField xhTextField;

    public FidSearchDebugDialog(FidService service) throws VersionException, IOException {
        super("Fid Db Search", false);
        this.service = service;
        this.addDismissButton();
        this.addWorkPanel(this.buildPanel());
        this.fidQueryService = FidFileManager.getInstance().openFidQueryService(null, true);
        this.setRememberSize(false);
        this.setHelpLocation(new HelpLocation("FunctionID", "debugsearch"));
    }

    public void setFunctionIdText(String id) {
        this.functionIdTextField.setText(id);
    }

    public void setNameText(String name) {
        this.nameTextField.setText(name);
    }

    public void setDomainPathText(String path) {
        this.pathTextField.setText(path);
    }

    public void setFullHashText(String hash) {
        this.fhTextField.setText(hash);
    }

    public void setSpecificHashText(String hash) {
        this.xhTextField.setText(hash);
    }

    private JLabel getPreparedLabel(String text) {
        GDLabel label = new GDLabel(text, 4);
        Gui.registerFont((Component)label, (String)"font.monospaced");
        return label;
    }

    private JTextField getPreparedTextField() {
        JTextField textField = new JTextField(25);
        Gui.registerFont((Component)textField, (String)"font.monospaced");
        return textField;
    }

    private JComponent buildPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout((LayoutManager)new PairLayout(5, 5));
        panel.add(this.getPreparedLabel("Function ID: "));
        this.functionIdTextField = this.getPreparedTextField();
        panel.add(this.functionIdTextField);
        panel.add(this.getPreparedLabel("Name: "));
        this.nameTextField = this.getPreparedTextField();
        panel.add(this.nameTextField);
        panel.add(this.getPreparedLabel("Domain Path: "));
        this.pathTextField = this.getPreparedTextField();
        panel.add(this.pathTextField);
        panel.add(this.getPreparedLabel("FH: "));
        this.fhTextField = this.getPreparedTextField();
        panel.add(this.fhTextField);
        panel.add(this.getPreparedLabel("XH: "));
        this.xhTextField = this.getPreparedTextField();
        panel.add(this.xhTextField);
        this.functionIdTextField.addActionListener(e -> {
            String text = ((JTextField)e.getSource()).getText();
            Long val = FidDebugUtils.validateHashText(text, "function ID");
            if (val == null) {
                return;
            }
            FidDebugUtils.searchByFunctionID(val, this.service, this.fidQueryService);
        });
        this.nameTextField.addActionListener(e -> {
            String text = ((JTextField)e.getSource()).getText();
            FidDebugUtils.searchByName(text, this.service, this.fidQueryService);
        });
        this.pathTextField.addActionListener(e -> {
            String text = ((JTextField)e.getSource()).getText();
            FidDebugUtils.searchByDomainPath(text, this.service, this.fidQueryService);
        });
        this.fhTextField.addActionListener(e -> {
            String text = ((JTextField)e.getSource()).getText();
            Long val = FidDebugUtils.validateHashText(text, "full hash");
            if (val == null) {
                return;
            }
            FidDebugUtils.searchByFullHash(val, this.service, this.fidQueryService);
        });
        this.xhTextField.addActionListener(e -> {
            String text = ((JTextField)e.getSource()).getText();
            Long val = FidDebugUtils.validateHashText(text, "specific hash");
            if (val == null) {
                return;
            }
            FidDebugUtils.searchBySpecificHash(val, this.service, this.fidQueryService);
        });
        return panel;
    }

    public void close() {
        this.fidQueryService.close();
        super.close();
    }
}

