/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint.dialog;

import docking.widgets.EmptyBorderButton;
import docking.widgets.combobox.GComboBox;
import docking.widgets.list.GListCellRenderer;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.dialog.DialogFilterCondition;
import docking.widgets.table.constraint.dialog.FilterPanelLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import resources.Icons;

public class ConstraintFilterPanel
extends JPanel {
    private DialogFilterCondition<?> constraintEntry;
    private Component firstColumnComponent;
    private JComboBox<ColumnConstraint<?>> constraintComboBox;
    private JPanel inlineEditorPanel;
    private ActionListener constraintComboBoxListener = e -> this.constraintChanged();
    private Component detailEditorComponent;

    ConstraintFilterPanel(DialogFilterCondition<?> constraintEntry, Component firstColumnComponent) {
        this.constraintEntry = constraintEntry;
        this.firstColumnComponent = firstColumnComponent;
        this.setLayout(new BorderLayout());
        this.add(this.buildMainPanel(), "Center");
        this.add(this.buildButtonPanel(), "East");
        Component detailPanel = this.buildDetailEditorPanel();
        if (detailPanel != null) {
            this.add(detailPanel, "South");
        }
    }

    private Component buildMainPanel() {
        JPanel panel = new JPanel(new FilterPanelLayout(200, 5));
        panel.add(this.firstColumnComponent);
        panel.add(this.buildConstraintCombo());
        panel.add(this.buildInlineEditorPanel());
        return panel;
    }

    private Component buildDetailEditorPanel() {
        this.detailEditorComponent = this.constraintEntry.getDetailEditorComponent();
        if (this.detailEditorComponent == null) {
            return null;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(4, 50, 14, 20));
        panel.add(this.detailEditorComponent);
        return panel;
    }

    private Component buildInlineEditorPanel() {
        this.inlineEditorPanel = new JPanel(new BorderLayout());
        this.inlineEditorPanel.add(this.constraintEntry.getInlineEditorComponent(), "Center");
        return this.inlineEditorPanel;
    }

    private Component buildConstraintCombo() {
        JPanel panel = new JPanel(new BorderLayout());
        this.constraintComboBox = new GComboBox();
        this.constraintComboBox.setRenderer(new ConstraintComboBoxCellRenderer());
        this.constraintComboBox.addActionListener(this.constraintComboBoxListener);
        panel.add(this.constraintComboBox, "Center");
        this.updateConstraintComboBoxModel();
        return panel;
    }

    private Component buildButtonPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        Icon icon = Icons.DELETE_ICON;
        EmptyBorderButton button = new EmptyBorderButton(icon);
        button.setToolTipText("Delete entry");
        button.addActionListener(e -> this.constraintEntry.delete());
        panel.add((Component)button, "North");
        return panel;
    }

    private void constraintChanged() {
        int selectedIndex = this.constraintComboBox.getSelectedIndex();
        ColumnConstraint<?> selectedConstraint = this.constraintComboBox.getItemAt(selectedIndex);
        String constraintName = selectedConstraint.getName();
        this.constraintEntry.setSelectedConstraint(constraintName);
    }

    private void updateConstraintComboBoxModel() {
        this.constraintComboBox.removeActionListener(this.constraintComboBoxListener);
        ColumnConstraint<?>[] constraints = this.constraintEntry.getColumnConstraints();
        this.constraintComboBox.setModel(new DefaultComboBoxModel(constraints));
        this.constraintComboBox.setSelectedItem(this.constraintEntry.getSelectedConstraint());
        this.constraintComboBox.addActionListener(this.constraintComboBoxListener);
    }

    private class ConstraintComboBoxCellRenderer
    extends GListCellRenderer<ColumnConstraint<?>> {
        private ConstraintComboBoxCellRenderer() {
        }

        @Override
        protected String getItemText(ColumnConstraint<?> value) {
            return value.getName();
        }

        @Override
        public boolean shouldAlternateRowBackgroundColor() {
            return false;
        }
    }
}

