/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.pathmanager;

import docking.widgets.button.GButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.pathmanager.PathManagerListener;
import docking.widgets.pathmanager.PathManagerModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import generic.jar.ResourceFile;
import generic.util.Path;
import ghidra.framework.options.SaveState;
import ghidra.framework.preferences.Preferences;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import resources.Icons;

public class PathManager {
    private JPanel panel;
    private GTable pathTable;
    private PathManagerModel pathModel;
    private TableModelListener pathModelListener;
    private JButton upButton;
    private JButton downButton;
    private JButton addButton;
    private JButton removeButton;
    private String preferenceForLastSelectedDir = "LastPathDirectory";
    private String title = "Select File";
    private GhidraFileChooserMode fileChooserMode = GhidraFileChooserMode.FILES_ONLY;
    private boolean allowMultiFileSelection;
    private GhidraFileFilter filter;
    private boolean addToTop;
    private boolean allowOrdering;
    private ArrayList<PathManagerListener> listeners = new ArrayList();

    public PathManager(List<Path> paths, boolean addToTop, boolean allowOrdering) {
        this.addToTop = addToTop;
        this.allowOrdering = allowOrdering;
        this.create(paths);
    }

    public PathManager(boolean addToTop, boolean allowOrdering) {
        this(new ArrayList<Path>(), addToTop, allowOrdering);
    }

    public void setFileChooserProperties(String title, String preferenceForLastSelectedDir, GhidraFileChooserMode selectionMode, boolean allowMultiSelection, GhidraFileFilter filter) {
        this.title = title;
        this.preferenceForLastSelectedDir = preferenceForLastSelectedDir;
        this.fileChooserMode = selectionMode;
        this.allowMultiFileSelection = allowMultiSelection;
        this.filter = filter;
    }

    public boolean addPath(ResourceFile file, boolean enabled) {
        ResourceFile dir = file.isDirectory() ? file : file.getParentFile();
        for (Path path : this.pathModel.getAllPaths()) {
            if (!path.getPath().equals((Object)dir)) continue;
            if (enabled && !path.isEnabled()) {
                path.setEnabled(true);
                this.pathModel.fireTableDataChanged();
                this.firePathsChanged();
                return true;
            }
            return false;
        }
        Path p = new Path(dir);
        p.setEnabled(enabled);
        this.pathModel.addPath(p, true);
        Preferences.setProperty((String)this.preferenceForLastSelectedDir, (String)dir.getAbsolutePath());
        this.firePathsChanged();
        return true;
    }

    public void setPaths(List<Path> paths) {
        this.pathModel.setPaths(paths);
    }

    public void clear() {
        this.pathModel.clear();
    }

    public void addListener(PathManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(PathManagerListener listener) {
        this.listeners.remove(listener);
    }

    public List<PathManagerListener> getListeners() {
        return new ArrayList<PathManagerListener>(this.listeners);
    }

    private void firePathsChanged() {
        for (PathManagerListener listener : this.listeners) {
            listener.pathsChanged();
        }
    }

    private void create(List<Path> paths) {
        this.panel = new JPanel(new BorderLayout(5, 5));
        if (this.allowOrdering) {
            this.upButton = new GButton(Icons.UP_ICON);
            this.upButton.setName("UpArrow");
            this.upButton.setToolTipText("Move the selected path up in list");
            this.upButton.addActionListener(e -> this.up());
            this.upButton.setFocusable(false);
            this.downButton = new GButton(Icons.DOWN_ICON);
            this.downButton.setName("DownArrow");
            this.downButton.setToolTipText("Move the selected path down in list");
            this.downButton.addActionListener(e -> this.down());
            this.downButton.setFocusable(false);
        }
        this.addButton = new GButton(Icons.ADD_ICON);
        this.addButton.setName("AddPath");
        this.addButton.setToolTipText("Display file chooser to select files to add");
        this.addButton.addActionListener(e -> this.add());
        this.addButton.setFocusable(false);
        this.removeButton = new GButton(Icons.DELETE_ICON);
        this.removeButton.setName("RemovePath");
        this.removeButton.setToolTipText("Remove selected path(s) from list");
        this.removeButton.addActionListener(e -> this.remove());
        this.removeButton.setFocusable(false);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        if (this.allowOrdering) {
            buttonPanel.add((Component)this.upButton, gbc);
            ++gbc.gridy;
            buttonPanel.add((Component)this.downButton, gbc);
            ++gbc.gridy;
        }
        buttonPanel.add((Component)this.addButton, gbc);
        ++gbc.gridy;
        buttonPanel.add((Component)this.removeButton, gbc);
        this.pathModelListener = e -> this.firePathsChanged();
        this.pathModel = new PathManagerModel(this, paths);
        this.pathModel.addTableModelListener(this.pathModelListener);
        this.pathTable = new GTable(this.pathModel);
        this.pathTable.setName("PATH_TABLE");
        this.pathTable.setSelectionMode(2);
        TableColumn useColumn = this.pathTable.getColumnModel().getColumn(0);
        int width = 50;
        useColumn.setPreferredWidth(width);
        useColumn.setMinWidth(width);
        useColumn.setMaxWidth(width);
        useColumn.setWidth(width);
        TableColumn pathColumn = this.pathTable.getColumnModel().getColumn(1);
        pathColumn.setCellRenderer(new GTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                Path path;
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
                Object value = data.getValue();
                int column = data.getColumnViewIndex();
                if (column == 1 && !PathManager.this.isValidPath(path = (Path)value)) {
                    renderer.setForeground(this.getErrorForegroundColor(data.isSelected()));
                }
                return renderer;
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.pathTable);
        scrollPane.getViewport().setBackground(this.pathTable.getBackground());
        ListSelectionModel selModel = this.pathTable.getSelectionModel();
        selModel.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateButtonsEnabled();
        });
        this.updateButtonsEnabled();
        this.panel.add((Component)scrollPane, "Center");
        this.panel.add((Component)buttonPanel, "East");
        this.panel.setPreferredSize(new Dimension(400, 200));
    }

    private void updateButtonsEnabled() {
        int[] rows = this.pathTable.getSelectedRows();
        if (this.allowOrdering) {
            if (this.pathModel.getRowCount() > 1 && rows.length == 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        }
        this.removeButton.setEnabled(rows.length > 0);
    }

    private void remove() {
        int[] selectedRows = this.pathTable.getSelectedRows();
        if (selectedRows == null) {
            return;
        }
        this.pathModel.remove(selectedRows);
        Arrays.sort(selectedRows);
        int row = selectedRows[selectedRows.length - 1] + 1 - selectedRows.length;
        int count = this.pathModel.getRowCount();
        if (row >= count) {
            row = count - 1;
        }
        if (row >= 0) {
            this.pathTable.setRowSelectionInterval(row, row);
        }
        this.updateButtonsEnabled();
    }

    private void add() {
        List<File> files;
        String dir;
        GhidraFileChooser fileChooser = new GhidraFileChooser(this.panel);
        fileChooser.setMultiSelectionEnabled(this.allowMultiFileSelection);
        fileChooser.setFileSelectionMode(this.fileChooserMode);
        fileChooser.setTitle(this.title);
        fileChooser.setApproveButtonToolTipText(this.title);
        if (this.filter != null) {
            fileChooser.addFileFilter(new GhidraFileFilter(){

                public String getDescription() {
                    return PathManager.this.filter.getDescription();
                }

                public boolean accept(File f, GhidraFileChooserModel l_model) {
                    return PathManager.this.filter.accept(f, l_model);
                }
            });
        }
        if ((dir = Preferences.getProperty((String)this.preferenceForLastSelectedDir)) != null) {
            fileChooser.setCurrentDirectory(new File(dir));
        }
        if (!(files = fileChooser.getSelectedFiles()).isEmpty()) {
            if (this.allowMultiFileSelection) {
                String parent = files.get(0).getParent();
                Preferences.setProperty((String)this.preferenceForLastSelectedDir, (String)parent);
                for (File element : files) {
                    Path p = new Path(element.getAbsolutePath());
                    this.pathModel.addPath(p, this.addToTop);
                }
            } else {
                String path = files.get(0).getAbsolutePath();
                Path p = new Path(path);
                this.pathModel.addPath(p, this.addToTop);
                Preferences.setProperty((String)this.preferenceForLastSelectedDir, (String)path);
            }
        }
        fileChooser.dispose();
    }

    private void up() {
        int row = this.pathTable.getSelectedRow();
        int newRow = this.pathModel.moveUp(row);
        this.pathTable.setRowSelectionInterval(newRow, newRow);
    }

    private void down() {
        int row = this.pathTable.getSelectedRow();
        int newRow = this.pathModel.moveDown(row);
        this.pathTable.setRowSelectionInterval(newRow, newRow);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void saveState(SaveState ss) {
        List<Path> paths = this.pathModel.getAllPaths();
        String[] pathArr = new String[paths.size()];
        boolean[] enableArr = new boolean[paths.size()];
        boolean[] editArr = new boolean[paths.size()];
        boolean[] readArr = new boolean[paths.size()];
        int index = 0;
        for (Path path : paths) {
            pathArr[index] = path.getPathAsString();
            enableArr[index] = path.isEnabled();
            editArr[index] = path.isEditable();
            readArr[index] = path.isReadOnly();
            ++index;
        }
        ss.putStrings("PathManagerPanel_PATH", pathArr);
        ss.putBooleans("PathManagerPanel_ENABLE", enableArr);
        ss.putBooleans("PathManagerPanel_EDIT", editArr);
        ss.putBooleans("PathManagerPanel_READ", readArr);
    }

    public void restoreFromPreferences(String enablePathKey, Path[] defaultEnablePaths, String disabledPathKey) {
        this.pathModel.clear();
        for (Path path : PathManager.getPathsFromPreferences(enablePathKey, defaultEnablePaths, disabledPathKey)) {
            this.pathModel.addPath(path, this.addToTop);
        }
    }

    public static Path[] getPathsFromPreferences(String enablePathKey, Path[] defaultEnablePaths, String disabledPathKey) {
        String disabledPath;
        String enablePath = Preferences.getProperty((String)enablePathKey, null, (boolean)true);
        if (enablePath != null && enablePath.length() == 0) {
            enablePath = null;
        }
        if ((disabledPath = Preferences.getProperty((String)disabledPathKey, null)) != null && disabledPath.length() == 0) {
            disabledPath = null;
        }
        String[] enabledPaths = null;
        String[] disabledPaths = null;
        if (defaultEnablePaths != null && enablePath == null && disabledPath == null) {
            return defaultEnablePaths;
        }
        enabledPaths = enablePath != null ? enablePath.split(File.pathSeparator) : new String[]{};
        disabledPaths = disabledPath != null ? disabledPath.split(File.pathSeparator) : new String[]{};
        ArrayList<Path> list = new ArrayList<Path>();
        int disabledIndex = 0;
        for (String p : enabledPaths) {
            if (p.length() == 0) {
                if (disabledIndex >= disabledPaths.length) continue;
                list.add(new Path(disabledPaths[disabledIndex++], false));
                continue;
            }
            list.add(new Path(p, true));
        }
        for (int i = disabledIndex; i < disabledPaths.length; ++i) {
            list.add(new Path(disabledPaths[i], false));
        }
        Path[] paths = new Path[list.size()];
        return list.toArray(paths);
    }

    public boolean saveToPreferences(String enablePathKey, String disabledPathKey) {
        List<Path> pathList = this.pathModel.getAllPaths();
        return PathManager.savePathsToPreferences(enablePathKey, disabledPathKey, pathList.toArray(new Path[pathList.size()]));
    }

    private static void appendPath(StringBuilder buf, String path, boolean previousPathIsEmpty) {
        if (buf.length() != 0 || previousPathIsEmpty) {
            buf.append(File.pathSeparatorChar);
        }
        buf.append(path);
    }

    public static boolean savePathsToPreferences(String enablePathKey, String disabledPathKey, Path[] paths) {
        StringBuilder enabledPathBuffer = new StringBuilder();
        StringBuilder disabledPathBuffer = new StringBuilder();
        boolean previousPathDisabled = false;
        for (Path path : paths) {
            if (path.isEnabled()) {
                PathManager.appendPath(enabledPathBuffer, path.getPathAsString(), previousPathDisabled);
                previousPathDisabled = false;
                continue;
            }
            PathManager.appendPath(disabledPathBuffer, path.getPathAsString(), false);
            PathManager.appendPath(enabledPathBuffer, "", previousPathDisabled);
            previousPathDisabled = true;
        }
        if (enablePathKey != null) {
            Preferences.setProperty((String)enablePathKey, (String)enabledPathBuffer.toString());
        }
        if (disabledPathKey != null) {
            Preferences.setProperty((String)disabledPathKey, (String)disabledPathBuffer.toString());
        }
        return Preferences.store();
    }

    public void restoreState(SaveState ss) {
        String[] pathArr = ss.getStrings("PathManagerPanel_PATH", new String[0]);
        if (pathArr.length == 0) {
            return;
        }
        this.pathModel.removeTableModelListener(this.pathModelListener);
        boolean[] enableArr = ss.getBooleans("PathManagerPanel_ENABLE", new boolean[pathArr.length]);
        boolean[] editArr = ss.getBooleans("PathManagerPanel_EDIT", new boolean[pathArr.length]);
        boolean[] readArr = ss.getBooleans("PathManagerPanel_READ", new boolean[pathArr.length]);
        List<Path> oldPaths = this.pathModel.getAllPaths();
        this.pathModel.clear();
        for (int i = 0; i < pathArr.length; ++i) {
            Path path = new Path(pathArr[i], enableArr[i], editArr[i], readArr[i]);
            Path oldPath = PathManager.getPath(path.getPathAsString(), oldPaths);
            if (oldPath != null) {
                if (!oldPath.isEditable()) {
                    boolean enabled = path.isEnabled();
                    path = oldPath;
                    path.setEnabled(enabled);
                }
                oldPaths.remove(oldPath);
            } else if (path.isReadOnly()) continue;
            this.pathModel.addPath(path, false);
        }
        for (Path path : oldPaths) {
            if (path.isEditable()) continue;
            this.pathModel.addPath(path, false);
        }
        this.pathModel.addTableModelListener(this.pathModelListener);
        this.firePathsChanged();
    }

    private static Path getPath(String filepath, List<Path> paths) {
        for (Path path : paths) {
            if (!filepath.equals(path.getPathAsString())) continue;
            return path;
        }
        return null;
    }

    private boolean isValidPath(Path path) {
        if (this.fileChooserMode == GhidraFileChooserMode.FILES_ONLY && path.getPath().isDirectory()) {
            return false;
        }
        if (this.fileChooserMode == GhidraFileChooserMode.DIRECTORIES_ONLY && path.getPath().isFile()) {
            return false;
        }
        return path.exists();
    }

    public void dispose() {
        this.pathTable.dispose();
    }
}

