/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.options.editor.OptionsRootTreeNode;
import docking.options.editor.OptionsTreeNode;
import docking.options.editor.ScrollableOptionsEditor;
import docking.widgets.MultiLineLabel;
import docking.widgets.OptionDialog;
import docking.widgets.label.GIconLabel;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.internal.DefaultGTreeDataTransformer;
import ghidra.framework.options.CustomOptionsEditor;
import ghidra.framework.options.EditorStateFactory;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsEditor;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.bean.opteditor.OptionsVetoException;
import ghidra.util.layout.MiddleLayout;
import ghidra.util.task.SwingUpdateManager;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import resources.Icons;

public class OptionsPanel
extends JPanel {
    private PropertyChangeListener changeListener;
    private GTree gTree;
    private OptionsRootTreeNode rootNode;
    private OptionsEditor currentOptionsEditor;
    private Map<OptionsTreeNode, OptionsEditor> editorMap = new HashMap<OptionsTreeNode, OptionsEditor>();
    private JPanel viewPanel;
    private JPanel defaultPanel;
    private JPanel optionsEditorContainer;
    private JPanel restoreDefaultPanel;
    private SwingUpdateManager updateManager;
    private EditorStateFactory editorStateFactory = new EditorStateFactory();
    private JSplitPane splitPane;

    public OptionsPanel(String rootName, Options[] options, boolean showRestoreDefaultsButton, PropertyChangeListener changeListener) {
        this.changeListener = changeListener;
        this.updateManager = new SwingUpdateManager(100, () -> {
            OptionsTreeNode node = null;
            TreePath selectedPath = this.gTree.getSelectionPath();
            if (selectedPath != null) {
                node = (OptionsTreeNode)selectedPath.getLastPathComponent();
            }
            if (node == null) {
                return;
            }
            this.processSelection(node);
        });
        this.setLayout(new BorderLayout());
        this.rootNode = options.length == 1 ? new OptionsRootTreeNode(options[0]) : new OptionsRootTreeNode(rootName, options);
        this.gTree = new GTree(this.rootNode);
        this.gTree.addGTreeSelectionListener(e -> this.updateManager.updateLater());
        this.gTree.setDataTransformer(new OptionsDataTransformer());
        this.viewPanel = new JPanel(new BorderLayout());
        this.viewPanel.setName("View");
        this.splitPane = new JSplitPane(1, this.gTree, this.viewPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(250);
        Dimension minSize = new Dimension(100, 300);
        this.gTree.setMinimumSize(minSize);
        this.viewPanel.setMinimumSize(minSize);
        this.splitPane.setBorder(null);
        this.add((Component)this.splitPane, "Center");
        this.gTree.expandPath(new TreePath(new Object[]{this.rootNode}));
        TreeSelectionModel selModel = this.gTree.getSelectionModel();
        selModel.setSelectionMode(1);
        this.defaultPanel = this.createDefaultPanel();
        this.viewPanel.add((Component)this.defaultPanel, "Center");
        this.gTree.setSelectedNode(this.rootNode);
        this.optionsEditorContainer = new JPanel(new BorderLayout());
        this.restoreDefaultPanel = new JPanel();
        this.restoreDefaultPanel.setLayout(new BorderLayout());
        if (showRestoreDefaultsButton) {
            this.restoreDefaultPanel.add(this.createRestoreDefaultsButton(), "East");
        }
    }

    public void dispose() {
        this.updateManager.dispose();
        this.gTree.dispose();
    }

    private Component createRestoreDefaultsButton() {
        JButton button = new JButton("Restore Defaults");
        button.addActionListener(e -> {
            Options currentOptions = this.getSelectedOptions();
            int userChoice = OptionDialog.showOptionDialog(this.viewPanel, "Restore Defaults?", "<html>Restore <b>" + HTMLUtilities.escapeHTML((String)currentOptions.getName()) + "</b> to default option values <b>and erase current settings?</b>", "Restore Defaults");
            if (userChoice == 0) {
                return;
            }
            this.restoreDefaultOptionsForCurrentEditor();
        });
        return button;
    }

    Component getFocusComponent() {
        return this.gTree.getFilterField();
    }

    private void restoreDefaultOptionsForCurrentEditor() {
        TreePath selectedPath = this.gTree.getSelectionPath();
        if (selectedPath == null) {
            return;
        }
        OptionsTreeNode node = (OptionsTreeNode)selectedPath.getLastPathComponent();
        if (node == null) {
            return;
        }
        Options options = node.getOptions();
        options.restoreDefaultValues();
        OptionsEditor optionsEditor = options.getOptionsEditor();
        if (optionsEditor != null) {
            optionsEditor.reload();
        }
        this.editorMap.remove(node);
        List<String> optionNames = node.getOptionNames();
        for (String optionName : optionNames) {
            this.editorStateFactory.clear(options, optionName);
        }
        this.processSelection(node);
    }

    public void cancel() {
        Set<Map.Entry<OptionsTreeNode, OptionsEditor>> entrySet = this.editorMap.entrySet();
        for (Map.Entry<OptionsTreeNode, OptionsEditor> entry : entrySet) {
            OptionsEditor editor = entry.getValue();
            try {
                editor.cancel();
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                String title = "Error Resetting Options on " + entry.getKey().getName();
                Msg.showError((Object)this, (Component)this, (String)title, (Object)(title + "\nError Message: " + msg), (Throwable)e);
            }
        }
    }

    public boolean apply() {
        boolean status = true;
        Set<Map.Entry<OptionsTreeNode, OptionsEditor>> entrySet = this.editorMap.entrySet();
        for (Map.Entry<OptionsTreeNode, OptionsEditor> entry : entrySet) {
            OptionsEditor editor = entry.getValue();
            try {
                editor.apply();
            }
            catch (OptionsVetoException ove) {
                Msg.showWarn((Object)this, (Component)this, (String)"Invalid Option Value", (Object)("Attempted to set an option to an invalid value:\n" + ove.getMessage()));
                status = false;
            }
            catch (Exception e) {
                status = false;
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                String title = "Error Setting Options on " + entry.getKey().getName();
                Msg.showError((Object)this, (Component)this, (String)title, (Object)(title + "\nError Message: " + msg), (Throwable)e);
            }
        }
        return status;
    }

    public void displayCategory(String category, String filterText) {
        String escapedDelimiter = Pattern.quote(Options.DELIMITER_STRING);
        GTreeNode root = this.gTree.getModelRoot();
        category = root.getName() + Options.DELIMITER_STRING + (String)category;
        String[] categories = ((String)category).split(escapedDelimiter);
        this.gTree.setFilterText(filterText);
        this.gTree.setSelectedNodeByNamePath(categories);
    }

    private JPanel createDefaultPanel() {
        JPanel panel = new JPanel((LayoutManager)new MiddleLayout());
        panel.setName("Default");
        MultiLineLabel label = new MultiLineLabel("To change Options, select a Folder or Option Group from the\nOptions Tree and change the Option settings.");
        label.setName("DefaultInfo");
        JPanel labelPanel = new JPanel();
        labelPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
        BoxLayout bl = new BoxLayout(labelPanel, 0);
        labelPanel.setLayout(bl);
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add(new GIconLabel(Icons.INFO_ICON));
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add(label);
        panel.add(labelPanel);
        return panel;
    }

    private void processSelection(OptionsTreeNode selectedNode) {
        if (selectedNode == null) {
            this.setViewPanel(this.defaultPanel, selectedNode);
            return;
        }
        this.currentOptionsEditor = this.getOptionsEditor(selectedNode);
        if (this.currentOptionsEditor == null) {
            this.setViewPanel(this.defaultPanel, selectedNode);
            return;
        }
        JComponent editorComponent = this.currentOptionsEditor.getEditorComponent(selectedNode.getOptions(), this.editorStateFactory);
        if (editorComponent == null) {
            this.setViewPanel(this.defaultPanel, selectedNode);
            return;
        }
        editorComponent.setRequestFocusEnabled(true);
        this.optionsEditorContainer.removeAll();
        this.optionsEditorContainer.add((Component)editorComponent, "Center");
        this.optionsEditorContainer.add((Component)this.restoreDefaultPanel, "South");
        this.setViewPanel(this.optionsEditorContainer, selectedNode);
    }

    private Options getSelectedOptions() {
        TreePath selectedPath = this.gTree.getSelectionPath();
        if (selectedPath == null) {
            return null;
        }
        OptionsTreeNode node = (OptionsTreeNode)selectedPath.getLastPathComponent();
        if (node == null) {
            return null;
        }
        return node.getOptions();
    }

    private void setViewPanel(JComponent component, OptionsTreeNode selectedNode) {
        this.viewPanel.removeAll();
        this.viewPanel.add((Component)component, "Center");
        this.setHelpLocation(component, selectedNode);
        this.viewPanel.validate();
        this.viewPanel.repaint();
    }

    private void setHelpLocation(JComponent component, OptionsTreeNode node) {
        Options options = node.getOptions();
        if (options == null) {
            return;
        }
        HelpService help = Help.getHelpService();
        HelpLocation location = options.getOptionsHelpLocation();
        if (location == null) {
            help.clearHelp((Object)this);
        } else {
            help.registerHelp((Object)this, location);
        }
    }

    private OptionsEditor getOptionsEditor(OptionsTreeNode node) {
        OptionsEditor editor = this.editorMap.get(node);
        if (editor != null) {
            return editor;
        }
        Options options = node.getOptions();
        if (options == null) {
            return null;
        }
        editor = options.getOptionsEditor();
        if (editor == null) {
            List<String> optionList = node.getOptionNames();
            Collections.sort(optionList);
            if (optionList.size() > 0) {
                editor = new ScrollableOptionsEditor(options.getName(), optionList);
            }
        }
        if (editor != null) {
            this.editorMap.put(node, editor);
            editor.setOptionsPropertyChangeListener(this.changeListener);
        }
        return editor;
    }

    void setSelectedPath(TreePath path) {
        if (path == null) {
            return;
        }
        this.gTree.expandPath(path);
        this.gTree.setSelectionPath(path);
    }

    TreePath getSelectedPath() {
        return this.gTree.getSelectionPath();
    }

    public class OptionsDataTransformer
    extends DefaultGTreeDataTransformer {
        @Override
        public List<String> transform(GTreeNode node) {
            List<String> results = super.transform(node);
            OptionsTreeNode optionsNode = (OptionsTreeNode)node;
            Options options = optionsNode.getOptions();
            List<String> optionsList = optionsNode.getOptionNames();
            for (String optionName : optionsList) {
                this.addDetails(options, optionName, results);
            }
            return results;
        }

        private void addDetails(Options options, String optionName, List<String> results) {
            PropertyEditor propertyEditor = options.getRegisteredPropertyEditor(optionName);
            if (propertyEditor instanceof CustomOptionsEditor) {
                this.addOptionDetails((CustomOptionsEditor)propertyEditor, results);
            } else {
                String description = options.getDescription(optionName);
                results.add(optionName);
                results.add(description);
            }
        }

        private void addOptionDetails(CustomOptionsEditor editor, List<String> results) {
            String[] optionNames;
            for (String string : optionNames = editor.getOptionNames()) {
                results.add(string);
            }
            String[] descriptions = editor.getOptionDescriptions();
            if (descriptions != null) {
                for (String string : descriptions) {
                    results.add(string);
                }
            }
        }
    }
}

