/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.DockingWindowManager;
import docking.EmptyBorderToggleButton;
import docking.action.ActionContextProvider;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToggleDockingActionIf;
import docking.action.ToolBarData;
import docking.menu.DockingToolBarUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;

public class DialogToolbarButton
extends EmptyBorderToggleButton {
    private DockingActionIf dockingAction;
    private ActionContextProvider contextProvider;

    public DialogToolbarButton(DockingActionIf action, ActionContextProvider contextProvider) {
        super(action);
        this.contextProvider = contextProvider;
        this.setFocusable(false);
        this.addMouseListener(new MouseOverMouseListener());
        action.addPropertyChangeListener(this.propertyChangeListener);
        DockingToolBarUtils.setToolTipText(this, this.dockingAction);
    }

    @Override
    protected void initFromAction(DockingActionIf action) {
        this.dockingAction = action;
        super.initFromAction(action);
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        if (this.dockingAction instanceof ToggleDockingActionIf) {
            ToggleDockingActionIf toggleAction;
            toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)this.dockingAction).isSelected());
        }
        this.dockingAction.actionPerformed(this.contextProvider.getActionContext(null));
    }

    @Override
    protected void doPropertyChange(PropertyChangeEvent e) {
        super.doPropertyChange(e);
        String name = e.getPropertyName();
        if (name.equals("enabled")) {
            this.setEnabled((Boolean)e.getNewValue());
        } else if (name.equals("description")) {
            DockingToolBarUtils.setToolTipText(this, this.dockingAction);
        } else if (name.equals("ToolBar")) {
            ToolBarData toolBarData = (ToolBarData)e.getNewValue();
            this.setIcon(toolBarData == null ? null : toolBarData.getIcon());
        } else if (name.equals("selectState")) {
            this.setSelected((Boolean)e.getNewValue());
        } else if (name.equals("KeyBindings")) {
            DockingToolBarUtils.setToolTipText(this, this.dockingAction);
        }
    }

    @Override
    protected boolean isButtonSelected() {
        if (this.dockingAction instanceof ToggleDockingAction) {
            return ((ToggleDockingAction)this.dockingAction).isSelected();
        }
        return false;
    }

    public DockingActionIf getDockingAction() {
        return this.dockingAction;
    }

    @Override
    public void setSelected(boolean b) {
        if (this.dockingAction instanceof ToggleDockingActionIf) {
            ((ToggleDockingActionIf)this.dockingAction).setSelected(b);
        }
        super.setSelected(b);
    }

    @Override
    public boolean isSelected() {
        if (this.dockingAction instanceof ToggleDockingActionIf) {
            return ((ToggleDockingActionIf)this.dockingAction).isSelected();
        }
        return super.isSelected();
    }

    @Override
    public void removeListeners() {
        this.dockingAction.removePropertyChangeListener(this.propertyChangeListener);
        super.removeListeners();
    }

    private class MouseOverMouseListener
    extends MouseAdapter {
        private MouseOverMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            DockingWindowManager.setMouseOverAction(DialogToolbarButton.this.dockingAction);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            DockingWindowManager.setMouseOverAction(null);
        }
    }
}

