/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.DockingActionProxy;
import docking.DockingWindowManager;
import docking.WindowNode;
import docking.action.DockingActionIf;
import docking.menu.MenuBarManager;
import docking.menu.MenuGroupMap;
import docking.menu.MenuHandler;
import docking.menu.ToolBarManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuBar;

public class WindowActionManager {
    private Map<DockingActionIf, DockingActionProxy> actionToProxyMap;
    private MenuBarManager menuBarMgr;
    private ToolBarManager toolBarMgr;
    private final WindowNode node;
    private boolean disposed;

    WindowActionManager(WindowNode node, MenuHandler menuBarHandler, DockingWindowManager winMgr, MenuGroupMap menuGroupMap) {
        this.node = node;
        this.actionToProxyMap = new HashMap<DockingActionIf, DockingActionProxy>();
        this.menuBarMgr = new MenuBarManager(menuBarHandler, menuGroupMap);
        this.toolBarMgr = new ToolBarManager(winMgr);
    }

    void setActions(List<DockingActionIf> actionList) {
        this.menuBarMgr.clearActions();
        this.toolBarMgr.clearActions();
        this.actionToProxyMap.clear();
        for (DockingActionIf action : actionList) {
            this.addAction(action);
        }
    }

    void addAction(DockingActionIf action) {
        if (action.getMenuBarData() != null || action.getToolBarData() != null) {
            DockingActionProxy proxyAction = new DockingActionProxy(action);
            this.actionToProxyMap.put(action, proxyAction);
            this.menuBarMgr.addAction(proxyAction);
            this.toolBarMgr.addAction(proxyAction);
        }
    }

    void removeAction(DockingActionIf action) {
        DockingActionProxy proxyAction = this.actionToProxyMap.remove(action);
        if (proxyAction != null) {
            this.menuBarMgr.removeAction(proxyAction);
            this.toolBarMgr.removeAction(proxyAction);
        }
    }

    DockingActionIf getToolbarAction(String actionName) {
        return this.toolBarMgr.getAction(actionName);
    }

    void update() {
        JMenuBar menuBar = this.menuBarMgr.getMenuBar();
        if (menuBar.getMenuCount() > 0) {
            this.node.setMenuBar(menuBar);
        }
        this.node.setToolBar(this.toolBarMgr.getToolBar());
        this.node.validate();
    }

    void dispose() {
        this.disposed = true;
        this.node.setToolBar(null);
        this.node.setMenuBar(null);
        this.actionToProxyMap.clear();
        this.menuBarMgr.dispose();
        this.toolBarMgr.dispose();
    }

    void contextChanged(ActionContext globalContext, ActionContext localContext, Set<DockingActionIf> excluded) {
        if (!this.node.isVisible() || this.disposed) {
            return;
        }
        ArrayList<DockingActionIf> list = new ArrayList<DockingActionIf>(this.actionToProxyMap.keySet());
        for (DockingActionIf action : list) {
            if (excluded.contains(action)) continue;
            DockingActionIf proxyAction = this.actionToProxyMap.get(action);
            if (proxyAction.isValidContext(localContext)) {
                proxyAction.setEnabled(proxyAction.isEnabledForContext(localContext));
                continue;
            }
            if (this.isValidDefaultToolContext(proxyAction, globalContext)) {
                proxyAction.setEnabled(proxyAction.isEnabledForContext(globalContext));
                continue;
            }
            proxyAction.setEnabled(false);
        }
    }

    private boolean isValidDefaultToolContext(DockingActionIf action, ActionContext toolContext) {
        return action.supportsDefaultToolContext() && action.isValidContext(toolContext);
    }

    Set<DockingActionIf> getOriginalActions() {
        return new HashSet<DockingActionIf>(this.actionToProxyMap.keySet());
    }
}

