/*
 * Decompiled with CFR 0.152.
 */
package org.phidias.compile;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.phidias.compile.BundleJavaFileObject;
import org.phidias.compile.Constants;
import org.phidias.compile.JarJavaFileObject;
import org.phidias.compile.ResourceResolver;
import org.phidias.compile.TPhLog;
import org.phidias.compile.internal.BasicResourceResolver;

public class BundleJavaManager
extends ForwardingJavaFileManager<JavaFileManager>
implements Constants {
    private Bundle _bundle;
    private BundleWiring _bundleWiring;
    private ArrayList<BundleWiring> _bundleWirings;
    private ClassLoader _classLoader;
    private JavaFileManager _javaFileManager;
    private TPhLog _log;
    private List<String> _options = new ArrayList<String>();
    private List<BundleRequirement> _packageRequirements;
    private ResourceResolver _resourceResolver;
    private boolean _strict;
    private BundleWiring _systemBundleWiring;
    private List<BundleCapability> _systemCapabilities;

    public BundleJavaManager(Bundle bundle, JavaFileManager javaFileManager) throws IOException {
        this(bundle, javaFileManager, null, false);
    }

    public BundleJavaManager(Bundle bundle, JavaFileManager javaFileManager, List<String> options) throws IOException {
        this(bundle, javaFileManager, options, false);
    }

    public BundleJavaManager(Bundle bundle, JavaFileManager javaFileManager, List<String> options, boolean strict) throws IOException {
        super(javaFileManager);
        this._bundle = bundle;
        this._javaFileManager = javaFileManager;
        this._log = new TPhLog();
        this.setOptions(options);
        this._strict = strict;
        this._log.log("Initializing compilation in OSGi for bundle " + this._bundle.getSymbolicName() + "-" + this._bundle.getVersion());
        this._bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        this._classLoader = this._bundleWiring.getClassLoader();
        this._packageRequirements = this._bundleWiring.getRequirements("osgi.wiring.package");
        List providedWires = this._bundleWiring.getRequiredWires(null);
        this._log.log("Dependent BundleWirings included in this BundleJavaManager context: ");
        this._bundleWirings = new ArrayList();
        for (BundleWire bundleWire : providedWires) {
            BundleWiring providerWiring = bundleWire.getProviderWiring();
            if (this._bundleWirings.contains(providerWiring)) continue;
            Bundle curBundle = providerWiring.getBundle();
            if (this._strict && curBundle.getBundleId() == 0L) {
                this._systemBundleWiring = providerWiring;
            }
            this._log.log("\t" + curBundle.getSymbolicName() + "-" + curBundle.getVersion());
            this._bundleWirings.add(providerWiring);
        }
        if (this._strict && this._systemBundleWiring != null) {
            this._systemCapabilities = this._systemBundleWiring.getCapabilities("osgi.wiring.package");
        }
    }

    public void addBundleRequirement(BundleRequirement bundleRequirement) {
        if (this._packageRequirements.contains(bundleRequirement)) {
            return;
        }
        this._packageRequirements.add(bundleRequirement);
    }

    public void addBundleWiring(BundleWiring bundleWiring) {
        if (this._bundleWirings.contains(bundleWiring)) {
            return;
        }
        this._bundleWirings.add(bundleWiring);
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        if (location != StandardLocation.CLASS_PATH) {
            return this._javaFileManager.getClassLoader(location);
        }
        return this.getClassLoader();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (location == StandardLocation.CLASS_PATH && file instanceof BundleJavaFileObject) {
            BundleJavaFileObject bundleJavaFileObject = (BundleJavaFileObject)file;
            this._log.log("Infering binary name from " + bundleJavaFileObject);
            return bundleJavaFileObject.inferBinaryName();
        }
        return this._javaFileManager.inferBinaryName(location, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        ArrayList<JavaFileObject> javaFileObjects = new ArrayList<JavaFileObject>();
        if (location == StandardLocation.CLASS_PATH) {
            this._log.log("List available sources for {location=" + location + ", packageName=" + packageName + ", kinds=" + kinds + ", recurse=" + recurse + "}");
        }
        String packagePath = packageName.replace('.', '/');
        if (!packageName.startsWith("java.") && location == StandardLocation.CLASS_PATH) {
            this.listFromDependencies(kinds, recurse, packagePath, javaFileObjects);
        }
        if (packageName.startsWith("java.") || location != StandardLocation.CLASS_PATH || javaFileObjects.isEmpty() && this.hasPackageCapability(packageName)) {
            Iterable<JavaFileObject> localJavaFileObjects = this._javaFileManager.list(location, packagePath, kinds, recurse);
            for (JavaFileObject javaFileObject : localJavaFileObjects) {
                if (location == StandardLocation.CLASS_PATH) {
                    this._log.log("\t" + javaFileObject);
                }
                javaFileObjects.add(javaFileObject);
            }
        }
        return javaFileObjects;
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this._resourceResolver = resourceResolver;
    }

    private String getClassNameFromPath(String resourceName) {
        if (resourceName.endsWith(".class")) {
            resourceName = resourceName.substring(0, resourceName.length() - 6);
        }
        return resourceName.replace('/', '.');
    }

    private URI getURI(URL url) {
        String protocol = url.getProtocol();
        if (protocol.equals("bundle") || protocol.equals("bundleresource")) {
            try {
                return url.toURI();
            }
            catch (Exception e) {
                this._log.log(e);
            }
        } else if (protocol.equals("jar")) {
            try {
                JarURLConnection jarUrlConnection = (JarURLConnection)url.openConnection();
                return jarUrlConnection.getJarFileURL().toURI();
            }
            catch (Exception e) {
                this._log.log(e);
            }
        } else if (protocol.equals("vfs")) {
            String file = url.getFile();
            int indexOf = file.indexOf(".jar") + 4;
            file = file.substring(0, indexOf) + "!" + url.getFile().substring(indexOf, url.getFile().length());
            return new File(file).toURI();
        }
        return null;
    }

    private JavaFileObject getJavaFileObject(URL resourceURL, String resourceName) {
        String protocol = resourceURL.getProtocol();
        String className = this.getClassNameFromPath(resourceName);
        URI uri = this.getURI(resourceURL);
        if (protocol.equals("bundle") || protocol.equals("bundleresource")) {
            try {
                return new BundleJavaFileObject(uri, className);
            }
            catch (Exception e) {
                this._log.log(e);
            }
        } else {
            if (protocol.equals("jar")) {
                return new JarJavaFileObject(uri, className, resourceURL, resourceName);
            }
            if (protocol.equals("vfs")) {
                try {
                    return new JarJavaFileObject(uri, className, new URL("jar:" + uri.toString()), resourceName);
                }
                catch (IOException e) {
                    this._log.log(e);
                }
            }
        }
        return null;
    }

    private ResourceResolver getResourceResolver() {
        if (this._resourceResolver != null) {
            return this._resourceResolver;
        }
        this._resourceResolver = new BasicResourceResolver();
        return this._resourceResolver;
    }

    private boolean hasPackageCapability(String packageName) {
        if (!this._strict) {
            return true;
        }
        return this._systemBundleWiring != null && this.hasPackageCapability(this._systemCapabilities, packageName);
    }

    private boolean hasPackageCapability(List<BundleCapability> capabilities, String packageName) {
        for (BundleCapability capability : capabilities) {
            Map attributes = capability.getAttributes();
            Object packageAttribute = attributes.get("osgi.wiring.package");
            if (packageAttribute == null || !packageAttribute.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private void list(String packagePath, JavaFileObject.Kind kind, int options, BundleWiring bundleWiring, List<JavaFileObject> javaFileObjects) {
        ResourceResolver resourceResolver = this.getResourceResolver();
        Collection<String> resources = resourceResolver.resolveResources(bundleWiring, packagePath, "*".concat(kind.extension), options);
        if (resources == null || resources.isEmpty()) {
            return;
        }
        for (String resourceName : resources) {
            URL resourceURL = resourceResolver.getResource(bundleWiring, resourceName);
            JavaFileObject javaFileObject = this.getJavaFileObject(resourceURL, resourceName);
            if (javaFileObject == null) {
                this._log.log("\tCould not create JavaFileObject for {" + resourceURL + "}");
                continue;
            }
            this._log.log("\t" + javaFileObject);
            javaFileObjects.add(javaFileObject);
        }
    }

    private void listFromDependencies(Set<JavaFileObject.Kind> kinds, boolean recurse, String packagePath, List<JavaFileObject> javaFileObjects) {
        int options = recurse ? 1 : 0;
        for (JavaFileObject.Kind kind : kinds) {
            if (kind.equals((Object)JavaFileObject.Kind.CLASS)) {
                for (BundleWiring bundleWiring : this._bundleWirings) {
                    this.list(packagePath, kind, options, bundleWiring, javaFileObjects);
                }
            }
            if (!javaFileObjects.isEmpty()) continue;
            this.list(packagePath, kind, options, this._bundleWiring, javaFileObjects);
        }
    }

    private void setOptions(List<String> options) {
        if (options == null) {
            return;
        }
        this._options.addAll(options);
        if (this._options.contains("-verbose")) {
            this._log.out = System.err;
        }
    }
}

