/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.iface2;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugSessionRecord;
import agent.dbgeng.manager.DbgEventsListenerAdapter;
import agent.dbgeng.manager.DbgSession;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.iface1.DbgModelSelectableObject;
import agent.dbgeng.model.iface1.DbgModelTargetAccessConditioned;
import agent.dbgeng.model.iface1.DbgModelTargetExecutionStateful;
import agent.dbgeng.model.iface1.DbgModelTargetInterpreter;
import agent.dbgeng.model.iface1.DbgModelTargetInterruptible;
import agent.dbgeng.model.iface1.DbgModelTargetResumable;
import agent.dbgeng.model.iface2.DbgModelTargetProcessContainer;
import ghidra.dbg.target.TargetAggregate;
import ghidra.dbg.target.TargetConsole;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface DbgModelTargetSession
extends DbgModelTargetAccessConditioned,
DbgModelTargetExecutionStateful,
DbgModelTargetInterpreter,
DbgModelTargetInterruptible,
DbgModelTargetResumable,
DbgEventsListenerAdapter,
DbgModelSelectableObject,
TargetAggregate {
    public DbgModelTargetProcessContainer getProcesses();

    default public DbgSession getSession() {
        return this.getSession(true);
    }

    default public DbgSession getSession(boolean fire) {
        DbgManagerImpl manager = this.getManager();
        try {
            String index = PathUtils.parseIndex((String)this.getName());
            Integer sid = Integer.decode(index);
            DebugSessionRecord id = new DebugSessionRecord(sid.intValue());
            return manager.getSessionComputeIfAbsent(id, fire);
        }
        catch (IllegalArgumentException e) {
            return manager.getCurrentSession();
        }
    }

    @Override
    default public void consoleOutput(String output, int mask) {
        if (!this.isValid()) {
            return;
        }
        TargetConsole.Channel chan = TargetConsole.Channel.STDOUT;
        if (((long)mask & DebugClient.DebugOutputFlags.DEBUG_OUTPUT_ERROR.getValue()) == DebugClient.DebugOutputFlags.DEBUG_OUTPUT_ERROR.getValue() || ((long)mask & DebugClient.DebugOutputFlags.DEBUG_OUTPUT_WARNING.getValue()) == DebugClient.DebugOutputFlags.DEBUG_OUTPUT_WARNING.getValue()) {
            chan = TargetConsole.Channel.STDERR;
        }
        if (output.contains("loaded *kernel* extension dll for usermode")) {
            return;
        }
        if (!this.isValid()) {
            return;
        }
        this.broadcast().consoleOutput(this.getProxy(), chan, output);
    }

    @Override
    default public void promptChanged(String prompt) {
        this.changeAttributes(List.of(), Map.of("_prompt", prompt), "Refreshed");
    }

    @Override
    default public CompletableFuture<Void> setActive() {
        DbgManagerImpl manager = this.getManager();
        DbgSession session = this.getSession();
        if (session == null) {
            session = manager.getEventSession();
        }
        return manager.setActiveSession(session);
    }
}

