/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugSystemThreadRecord;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DbgListThreadsCommand
extends AbstractDbgCommand<Map<DebugThreadId, DbgThread>> {
    protected final DbgProcessImpl process;
    private List<DebugThreadId> updatedThreadIds;

    public DbgListThreadsCommand(DbgManagerImpl manager, DbgProcessImpl process) {
        super(manager);
        this.process = process;
    }

    @Override
    public Map<DebugThreadId, DbgThread> complete(DbgPendingCommand<?> pending) {
        Map<DebugThreadId, DbgThread> threads = this.process.getKnownThreads();
        Set<DebugThreadId> cur = threads.keySet();
        for (DebugThreadId id : this.updatedThreadIds) {
            long tid;
            if (cur.contains(id)) continue;
            DebugSystemObjects so = this.manager.getSystemObjects();
            if (!this.manager.isKernelMode()) {
                Msg.warn((Object)this, (Object)("Resync: Was missing thread: " + id));
                so.setCurrentThreadId(id);
                tid = so.getCurrentThreadSystemId();
            } else {
                id = new DebugSystemThreadRecord(id.value());
                tid = -1L;
            }
            DbgThreadImpl thread = this.manager.getThreadComputeIfAbsent(id, this.process, tid, false);
            Long offset = so.getCurrentThreadDataOffset();
            thread.setOffset(offset);
        }
        for (DebugThreadId id : new ArrayList<DebugThreadId>(cur)) {
            if (this.updatedThreadIds.contains(id) || this.manager.isKernelMode()) continue;
            Msg.warn((Object)this, (Object)("Resync: Had extra thread: " + id));
            this.process.removeThread(id);
            this.manager.removeThread(id);
        }
        return this.process.getKnownThreads();
    }

    @Override
    public void invoke() {
        try {
            this.setProcess(this.process);
            DebugSystemObjects so = this.manager.getSystemObjects();
            this.updatedThreadIds = so.getThreads();
        }
        finally {
            this.resetProcess();
        }
    }
}

