/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugSymbolEntry;
import agent.dbgeng.dbgeng.DebugSymbolId;
import agent.dbgeng.dbgeng.DebugSymbolName;
import agent.dbgeng.dbgeng.DebugSymbols;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgMinimalSymbol;
import agent.dbgeng.manager.impl.DbgModuleImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbgListSymbolsCommand
extends AbstractDbgCommand<Map<String, DbgMinimalSymbol>> {
    protected final DbgProcessImpl process;
    protected final DbgModuleImpl module;
    private Map<DebugSymbolId, DebugSymbolEntry> symbolEntries = new HashMap<DebugSymbolId, DebugSymbolEntry>();

    public DbgListSymbolsCommand(DbgManagerImpl manager, DbgProcessImpl process, DbgModuleImpl module) {
        super(manager);
        this.process = process;
        this.module = module;
    }

    @Override
    public Map<String, DbgMinimalSymbol> complete(DbgPendingCommand<?> pending) {
        HashMap<String, DbgMinimalSymbol> symbolMap = new HashMap<String, DbgMinimalSymbol>();
        for (Map.Entry<DebugSymbolId, DebugSymbolEntry> entry : this.symbolEntries.entrySet()) {
            DebugSymbolEntry value = entry.getValue();
            DbgMinimalSymbol minSymbol = new DbgMinimalSymbol(entry.getKey().symbolIndex, value.typeId, value.name, value.offset, value.size, value.tag, value.moduleBase);
            symbolMap.put(entry.getKey().toString(), minSymbol);
        }
        return symbolMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() {
        try {
            this.setProcess(this.process);
            DebugSymbols symbols = this.manager.getSymbols();
            for (DebugSymbolName symbol : symbols.iterateSymbolMatches(this.module.getName() + "!*")) {
                List<DebugSymbolId> symbolIdsByName = symbols.getSymbolIdsByName(symbol.name);
                for (DebugSymbolId symbolId : symbolIdsByName) {
                    DebugSymbolEntry symbolEntry = symbols.getSymbolEntry(symbolId);
                    this.symbolEntries.put(symbolId, symbolEntry);
                }
            }
        }
        finally {
            this.resetProcess();
        }
    }
}

